#ifndef POKITTO_MODEL_H
#define POKITTO_MODEL_H

#define POKITTO_VERTEX_COUNT 32
const S3L_Unit pokittoVertices[POKITTO_VERTEX_COUNT * 3] = {
  -1549,  2591,  -407,        // 0
  -1549,  2591,   375,        // 3
  -1549,   618,   375,        // 6
  -1549,   618,  -407,        // 9
  -1549,  1327,   375,        // 12
  -1549,  1327,  -407,        // 15
  -2187,  1327,  -407,        // 18
  -2187,   618,  -407,        // 21
  -2187,   618,   375,        // 24
  -2187,  1327,   375,        // 27
   -841, -1504,   375,        // 30
   -841, -1504,  -407,        // 33
   -841, -2088,   375,        // 36
  -1549, -2088,   375,        // 39
  -1549, -2088,  -407,        // 42
   -841, -2088,  -407,        // 45
   1549,  2591,  -407,        // 48
   1549,  2591,   375,        // 51
   1549,   618,   375,        // 54
   1549,   618,  -407,        // 57
   1549,  1327,   375,        // 60
   1549,  1327,  -407,        // 63
   2187,  1327,  -407,        // 66
   2187,   618,  -407,        // 69
   2187,   618,   375,        // 72
   2187,  1327,   375,        // 75
    841, -1504,   375,        // 78
    841, -1504,  -407,        // 81
    841, -2088,   375,        // 84
   1549, -2088,   375,        // 87
   1549, -2088,  -407,        // 90
    841, -2088,  -407         // 93
}; // pokittoVertices

#define POKITTO_TRIANGLE_COUNT 60
const S3L_Index pokittoTriangleIndices[POKITTO_TRIANGLE_COUNT * 3] = {
     14,    15,     3,        // 0
      2,     7,     8,        // 3
      6,     8,     7,        // 6
     11,     3,    15,        // 9
      5,     7,     3,        // 12
      0,     4,     5,        // 15
      2,     9,     4,        // 18
      4,     6,     5,        // 21
     15,    13,    12,        // 24
     11,    12,    10,        // 27
      2,    14,     3,        // 30
     13,    10,    12,        // 33
     13,     2,    10,        // 36
     30,    19,    31,        // 39
     24,    19,    18,        // 42
     24,    22,    23,        // 45
     27,    31,    19,        // 48
     23,    21,    19,        // 51
     20,    16,    21,        // 54
     25,    18,    20,        // 57
     21,    25,    20,        // 60
     28,    30,    31,        // 63
     28,    27,    26,        // 66
     30,    18,    19,        // 69
     29,    28,    26,        // 72
     29,    26,    18,        // 75
      3,    11,    27,        // 78
     27,    19,     3,        // 81
     19,    21,     3,        // 84
      3,    21,     5,        // 87
     21,    16,     5,        // 90
      5,    16,     0,        // 93
      1,     0,    16,        // 96
     16,    17,     1,        // 99
     17,    20,     1,        // 102
      1,    20,     4,        // 105
      4,    20,     2,        // 108
     20,    18,     2,        // 111
     18,    26,    10,        // 114
      2,    18,    10,        // 117
     10,    26,    11,        // 120
     26,    27,    11,        // 123
      2,     3,     7,        // 126
      6,     9,     8,        // 129
      5,     6,     7,        // 132
      0,     1,     4,        // 135
      2,     8,     9,        // 138
      4,     9,     6,        // 141
     15,    14,    13,        // 144
     11,    15,    12,        // 147
      2,    13,    14,        // 150
     24,    23,    19,        // 153
     24,    25,    22,        // 156
     23,    22,    21,        // 159
     20,    17,    16,        // 162
     25,    24,    18,        // 165
     21,    22,    25,        // 168
     28,    29,    30,        // 171
     28,    31,    27,        // 174
     30,    29,    18         // 177
}; // pokittoTriangleIndices

#define POKITTO_UV_COUNT 72
const S3L_Unit pokittoUVs[POKITTO_UV_COUNT * 2] = {
     51,   322,         // 0
     93,   322,         // 2
     51,   150,         // 4
    175,   344,         // 6
    204,   383,         // 8
    204,   344,         // 10
    236,   383,         // 12
     93,   285,         // 14
     51,   106,         // 16
     14,   150,         // 18
    323,   383,         // 20
    266,   344,         // 22
    266,   383,         // 24
    283,   199,         // 26
    246,   244,         // 28
    283,   244,         // 30
    214,   494,         // 32
    247,   455,         // 34
    214,   455,         // 36
    188,   494,         // 38
    188,   455,         // 40
     51,   383,         // 42
    175,   383,         // 44
    283,    28,         // 46
    325,    65,         // 48
    325,    28,         // 50
    232,   322,         // 52
    232,   150,         // 54
    191,   322,         // 56
    205,   441,         // 58
    176,   402,         // 60
    176,   441,         // 62
    237,   402,         // 64
    205,   402,         // 66
    191,   285,         // 68
    270,   150,         // 70
    232,   106,         // 72
    266,   441,         // 74
    324,   402,         // 76
    266,   402,         // 78
    502,   244,         // 80
    464,   199,         // 82
    464,   244,         // 84
    237,   441,         // 86
     84,   455,         // 88
     52,   494,         // 90
     84,   494,         // 92
    111,   494,         // 94
    111,   455,         // 96
     52,   402,         // 98
    464,    28,         // 100
    423,    28,         // 102
    423,    65,         // 104
    232,    26,         // 106
     51,    26,         // 108
    379,   343,         // 110
    344,   343,         // 112
    344,   497,         // 114
    379,   497,         // 116
    464,   324,         // 118
    283,   324,         // 120
    236,   344,         // 122
     14,   106,         // 124
    323,   344,         // 126
    246,   199,         // 128
    247,   494,         // 130
     51,   344,         // 132
    270,   106,         // 134
    324,   441,         // 136
    502,   199,         // 138
     52,   455,         // 140
     52,   441          // 142
}; // pokittoUVs

#define POKITTO_UV_INDEX_COUNT 60
const S3L_Index pokittoUVIndices[POKITTO_UV_INDEX_COUNT * 3] = {
      0,     1,     2,        // 0
      3,     4,     5,        // 3
      6,     5,     4,        // 6
      7,     2,     1,        // 9
      8,     9,     2,        // 12
     10,    11,    12,        // 15
     13,    14,    15,        // 18
     11,     6,    12,        // 21
     16,    17,    18,        // 24
     19,    18,    20,        // 27
      3,    21,    22,        // 30
     23,    24,    25,        // 33
     23,    13,    24,        // 36
     26,    27,    28,        // 39
     29,    30,    31,        // 42
     29,    32,    33,        // 45
     34,    28,    27,        // 48
     35,    36,    27,        // 51
     37,    38,    39,        // 54
     40,    41,    42,        // 57
     39,    43,    37,        // 60
     44,    45,    46,        // 63
     44,    47,    48,        // 66
     49,    31,    30,        // 69
     50,    51,    52,        // 72
     50,    52,    41,        // 75
      2,     7,    34,        // 78
     34,    27,     2,        // 81
     27,    36,     2,        // 84
      2,    36,     8,        // 87
     36,    53,     8,        // 90
      8,    53,    54,        // 93
     55,    56,    57,        // 96
     57,    58,    55,        // 99
     59,    42,    60,        // 102
     60,    42,    15,        // 105
     15,    42,    13,        // 108
     42,    41,    13,        // 111
     41,    52,    24,        // 114
     13,    41,    24,        // 117
     20,    48,    19,        // 120
     48,    47,    19,        // 123
      3,    22,     4,        // 126
      6,    61,     5,        // 129
      8,    62,     9,        // 132
     10,    63,    11,        // 135
     13,    64,    14,        // 138
     11,    61,     6,        // 141
     16,    65,    17,        // 144
     19,    16,    18,        // 147
      3,    66,    21,        // 150
     29,    33,    30,        // 153
     29,    43,    32,        // 156
     35,    67,    36,        // 159
     37,    68,    38,        // 162
     40,    69,    41,        // 165
     39,    32,    43,        // 168
     44,    70,    45,        // 171
     44,    46,    47,        // 174
     49,    71,    31         // 177
}; // pokittoUVIndices

S3L_Model3D pokittoModel;

void pokittoModelInit()
{
  S3L_initModel3D(
    pokittoVertices,
    POKITTO_VERTEX_COUNT,
    pokittoTriangleIndices,
    POKITTO_TRIANGLE_COUNT,
    &pokittoModel);
}

#endif // guard
