#ifndef LEVEL_MODEL_H
#define LEVEL_MODEL_H

#define LEVEL_VERTEX_COUNT 143
const S3L_Unit levelVertices[LEVEL_VERTEX_COUNT * 3] = {
  -1291,   -25,  -517,        // 0
   -676,   -25, -1131,        // 3
  -1905,   -25,  -517,        // 6
    -62,   -25, -2360,        // 9
    -62,   -25, -1131,        // 12
   -676,   -25,    96,        // 15
    -62,   -25,  -517,        // 18
  -1905,   -25,    96,        // 21
  -1444,   -25,  -671,        // 24
    552,  -639, -2360,        // 27
  -1444,  1203,  -671,        // 30
    552,  -639, -1131,        // 33
  -2059,   -25,  2400,        // 36
  -1291,   -25,   711,        // 39
     91,  1203,  1940,        // 42
   -676,   -25,   711,        // 45
   1780,  -639, -1131,        // 48
   1934,  -639,  -671,        // 51
   2548,  1203,  -671,        // 54
   2548,  -639,  -671,        // 57
   1780,  -639,  -517,        // 60
   1934,  1203, -2360,        // 63
     91,   -25,   711,        // 66
    -62, -1868, -1131,        // 69
    -62, -1868,  -517,        // 72
   1166, -1868, -1131,        // 75
   -676, -1868,    96,        // 78
     91,   -25,  1940,        // 81
  -1291, -1868,    96,        // 84
   1166, -1868,  -517,        // 87
   2395,  -639,  -517,        // 90
   1780, -1868,    96,        // 93
   2395, -1868,    96,        // 96
  -2827,  -178,   864,        // 99
  -2827,  -178,    96,        // 102
   3624,  -639,  -671,        // 105
   1780, -1868,  -517,        // 108
  -2059,   -25,  -671,        // 111
  -2059,   -25,   250,        // 114
  -1444,   -25,   864,        // 117
  -1444,   -25,  1786,        // 120
   2395,   -25,   711,        // 123
   1934,  1203,  -671,        // 126
  -1291,  1203,   711,        // 129
     91,  1203,   711,        // 132
  -2827,  1203,  -517,        // 135
  -2827,   -25, -1131,        // 138
    -62,  1203,  1786,        // 141
  -1444,  1203,  1786,        // 144
  -1444,  1203,   864,        // 147
  -1291,  1203,  -517,        // 150
  -1905,  1203,    96,        // 153
   -676,  1203, -1131,        // 156
   -676,  1203, -2360,        // 159
  -1905,  1203,  -517,        // 162
   2395,  1203,   711,        // 165
   2395,  1203,  -517,        // 168
   2548,   -25,   711,        // 171
   2548,  1203,   711,        // 174
   1780,  1203, -2360,        // 177
   1780,  1203,  -517,        // 180
   3624,   -25,   711,        // 183
   3624,   -25,  1940,        // 186
   -676,  -178,   711,        // 189
   3624,  1203,  1940,        // 192
   3009,  -639, -2360,        // 195
   3624,  -639, -1746,        // 198
   3009,  1203, -2360,        // 201
   3624,  1203, -1746,        // 204
  -1905, -1254,  1325,        // 207
   -676, -1868,  1325,        // 210
  -1291, -1868,  1325,        // 213
   1780, -1868,  1325,        // 216
   2395, -1868,  1325,        // 219
   1780,  -639,  1940,        // 222
   2395,  -639,  1940,        // 225
   1780, -1868,  1940,        // 228
   2395, -1868,  1940,        // 231
   2395, -1868,  -517,        // 234
  -2059,  1203,   250,        // 237
  -2059,  1203,  -671,        // 240
  -2827,  1203, -1131,        // 243
  -4055,   -25, -1131,        // 246
  -1905, -1254,    96,        // 249
  -2827, -1254,    96,        // 252
  -4055, -1254,    96,        // 255
  -4055, -1254,  1325,        // 258
  -2059,  1203,  2400,        // 261
   -676,  -639,  1940,        // 264
  -1291,  -639,  1940,        // 267
   -676, -1868,  1940,        // 270
  -1291,  -178,  1325,        // 273
  -4055,  -178,   864,        // 276
  -4055,  1203,  -517,        // 279
  -4055,  -178,  1325,        // 282
   -676,  -178,    96,        // 285
   2395,  -178,   711,        // 288
   3624,  -639,  -517,        // 291
   3624,  -178,   711,        // 294
   3624, -1868,  1940,        // 297
  -1291,  -178,  1940,        // 300
   3624, -1868,  -517,        // 303
    -62,   -25,  1786,        // 306
    -62,   -25,   864,        // 309
  -2673,   -25,  2400,        // 312
  -2673,   -25, -1131,        // 315
    -62,  1203,   864,        // 318
  -2673,  1203,  2400,        // 321
  -2673,  1203, -1131,        // 324
   -830,   -25, -1285,        // 327
   -830,  1203, -1285,        // 330
   -830,  1203, -2360,        // 333
  -4055,   -25, -2360,        // 336
  -4055,  1203, -2360,        // 339
   3624,  -178,  1940,        // 342
    -62,   -25,  1671,        // 345
    -62,   -25,  1026,        // 348
    -62,   683,  1671,        // 351
    -62,   860,  1484,        // 354
    -62,   860,  1224,        // 357
    -62,   683,  1026,        // 360
     91,   -25,  1026,        // 363
     91,   -25,  1671,        // 366
     91,   683,  1026,        // 369
     91,   860,  1224,        // 372
     91,   860,  1484,        // 375
     91,   683,  1671,        // 378
   -676,   905, -2360,        // 381
   -676,   -25, -1658,        // 384
   -676,   905, -1910,        // 387
   -676,   685, -1658,        // 390
   -830,   905, -2360,        // 393
   -830,   -25, -1658,        // 396
   -830,   905, -1910,        // 399
   -830,   685, -1658,        // 402
   1780,   453, -2360,        // 405
   1780,  -639, -1417,        // 408
   1780,   207, -1417,        // 411
   1780,   453, -1586,        // 414
   1934,  -639, -1417,        // 417
   1934,   453, -2360,        // 420
   1934,   207, -1417,        // 423
   1934,   453, -1586         // 426
}; // levelVertices

#define LEVEL_TRIANGLE_COUNT 293
const S3L_Index levelTriangleIndices[LEVEL_TRIANGLE_COUNT * 3] = {
      7,    54,     2,        // 0
      6,     0,     1,        // 3
      4,     6,     1,        // 6
     13,     5,    15,        // 9
      3,    59,     9,        // 12
      4,     1,   128,        // 15
     63,     5,    95,        // 18
     26,     6,    24,        // 21
      6,    26,    95,        // 24
      6,    95,     5,        // 27
     43,    15,    44,        // 30
     13,     0,     5,        // 33
      3,    11,     4,        // 36
    109,    10,     8,        // 39
     23,    29,    24,        // 42
     22,    44,    15,        // 45
      3,    53,    59,        // 48
     29,    16,    20,        // 51
     32,    20,    30,        // 54
     29,    20,    36,        // 57
     31,    36,    20,        // 60
     41,    96,    30,        // 63
     60,   137,   138,        // 66
     22,    96,    41,        // 69
    124,   125,    14,        // 72
     13,    51,     7,        // 75
     82,    93,   113,        // 78
     57,    18,    19,        // 81
     13,    15,    43,        // 84
     40,    87,    12,        // 87
    104,   108,   105,        // 90
      2,     0,     7,        // 93
      3,   127,    53,        // 96
     54,     0,     2,        // 99
     41,    56,    55,        // 102
     50,     1,     0,        // 105
     19,    42,    17,        // 108
     56,    20,    60,        // 111
     27,    64,    14,        // 114
      8,    80,    37,        // 117
    110,   134,   133,        // 120
    122,   121,    41,        // 123
     61,    68,    64,        // 126
     62,    57,    61,        // 129
     65,    68,    66,        // 132
     35,    66,    68,        // 135
    140,    21,    67,        // 138
     35,    68,    61,        // 141
     58,    41,    55,        // 144
     61,    64,    62,        // 147
     16,    25,    11,        // 150
     11,    23,     4,        // 153
     23,    11,    25,        // 156
     98,    99,    97,        // 159
     70,    31,    72,        // 162
     69,    84,    83,        // 165
     99,   101,    97,        // 168
     85,    84,    86,        // 171
     77,    73,    99,        // 174
     32,    99,    73,        // 177
     70,    28,    26,        // 180
     75,    72,    73,        // 183
     74,    76,    72,        // 186
     73,    77,    75,        // 189
     30,    78,    32,        // 192
     80,    38,    37,        // 195
     12,   107,   104,        // 198
     46,   108,    81,        // 201
     69,    71,    91,        // 204
     71,    83,    28,        // 207
     34,    63,    95,        // 210
     84,    69,    86,        // 213
     81,    45,    34,        // 216
     34,    45,    33,        // 219
     34,    84,    46,        // 222
     49,   103,    39,        // 225
     79,    39,    38,        // 228
    119,   106,    47,        // 231
    102,    48,    40,        // 234
     88,    71,    70,        // 237
     70,    90,    88,        // 240
     89,    91,    71,        // 243
     26,    28,    95,        // 246
     84,    34,    83,        // 249
     95,    83,    34,        // 252
     28,    83,    95,        // 255
     94,    92,    86,        // 258
     91,    94,    69,        // 261
    112,    82,   113,        // 264
     34,    46,    81,        // 267
     86,    69,    94,        // 270
     86,    92,    85,        // 273
     93,    33,    45,        // 276
     85,    46,    84,        // 279
    115,   102,    40,        // 282
     52,   129,   130,        // 285
     92,    82,    85,        // 288
     57,    62,    41,        // 291
     72,    90,    70,        // 294
     74,    90,    76,        // 297
     97,    78,    30,        // 300
     73,    31,    32,        // 303
     78,   101,    32,        // 306
     98,    30,    96,        // 309
     77,   114,    75,        // 312
     99,   114,    77,        // 315
    100,    91,    89,        // 318
    100,    89,    88,        // 321
     98,   114,    99,        // 324
     61,    19,    35,        // 327
     38,    40,    12,        // 330
    104,    38,    12,        // 333
    105,    38,   104,        // 336
     38,   105,    37,        // 339
     37,   109,     8,        // 342
    105,   132,   109,        // 345
    112,    46,    82,        // 348
     22,    15,    63,        // 351
     94,    33,    92,        // 354
     91,    33,    94,        // 357
     74,   100,    88,        // 360
     36,    31,    29,        // 363
     29,    26,    24,        // 366
     91,   100,    63,        // 369
     35,    19,    66,        // 372
     66,    19,    65,        // 375
     45,    81,    93,        // 378
     93,    81,   113,        // 381
    111,   108,   110,        // 384
    110,   108,    10,        // 387
     10,   108,    80,        // 390
    108,    79,    80,        // 393
    107,    87,    79,        // 396
     87,    49,    79,        // 399
     47,    49,    48,        // 402
     51,    50,    54,        // 405
     43,    44,    50,        // 408
     50,    44,    52,        // 411
     59,    52,    44,        // 414
     59,    53,    52,        // 417
     60,    59,    44,        // 420
     56,    60,    55,        // 423
     60,    44,    55,        // 426
     44,    14,    55,        // 429
     64,    55,    14,        // 432
     55,    64,    58,        // 435
     58,    64,    18,        // 438
     64,    68,    18,        // 441
     68,    67,    18,        // 444
     67,    21,    18,        // 447
     42,    18,    21,        // 450
     46,   112,   105,        // 453
    124,   120,   119,        // 456
    125,   119,   118,        // 459
    126,   118,   117,        // 462
    122,   117,   115,        // 465
    123,   116,   120,        // 468
    116,   122,   115,        // 471
    130,   132,   128,        // 474
    129,   134,   130,        // 477
    127,   133,   129,        // 480
    131,   127,     3,        // 483
     16,    60,    20,        // 486
    141,    17,    42,        // 489
    136,   141,   137,        // 492
    137,   142,   138,        // 495
    138,   140,   135,        // 498
      7,    51,    54,        // 501
      6,     5,     0,        // 504
      3,     4,   128,        // 507
     63,    15,     5,        // 510
     13,     7,     0,        // 513
      3,     9,    11,        // 516
     16,    11,   136,        // 519
     11,     9,   136,        // 522
    109,   110,    10,        // 525
     23,    25,    29,        // 528
     23,    24,     6,        // 531
      6,     4,    23,        // 534
     29,    25,    16,        // 537
     32,    31,    20,        // 540
     60,    16,   137,        // 543
     16,   136,   137,        // 546
    135,    59,   138,        // 549
     59,    60,   138,        // 552
     22,    63,    96,        // 555
     44,    22,   123,        // 558
     22,   121,   123,        // 561
    122,    27,   126,        // 564
     27,    14,   126,        // 567
     44,   123,   124,        // 570
    125,   126,    14,        // 573
     44,   124,    14,        // 576
     13,    43,    51,        // 579
     57,    58,    18,        // 582
     40,    48,    87,        // 585
    104,   107,   108,        // 588
     54,    50,     0,        // 591
     41,    30,    56,        // 594
     50,    52,     1,        // 597
     19,    18,    42,        // 600
     56,    30,    20,        // 603
     27,    62,    64,        // 606
      8,    10,    80,        // 609
    110,   109,   134,        // 612
    109,   132,   134,        // 615
    131,   111,   133,        // 618
    111,   110,   133,        // 621
     62,    27,    41,        // 624
     27,   122,    41,        // 627
    121,    22,    41,        // 630
     65,    67,    68,        // 633
      9,    59,   135,        // 636
     67,    65,   140,        // 639
     58,    57,    41,        // 642
     70,    26,    31,        // 645
     32,   101,    99,        // 648
     70,    71,    28,        // 651
     75,    74,    72,        // 654
     80,    79,    38,        // 657
     12,    87,   107,        // 660
     46,   105,   108,        // 663
     71,    69,    83,        // 666
     34,    33,    63,        // 669
     49,   106,   103,        // 672
     79,    49,    39,        // 675
    116,   103,   120,        // 678
    103,   106,   120,        // 681
     47,   102,   117,        // 684
    102,   115,   117,        // 687
    119,   120,   106,        // 690
     47,   117,   118,        // 693
    118,   119,    47,        // 696
    102,    47,    48,        // 699
     88,    89,    71,        // 702
     93,    92,    33,        // 705
     85,    82,    46,        // 708
     40,    39,   116,        // 711
     39,   103,   116,        // 714
    116,   115,    40,        // 717
    128,     1,   130,        // 720
      1,    52,   130,        // 723
     52,    53,   129,        // 726
     53,   127,   129,        // 729
     92,    93,    82,        // 732
     72,    76,    90,        // 735
     74,    88,    90,        // 738
     97,   101,    78,        // 741
     73,    72,    31,        // 744
     98,    97,    30,        // 747
     61,    57,    19,        // 750
     38,    39,    40,        // 753
     37,   105,   109,        // 756
      3,   105,   112,        // 759
     91,    63,    33,        // 762
     29,    31,    26,        // 765
     65,    19,   139,        // 768
     19,    17,   139,        // 771
    108,   107,    79,        // 774
     87,    48,    49,        // 777
     47,   106,    49,        // 780
     51,    43,    50,        // 783
    124,   123,   120,        // 786
    125,   124,   119,        // 789
    126,   125,   118,        // 792
    122,   126,   117,        // 795
    123,   121,   116,        // 798
    116,   121,   122,        // 801
    130,   134,   132,        // 804
    129,   133,   134,        // 807
    127,   131,   133,        // 810
    128,   132,     3,        // 813
     21,   140,   142,        // 816
    141,   139,    17,        // 819
     42,    21,   142,        // 822
    142,   141,    42,        // 825
    136,   139,   141,        // 828
    137,   141,   142,        // 831
    138,   142,   140,        // 834
    136,    65,   139,        // 837
    136,     9,    65,        // 840
    140,    65,   135,        // 843
      9,   135,    65,        // 846
    105,     3,   132,        // 849
      3,   112,   131,        // 852
    112,   113,   131,        // 855
     81,   111,   113,        // 858
    108,   111,    81,        // 861
    131,   113,   111,        // 864
     75,   114,    74,        // 867
     74,   114,   100,        // 870
     63,   100,   114,        // 873
    114,    98,    63         // 876
}; // levelTriangleIndices

const uint8_t levelMaterials[LEVEL_TRIANGLE_COUNT] = {
      0,          // 0
      1,          // 1
      1,          // 2
      1,          // 3
      0,          // 4
      1,          // 5
      0,          // 6
      0,          // 7
      0,          // 8
      0,          // 9
      0,          // 10
      1,          // 11
      1,          // 12
      0,          // 13
      1,          // 14
      0,          // 15
      0,          // 16
      0,          // 17
      2,          // 18
      0,          // 19
      0,          // 20
      0,          // 21
      0,          // 22
      0,          // 23
      0,          // 24
      0,          // 25
      0,          // 26
      0,          // 27
      0,          // 28
      0,          // 29
      0,          // 30
      1,          // 31
      0,          // 32
      0,          // 33
      0,          // 34
      0,          // 35
      0,          // 36
      0,          // 37
      0,          // 38
      0,          // 39
      0,          // 40
      1,          // 41
      0,          // 42
      1,          // 43
      0,          // 44
      0,          // 45
      0,          // 46
      0,          // 47
      0,          // 48
      0,          // 49
      0,          // 50
      0,          // 51
      0,          // 52
      0,          // 53
      1,          // 54
      1,          // 55
      0,          // 56
      1,          // 57
      1,          // 58
      1,          // 59
      1,          // 60
      2,          // 61
      0,          // 62
      0,          // 63
      0,          // 64
      0,          // 65
      0,          // 66
      0,          // 67
      0,          // 68
      1,          // 69
      2,          // 70
      1,          // 71
      0,          // 72
      0,          // 73
      0,          // 74
      0,          // 75
      0,          // 76
      0,          // 77
      0,          // 78
      2,          // 79
      0,          // 80
      0,          // 81
      0,          // 82
      0,          // 83
      0,          // 84
      0,          // 85
      0,          // 86
      0,          // 87
      0,          // 88
      0,          // 89
      0,          // 90
      0,          // 91
      2,          // 92
      1,          // 93
      1,          // 94
      0,          // 95
      0,          // 96
      1,          // 97
      1,          // 98
      0,          // 99
      0,          // 100
      1,          // 101
      1,          // 102
      2,          // 103
      0,          // 104
      0,          // 105
      0,          // 106
      0,          // 107
      0,          // 108
      1,          // 109
      1,          // 110
      1,          // 111
      1,          // 112
      1,          // 113
      1,          // 114
      1,          // 115
      1,          // 116
      0,          // 117
      2,          // 118
      2,          // 119
      0,          // 120
      1,          // 121
      1,          // 122
      2,          // 123
      1,          // 124
      1,          // 125
      2,          // 126
      2,          // 127
      2,          // 128
      2,          // 129
      2,          // 130
      2,          // 131
      2,          // 132
      2,          // 133
      2,          // 134
      2,          // 135
      2,          // 136
      2,          // 137
      2,          // 138
      2,          // 139
      2,          // 140
      2,          // 141
      2,          // 142
      2,          // 143
      2,          // 144
      2,          // 145
      2,          // 146
      2,          // 147
      2,          // 148
      2,          // 149
      2,          // 150
      1,          // 151
      0,          // 152
      0,          // 153
      0,          // 154
      0,          // 155
      0,          // 156
      1,          // 157
      0,          // 158
      0,          // 159
      0,          // 160
      0,          // 161
      0,          // 162
      0,          // 163
      0,          // 164
      0,          // 165
      0,          // 166
      0,          // 167
      1,          // 168
      1,          // 169
      0,          // 170
      1,          // 171
      1,          // 172
      1,          // 173
      1,          // 174
      0,          // 175
      1,          // 176
      0,          // 177
      0,          // 178
      0,          // 179
      2,          // 180
      0,          // 181
      0,          // 182
      0,          // 183
      0,          // 184
      0,          // 185
      0,          // 186
      0,          // 187
      0,          // 188
      0,          // 189
      0,          // 190
      0,          // 191
      0,          // 192
      0,          // 193
      0,          // 194
      0,          // 195
      0,          // 196
      0,          // 197
      0,          // 198
      0,          // 199
      0,          // 200
      0,          // 201
      0,          // 202
      0,          // 203
      0,          // 204
      0,          // 205
      0,          // 206
      0,          // 207
      1,          // 208
      1,          // 209
      1,          // 210
      0,          // 211
      0,          // 212
      0,          // 213
      0,          // 214
      1,          // 215
      1,          // 216
      1,          // 217
      2,          // 218
      0,          // 219
      0,          // 220
      0,          // 221
      1,          // 222
      2,          // 223
      0,          // 224
      0,          // 225
      0,          // 226
      0,          // 227
      0,          // 228
      0,          // 229
      0,          // 230
      0,          // 231
      0,          // 232
      0,          // 233
      2,          // 234
      2,          // 235
      1,          // 236
      1,          // 237
      1,          // 238
      1,          // 239
      0,          // 240
      0,          // 241
      0,          // 242
      0,          // 243
      0,          // 244
      1,          // 245
      0,          // 246
      0,          // 247
      1,          // 248
      2,          // 249
      1,          // 250
      1,          // 251
      1,          // 252
      1,          // 253
      2,          // 254
      1,          // 255
      1,          // 256
      1,          // 257
      2,          // 258
      2,          // 259
      2,          // 260
      2,          // 261
      0,          // 262
      0,          // 263
      0,          // 264
      0,          // 265
      0,          // 266
      1,          // 267
      0,          // 268
      0,          // 269
      0,          // 270
      1,          // 271
      0,          // 272
      0,          // 273
      0,          // 274
      0,          // 275
      0,          // 276
      0,          // 277
      0,          // 278
      1,          // 279
      1,          // 280
      0,          // 281
      0,          // 282
      1,          // 283
      0,          // 284
      0,          // 285
      2,          // 286
      2,          // 287
      0,          // 288
      0,          // 289
      0,          // 290
      2,          // 291
      2           // 292
}; // levelMaterials

#define LEVEL_UV_COUNT 344
const S3L_Unit levelUVs[LEVEL_UV_COUNT * 2] = {
  -1655, -1007,         // 0
  -2184, -2065,         // 2
  -2184, -1007,         // 4
    402,   699,         // 6
   -690,   699,         // 8
   -144,  1246,         // 10
    402,  1246,         // 12
   -690,  -393,         // 14
   -144,   152,         // 16
   -144,  -393,         // 18
  -3482, -1000,         // 20
  -5047, -2047,         // 22
  -4005,  -478,         // 24
   -144,  1714,         // 26
  -10129,  -912,        // 28
  -10653, -1045,        // 30
  -10653,  -914,        // 32
  -10659,   525,        // 34
  -11394, -1048,        // 36
  -11400,   522,        // 38
   -907, -2065,         // 40
   -378, -1007,         // 42
    282, -2065,         // 44
    402,  2339,         // 46
    948,  1246,         // 48
    324, -1016,         // 50
   -423, -2074,         // 52
   -423, -1016,         // 54
    402,  1246,         // 56
   1495,   699,         // 58
    402,   699,         // 60
    282, -1007,         // 62
  -2958, -2044,         // 64
    553,  -430,         // 66
    -60,   942,         // 68
    553,   942,         // 70
    460,  -253,         // 72
     21,   729,         // 74
    460,   729,         // 76
    -98, -1023,         // 78
   -624, -2074,         // 80
   -624, -1023,         // 82
  -1150, -1023,         // 84
  -1838,  -992,         // 86
  -1838,  -857,         // 88
   -762,  -454,         // 90
   -224, -2068,         // 92
    563, -1196,         // 94
    711, -1411,         // 96
  -9474, -1040,         // 98
  -7510,  -901,         // 100
  -7509, -1032,         // 102
    724, -1770,         // 104
    948, -1770,         // 106
   1340, -2065,         // 108
   -907, -1007,         // 110
  -1655, -2065,         // 112
    958,  -993,         // 114
   1482, -2037,         // 116
    -84, -2039,         // 118
    148, -1013,         // 120
  -1037, -2067,         // 122
  -1037,  -486,         // 124
  -3364, -1016,         // 126
  -4100, -2066,         // 128
  -4104, -1019,         // 130
  -4628, -1021,         // 132
  -7636, -2081,         // 134
  -7640, -1033,         // 136
  -1237,   699,         // 138
  -1237,   152,         // 140
  -2958, -1791,         // 142
  -2713, -1007,         // 144
   -762, -2068,         // 146
  -1838, -2068,         // 148
  -2713, -2065,         // 150
  -3461, -1007,         // 152
  -1564, -2067,         // 154
  -1564,  -486,         // 156
   -224,  -454,         // 158
  -12971, -1015,        // 160
  -9965, -2055,         // 162
  -12969, -2059,        // 164
   -952, -2074,         // 166
   -952, -1016,         // 168
    324, -2074,         // 170
    645, -1628,         // 172
    861, -1818,         // 174
    538, -1247,         // 176
    538,  -673,         // 178
   2588,  -393,         // 180
  -8922, -1008,         // 182
  -6831, -2050,         // 184
   3681, -1486,         // 186
   2724,  -393,         // 188
   3681,  -393,         // 190
  -6095,  -481,         // 192
  -6833,  -483,         // 194
  -7748,  -484,         // 196
  -5179, -1409,         // 198
  -5178, -2047,         // 200
  -6092, -2049,         // 202
    148, -2067,         // 204
    280, -1013,         // 206
    280, -2067,         // 208
  -9967, -1010,         // 210
  -13495,  -520,        // 212
  -12975,   519,        // 214
  -12455,  -520,        // 216
  -11935,   519,        // 218
  -11935, -1040,        // 220
  11145,  -846,         // 222
  10098,   588,         // 224
  12189,  -452,         // 226
   -144,  -940,         // 228
   2041,   152,         // 230
   2041,  -940,         // 232
  -1237,  -940,         // 234
  -2057,   152,         // 236
  -1237,   152,         // 238
  12187,   591,         // 240
  -3150,   152,         // 242
  -3150,  -940,         // 244
   2588, -1486,         // 246
   2588,  -940,         // 248
   3681, -1486,         // 250
   2588,   152,         // 252
   -690,   152,         // 254
   -144,   152,         // 256
    467,  -256,         // 258
     22,   740,         // 260
    467,   740,         // 262
   -626, -2067,         // 264
   -626, -1015,         // 266
   -100, -1015,         // 268
  -1140, -1010,         // 270
   -614, -1010,         // 272
   -614, -2062,         // 274
   -614, -2054,         // 276
   -607, -1002,         // 278
    -81, -1005,         // 280
  -1746, -1016,         // 282
  -4624, -2068,         // 284
  -7771, -1034,         // 286
  -7767, -2081,         // 288
   4874,    57,         // 290
   5396,   581,         // 292
   5398,  -855,         // 294
   -690,  -940,         // 296
      1,  2256,         // 298
   -500,   501,         // 300
      1,   501,         // 302
  -8291, -2083,         // 304
  -8820,  -907,         // 306
  -9474,  -909,         // 308
  -8823,     9,         // 310
  -2494, -2074,         // 312
  -3684, -1016,         // 314
  -2494, -1016,         // 316
  -1746, -2074,         // 318
  -3994, -1779,         // 320
  -3684, -2074,         // 322
  -4477, -2074,         // 324
  -2185, -1011,         // 326
  -3359, -2063,         // 328
    466,  -246,         // 330
     26,   736,         // 332
    466,   736,         // 334
  -1153, -1015,         // 336
   -627, -1015,         // 338
   -627, -2067,         // 340
   5920,  -462,         // 342
  -10135,   528,        // 344
  -9609,     6,         // 346
   3047,  -859,         // 348
   2656,  -859,         // 350
   3046,    55,         // 352
    -86,  -994,         // 354
   2001,    53,         // 356
    502,  3259,         // 358
   -625,  2256,         // 360
    502,  2256,         // 362
  -2057,  1246,         // 364
    402, -1247,         // 366
    402, -1349,         // 368
   -827, -1349,         // 370
  -3461, -2065,         // 372
  -4131, -1808,         // 374
  -3914, -1619,         // 376
   -144, -1486,         // 378
   8532,  -458,         // 380
   6441,   582,         // 382
   8530,   586,         // 384
  13232,   593,         // 386
  13234,  -451,         // 388
   2588,   699,         // 390
   3681,   699,         // 392
   -500, -3008,         // 394
    502, -2005,         // 396
   -500, -2005,         // 398
   9053,   586,         // 400
  10100,  -847,         // 402
   9054,  -457,         // 404
   5921,  -854,         // 406
   6442,  -461,         // 408
   2724,   836,         // 410
   3681,   836,         // 412
  -1374,    16,         // 414
  -1374, -1896,         // 416
  -1920, -1896,         // 418
  -1920,  1246,         // 420
  -1374,   836,         // 422
   -280,  1382,         // 424
   -827,   836,         // 426
   -280,  1714,         // 428
  -3150,  2339,         // 430
  -3150,  1246,         // 432
  -10129, -1043,        // 434
  -1001,  3259,         // 436
   -625,  3259,         // 438
  -1001,  1003,         // 440
   2041,   699,         // 442
  -1503,  1003,         // 444
   3681,  1792,         // 446
   3134,  2339,         // 448
   1004,  2256,         // 450
   2007,  3259,         // 452
   2007,   627,         // 454
   1004,  2131,         // 456
   1129,   627,         // 458
    628,  1128,         // 460
    628,  1629,         // 462
   -123,  1629,         // 464
  -1879,  2131,         // 466
  -1879,  1629,         // 468
   -625,  1128,         // 470
  -1377,     0,         // 472
  -1377,  1128,         // 474
      1,  1504,         // 476
    502,  1003,         // 478
    502,  1504,         // 480
   -500,  1003,         // 482
   -500,  -125,         // 484
   1004,   501,         // 486
   2007, -1504,         // 488
   2007,   501,         // 490
    502, -1504,         // 492
    502, -2005,         // 494
   -500, -2005,         // 496
  -1503,  -125,         // 498
  -1503, -3008,         // 500
   -500, -2131,         // 502
    628, -2131,         // 504
   1505, -3008,         // 506
   2007, -2507,         // 508
   2007, -1629,         // 510
    628, -1629,         // 512
    374,   350,         // 514
    669,   180,         // 516
    374,   180,         // 518
     87,   350,         // 520
     87,   180,         // 522
   -197,   350,         // 524
   -197,   180,         // 526
   -606, -1009,         // 528
   -736, -1610,         // 530
   -736, -1009,         // 532
   -606, -1610,         // 534
   -475, -1009,         // 536
   -475, -1610,         // 538
    402,  -673,         // 540
   -345, -1610,         // 542
   -475, -1007,         // 544
   -345, -1007,         // 546
    185,   515,         // 548
   -150,   360,         // 550
   -150,   515,         // 552
    638,   515,         // 554
    185,   360,         // 556
  -2827, -1790,         // 558
    313,  -454,         // 560
  -2204, -1213,         // 562
   -313, -1003,         // 564
   -182, -1722,         // 566
   -313, -1722,         // 568
    842,   351,         // 570
    500,   176,         // 572
    500,   351,         // 574
   -385,   176,         // 576
   -385,   351,         // 578
    948,  2339,         // 580
   2041,  1246,         // 582
   2041,  1499,         // 584
   1495,  1246,         // 586
  -11924,   520,        // 588
  -11917, -1050,        // 590
    -60,  -430,         // 592
     21,  -253,         // 594
    563,  -454,         // 596
   1389, -1411,         // 598
   1389, -2068,         // 600
    553, -1617,         // 602
    553, -1007,         // 604
   1109, -1007,         // 606
   1340, -1007,         // 608
   1109, -1617,         // 610
    645, -1016,         // 612
   1249, -1818,         // 614
   1249, -2074,         // 616
    538, -1486,         // 618
    538,  -393,         // 620
  -5048, -1409,         // 622
     22,  -256,         // 624
  -3823, -1016,         // 626
  -3823, -1626,         // 628
  -4477, -1016,         // 630
  -4378, -1626,         // 632
  -4378, -1016,         // 634
  -4217, -1779,         // 636
  -2181, -2059,         // 638
     26,  -246,         // 640
   -827,  -530,         // 642
    402,  -530,         // 644
  -3914, -1007,         // 646
  -4519, -2065,         // 648
  -4519, -1808,         // 650
   2041, -1486,         // 652
    502, -3008,         // 654
   2178,  1499,         // 656
   2178,   836,         // 658
   -625,     0,         // 660
    669,   350,         // 662
   -606, -1610,         // 664
   -606, -1009,         // 666
   -475, -1610,         // 668
    638,   360,         // 670
  -3013, -2067,         // 672
  -3013, -1423,         // 674
  -2349, -1423,         // 676
  -2204,  -486,         // 678
   -182, -1003,         // 680
    842,   176,         // 682
  -2827, -2043,         // 684
  -1503, -3008          // 686
}; // levelUVs

#define LEVEL_UV_INDEX_COUNT 293
const S3L_Index levelUVIndices[LEVEL_UV_INDEX_COUNT * 3] = {
      0,     1,     2,        // 0
      3,     4,     5,        // 3
      6,     3,     5,        // 6
      7,     8,     9,        // 9
     10,    11,    12,        // 12
      6,     5,    13,        // 15
     14,    15,    16,        // 18
     17,    18,    19,        // 21
     18,    17,    16,        // 24
     18,    16,    15,        // 27
     20,    21,    22,        // 30
      7,     4,     8,        // 33
     23,    24,     6,        // 36
     25,    26,    27,        // 39
     28,    29,    30,        // 42
     31,    22,    21,        // 45
     10,    32,    11,        // 48
     33,    34,    35,        // 51
     36,    37,    38,        // 54
     39,    40,    41,        // 57
     42,    41,    40,        // 60
     43,    44,    45,        // 63
     46,    47,    48,        // 66
     49,    50,    51,        // 69
     52,    53,    54,        // 72
     55,    56,     0,        // 75
     57,    58,    59,        // 78
     60,    61,    62,        // 81
     55,    21,    20,        // 84
     63,    64,    65,        // 87
     66,    67,    68,        // 90
     69,     4,    70,        // 93
     10,    71,    32,        // 96
      1,    72,     2,        // 99
     43,    73,    74,        // 102
     75,    76,    72,        // 105
     62,    77,    78,        // 108
     73,    79,    46,        // 111
     80,    81,    82,        // 114
     27,    83,    84,        // 117
     85,    86,    87,        // 120
     88,    89,    90,        // 123
     91,    92,    81,        // 126
     93,    94,    95,        // 129
     96,    92,    97,        // 132
     98,    97,    92,        // 135
     99,   100,   101,        // 138
     98,    92,    91,        // 141
    102,   103,   104,        // 144
     91,    81,   105,        // 147
    106,   107,   108,        // 150
    108,   109,   110,        // 153
    109,   108,   107,        // 156
    111,   112,   113,        // 159
    114,   115,   116,        // 162
    117,   118,   119,        // 165
    112,   120,   113,        // 168
    121,   118,   122,        // 171
    123,   124,   125,        // 174
    126,   125,   124,        // 177
    114,   127,   128,        // 180
    129,   130,   131,        // 183
    132,   133,   134,        // 186
    135,   136,   137,        // 189
    138,   139,   140,        // 192
     83,   141,    84,        // 195
     65,   142,    66,        // 198
    143,    67,   144,        // 201
    145,   146,   147,        // 204
    148,   119,   127,        // 207
    149,   150,   151,        // 210
    118,   117,   122,        // 213
    144,   152,   153,        // 216
    153,   152,   154,        // 219
    153,   155,   143,        // 222
    156,   157,   158,        // 225
    159,   158,   141,        // 228
    160,   161,   162,        // 231
    163,   164,    63,        // 234
    165,   166,   167,        // 237
    168,   169,   170,        // 240
    171,   147,   146,        // 243
     17,   172,    16,        // 246
    155,   153,   173,        // 249
     16,   173,   153,        // 252
    172,   173,    16,        // 255
    174,   175,   176,        // 258
    147,   174,   145,        // 261
    177,    57,    59,        // 264
    153,   143,   144,        // 267
    176,   145,   174,        // 270
    176,   175,   178,        // 273
    179,   180,   181,        // 276
    121,   182,   118,        // 279
    183,   184,   185,        // 282
    186,   187,   188,        // 285
    175,    57,   178,        // 288
     94,    93,    90,        // 291
    116,   189,   114,        // 294
    190,   191,   192,        // 297
    113,   193,   194,        // 300
    124,   115,   126,        // 303
    195,   196,   126,        // 306
    197,   198,   199,        // 309
    200,   201,   202,        // 312
    112,   201,   200,        // 315
    203,   147,   171,        // 318
    203,   171,   204,        // 321
    111,   201,   112,        // 324
     95,   205,   206,        // 327
    207,   185,   208,        // 330
    209,   207,   208,        // 333
    210,   207,   209,        // 336
    207,   210,   211,        // 339
    211,   212,   213,        // 342
    210,   214,   212,        // 345
    215,   182,   216,        // 348
     49,   217,    14,        // 351
    218,   180,   219,        // 354
    220,   180,   218,        // 357
    190,   203,   204,        // 360
    221,   115,    29,        // 363
     29,   128,    30,        // 366
    220,   222,   150,        // 369
    206,   205,   223,        // 372
    223,   205,   224,        // 375
    181,   225,   179,        // 378
    179,   225,   226,        // 381
    227,   228,   229,        // 384
    229,   228,   230,        // 387
    230,   228,   231,        // 390
    228,   232,   231,        // 393
    233,   234,   232,        // 396
    234,   235,   232,        // 399
    236,   235,   237,        // 402
    238,   239,   240,        // 405
    241,   242,   239,        // 408
    239,   242,   243,        // 411
    244,   243,   242,        // 414
    244,   245,   243,        // 417
    246,   244,   242,        // 420
    247,   246,   248,        // 423
    246,   242,   248,        // 426
    242,   249,   248,        // 429
    250,   248,   249,        // 432
    248,   250,   251,        // 435
    251,   250,   252,        // 438
    250,   253,   252,        // 441
    253,   254,   252,        // 444
    254,   255,   252,        // 447
    256,   252,   255,        // 450
    182,   215,   210,        // 453
    257,   258,   259,        // 456
    260,   259,   261,        // 459
    262,   261,   263,        // 462
    264,   265,   266,        // 465
    267,   268,   269,        // 468
    270,    88,   183,        // 471
    271,   272,   273,        // 474
    274,   275,   276,        // 477
    277,   278,   274,        // 480
    279,    71,    10,        // 483
    280,    46,    79,        // 486
    281,    78,    77,        // 489
    282,   283,   284,        // 492
    285,   286,   287,        // 495
    287,   288,   289,        // 498
      0,    56,     1,        // 501
      3,     8,     4,        // 504
     23,     6,    13,        // 507
     14,   217,    15,        // 510
      7,    70,     4,        // 513
     23,   290,    24,        // 516
    291,    24,   292,        // 519
     24,   290,   292,        // 522
     25,    85,    26,        // 525
     28,   293,    29,        // 528
    294,    19,    18,        // 531
     18,   295,   294,        // 534
     33,   296,    34,        // 537
     36,   297,    37,        // 540
     46,   280,    47,        // 543
    280,   298,    47,        // 546
    299,   300,    48,        // 549
    300,    46,    48,        // 552
     49,    14,    50,        // 555
     22,    31,   301,        // 558
     31,   302,   301,        // 561
    303,   304,   305,        // 564
    304,    54,   305,        // 567
     22,   301,    52,        // 570
     53,   305,    54,        // 573
     22,    52,    54,        // 576
     55,    20,    56,        // 579
     60,   102,    61,        // 582
     63,   164,    64,        // 585
     66,   142,    67,        // 588
      1,    75,    72,        // 591
     43,    45,    73,        // 594
     75,   186,    76,        // 597
     62,    61,    77,        // 600
     73,    45,    79,        // 603
     80,   105,    81,        // 606
     27,    26,    83,        // 609
     85,    25,    86,        // 612
     25,   306,    86,        // 615
    307,   308,    87,        // 618
    308,    85,    87,        // 621
     93,   309,    90,        // 624
    309,    88,    90,        // 627
     89,   310,    90,        // 630
     96,   101,    92,        // 633
     12,    11,   311,        // 636
    101,    96,    99,        // 639
    102,    60,   103,        // 642
    114,   128,   115,        // 645
    126,   196,   125,        // 648
    114,   148,   127,        // 651
    129,   312,   130,        // 654
     83,   159,   141,        // 657
     65,    64,   142,        // 660
    143,    68,    67,        // 663
    148,   117,   119,        // 666
    149,   180,   150,        // 669
    156,   161,   157,        // 672
    159,   156,   158,        // 675
    313,   157,   314,        // 678
    157,   161,   314,        // 681
    162,   315,   316,        // 684
    315,   317,   316,        // 687
    160,   314,   161,        // 690
    162,   316,   318,        // 693
    318,   160,   162,        // 696
    163,   319,   164,        // 699
    165,   320,   166,        // 702
    179,   219,   180,        // 705
    121,   216,   182,        // 708
    185,   321,   270,        // 711
    321,   322,   270,        // 714
    270,   183,   185,        // 717
    323,    76,   188,        // 720
     76,   186,   188,        // 723
    186,   324,   187,        // 726
    324,   325,   187,        // 729
    175,    58,    57,        // 732
    116,   326,   189,        // 735
    190,   204,   191,        // 738
    113,   120,   193,        // 741
    124,   116,   115,        // 744
    197,   327,   198,        // 747
     95,    94,   205,        // 750
    207,   321,   185,        // 753
    211,   210,   212,        // 756
     23,   210,   215,        // 759
    220,   150,   180,        // 762
     29,   115,   128,        // 765
    224,   205,   328,        // 768
    205,   329,   328,        // 771
    228,   233,   232,        // 774
    234,   237,   235,        // 777
    236,   330,   235,        // 780
    238,   241,   239,        // 783
    257,   331,   258,        // 786
    260,   257,   259,        // 789
    262,   260,   261,        // 792
    264,   332,   265,        // 795
    267,   333,   268,        // 798
    270,    89,    88,        // 801
    271,   334,   272,        // 804
    274,   278,   275,        // 807
    277,   335,   278,        // 810
     13,   214,    23,        // 813
    336,   337,   338,        // 816
    281,   339,    78,        // 819
     77,   336,   338,        // 822
    338,   281,    77,        // 825
    282,   340,   283,        // 828
    285,   341,   286,        // 831
    287,   286,   288,        // 834
    292,   224,   328,        // 837
    292,   290,   224,        // 840
     99,    96,   311,        // 843
     12,   311,    96,        // 846
    210,    23,   214,        // 849
     10,   177,   279,        // 852
    177,    59,   279,        // 855
    225,   227,   226,        // 858
    228,   227,   225,        // 861
    279,    59,   342,        // 864
    202,   201,   190,        // 867
    190,   201,   203,        // 870
    150,   222,   343,        // 873
    343,   197,   150         // 876
}; // levelUVIndices

S3L_Model3D levelModel;

void levelModelInit()
{
  S3L_initModel3D(
    levelVertices,
    LEVEL_VERTEX_COUNT,
    levelTriangleIndices,
    LEVEL_TRIANGLE_COUNT,
    &levelModel);
}

#endif // guard
