#ifndef HOUSE_MODEL_H
#define HOUSE_MODEL_H

#define HOUSE_VERTEX_COUNT 127
const S3L_Unit houseVertices[HOUSE_VERTEX_COUNT * 3] = {
   1809,   657,  -687,        // 0
   1635,  -291,  -914,        // 3
   1635,  -309,  -632,        // 6
   1473,   657, -1113,        // 9
   1809,   657, -1113,        // 12
   2070,   661, -1396,        // 15
   1659,   657,  -687,        // 18
   1659,   657,  1039,        // 21
   1563,   142,  -217,        // 24
   1563,   138,   582,        // 27
   1489,  -270,  -632,        // 30
    188,   733, -1473,        // 33
   1354,  -245,  -914,        // 36
   1473,   657,  -910,        // 39
   1354,  -206,  -729,        // 42
   1240,  2205,   176,        // 45
     68,  2107,   176,        // 48
   1530, -1123,  -636,        // 51
   1313, -1123,  -765,        // 54
   1313, -1123, -1005,        // 57
   1644, -1123, -1005,        // 60
   1644, -1123,  -636,        // 63
    602,  -251,  -728,        // 66
    637,   374,  -882,        // 69
    539, -1118,  -936,        // 72
    637,   372, -1124,        // 75
    539, -1123,  -768,        // 78
    464,   190, -1109,        // 81
    372, -1119,  -948,        // 84
    464,   192,  -845,        // 87
    372, -1123,  -748,        // 90
   1312,   142,  -217,        // 93
   1489,  -248,  -204,        // 96
   1312,  -534,  -171,        // 99
   1312,  -533,   521,        // 102
   1312,   138,   582,        // 105
   1508,  -534,  -171,        // 108
   1508,  -533,   521,        // 111
   1530, -1123,   988,        // 114
  -1672,   657,  -687,        // 117
  -1498,  -315,  -914,        // 120
  -1672,   657, -1113,        // 123
  -1336,   657, -1113,        // 126
  -1909,   681, -1429,        // 129
  -1352,  -251,  -632,        // 132
  -1498,  -315,  -632,        // 135
  -1426,   146,   494,        // 138
  -1323,  -347,   999,        // 141
  -1352,  -247,   503,        // 144
  -1221,  -305,  -914,        // 147
  -1336,   657,  -910,        // 150
  -2446,  2327,   278,        // 153
  -1872,   681,  1713,        // 156
  -1393, -1123,  -636,        // 159
  -1176, -1123,  -765,        // 162
  -1221,  -284,  -729,        // 165
  -1176, -1123,  -961,        // 168
  -1527, -1123,  -636,        // 171
   -443,  -251,  -728,        // 174
   -477,   343,  -882,        // 177
   -402, -1118,  -936,        // 180
   -402, -1123,  -768,        // 183
   -304,   160, -1109,        // 186
   -477,   341, -1124,        // 189
   -235, -1119,  -948,        // 192
   -304,   162,  -845,        // 195
  -1672,   657,  1039,        // 198
  -1175,   146,  -142,        // 201
  -1175,  -645,  -145,        // 204
  -1352,  -247,  -151,        // 207
  -1426,   146,  -142,        // 210
  -1371,  -645,  -145,        // 213
  -1523,   657,  1039,        // 216
   1809,   657,  1039,        // 219
   1635,  -251,  1266,        // 222
   1809,   628,  1466,        // 225
   2450,  2567,   227,        // 228
  -1336,   657,  1262,        // 231
    247,   714,  1527,        // 234
   1473,   657,  1262,        // 237
   1473,   657,  1466,        // 240
   2042,   591,  1653,        // 243
   1635,  -219,   984,        // 246
   1373,  -213,  1266,        // 249
  -1103,  2205,   176,        // 252
  -1286,  1892,  -143,        // 255
   1489,  -219,   984,        // 258
   1313, -1123,  1117,        // 261
   1373,  -213,  1081,        // 264
   1313, -1123,  1313,        // 267
   1644, -1123,   988,        // 270
   1489,  -248,   555,        // 273
  -1468,  -347,  1266,        // 276
  -1468,  -347,   999,        // 279
  -1336,   657,  1466,        // 282
  -1672,   657,  1466,        // 285
  -1175,   146,   494,        // 288
  -1523,   657,  -687,        // 291
  -1222,  -347,  1266,        // 294
  -1222,  -347,  1081,        // 297
  -1393, -1123,   988,        // 300
  -1176, -1123,  1117,        // 303
  -1176, -1123,  1313,        // 306
  -1507, -1123,  1313,        // 309
  -1507, -1123,   988,        // 312
  -1371,  -645,   497,        // 315
  -1175,  -645,   497,        // 318
   -235, -1123,  -748,        // 321
  -1442,  2357,  -538,        // 324
  -1405,  1712,  -323,        // 327
  -1589,  1878,  -170,        // 330
  -1257,  2383,  -200,        // 333
  -1712,  2416,  -224,        // 336
  -1527, -1123,  -961,        // 339
   1644, -1123,  1313,        // 342
  -1636,   657,  -930,        // 345
  -1636,   657,  -930,        // 348
  -1672,   657,  1466,        // 351
   1773,   657,  -930,        // 354
   1773,   657,  -930,        // 357
   1809,   657,  1466,        // 360
  -1636,   657,  1282,        // 363
  -1636,   657,  1282,        // 366
  -1672,   657, -1113,        // 369
   1773,   657,  1282,        // 372
   1773,   657,  1282,        // 375
   1809,   657, -1113         // 378
}; // houseVertices

#define HOUSE_TRIANGLE_COUNT 200
const S3L_Index houseTriangleIndices[HOUSE_TRIANGLE_COUNT * 3] = {
      0,     1,     2,        // 0
      3,     1,     4,        // 3
      3,     4,     5,        // 6
      0,     5,     4,        // 9
      2,     6,     0,        // 12
      7,     8,     9,        // 15
      6,    10,     8,        // 18
     11,     3,     5,        // 21
     12,    13,    14,        // 24
     15,    16,    11,        // 27
      2,    17,    10,        // 30
     12,    18,    19,        // 33
      1,    19,    20,        // 36
      1,    21,     2,        // 39
     22,    18,    14,        // 42
     23,    14,    13,        // 45
     24,    23,    25,        // 48
     26,    22,    23,        // 51
     24,    27,    28,        // 54
     28,    29,    30,        // 57
     31,    32,    33,        // 60
     32,    31,     8,        // 63
     31,    34,    35,        // 66
     36,    33,    32,        // 69
     37,    17,    38,        // 72
     17,    36,    10,        // 75
     39,    40,    41,        // 78
     40,    42,    41,        // 81
     42,    43,    41,        // 84
     39,    41,    43,        // 87
     39,    44,    45,        // 90
     46,    47,    48,        // 93
     11,    43,    42,        // 96
     49,    50,    42,        // 99
     51,    52,    43,        // 102
     53,    45,    44,        // 105
     49,    54,    55,        // 108
     40,    56,    49,        // 111
     57,    40,    45,        // 114
     54,    58,    55,        // 117
     55,    59,    50,        // 120
     60,    59,    61,        // 123
     61,    59,    58,        // 126
     60,    62,    63,        // 129
     64,    65,    62,        // 132
     43,    66,    39,        // 135
     67,    68,    69,        // 138
     69,    70,    67,        // 141
     71,    69,    68,        // 144
     72,    47,    46,        // 147
     73,    74,    75,        // 150
     15,     5,    76,        // 153
     77,    78,    79,        // 156
     74,    80,    75,        // 159
     80,    81,    75,        // 162
     73,    75,    81,        // 165
      7,    82,    73,        // 168
      0,     7,    73,        // 171
     10,    32,     8,        // 174
     78,    81,    80,        // 177
     83,    79,    80,        // 180
     16,    84,    85,        // 183
     15,    78,    16,        // 186
     38,    82,    86,        // 189
     83,    87,    88,        // 192
     74,    89,    83,        // 195
     90,    74,    82,        // 198
     35,    34,    91,        // 201
     91,     9,    35,        // 204
      8,    35,     9,        // 207
     37,    91,    34,        // 210
     33,    37,    34,        // 213
     10,    36,    32,        // 216
     66,    92,    93,        // 219
     84,    52,    51,        // 222
     94,    78,    77,        // 225
     94,    92,    95,        // 228
     94,    95,    52,        // 231
     66,    52,    95,        // 234
     93,    72,    66,        // 237
     96,    68,    67,        // 240
     97,    70,    44,        // 243
     78,    94,    52,        // 246
     98,    77,    99,        // 249
     15,    81,    78,        // 252
     84,    16,    78,        // 255
     70,    72,    46,        // 258
     93,   100,    47,        // 261
     98,   101,   102,        // 264
     98,   103,    92,        // 267
     92,   104,    93,        // 270
     99,    87,   101,        // 273
     77,    88,    99,        // 276
    105,    53,    71,        // 279
     96,    48,   106,        // 282
     48,    96,    46,        // 285
    106,    71,    68,        // 288
    105,   106,    48,        // 291
     46,    67,    70,        // 294
     70,    69,    44,        // 297
     66,    97,    39,        // 300
     81,     0,    73,        // 303
     76,     5,    81,        // 306
     30,    65,   107,        // 309
     27,    65,    29,        // 312
     27,    63,    62,        // 315
     59,    25,    23,        // 318
     23,    50,    59,        // 321
     11,    50,    13,        // 324
      3,    11,    13,        // 327
     11,    42,    50,        // 330
      7,     9,    86,        // 333
     86,     9,    91,        // 336
     86,    91,    37,        // 339
     38,    86,    37,        // 342
    105,    48,    47,        // 345
     47,   100,   105,        // 348
     71,    44,    69,        // 351
     44,    71,    53,        // 354
     85,   108,   109,        // 357
    108,   110,   109,        // 360
    110,   111,    85,        // 363
    112,   108,   111,        // 366
     43,   110,    51,        // 369
    109,   110,    43,        // 372
     11,    16,    85,        // 375
    109,    11,    85,        // 378
    109,    43,    11,        // 381
     85,    84,   110,        // 384
     84,    51,   110,        // 387
     78,    80,    79,        // 390
      0,     4,     1,        // 393
      3,    12,     1,        // 396
      2,    10,     6,        // 399
      7,     6,     8,        // 402
     12,     3,    13,        // 405
      2,    21,    17,        // 408
     12,    14,    18,        // 411
      1,    12,    19,        // 414
      1,    20,    21,        // 417
     22,    26,    18,        // 420
     23,    22,    14,        // 423
     24,    26,    23,        // 426
     24,    25,    27,        // 429
     28,    27,    29,        // 432
     31,    33,    34,        // 435
     37,    36,    17,        // 438
     39,    45,    40,        // 441
     40,    49,    42,        // 444
     39,    97,    44,        // 447
     49,    55,    50,        // 450
     53,    57,    45,        // 453
     49,    56,    54,        // 456
     40,   113,    56,        // 459
     57,   113,    40,        // 462
     54,    61,    58,        // 465
     55,    58,    59,        // 468
     60,    63,    59,        // 471
     60,    64,    62,        // 474
     64,   107,    65,        // 477
     43,    52,    66,        // 480
     73,    82,    74,        // 483
     15,    11,     5,        // 486
     74,    83,    80,        // 489
      7,    86,    82,        // 492
      0,     6,     7,        // 495
     83,    88,    79,        // 498
     38,    90,    82,        // 501
     83,    89,    87,        // 504
     74,   114,    89,        // 507
     90,   114,    74,        // 510
      8,    31,    35,        // 513
     33,    36,    37,        // 516
     66,    95,    92,        // 519
     84,    78,    52,        // 522
     94,    98,    92,        // 525
     93,    47,    72,        // 528
     96,   106,    68,        // 531
     98,    94,    77,        // 534
     15,    76,    81,        // 537
     70,    97,    72,        // 540
     93,   104,   100,        // 543
     98,    99,   101,        // 546
     98,   102,   103,        // 549
     92,   103,   104,        // 552
     99,    88,    87,        // 555
     77,    79,    88,        // 558
    105,   100,    53,        // 561
    106,   105,    71,        // 564
     46,    96,    67,        // 567
     66,    72,    97,        // 570
     81,     5,     0,        // 573
     30,    29,    65,        // 576
     27,    62,    65,        // 579
     27,    25,    63,        // 582
     59,    63,    25,        // 585
     23,    13,    50,        // 588
     85,   111,   108,        // 591
    108,   112,   110,        // 594
    110,   112,   111         // 597
}; // houseTriangleIndices

#define HOUSE_UV_COUNT 173
const S3L_Unit houseUVs[HOUSE_UV_COUNT * 2] = {
    279,   174,         // 0
    166,   140,         // 2
    166,   174,         // 4
    279,   106,         // 6
    279,   140,         // 8
    281,   238,         // 10
    307,   238,         // 12
    327,   260,         // 14
    307,   206,         // 16
    279,   204,         // 18
    484,    15,         // 20
    393,    53,         // 22
    447,    53,         // 24
    355,    15,         // 26
    360,    83,         // 28
    183,   266,         // 30
    166,   106,         // 32
    279,    74,         // 34
    166,    74,         // 36
    263,   397,         // 38
    203,   397,         // 40
    203,   505,         // 42
     68,   204,         // 44
    166,   204,         // 46
     68,    74,         // 48
     68,   106,         // 50
     68,   140,         // 52
     68,   174,         // 54
    454,   338,         // 56
    494,   392,         // 58
    496,   335,         // 60
    451,   298,         // 62
    504,   280,         // 64
    440,   382,         // 66
    445,   304,         // 68
    445,   392,         // 70
    436,   314,         // 72
    431,   382,         // 74
    432,   318,         // 76
    428,   373,         // 78
    399,    58,         // 80
    392,    82,         // 82
    401,   102,         // 84
    439,   102,         // 86
    441,    58,         // 88
    395,   107,         // 90
    444,   107,         // 92
    359,   147,         // 94
    480,   147,         // 96
    279,   106,         // 98
    166,   140,         // 100
    279,   140,         // 102
    279,   174,         // 104
     66,   238,         // 106
     22,   263,         // 108
     41,   238,         // 110
     41,   206,         // 112
    166,    74,         // 114
    166,   106,         // 116
    447,    53,         // 118
    480,    85,         // 120
    448,    82,         // 122
    166,   174,         // 124
    279,   204,         // 126
     86,   397,         // 128
      0,   449,         // 130
     86,   505,         // 132
     68,    74,         // 134
     68,   204,         // 136
    166,   204,         // 138
     68,   174,         // 140
     68,   106,         // 142
    337,   392,         // 144
    378,   338,         // 146
    334,   340,         // 148
    381,   300,         // 150
    327,   280,         // 152
    391,   382,         // 154
    385,   392,         // 156
    396,   315,         // 158
    387,   306,         // 160
    399,   382,         // 162
    400,   319,         // 164
     41,    74,         // 166
    399,    58,         // 168
    401,   102,         // 170
    392,    82,         // 172
    393,    53,         // 174
    395,   107,         // 176
    484,    15,         // 178
    279,   106,         // 180
    166,   140,         // 182
    279,   140,         // 184
    314,   505,         // 186
    314,   397,         // 188
     66,    57,         // 190
    187,    36,         // 192
    281,    57,         // 194
    279,   174,         // 196
    281,    41,         // 198
    325,    27,         // 200
    307,    41,         // 202
    307,    74,         // 204
    279,    74,         // 206
    166,   106,         // 208
    295,    74,         // 210
    166,   174,         // 212
    279,   204,         // 214
    144,   397,         // 216
    136,   420,         // 218
    203,   291,         // 220
     68,    74,         // 222
    166,    74,         // 224
     68,   204,         // 226
    166,   204,         // 228
     68,   174,         // 230
     68,   106,         // 232
    448,    82,         // 234
    279,   174,         // 236
    166,   140,         // 238
    166,   174,         // 240
     86,   291,         // 242
     66,    41,         // 244
    279,   106,         // 246
    279,   140,         // 248
     41,    41,         // 250
     25,    22,         // 252
    279,   204,         // 254
    441,    58,         // 256
    355,    15,         // 258
    360,    83,         // 260
    166,   106,         // 262
    279,    74,         // 264
    166,    74,         // 266
    314,   291,         // 268
     68,   204,         // 270
    166,   204,         // 272
     68,    74,         // 274
     68,   106,         // 276
     68,   140,         // 278
     68,   174,         // 280
    495,   218,         // 282
    345,   264,         // 284
    492,   264,         // 286
    502,   158,         // 288
    342,   210,         // 290
    444,   107,         // 292
    359,   147,         // 294
    439,   102,         // 296
     52,   206,         // 298
    402,   449,         // 300
    403,   373,         // 302
     66,   223,         // 304
    281,   223,         // 306
    480,    85,         // 308
    480,   147,         // 310
    492,   407,         // 312
    425,   437,         // 314
    492,   437,         // 316
    492,   467,         // 318
    425,   500,         // 320
    492,   500,         // 322
    425,   467,         // 324
    398,   484,         // 326
    121,   423,         // 328
    131,   433,         // 330
    279,    74,         // 332
     68,   140,         // 334
    295,   206,         // 336
     68,   140,         // 338
    336,   158,         // 340
     52,    74,         // 342
    425,   407          // 344
}; // houseUVs

#define HOUSE_UV_INDEX_COUNT 200
const S3L_Index houseUVIndices[HOUSE_UV_INDEX_COUNT * 3] = {
      0,     1,     2,        // 0
      3,     1,     4,        // 3
      5,     6,     7,        // 6
      8,     7,     6,        // 9
      2,     9,     0,        // 12
     10,    11,    12,        // 15
     13,    14,    11,        // 18
     15,     5,     7,        // 21
     16,    17,    18,        // 24
     19,    20,    21,        // 27
      2,    22,    23,        // 30
     16,    24,    25,        // 33
      1,    25,    26,        // 36
      1,    27,     2,        // 39
     28,    29,    30,        // 42
     31,    30,    32,        // 45
     33,    31,    34,        // 48
     35,    28,    31,        // 51
     33,    36,    37,        // 54
     37,    38,    39,        // 57
     40,    41,    42,        // 60
     41,    40,    11,        // 63
     40,    43,    44,        // 66
     45,    42,    41,        // 69
     46,    47,    48,        // 72
     47,    45,    14,        // 75
     49,    50,    51,        // 78
     50,    52,    51,        // 81
     53,    54,    55,        // 84
     56,    55,    54,        // 87
     49,    57,    58,        // 90
     59,    60,    61,        // 93
     15,    54,    53,        // 96
     62,    63,    52,        // 99
     64,    65,    66,        // 102
     67,    58,    57,        // 105
     62,    68,    69,        // 108
     50,    70,    62,        // 111
     71,    50,    58,        // 114
     72,    73,    74,        // 117
     74,    75,    76,        // 120
     77,    75,    78,        // 123
     78,    75,    73,        // 126
     77,    79,    80,        // 129
     81,    82,    79,        // 132
     54,    83,    56,        // 135
     84,    85,    86,        // 138
     86,    87,    84,        // 141
     88,    86,    85,        // 144
     89,    60,    59,        // 147
     90,    91,    92,        // 150
     19,    93,    94,        // 153
     95,    96,    97,        // 156
     91,    98,    92,        // 159
     99,   100,   101,        // 162
    102,   101,   100,        // 165
    103,   104,    90,        // 168
      8,   105,   102,        // 171
     14,    41,    11,        // 174
     96,   100,    99,        // 177
    106,   107,    98,        // 180
     20,   108,   109,        // 183
     19,   110,    20,        // 186
    111,   104,   112,        // 189
    106,   113,   114,        // 192
     91,   115,   106,        // 195
    116,    91,   104,        // 198
     44,    43,   117,        // 201
    117,    12,    44,        // 204
     11,    44,    12,        // 207
     46,   117,    43,        // 210
     42,    46,    43,        // 213
     14,    45,    41,        // 216
    118,   119,   120,        // 219
    108,   121,    64,        // 222
    122,    96,    95,        // 225
    123,   119,   124,        // 228
    122,   125,   126,        // 231
     83,   126,   125,        // 234
    120,   127,   118,        // 237
    128,    85,    84,        // 240
    129,    87,   130,        // 243
     96,   122,   126,        // 246
    131,   132,   133,        // 249
     19,   134,   110,        // 252
    108,    20,   110,        // 255
     87,    89,    59,        // 258
    120,   135,   136,        // 261
    131,   137,   138,        // 264
    131,   139,   119,        // 267
    119,   140,   120,        // 270
    141,   142,   143,        // 273
    144,   145,   141,        // 276
    146,   147,    88,        // 279
    128,    61,   148,        // 282
     61,   128,    59,        // 285
    148,    88,    85,        // 288
    146,   148,    61,        // 291
     59,    84,    87,        // 294
     87,    86,   130,        // 297
     83,   149,    56,        // 300
    100,     8,   102,        // 303
     94,    93,   150,        // 306
     39,    82,   151,        // 309
     36,    82,    38,        // 312
     36,    80,    79,        // 315
     75,    34,    31,        // 318
     31,    76,    75,        // 321
     15,   152,   153,        // 324
      5,    15,   153,        // 327
     15,    53,   152,        // 330
     10,    12,   154,        // 333
    154,    12,   117,        // 336
    154,   117,    46,        // 339
     48,   154,    46,        // 342
    146,    61,    60,        // 345
     60,   155,   146,        // 348
     88,   130,    86,        // 351
    130,    88,   147,        // 354
    156,   157,   158,        // 357
    157,   159,   158,        // 360
    159,   160,   161,        // 363
    162,   163,   160,        // 366
     66,   164,    64,        // 369
    165,   164,    66,        // 372
     21,    20,   109,        // 375
    165,    21,   109,        // 378
    165,    66,    21,        // 381
    109,   108,   164,        // 384
    108,    64,   164,        // 387
     96,    99,    97,        // 390
      0,     4,     1,        // 393
      3,    16,     1,        // 396
      2,    23,     9,        // 399
     10,    13,    11,        // 402
     16,     3,    17,        // 405
      2,    27,    22,        // 408
     16,    18,    24,        // 411
      1,    16,    25,        // 414
      1,    26,    27,        // 417
     28,    35,    29,        // 420
     31,    28,    30,        // 423
     33,    35,    31,        // 426
     33,    34,    36,        // 429
     37,    36,    38,        // 432
     40,    42,    43,        // 435
     46,    45,    47,        // 438
     49,    58,    50,        // 441
     50,    62,    52,        // 444
     49,   166,    57,        // 447
     62,    69,    63,        // 450
     67,    71,    58,        // 453
     62,    70,    68,        // 456
     50,   167,    70,        // 459
     71,   167,    50,        // 462
     72,    78,    73,        // 465
     74,    73,    75,        // 468
     77,    80,    75,        // 471
     77,    81,    79,        // 474
     81,   151,    82,        // 477
     54,   126,    83,        // 480
     90,   104,    91,        // 483
     19,    21,    93,        // 486
     91,   106,    98,        // 489
    103,   112,   104,        // 492
      8,   168,   105,        // 495
    106,   114,   107,        // 498
    111,   116,   104,        // 501
    106,   115,   113,        // 504
     91,   169,   115,        // 507
    116,   169,    91,        // 510
     11,    40,    44,        // 513
     42,    45,    46,        // 516
    118,   124,   119,        // 519
    108,   110,   121,        // 522
    123,   131,   119,        // 525
    120,   136,   127,        // 528
    128,   148,    85,        // 531
    131,   123,   132,        // 534
     19,    94,   134,        // 537
     87,   129,    89,        // 540
    120,   140,   135,        // 543
    131,   133,   137,        // 546
    131,   138,   139,        // 549
    119,   139,   140,        // 552
    141,   145,   142,        // 555
    144,   170,   145,        // 558
    146,   155,   147,        // 561
    148,   146,    88,        // 564
     59,   128,    84,        // 567
     83,   171,   149,        // 570
    100,     7,     8,        // 573
     39,    38,    82,        // 576
     36,    79,    82,        // 579
     36,    34,    80,        // 582
     75,    80,    34,        // 585
     31,    32,    76,        // 588
    156,   172,   157,        // 591
    157,   162,   159,        // 594
    159,   162,   160         // 597
}; // houseUVIndices

S3L_Model3D houseModel;

void houseModelInit()
{
  S3L_initModel3D(
    houseVertices,
    HOUSE_VERTEX_COUNT,
    houseTriangleIndices,
    HOUSE_TRIANGLE_COUNT,
    &houseModel);
}

#endif // guard
