/*
  Can be used to test the engine on prepared position test. Copy positions here
  from existing tests (won't be added here because of copyright).
*/

#include <stdio.h>
#include "smallchesslib.h"

const char *positions[] =
{
  /* format: ! at start means avoid the move, else play the move; then the move
  follows, then space, then FEN. */

  "h5f7 r1bqkb1r/p1pppppp/1pn2n2/4N2Q/8/4P3/PPPP1PPP/RNB1K2R w KQkq - 0 1",
  "g5f3 rnb1kb1r/pppppppp/4q3/6n1/8/1P4PN/P1PPPP1P/RNBQKB1R b KQkq - 0 1",
  "!a4d4 rn2kb1r/pppppppp/8/8/Q2b4/1P2n3/P2PPPPP/RRB1KBN1 w Qkq - 0 1",
  "!b6a5 rnb1kn2/p1pppppp/1p6/R7/4Q2B/8/PPPPPPPP/RN2K2R b KQq - 0 1",
  "-" // terminator, leave at the end
};

int main(void)
{
  puts("TESTING POSITIONS:");

  unsigned int score = 0;
  unsigned int total = 0;

  while (1)
  {
    const char *s = positions[total];

    if (*s == '-')
      break;

    uint8_t avoid = 0;

    if (*s == '!')
    {
      avoid = 1;
      s++;
    }

    uint8_t mFrom, mTo;
    char mProm;

    SCL_stringToMove(s,&mFrom,&mTo,&mProm);

    while (*s != ' ')
      s++;

    s++;

    SCL_Board b;

    SCL_boardFromFEN(b,s);

    uint8_t mFrom2, mTo2;
    char mProm2;

    SCL_getAIMove(b,
      5, // depth
      2, // extension depth
      1, // endgame extra
      SCL_boardEvaluateStatic,0,0,255,255,&mFrom2,&mTo2,&mProm2);

    printf("%d: ",total);

    if ((mFrom == mFrom2 && mTo == mTo2) != avoid)
    {
      printf("OK\n");
      score++;
    }
    else
      printf("FAIL\n");

    total++;
  }

  printf("\nresult: %d/%d\n",score,total);

  return 0;
}
