#ifndef CAT2_MODEL_H
#define CAT2_MODEL_H

#define CAT2_VERTEX_COUNT 59
const S3L_Unit cat2Vertices[CAT2_VERTEX_COUNT * 3] = {
    271,   395,  1477,        // 0
    -82,  1300,  1688,        // 3
    130,  2076,  1361,        // 6
    321,  -125,  1535,        // 9
    283,  -485,  1781,        // 12
    206, -1236,  1900,        // 15
    165, -1434,  1643,        // 18
    259,  -698,  1535,        // 21
    175,  -429,   611,        // 24
    245,  -369,  -577,        // 27
    470,   869, -1281,        // 30
    518,  1224, -1275,        // 33
    195,   582, -1421,        // 36
    353,  -136, -1121,        // 39
    194, -1395, -1379,        // 42
    260,   416,  -874,        // 45
    112, -1329, -1848,        // 48
    106, -1162, -1529,        // 51
    273,   211,   226,        // 54
    391,   717, -1698,        // 57
      5, -1395, -1374,        // 60
     82,  -527,  1708,        // 63
      5, -1214,  1900,        // 66
   -229,   289,  1463,        // 69
      0,   646,  -755,        // 72
   -333,  1386,  1691,        // 75
    -30,  2130,  1371,        // 78
    -27,  1896,  1245,        // 81
   -207,  1322,  1465,        // 84
      3,   632,  1264,        // 87
      0,   600,   239,        // 90
   -321,  -186,  1262,        // 93
   -325,  -879,  1000,        // 96
   -325, -1396,   478,        // 99
   -285, -1289,   222,        // 102
   -259,  -805,   660,        // 105
   -175,  -429,   611,        // 108
   -245,  -376,  -479,        // 111
   -297,  1021, -1277,        // 114
   -252,  1384, -1171,        // 117
    140,  1221, -1448,        // 120
    139,  1222, -1661,        // 123
     66,   862, -1982,        // 126
     31,   684, -1976,        // 129
   -160,   637, -1420,        // 132
   -353,     7, -1013,        // 135
   -398, -1209,  -107,        // 138
   -260,   416,  -868,        // 141
   -297, -1417,  -525,        // 144
   -254, -1171,  -389,        // 147
   -273,   296,   360,        // 150
   -286,   851, -1695,        // 153
    134,  1186, -1170,        // 156
      7,   554, -1513,        // 159
      0,  -288, -1107,        // 162
   -174, -1225,  -119,        // 165
      0,  -231,  1361,        // 168
   -124,  -850,   978,        // 171
   -124, -1403,   456         // 174
}; // cat2Vertices

#define CAT2_TRIANGLE_COUNT 114
const S3L_Index cat2TriangleIndices[CAT2_TRIANGLE_COUNT * 3] = {
      9,    13,    14,        // 0
     16,    14,    17,        // 3
     24,    18,    30,        // 6
     29,    18,     0,        // 9
     15,    13,     9,        // 12
     18,    15,     9,        // 15
      9,     8,    18,        // 18
     28,    29,     0,        // 21
      0,     1,    28,        // 24
     27,    28,     2,        // 27
      1,     2,    28,        // 30
      8,     3,    18,        // 33
      0,    18,     3,        // 36
      8,     7,     3,        // 39
      3,     7,     4,        // 42
      5,     4,     7,        // 45
      6,     5,     7,        // 48
     11,    40,    10,        // 51
     43,    12,    19,        // 54
     19,    42,    43,        // 57
     41,    42,    19,        // 60
     19,    10,    41,        // 63
     41,    10,    40,        // 66
     19,    12,    10,        // 69
     24,    10,    15,        // 72
     10,    12,    15,        // 75
     12,    13,    15,        // 78
     10,    52,    11,        // 81
     11,    52,    40,        // 84
     24,    52,    10,        // 87
     43,    53,    12,        // 90
     13,    53,    54,        // 93
     17,    20,    16,        // 96
      9,    14,    20,        // 99
     16,    20,    14,        // 102
     54,    20,    17,        // 105
      9,    20,    54,        // 108
      1,    26,     2,        // 111
      5,    21,     4,        // 114
     21,     3,     4,        // 117
      5,     6,    22,        // 120
      7,    22,     6,        // 123
      7,    56,    21,        // 126
      3,    56,     0,        // 129
     56,     8,    36,        // 132
     14,    13,    17,        // 135
     54,    17,    13,        // 138
     37,    46,    45,        // 141
     48,    49,    46,        // 144
     30,    47,    24,        // 147
     29,    50,    30,        // 150
     47,    37,    45,        // 153
     50,    37,    47,        // 156
     37,    50,    36,        // 159
     28,    23,    29,        // 162
     23,    28,    25,        // 165
     27,    26,    28,        // 168
     25,    28,    26,        // 171
     36,    50,    31,        // 174
     23,    31,    50,        // 177
     36,    31,    35,        // 180
     31,    32,    35,        // 183
     33,    35,    32,        // 186
     34,    35,    33,        // 189
     39,    38,    40,        // 192
     43,    51,    44,        // 195
     51,    43,    42,        // 198
     41,    51,    42,        // 201
     51,    41,    38,        // 204
     41,    40,    38,        // 207
     51,    38,    44,        // 210
     24,    47,    38,        // 213
     38,    47,    44,        // 216
     44,    47,    45,        // 219
     38,    39,    52,        // 222
     39,    40,    52,        // 225
     24,    38,    52,        // 228
     43,    44,    53,        // 231
     53,    45,    54,        // 234
     49,    48,    55,        // 237
     37,    55,    46,        // 240
     48,    46,    55,        // 243
     54,    49,    55,        // 246
     37,    54,    55,        // 249
      2,    26,    27,        // 252
     23,     1,     0,        // 255
     33,    57,    58,        // 258
     31,    57,    32,        // 261
     33,    58,    34,        // 264
     58,    35,    34,        // 267
     57,    36,    35,        // 270
     31,    23,    56,        // 273
     56,    23,     0,        // 276
     37,     8,     9,        // 279
     54,    37,     9,        // 282
     46,    49,    45,        // 285
     54,    45,    49,        // 288
     24,    15,    18,        // 291
     29,    30,    18,        // 294
     13,    12,    53,        // 297
      1,    25,    26,        // 300
      5,    22,    21,        // 303
     21,    56,     3,        // 306
      7,    21,    22,        // 309
      7,     8,    56,        // 312
     30,    50,    47,        // 315
     29,    23,    50,        // 318
     53,    44,    45,        // 321
     23,    25,     1,        // 324
     33,    32,    57,        // 327
     31,    56,    57,        // 330
     58,    57,    35,        // 333
     57,    56,    36,        // 336
     37,    36,     8         // 339
}; // cat2TriangleIndices

#define CAT2_UV_COUNT 90
const S3L_Unit cat2UVs[CAT2_UV_COUNT * 2] = {
    191,   369,         // 0
    142,   329,         // 2
    159,   509,         // 4
    109,   504,         // 6
    140,   472,         // 8
    164,   242,         // 10
    296,   277,         // 12
    289,   243,         // 14
    419,   232,         // 16
    438,   278,         // 18
    148,   264,         // 20
    341,   371,         // 22
    479,   146,         // 24
    506,   150,         // 26
    460,    66,         // 28
    486,    66,         // 30
    421,   337,         // 32
    416,   428,         // 34
    454,   421,         // 36
    394,   498,         // 38
    368,   493,         // 40
     98,   169,         // 42
     67,   155,         // 44
     96,   207,         // 46
     16,   251,         // 48
     81,   270,         // 50
     64,   239,         // 52
      7,   216,         // 54
     50,   153,         // 56
    117,   163,         // 58
     76,   276,         // 60
    127,   350,         // 62
    135,   117,         // 64
    153,    92,         // 66
    114,    86,         // 68
    211,   167,         // 70
    157,    64,         // 72
    154,   202,         // 74
    478,    75,         // 76
    464,   418,         // 78
    354,     5,         // 80
    341,    39,         // 82
    374,    29,         // 84
    402,    96,         // 86
    435,   172,         // 88
    449,   100,         // 90
    435,   343,         // 92
    389,   371,         // 94
    340,   347,         // 96
    337,   366,         // 98
    191,   369,         // 100
    159,   509,         // 102
    142,   329,         // 104
    109,   504,         // 106
    140,   472,         // 108
    148,   264,         // 110
    296,   277,         // 112
    341,   371,         // 114
    420,   278,         // 116
    490,   154,         // 118
    421,   337,         // 120
    416,   428,         // 122
    454,   421,         // 124
    394,   498,         // 126
    368,   493,         // 128
     98,   170,         // 130
     96,   207,         // 132
     64,   239,         // 134
     81,   270,         // 136
    135,   117,         // 138
    114,    86,         // 140
    153,    92,         // 142
    211,   167,         // 144
    157,    64,         // 146
    464,   418,         // 148
    412,   488,         // 150
    354,     5,         // 152
    374,    29,         // 154
    341,    39,         // 156
    402,    96,         // 158
    449,   100,         // 160
    346,   161,         // 162
    438,   277,         // 164
    205,   362,         // 166
    203,   341,         // 168
    166,   366,         // 170
    204,   363,         // 172
    412,   488,         // 174
    346,   161,         // 176
    336,   366          // 178
}; // cat2UVs

#define CAT2_UV_INDEX_COUNT 114
const S3L_Index cat2UVIndices[CAT2_UV_INDEX_COUNT * 3] = {
      0,     1,     2,        // 0
      3,     2,     4,        // 3
      5,     6,     7,        // 6
      8,     6,     9,        // 9
     10,     1,     0,        // 12
      6,    10,     0,        // 15
      0,    11,     6,        // 18
     12,     8,     9,        // 21
      9,    13,    12,        // 24
     14,    12,    15,        // 27
     13,    15,    12,        // 30
     11,    16,     6,        // 33
      9,     6,    16,        // 36
     11,    17,    16,        // 39
     16,    17,    18,        // 42
     19,    18,    17,        // 45
     20,    19,    17,        // 48
     21,    22,    23,        // 51
     24,    25,    26,        // 54
     26,    27,    24,        // 57
     28,    27,    26,        // 60
     26,    23,    28,        // 63
     28,    23,    22,        // 66
     26,    25,    23,        // 69
      5,    23,    10,        // 72
     23,    25,    10,        // 75
     25,     1,    10,        // 78
     23,    29,    21,        // 81
     21,    29,    22,        // 84
      5,    29,    23,        // 87
     24,    30,    25,        // 90
      1,    30,    31,        // 93
     32,    33,    34,        // 96
     35,    36,    33,        // 99
     34,    33,    36,        // 102
     37,    33,    32,        // 105
     35,    33,    37,        // 108
     13,    38,    15,        // 111
     19,    39,    18,        // 114
     39,    16,    18,        // 117
     40,    41,    42,        // 120
     43,    42,    41,        // 123
     43,    44,    45,        // 126
     16,    46,     9,        // 129
     47,    48,    49,        // 132
      2,     1,     4,        // 135
     31,     4,     1,        // 138
     50,    51,    52,        // 141
     53,    54,    51,        // 144
      7,    55,     5,        // 147
      8,    56,     7,        // 150
     55,    50,    52,        // 153
     56,    50,    55,        // 156
     50,    56,    57,        // 159
     12,    58,     8,        // 162
     58,    12,    59,        // 165
     14,    38,    12,        // 168
     59,    12,    38,        // 171
     57,    56,    60,        // 174
     58,    60,    56,        // 177
     57,    60,    61,        // 180
     60,    62,    61,        // 183
     63,    61,    62,        // 186
     64,    61,    63,        // 189
     65,    66,    22,        // 192
     24,    67,    68,        // 195
     67,    24,    27,        // 198
     28,    67,    27,        // 201
     67,    28,    66,        // 204
     28,    22,    66,        // 207
     67,    66,    68,        // 210
      5,    55,    66,        // 213
     66,    55,    68,        // 216
     68,    55,    52,        // 219
     66,    65,    29,        // 222
     65,    22,    29,        // 225
      5,    66,    29,        // 228
     24,    68,    30,        // 231
     30,    52,    31,        // 234
     69,    70,    71,        // 237
     72,    71,    73,        // 240
     70,    73,    71,        // 243
     37,    69,    71,        // 246
     72,    37,    71,        // 249
     15,    38,    14,        // 252
     58,    13,     9,        // 255
     63,    74,    75,        // 258
     60,    74,    62,        // 261
     76,    77,    78,        // 264
     77,    79,    78,        // 267
     80,    81,    79,        // 270
     60,    58,    46,        // 273
     46,    58,    82,        // 276
     83,    48,    84,        // 279
     85,    86,    84,        // 282
     51,    54,    52,        // 285
     31,    52,    54,        // 288
      5,    10,     6,        // 291
      8,     7,     6,        // 294
      1,    25,    30,        // 297
     13,    59,    38,        // 300
     19,    87,    39,        // 303
     39,    46,    16,        // 306
     43,    45,    42,        // 309
     43,    88,    44,        // 312
      7,    56,    55,        // 315
      8,    58,    56,        // 318
     30,    68,    52,        // 321
     58,    59,    13,        // 324
     63,    62,    74,        // 327
     60,    46,    74,        // 330
     77,    80,    79,        // 333
     80,    44,    81,        // 336
     83,    89,    48         // 339
}; // cat2UVIndices

S3L_Model3D cat2Model;

void cat2ModelInit(void)
{
  S3L_model3DInit(
    cat2Vertices,
    CAT2_VERTEX_COUNT,
    cat2TriangleIndices,
    CAT2_TRIANGLE_COUNT,
    &cat2Model);
}

#endif // guard
