#ifndef EARTH_MODEL_H
#define EARTH_MODEL_H

#define EARTH_VERTEX_COUNT 42
const S3L_Unit earthVertices[EARTH_VERTEX_COUNT * 3] = {
      0, -1984,     0,        // 0
      0, -1718,   992,        // 3
    701, -1718,   701,        // 6
      0,     0,  1984,        // 9
   1215,  -992,  1215,        // 12
      0,  -992,  1718,        // 15
      0,  1718,   992,        // 18
   1215,   992,  1215,        // 21
      0,   992,  1718,        // 24
   1403,     0,  1403,        // 27
      0,  1984,     0,        // 30
    701,  1718,   701,        // 33
   1718,   992,     0,        // 36
    992, -1718,     0,        // 39
   1984,     0,     0,        // 42
    992,  1718,     0,        // 45
   1718,  -992,     0,        // 48
    701, -1718,  -701,        // 51
   1215,   992, -1215,        // 54
   1403,     0, -1403,        // 57
    701,  1718,  -701,        // 60
   1215,  -992, -1215,        // 63
      0, -1718,  -992,        // 66
      0,     0, -1984,        // 69
      0,  1718,  -992,        // 72
      0,  -992, -1718,        // 75
      0,   992, -1718,        // 78
   -701, -1718,  -701,        // 81
  -1215,   992, -1215,        // 84
  -1403,     0, -1403,        // 87
   -701,  1718,  -701,        // 90
  -1215,  -992, -1215,        // 93
   -992, -1718,     0,        // 96
  -1984,     0,     0,        // 99
   -992,  1718,     0,        // 102
  -1718,  -992,     0,        // 105
  -1718,   992,     0,        // 108
  -1403,     0,  1403,        // 111
   -701,  1718,   701,        // 114
   -701, -1718,   701,        // 117
  -1215,  -992,  1215,        // 120
  -1215,   992,  1215         // 123
}; // earthVertices

#define EARTH_TRIANGLE_COUNT 80
const S3L_Index earthTriangleIndices[EARTH_TRIANGLE_COUNT * 3] = {
      0,     1,     2,        // 0
      3,     4,     5,        // 3
      6,     7,     8,        // 6
      1,     4,     2,        // 9
      8,     9,     3,        // 12
      6,    10,    11,        // 15
     11,    12,     7,        // 18
      4,    13,     2,        // 21
      7,    14,     9,        // 24
     11,    10,    15,        // 27
      0,     2,    13,        // 30
      9,    16,     4,        // 33
     16,    17,    13,        // 36
     14,    18,    19,        // 39
     15,    10,    20,        // 42
      0,    13,    17,        // 45
     14,    21,    16,        // 48
     15,    18,    12,        // 51
     21,    22,    17,        // 54
     18,    23,    19,        // 57
     20,    10,    24,        // 60
      0,    17,    22,        // 63
     19,    25,    21,        // 66
     20,    26,    18,        // 69
     25,    27,    22,        // 72
     23,    28,    29,        // 75
     24,    10,    30,        // 78
      0,    22,    27,        // 81
     25,    29,    31,        // 84
     24,    28,    26,        // 87
     31,    32,    27,        // 90
     28,    33,    29,        // 93
     30,    10,    34,        // 96
      0,    27,    32,        // 99
     29,    35,    31,        // 102
     30,    36,    28,        // 105
     36,    37,    33,        // 108
     34,    10,    38,        // 111
      0,    32,    39,        // 114
     33,    40,    35,        // 117
     34,    41,    36,        // 120
     35,    39,    32,        // 123
     38,    10,     6,        // 126
      0,    39,     1,        // 129
     37,     5,    40,        // 132
     38,     8,    41,        // 135
     39,     5,     1,        // 138
     41,     3,    37,        // 141
      3,     9,     4,        // 144
      6,    11,     7,        // 147
      1,     5,     4,        // 150
      8,     7,     9,        // 153
     11,    15,    12,        // 156
      4,    16,    13,        // 159
      7,    12,    14,        // 162
      9,    14,    16,        // 165
     16,    21,    17,        // 168
     14,    12,    18,        // 171
     14,    19,    21,        // 174
     15,    20,    18,        // 177
     21,    25,    22,        // 180
     18,    26,    23,        // 183
     19,    23,    25,        // 186
     20,    24,    26,        // 189
     25,    31,    27,        // 192
     23,    26,    28,        // 195
     25,    23,    29,        // 198
     24,    30,    28,        // 201
     31,    35,    32,        // 204
     28,    36,    33,        // 207
     29,    33,    35,        // 210
     30,    34,    36,        // 213
     36,    41,    37,        // 216
     33,    37,    40,        // 219
     34,    38,    41,        // 222
     35,    40,    39,        // 225
     37,     3,     5,        // 228
     38,     6,     8,        // 231
     39,    40,     5,        // 234
     41,     8,     3         // 237
}; // earthTriangleIndices

#define EARTH_UV_COUNT 61
const S3L_Unit earthUVs[EARTH_UV_COUNT * 2] = {
    352,   501,         // 0
    384,   426,         // 2
    320,   426,         // 4
    384,   256,         // 6
    320,   341,         // 8
    384,   341,         // 10
    384,    85,         // 12
    320,   170,         // 14
    384,   170,         // 16
    320,   256,         // 18
    352,    10,         // 20
    320,    85,         // 22
    256,   170,         // 24
    256,   426,         // 26
    256,   256,         // 28
    288,    10,         // 30
    256,    85,         // 32
    288,   501,         // 34
    256,   341,         // 36
    192,   426,         // 38
    192,   170,         // 40
    192,   256,         // 42
    224,    10,         // 44
    192,    85,         // 46
    224,   501,         // 48
    192,   341,         // 50
    128,   426,         // 52
    128,   256,         // 54
    160,    10,         // 56
    128,    85,         // 58
    160,   501,         // 60
    128,   341,         // 62
    128,   170,         // 64
     64,   426,         // 66
     64,   170,         // 68
     64,   256,         // 70
     96,    10,         // 72
     64,    85,         // 74
     96,   501,         // 76
     64,   341,         // 78
      0,   426,         // 80
      0,   256,         // 82
     32,    10,         // 84
      0,    85,         // 86
     32,   501,         // 88
      0,   341,         // 90
      0,   170,         // 92
    512,   170,         // 94
    448,   256,         // 96
    512,   256,         // 98
    512,    85,         // 100
    480,    10,         // 102
    448,    85,         // 104
    480,   501,         // 106
    512,   426,         // 108
    448,   426,         // 110
    448,   341,         // 112
    512,   341,         // 114
    448,   170,         // 116
    416,    10,         // 118
    416,   501          // 120
}; // earthUVs

#define EARTH_UV_INDEX_COUNT 80
const S3L_Index earthUVIndices[EARTH_UV_INDEX_COUNT * 3] = {
      0,     1,     2,        // 0
      3,     4,     5,        // 3
      6,     7,     8,        // 6
      1,     4,     2,        // 9
      8,     9,     3,        // 12
      6,    10,    11,        // 15
     11,    12,     7,        // 18
      4,    13,     2,        // 21
      7,    14,     9,        // 24
     11,    15,    16,        // 27
     17,     2,    13,        // 30
      9,    18,     4,        // 33
     18,    19,    13,        // 36
     14,    20,    21,        // 39
     16,    22,    23,        // 42
     24,    13,    19,        // 45
     14,    25,    18,        // 48
     16,    20,    12,        // 51
     25,    26,    19,        // 54
     20,    27,    21,        // 57
     23,    28,    29,        // 60
     30,    19,    26,        // 63
     21,    31,    25,        // 66
     23,    32,    20,        // 69
     31,    33,    26,        // 72
     27,    34,    35,        // 75
     29,    36,    37,        // 78
     38,    26,    33,        // 81
     31,    35,    39,        // 84
     29,    34,    32,        // 87
     39,    40,    33,        // 90
     34,    41,    35,        // 93
     37,    42,    43,        // 96
     44,    33,    40,        // 99
     35,    45,    39,        // 102
     37,    46,    34,        // 105
     47,    48,    49,        // 108
     50,    51,    52,        // 111
     53,    54,    55,        // 114
     49,    56,    57,        // 117
     50,    58,    47,        // 120
     57,    55,    54,        // 123
     52,    59,     6,        // 126
     60,    55,     1,        // 129
     48,     5,    56,        // 132
     52,     8,    58,        // 135
     55,     5,     1,        // 138
     58,     3,    48,        // 141
      3,     9,     4,        // 144
      6,    11,     7,        // 147
      1,     5,     4,        // 150
      8,     7,     9,        // 153
     11,    16,    12,        // 156
      4,    18,    13,        // 159
      7,    12,    14,        // 162
      9,    14,    18,        // 165
     18,    25,    19,        // 168
     14,    12,    20,        // 171
     14,    21,    25,        // 174
     16,    23,    20,        // 177
     25,    31,    26,        // 180
     20,    32,    27,        // 183
     21,    27,    31,        // 186
     23,    29,    32,        // 189
     31,    39,    33,        // 192
     27,    32,    34,        // 195
     31,    27,    35,        // 198
     29,    37,    34,        // 201
     39,    45,    40,        // 204
     34,    46,    41,        // 207
     35,    41,    45,        // 210
     37,    43,    46,        // 213
     47,    58,    48,        // 216
     49,    48,    56,        // 219
     50,    52,    58,        // 222
     57,    56,    55,        // 225
     48,     3,     5,        // 228
     52,     6,     8,        // 231
     55,    56,     5,        // 234
     58,     8,     3         // 237
}; // earthUVIndices

S3L_Model3D earthModel;

void earthModelInit()
{
  S3L_initModel3D(
    earthVertices,
    EARTH_VERTEX_COUNT,
    earthTriangleIndices,
    EARTH_TRIANGLE_COUNT,
    &earthModel);
}

#endif // guard
