#ifndef CITY_MODEL_H
#define CITY_MODEL_H

#define CITY_VERTEX_COUNT 155
const S3L_Unit cityVertices[CITY_VERTEX_COUNT * 3] = {
      0,     2, -2048,        // 0
   -512,     2, -1536,        // 3
  -1024,     2, -2560,        // 6
  -1024,     2, -3072,        // 9
  -1024,     2, -3584,        // 12
   -512,     2, -3072,        // 15
   -512,     2, -2560,        // 18
    512,     2, -1536,        // 21
    512,     2, -2048,        // 24
   1024,     2, -1536,        // 27
    512,     2, -2560,        // 30
      0,     2, -2560,        // 33
    563,   889, -1996,        // 36
    563,   889, -2611,        // 39
    -51,   889, -2611,        // 42
   -238,   790, -3072,        // 45
    512,   792, -3072,        // 48
  -1024,   388, -3072,        // 51
  -1024,   388, -3584,        // 54
    512,   388, -1536,        // 57
   1024,   388, -1536,        // 60
   -512,   698, -1536,        // 63
  -1024,   698, -2560,        // 66
  -1024,   388, -2560,        // 69
   -512,   698, -2560,        // 72
    512,   698, -1536,        // 75
    512,   407,  -938,        // 78
    512,   698,  -938,        // 81
   -512,   148, -3072,        // 84
   -238,   148, -3072,        // 87
   -512,   148, -3347,        // 90
  -1372,   297, -2017,        // 93
  -1145,   297, -1737,        // 96
  -1395,  1403, -2044,        // 99
  -1122,  1403, -1709,        // 102
   2560,     2, -1024,        // 105
   2048,     2,  -512,        // 108
   1024,     2, -3072,        // 111
   1024,     2, -3584,        // 114
    512,     2, -4096,        // 117
   1024,     2, -4096,        // 120
   2048,     2, -3584,        // 123
   2048,     2, -4096,        // 126
   1536,     2, -3584,        // 129
   1536,     2, -3072,        // 132
   1024,     2, -2560,        // 135
    512,     2, -3072,        // 138
   1536,     2, -1536,        // 141
   1536,     2, -2048,        // 144
   1536,     2, -2560,        // 147
   2048,     2, -2048,        // 150
   2048,     2, -1536,        // 153
   3072,     2,  -512,        // 156
   3072,     2, -1024,        // 159
   3584,     2,  -512,        // 162
   3072,     2, -2048,        // 165
   2560,     2, -1536,        // 168
   2560,     2, -3072,        // 171
   2560,     2, -3584,        // 174
   2048,     2, -3072,        // 177
    998,   155, -3046,        // 180
    998,   155, -3609,        // 183
   1561,   155, -3609,        // 186
   1561,   155, -3046,        // 189
   2508,   889,  -972,        // 192
   3123,   889,  -972,        // 195
   3123,   889, -1587,        // 198
   2508,   889, -1587,        // 201
   1024,   316, -4096,        // 204
   2048,   316, -4096,        // 207
    512,   792, -4096,        // 210
   1024,   298, -4710,        // 213
   2321,   790, -2048,        // 216
   3072,   792, -2048,        // 219
   2048,   790, -3072,        // 222
    512,   792, -4710,        // 225
   1280,   297, -3328,        // 228
   2560,   790, -3072,        // 231
   2560,   259, -3072,        // 234
   2560,   259, -3584,        // 237
   1024,   388, -2560,        // 240
   1536,   388, -2048,        // 243
   1536,   388, -2560,        // 246
   3072,   388,  -512,        // 249
   3584,   388,  -512,        // 252
   2048,   698,  -512,        // 255
   1536,   698, -1536,        // 258
   1536,   388, -1536,        // 261
   2048,   698, -1536,        // 264
   3072,   698,  -512,        // 267
   3072,   407,    85,        // 270
   3072,   698,    85,        // 273
   1536,   698,  -647,        // 276
   1536,   388,  -647,        // 279
   2048,   148, -2048,        // 282
   2321,   148, -2048,        // 285
   2048,   148, -2323,        // 288
   2048,   790, -2323,        // 291
   2048,  1484, -3584,        // 294
   2048,  1227, -4096,        // 297
   2560,  1484, -3584,        // 300
   2443,  -253, -5243,        // 303
   2721,  -253, -4712,        // 306
   2443,  1078, -5243,        // 309
   2721,  1078, -4712,        // 312
   1187,   297,  -993,        // 315
   1414,   297,  -713,        // 318
   1177,  1403, -1022,        // 321
   1450,  1403,  -687,        // 324
   1055,   297,  -700,        // 327
   1019,  1403,  -671,        // 330
   3584,     2, -2048,        // 333
   3584,     2, -2560,        // 336
   3072,     2, -3072,        // 339
   3584,     2, -3072,        // 342
   4608,     2, -2560,        // 345
   4608,     2, -3072,        // 348
   4096,     2, -2560,        // 351
   4096,     2, -2048,        // 354
   3584,     2, -1536,        // 357
   3072,     2, -1536,        // 360
   4096,     2, -1536,        // 363
   4608,     2, -1024,        // 366
   5120,     2, -2048,        // 369
   5120,     2, -2560,        // 372
   4608,     2, -2048,        // 375
   3558,   155, -2022,        // 378
   3558,   155, -2585,        // 381
   4121,   155, -2022,        // 384
   3584,   316, -3072,        // 387
   4608,   316, -3072,        // 390
   3072,   792, -3072,        // 393
   4881,   790, -1024,        // 396
   4608,   790, -2048,        // 399
   3840,   297, -2304,        // 402
   5120,   259, -2048,        // 405
   5120,   259, -2560,        // 408
   3584,   388, -1536,        // 411
   4096,   388, -1536,        // 414
   4881,   148, -1024,        // 417
   4608,   148, -1299,        // 420
   4608,   790, -1299,        // 423
   4608,  1484, -2560,        // 426
   4608,  1227, -3072,        // 429
   5120,  1484, -2560,        // 432
   5003,  -253, -4219,        // 435
   5281,  -253, -3688,        // 438
   5003,  1078, -4219,        // 441
   5281,  1078, -3688,        // 444
   3747,   297,    30,        // 447
   3974,   297,   310,        // 450
   3737,  1403,     1,        // 453
   4010,  1403,   336,        // 456
   3615,   297,   323,        // 459
   3579,  1403,   352         // 462
}; // cityVertices

#define CITY_TRIANGLE_COUNT 197
const S3L_Index cityTriangleIndices[CITY_TRIANGLE_COUNT * 3] = {
      0,     1,     6,        // 0
      2,     3,     5,        // 3
      5,     3,     4,        // 6
     11,     5,    46,        // 9
      0,     6,    11,        // 12
      1,     0,     7,        // 15
      8,    45,     9,        // 18
      8,    10,    45,        // 21
     46,    10,    11,        // 24
      5,    11,     6,        // 27
      0,     8,     7,        // 30
      8,     9,     7,        // 33
      5,     6,     2,        // 36
     11,    13,    14,        // 39
     10,     8,    12,        // 42
      3,    18,     4,        // 45
      9,    19,     7,        // 48
      9,    45,    80,        // 51
      1,     7,    19,        // 54
     22,    23,    24,        // 57
     19,    21,     1,        // 60
      1,    24,     6,        // 63
     25,    21,    19,        // 66
      2,    23,    17,        // 69
     24,    23,     6,        // 72
      2,    17,     3,        // 75
     25,    26,    27,        // 78
      6,    23,     2,        // 81
     29,    28,    30,        // 84
     28,    29,     5,        // 87
      5,    29,    46,        // 90
     46,    29,    16,        // 93
     29,    15,    16,        // 96
      3,    17,    18,        // 99
      1,    21,    24,        // 102
     11,    10,    13,        // 105
     10,    12,    13,        // 108
      9,    20,    19,        // 111
      9,    80,    20,        // 114
     25,    19,    26,        // 117
     34,    31,    32,        // 120
     34,    33,    31,        // 123
     35,    36,    51,        // 126
     38,    46,    39,        // 129
     40,    38,    39,        // 132
     42,    41,    43,        // 135
     43,    40,    42,        // 138
     41,    59,    43,        // 141
     45,    37,    44,        // 144
     10,    46,    37,        // 147
     47,    48,    50,        // 150
     49,    59,    50,        // 153
     50,    48,    49,        // 156
     56,    50,    55,        // 159
     35,    51,    56,        // 162
     36,    35,    52,        // 165
     53,   119,    54,        // 168
     53,   120,   119,        // 171
     55,   120,    56,        // 174
     59,    44,    43,        // 177
     59,    49,    44,        // 180
     50,    56,    51,        // 183
     35,    53,    52,        // 186
     53,    54,    52,        // 189
     50,    51,    47,        // 192
     40,    43,    38,        // 195
     38,    37,    46,        // 198
     37,    45,    10,        // 201
     44,    49,    45,        // 204
     57,    59,    41,        // 207
     41,    58,    57,        // 210
     44,    37,    60,        // 213
     37,    38,    61,        // 216
     62,    43,    44,        // 219
     43,    61,    38,        // 222
     62,    63,    76,        // 225
     56,    66,    67,        // 228
     56,    64,    35,        // 231
    120,    53,    65,        // 234
     35,    65,    53,        // 237
     40,    69,    42,        // 240
     98,    79,    41,        // 243
     68,    70,    75,        // 246
     39,    46,    16,        // 249
     39,    70,    68,        // 252
     39,    68,    40,        // 255
     60,    76,    63,        // 258
     41,    79,    58,        // 261
     78,    74,    59,        // 264
     58,    78,    57,        // 267
     96,    97,    95,        // 270
     45,    49,    82,        // 273
     48,    82,    49,        // 276
     54,    83,    52,        // 279
     54,   119,   137,        // 282
     36,    52,    83,        // 285
     86,    87,    88,        // 288
     83,    85,    36,        // 291
     36,    88,    51,        // 294
     89,    85,    83,        // 297
     47,    87,    81,        // 300
     88,    87,    51,        // 303
     47,    81,    48,        // 306
     89,    90,    91,        // 309
     51,    87,    47,        // 312
     87,    86,    92,        // 315
     76,    60,    61,        // 318
     61,    62,    76,        // 321
     74,    97,    96,        // 324
     96,    59,    74,        // 327
     57,    78,    59,        // 330
     59,    96,    50,        // 333
     94,    50,    96,        // 336
     95,    94,    96,        // 339
     94,    95,    50,        // 342
     50,    95,    55,        // 345
     55,    95,    73,        // 348
     95,    72,    73,        // 351
     97,    72,    95,        // 354
     42,    69,    41,        // 357
     69,    98,    41,        // 360
     40,    68,    69,        // 363
     68,    75,    71,        // 366
     45,    82,    80,        // 369
     48,    81,    82,        // 372
     39,    16,    70,        // 375
     36,    85,    88,        // 378
     87,    92,    93,        // 381
     56,   120,    66,        // 384
     56,    67,    64,        // 387
    120,    65,    66,        // 390
     35,    64,    65,        // 393
     98,   100,    79,        // 396
     58,    79,    78,        // 399
     78,    77,    74,        // 402
     98,    69,    99,        // 405
     44,    60,    63,        // 408
     37,    61,    60,        // 411
     62,    44,    63,        // 414
     43,    62,    61,        // 417
     54,    84,    83,        // 420
     54,   137,    84,        // 423
     89,    83,    90,        // 426
    101,   104,   102,        // 429
    101,   103,   104,        // 432
    108,   105,   106,        // 435
    110,   105,   107,        // 438
    108,   107,   105,        // 441
    110,   109,   105,        // 444
    112,    55,   113,        // 447
    114,   112,   113,        // 450
    117,   114,   116,        // 453
    115,   125,   117,        // 456
    119,   111,   118,        // 459
    120,    55,   111,        // 462
    121,   125,   122,        // 465
    125,   118,   117,        // 468
    125,   121,   118,        // 471
    114,   117,   112,        // 474
    112,   111,    55,        // 477
    111,   119,   120,        // 480
    118,   121,   119,        // 483
    123,   125,   115,        // 486
    115,   124,   123,        // 489
    118,   111,   126,        // 492
    111,   112,   127,        // 495
    114,   130,   116,        // 498
    142,   136,   115,        // 501
    113,    55,    73,        // 504
    113,   131,   129,        // 507
    113,   129,   114,        // 510
    126,   134,   128,        // 513
    115,   136,   124,        // 516
    124,   135,   123,        // 519
    140,   141,   139,        // 522
    119,   121,   138,        // 525
    134,   126,   127,        // 528
    133,   141,   140,        // 531
    140,   125,   133,        // 534
    125,   140,   122,        // 537
    141,   132,   139,        // 540
    116,   130,   115,        // 543
    130,   142,   115,        // 546
    114,   129,   130,        // 549
    119,   138,   137,        // 552
    113,    73,   131,        // 555
    142,   144,   136,        // 558
    124,   136,   135,        // 561
    142,   130,   143,        // 564
    118,   126,   128,        // 567
    111,   127,   126,        // 570
    145,   148,   146,        // 573
    145,   147,   148,        // 576
    152,   149,   150,        // 579
    154,   149,   151,        // 582
    152,   151,   149,        // 585
    154,   153,   149         // 588
}; // cityTriangleIndices

#define CITY_UV_COUNT 377
const S3L_Unit cityUVs[CITY_UV_COUNT * 2] = {
    125,   125,         // 0
      1,     1,         // 2
      1,   249,         // 4
      2,     1,         // 6
      2,   126,         // 8
    126,   126,         // 10
      2,   262,         // 12
    126,   262,         // 14
    126,   386,         // 16
    126,   387,         // 18
      2,   511,         // 20
      2,   262,         // 22
    125,   249,         // 24
      1,     2,         // 26
    125,   126,         // 28
      1,   251,         // 30
    126,   125,         // 32
      2,   249,         // 34
      2,     1,         // 36
    126,   249,         // 38
    126,   262,         // 40
    126,   511,         // 42
    125,   251,         // 44
    126,     1,         // 46
    126,     1,         // 48
    258,   253,         // 50
    386,     1,         // 52
    258,     1,         // 54
    260,   253,         // 56
    405,   253,         // 58
    405,     2,         // 60
    253,   511,         // 62
    130,   386,         // 64
    130,   511,         // 66
    381,   508,         // 68
    256,   386,         // 70
    256,   508,         // 72
    130,   509,         // 74
    380,   509,         // 76
    380,   386,         // 78
    258,   253,         // 80
    510,   253,         // 82
    510,   114,         // 84
    354,     3,         // 86
    354,   115,         // 88
    510,     3,         // 90
    258,     3,         // 92
    507,   252,         // 94
    255,     2,         // 96
    255,   252,         // 98
    510,     3,         // 100
    376,   511,         // 102
    376,   386,         // 104
    253,   386,         // 106
    510,   254,         // 108
    258,     3,         // 110
    475,   112,         // 112
    475,     3,         // 114
    354,   254,         // 116
    245,   319,         // 118
    190,   264,         // 120
    135,   319,         // 122
    509,   209,         // 124
    443,   209,         // 126
    509,   253,         // 128
    259,   253,         // 130
    259,    16,         // 132
    443,    16,         // 134
    507,     2,         // 136
    386,   253,         // 138
    260,     2,         // 140
    381,   386,         // 142
    130,   386,         // 144
    258,   112,         // 146
    509,   352,         // 148
    261,   259,         // 150
    261,   352,         // 152
    509,   259,         // 154
    125,   125,         // 156
      1,     1,         // 158
      1,   249,         // 160
    127,   125,         // 162
      3,   249,         // 164
      3,     1,         // 166
    127,     1,         // 168
      1,     2,         // 170
    125,     2,         // 172
    125,   126,         // 174
      1,   250,         // 176
    125,   254,         // 178
    125,   129,         // 180
      1,   254,         // 182
    126,   128,         // 184
      1,   128,         // 186
      1,   252,         // 188
    130,     1,         // 190
    130,   125,         // 192
    254,   125,         // 194
      2,     1,         // 196
      2,   126,         // 198
    126,   126,         // 200
    126,   386,         // 202
      2,   510,         // 204
      2,   262,         // 206
      2,   262,         // 208
    126,   262,         // 210
    126,   386,         // 212
    126,   387,         // 214
      2,   511,         // 216
      2,   262,         // 218
    125,   249,         // 220
      1,     2,         // 222
    125,   126,         // 224
      1,   251,         // 226
    126,   125,         // 228
      2,   249,         // 230
      2,     1,         // 232
    126,   249,         // 234
    126,   262,         // 236
      1,   129,         // 238
    126,   510,         // 240
    126,   511,         // 242
    125,   251,         // 244
    126,     1,         // 246
    126,     1,         // 248
    125,   250,         // 250
    127,   249,         // 252
    254,     1,         // 254
    126,   252,         // 256
    253,   130,         // 258
    129,   130,         // 260
    129,   254,         // 262
    253,   254,         // 264
    387,   448,         // 266
    508,   448,         // 268
    508,   386,         // 270
    387,   446,         // 272
    508,   446,         // 274
    508,   388,         // 276
    385,   390,         // 278
    385,   446,         // 280
    510,   446,         // 282
    511,   447,         // 284
    386,   388,         // 286
    386,   447,         // 288
    254,   259,         // 290
    131,   259,         // 292
    192,   321,         // 294
    258,   253,         // 296
    386,     1,         // 298
    258,     1,         // 300
    510,   252,         // 302
    385,     2,         // 304
    385,   252,         // 306
    260,   253,         // 308
    405,   253,         // 310
    405,     2,         // 312
    510,   254,         // 314
    384,     0,         // 316
    384,   254,         // 318
    381,   511,         // 320
    131,   434,         // 322
    131,   511,         // 324
    510,   350,         // 326
    302,   261,         // 328
    259,   350,         // 330
    221,   324,         // 332
    221,   257,         // 334
    163,   257,         // 336
    259,   252,         // 338
    511,   252,         // 340
    511,    15,         // 342
    259,   352,         // 344
    404,   352,         // 346
    317,   258,         // 348
    259,   258,         // 350
    130,   259,         // 352
    191,   320,         // 354
    253,   259,         // 356
    259,   261,         // 358
    259,   176,         // 360
    414,    16,         // 362
    414,   254,         // 364
    253,   382,         // 366
    129,   327,         // 368
    129,   382,         // 370
    477,   210,         // 372
    477,    15,         // 374
    354,   210,         // 376
    222,   509,         // 378
    352,   509,         // 380
    352,   386,         // 382
    253,   511,         // 384
    130,   386,         // 386
    130,   511,         // 388
    381,   508,         // 390
    256,   386,         // 392
    256,   508,         // 394
    130,   509,         // 396
    380,   509,         // 398
    380,   386,         // 400
    258,   253,         // 402
    510,   253,         // 404
    510,   114,         // 406
    354,     3,         // 408
    354,   115,         // 410
    510,     3,         // 412
    258,     3,         // 414
    507,   252,         // 416
    255,     2,         // 418
    255,   252,         // 420
    510,     3,         // 422
    376,   511,         // 424
    376,   386,         // 426
    253,   386,         // 428
    510,   254,         // 430
    258,     3,         // 432
    475,   112,         // 434
    475,     3,         // 436
    354,   254,         // 438
    509,   117,         // 440
    509,     2,         // 442
    259,     2,         // 444
    191,   321,         // 446
    254,   258,         // 448
    128,   258,         // 450
    252,   259,         // 452
    131,   259,         // 454
    192,   320,         // 456
    260,    16,         // 458
    442,    16,         // 460
    442,   211,         // 462
    260,   255,         // 464
    259,   254,         // 466
    509,   255,         // 468
    509,   211,         // 470
    245,   319,         // 472
    190,   264,         // 474
    135,   319,         // 476
    509,   209,         // 478
    443,   209,         // 480
    509,   253,         // 482
    259,   253,         // 484
    259,    16,         // 486
    443,    16,         // 488
    354,    15,         // 490
    260,   350,         // 492
    312,   350,         // 494
    260,   264,         // 496
    509,   264,         // 498
    381,   434,         // 500
    163,   324,         // 502
    222,   386,         // 504
    259,    15,         // 506
    507,     2,         // 508
    259,   117,         // 510
    386,   253,         // 512
    510,     2,         // 514
    260,     2,         // 516
    510,     0,         // 518
    510,   261,         // 520
    253,   327,         // 522
    259,    16,         // 524
    466,   350,         // 526
    387,   386,         // 528
    387,   388,         // 530
    510,   390,         // 532
    511,   388,         // 534
    381,   386,         // 536
    130,   386,         // 538
    258,   112,         // 540
    509,   251,         // 542
    351,     1,         // 544
    351,   251,         // 546
    509,     1,         // 548
    509,   352,         // 550
    261,   259,         // 552
    261,   352,         // 554
    509,   260,         // 556
    261,   351,         // 558
    509,   351,         // 560
    509,   259,         // 562
    261,   260,         // 564
    127,   125,         // 566
      3,   249,         // 568
      3,     1,         // 570
    127,     1,         // 572
    125,   126,         // 574
      1,   250,         // 576
      1,     2,         // 578
    125,   254,         // 580
    125,   129,         // 582
      1,   254,         // 584
    126,   128,         // 586
      1,   128,         // 588
      1,   252,         // 590
    130,     1,         // 592
    130,   125,         // 594
    254,   125,         // 596
    126,   386,         // 598
      2,   510,         // 600
      2,   262,         // 602
      1,   129,         // 604
    126,   510,         // 606
    125,   250,         // 608
    127,   249,         // 610
    254,     1,         // 612
    126,   252,         // 614
    253,   130,         // 616
    129,   130,         // 618
    129,   254,         // 620
    253,   254,         // 622
    387,   448,         // 624
    508,   448,         // 626
    508,   386,         // 628
    387,   446,         // 630
    508,   446,         // 632
    508,   388,         // 634
    381,   511,         // 636
    131,   434,         // 638
    131,   511,         // 640
    510,   350,         // 642
    302,   261,         // 644
    259,   350,         // 646
    259,   252,         // 648
    511,   252,         // 650
    511,    15,         // 652
    259,   352,         // 654
    404,   352,         // 656
    317,   258,         // 658
    259,   258,         // 660
    130,   259,         // 662
    191,   320,         // 664
    253,   259,         // 666
    259,   261,         // 668
    253,   382,         // 670
    129,   327,         // 672
    129,   382,         // 674
    477,   210,         // 676
    477,    15,         // 678
    354,   210,         // 680
    222,   509,         // 682
    352,   509,         // 684
    352,   386,         // 686
    191,   321,         // 688
    254,   258,         // 690
    128,   258,         // 692
    260,    16,         // 694
    442,    16,         // 696
    442,   211,         // 698
    260,   255,         // 700
    509,   255,         // 702
    354,    15,         // 704
    260,   350,         // 706
    312,   350,         // 708
    260,   264,         // 710
    509,   264,         // 712
    381,   434,         // 714
    222,   386,         // 716
    259,    15,         // 718
    510,   261,         // 720
    253,   327,         // 722
    466,   350,         // 724
    387,   386,         // 726
    387,   388,         // 728
    509,   251,         // 730
    351,     1,         // 732
    351,   251,         // 734
    509,     1,         // 736
    509,   352,         // 738
    261,   259,         // 740
    261,   352,         // 742
    509,   260,         // 744
    261,   351,         // 746
    509,   351,         // 748
    509,   259,         // 750
    261,   260          // 752
}; // cityUVs

#define CITY_UV_INDEX_COUNT 197
const S3L_Index cityUVIndices[CITY_UV_INDEX_COUNT * 3] = {
      0,     1,     2,        // 0
      3,     4,     5,        // 3
      6,     7,     8,        // 6
      9,    10,    11,        // 9
      0,     2,    12,        // 12
     13,    14,    15,        // 15
     16,    17,    18,        // 18
     16,    19,    17,        // 21
     11,    20,     9,        // 24
     10,     9,    21,        // 27
     14,    22,    15,        // 30
     16,    18,    23,        // 33
      5,    24,     3,        // 36
     25,    26,    27,        // 39
     28,    29,    30,        // 42
     31,    32,    33,        // 45
     34,    35,    36,        // 48
     37,    38,    39,        // 51
     40,    41,    42,        // 54
     43,    44,    45,        // 57
     42,    46,    40,        // 60
     47,    48,    49,        // 63
     50,    46,    42,        // 66
     51,    52,    53,        // 69
     45,    44,    54,        // 72
     51,    53,    31,        // 75
     55,    56,    57,        // 78
     54,    44,    58,        // 81
     59,    60,    61,        // 84
     62,    63,    64,        // 87
     64,    63,    65,        // 90
     65,    63,    66,        // 93
     63,    67,    66,        // 96
     31,    53,    32,        // 99
     47,    68,    48,        // 102
     25,    69,    26,        // 105
     28,    30,    70,        // 108
     34,    71,    35,        // 111
     37,    39,    72,        // 114
     55,    73,    56,        // 117
     74,    75,    76,        // 120
     74,    77,    75,        // 123
     78,    79,    80,        // 126
     81,    82,    83,        // 129
     84,    81,    83,        // 132
     85,    86,    87,        // 135
     87,    88,    85,        // 138
     89,    90,    91,        // 141
     92,    93,    94,        // 144
     95,    96,    97,        // 147
     98,    99,   100,        // 150
    101,   102,   103,        // 153
    104,   105,   106,        // 156
    107,   108,   109,        // 159
     78,    80,   110,        // 162
    111,   112,   113,        // 165
    114,   115,   116,        // 168
    114,   117,   115,        // 171
    109,   118,   107,        // 174
     90,   119,    91,        // 177
    102,   101,   120,        // 180
    108,   107,   121,        // 183
    112,   122,   113,        // 186
    114,   116,   123,        // 189
    100,   124,    98,        // 192
     88,    87,   125,        // 195
     81,   126,    82,        // 198
     97,   127,    95,        // 201
     94,   128,    92,        // 204
    129,   130,   131,        // 207
    131,   132,   129,        // 210
    133,   134,   135,        // 213
    136,   137,   138,        // 216
    139,   140,   141,        // 219
    142,   143,   144,        // 222
    145,   146,   147,        // 225
    148,   149,   150,        // 228
    151,   152,   153,        // 231
    154,   155,   156,        // 234
    157,   158,   159,        // 237
    160,   161,   162,        // 240
    163,   164,   165,        // 243
    166,   167,   168,        // 246
    169,   170,   171,        // 249
    172,   173,   174,        // 252
    172,   174,   175,        // 255
    176,   177,   178,        // 258
    165,   164,   179,        // 261
    180,   181,   182,        // 264
    183,   184,   185,        // 267
    186,   187,   188,        // 270
    189,   190,   191,        // 273
    192,   193,   194,        // 276
    195,   196,   197,        // 279
    198,   199,   200,        // 282
    201,   202,   203,        // 285
    204,   205,   206,        // 288
    203,   207,   201,        // 291
    208,   209,   210,        // 294
    211,   207,   203,        // 297
    212,   213,   214,        // 300
    206,   205,   215,        // 303
    212,   214,   192,        // 306
    216,   217,   218,        // 309
    215,   205,   219,        // 312
    220,   221,   222,        // 315
    223,   224,   225,        // 318
    226,   227,   228,        // 321
    229,   230,   231,        // 324
    231,   232,   229,        // 327
    233,   180,   182,        // 330
    232,   231,   234,        // 333
    235,   234,   231,        // 336
    236,   237,   238,        // 339
    239,   240,   241,        // 342
    241,   240,   242,        // 345
    242,   240,   243,        // 348
    240,   244,   243,        // 351
    187,   245,   188,        // 354
    246,   247,   248,        // 357
    247,   249,   248,        // 360
    160,   250,   161,        // 363
    166,   168,   251,        // 366
    189,   191,   252,        // 369
    192,   214,   193,        // 372
    169,   171,   253,        // 375
    208,   254,   209,        // 378
    220,   222,   255,        // 381
    148,   256,   149,        // 384
    151,   257,   152,        // 387
    154,   156,   258,        // 390
    157,   259,   158,        // 393
    163,   260,   164,        // 396
    183,   261,   184,        // 399
    180,   262,   181,        // 402
    249,   247,   263,        // 405
    133,   135,   264,        // 408
    136,   138,   265,        // 411
    139,   141,   266,        // 414
    142,   267,   143,        // 417
    195,   268,   196,        // 420
    198,   200,   269,        // 423
    216,   270,   217,        // 426
    271,   272,   273,        // 429
    271,   274,   272,        // 432
    275,   276,   277,        // 435
    278,   279,   280,        // 438
    275,   281,   276,        // 441
    278,   282,   279,        // 444
    283,   284,   285,        // 447
    286,   283,   285,        // 450
    287,   288,   289,        // 453
    290,   291,   292,        // 456
    293,   294,   295,        // 459
    296,   297,   298,        // 462
    299,   300,   301,        // 465
    291,   302,   292,        // 468
    300,   299,   303,        // 471
    288,   287,   304,        // 474
    283,   305,   284,        // 477
    298,   306,   296,        // 480
    295,   307,   293,        // 483
    308,   309,   310,        // 486
    310,   311,   308,        // 489
    312,   313,   314,        // 492
    315,   316,   317,        // 495
    318,   319,   320,        // 498
    321,   322,   323,        // 501
    324,   325,   326,        // 504
    327,   328,   329,        // 507
    327,   329,   330,        // 510
    331,   332,   333,        // 513
    323,   322,   334,        // 516
    335,   336,   337,        // 519
    338,   339,   340,        // 522
    341,   342,   343,        // 525
    344,   345,   346,        // 528
    347,   348,   349,        // 531
    349,   350,   347,        // 534
    350,   349,   351,        // 537
    339,   352,   340,        // 540
    353,   354,   355,        // 543
    354,   356,   355,        // 546
    318,   357,   319,        // 549
    341,   343,   358,        // 552
    324,   326,   359,        // 555
    321,   360,   322,        // 558
    335,   361,   336,        // 561
    356,   354,   362,        // 564
    312,   314,   363,        // 567
    315,   317,   364,        // 570
    365,   366,   367,        // 573
    365,   368,   366,        // 576
    369,   370,   371,        // 579
    372,   373,   374,        // 582
    369,   375,   370,        // 585
    372,   376,   373         // 588
}; // cityUVIndices

S3L_Model3D cityModel;

void cityModelInit()
{
  S3L_initModel3D(
    cityVertices,
    CITY_VERTEX_COUNT,
    cityTriangleIndices,
    CITY_TRIANGLE_COUNT,
    &cityModel);
}

#endif // guard
