# LRS Wiki Style/Rules/Meta/Etc.

This outlines the style and rules of this Wiki that should ensure "quality" and consistency. You should read this before contributing.

If you contribute, add yourself to [wiki authors](wiki_authors.md)! You can also join us on the [Island](island.md).

## Rules

1. **Everything is [public domain](public_domain.md)** under [CC0](cc0.md) to which all contributors agree. No one owns what we write here.
2. **No [fair use](fair_use.md)** or even unfair use. We want this Wiki to be as free as possible and don't thread the fine legal lines. That means you can't directly include anything on this Wiki if it's copyrighted, **even if it's under a free license**. So generally **avoid any copy pasting and rather try to write everything yourself**. Also no Wikipedia style fair use abuse like including detailed plot summaries of proprietary works -- this is incompatible with free culture (yes, even if Wikipedia claims otherwise).
3. **No unnecessary [censorship](censorship.md)**. Necessary censorship basically only includes spam, shitty content, [IP](intellectual_property.md)-infected content (content that would make this wiki not be in public domain) and hardcore illegal stuff that would immediately put us in jail, though we would of course love to include that. However spreading truth mustn't be hurt by fear of jail. Controversial/incorrect/taboo content etc. is NOT to be censored.
4. **[Electronic bullying](cyberbullying.md) of other wiki users is NOT PROHIBITED**. Nothing is prohibited here. { Also I'm alone here so at best I can bully myself :D ~drummyfish }
5. **ILLEGAL CONTENT IS ALLOWED** -- it still won't be added, because that would make this wiki less legally [free](free_culture.md), however this rule will be here to show we shit on laws and also that it's mostly quite stupid to forbid something that is already forbidden by definition, websites resort to doing it to dodge responsibility because they are [shit scared](fear_culture.md), but it's still stupid nonetheless. Putting rules like "uploading illegal content is prohibited" is basically like saying "I declare it that in my house laws of physics must function", illegal content will be prohibited whether you forbid it or not.
6. **Medical and legal advice is NOT prohibited** and it's highly encouraged. This kind of advice is very useful and it would be beyond stupid to prohibit it.
7. Peer-reviewed sources are highly discouraged, we prefer uncensored sources. 
8. [Nigger](nigger.md). This rule has practically no effect because linguistically it isn't even a sentence, but it is here to help [free speech](free_speech.md).

## Style

- **Don't line-break paragraphs** (whole paragraph is always a single line). The is because assuming certain screen width wouldn't be nice and editing such text would also be a huge pain in the ass, so let's just have it this way by default, it is easy for anyone to add line breaks and auto align to whatever width he needs later on.
- **Avoid [Unicode](unicode.md), highly prefer [ASCII](ascii.md)**, for the sake of maximum compatibility and simplicity. Use of unicode has to be greatly justified.
- **Each page shall start with a heading** (which may or may not correspond to article file name).
- I've finally decided that with certain exceptions headings should be written like this: **Each Word Of A Heading Is Capitalized**. This is for simplicity, we don't deal with weird ass rules of when or when not to capitalize.
- **Filenames of articles shall use a lowercase snake_case**.
- **Article/file names are to be preferably singular nouns**. I.e. "animal" rather than "animals", "portability" rather than "portable" etc. But there may be exceptions, e.g. articles that are lists may use plural ("human" is about human as species, "people" is a list of existing humans), non-nous MAY be used if nouns would be too long/awkward (e.g. "weird" instead of "weirdness"). Use your brain.
- **This isn't [Wikipedia](wikipedia.md)**, memes, opinions and uncensored truths are allowed (and welcome). **References/citations are not needed**, we aren't a religion that relies on someone else's reputation to validate truth, we just spread information and leave it to others to either trust, test its usefulness and/or verify. This wiki doesn't so much exist to convince people who disagree with us, that cannot be done and retards cannot be convinced no matter what, the wiki is here for people who already see the truth as we do, we aren't proving anything to them, we are offering them further stuff they may find useful. Furthermore we don't limit ourselves to truths that can be or have been "proven" by whatever is currently called "approved science^TM", many valuable truths are just proven by experience etc. LRS advocates society in which deception doesn't happen and in which therefore there is no need for citations serving as a proof -- we practice this here. However references are still allowed and many times useful, e.g. as a further reading.
- **The wiki must mentally be written in the past**, i.e. when writing it you mustn't adhere to the culture of [21st century](21st_century.md), get back to the previous millennium, just ignore the past several decades ever happened and continue existing back then, isolate yourself from the outside world if you must, don't talk to anyone, don't watch TV, use language and mindset that was present back in the better days.
- Unlike with [Wikipedia](wikipedia.md) our criterion of inclusion isn't notability, i.e. things that people talk about, but value, i.e. **things that are worth talking about**. On the other hand if something is notable but of little value, such as details of [OOP](oop.md) or famous feminists, we won't write too much about it, it's just useless noise that harms the good things by obscuring them.
- The style of this wiki is inspired by the classic hacker culture works such as the [WikiWikiWeb](wikiwikiweb.md) and [Jargon File](jargon_file.md).
- **Writing style should be relaxed and in many parts informal**. Formality is used where it is useful (e.g. definitions), most of other text can benefit from being written as a tech conversation among friends.
- **Depth/complexity/level of articles**: Articles shouldn't try to go to unnecessary depth, but also shouldn't be shallow. This is written mainly for programmers of [less retarded society](less_retarded_society.md), the complexity should follow from that. Again, start simple and go more into depth later on in the article, very complex things should rather be explained intuitively, no need for complex proofs etc.
- **Provide examples**: definitions give precision but examples give understanding.
- **Scope**: don't write about literally everything, include only what's relevant from LRS point of view and only to relevant degree -- for example we could write many articles about OOP design patterns, however as that's a complete capitalist bullshit, this would just be noise from our point of view, it would drown useful content and also waste our effort, so we rather limit ourselves to some kind of tl;dr or OOP design patterns.
- **[Future proof](future_proof.md) articles, minimize need for [maintenance](maintenance.md), focus on long term**: unlike Wikipedia we can't (and don't want to) be a dynamic resource that's only ever valid for one day, we want stable articles that will stay relevant forever. Don't go too much into temporary irrelevant shit such as which distro is currently the most bestest or how many forks dwm currently has. I.e. for example lists of software are not very good articles as that's something that will change constantly. List of historical events may be better as those are more or less given and only once in a decade we need to add few new relevant events, possibly also update the view on older ones. An article on mathematical concept on the other hand is quite good as equations are something that just stands valid forever.
- **The wiki is kind of a dirty idea dump**, it may contain TODOs, WIPs, errors, ugliness etc., it is not a [finished](finished.md) beautiful and tidy encyclopedia. Remember this wiki is kind of a temporary (though long term) project that's meant to host, communicate and spread ideas that should direct us towards better society, it is a vehicle that should get us somewhere else and will potentially be replaced by something else once we are there. Therefore aims for perfection and beauty shouldn't stand in way of just communicating ideas (i.e. do not delete content for its ugliness if that content is still potentially useful).
- **Political incorrectness, slurs and "offensive speech" are highly encouraged**. Avoid the use of the word "person" (use "man", "guy", "human", "one" etc., possibly "individual" at worst). Of course this is not to "offend" anyone, this helps people unlearn being offended.
- **Images**: for now don't embed images. [ASCII art](ascii_art.md) can be used in many places instead of an image. Thousand words are worth a picture. Non-embedding links to images may be okay. 
- **You can leave comments right in the text of articles**, e.g. like this: { I disagree with this [shit](shit.md). ~drummyfish }.

Articles should be written to be somewhat readable and understandable to tech savvy people who already know something about technology, i.e. neither illiterates, nor experts only (as is sometimes the case e.g. on Wikipedia). **Each article should ideally start with a general dictionary [definition](definition.md)** and continue with a simple general explanation and overview of the topic. With more paragraphs the text can get more complex. The idea is that a noob will read the first paragraph, understand the basic idea and take something away. A more advanced reader will read further on and take away more things etc. I.e. we educate in a top-down approach. **Each article should be a nice mini resource in itself** (valuable even when printed out, without being able to follow hyperlinks), quality should be preferred over quantity: for example the article on chess should be a nice general page about chess with focus on its programming, but also containing general overview, history, fun and interesting facts, data, essay elements and so on, so as to be highly self-contained (as opposed to the "Wikipedia approach" of making many separate articles on chess history, chess players, chess rules etc.).

Bonus: **try to [troll](troll.md) idiots** -- it's great if the article starts kind of "formal", like Wikipedia style, but then later on starts dropping swear words and lulz so that let's say someone who copy-pastes this as a school assignment without bothering to read more than one paragraph just gets kicked out of the school.

## Sources

These are some sources you can use for research and gathering information for articles:

- **paper [encyclopedias](encyclopedia.md)!** Consult them often, they are much better than any online resource, contain obscure, forgotten info and alternative points of view.
- **[Wikipedia](wikipedia.md)**: of course, but don't limit your search to it. Searching other language Wikipedias with machine translate can also help find extra info. If you know other languages than English, search that languages Wikipedia, it may have extra info. Also languages like Scots are understandable to English speakers, so try that as well.
- **[Citizendium](citizendium.md)**: can offer a different angle of view from Wikipedia.
- **non-SJW forks of Wikipedia**: to get past SWJ censorship/propaganda on Wikipedia try e.g. **[infogalactic](infogalactic.md)** or **[metapedia](metapedia.md)**.
- **Britannica online**: proprietary, but articles are nicely written, facts are in the public domain so we can steal them.
- **Archives: [Internet Archive](internet_archive.md), [Archive Team Wiki](https://wiki.archiveteam.org/), [archive.li](https://archive.li/), ...**: Most information once available on the Internet is most likely no longer accessible nowadays (taken down, privatized, censored, no longer indexed, ...). Look in the archives!
- **[wikiwikiweb](wikiwikiweb.md)**
- **Ask people lol**: sometimes you can't find a piece of information anywhere (for example which rendering technique was used in an old proprietary game) but if you just send a short mail to someone (the game's programmer), he just gives you the information in a second. People often just forget this and spend countless hours digging for something when they can just write one email. Also just randomly talking to nerds on IRC and similar network often leads you to finding interesting topics to research which you wouldn't even think about.
- **[Wiby](wiby.md), marginalia and other non-commercial search engines**: this will find nice small non-commercial sites of tech and other nerds that Google suffocates under bloatsites (or simply censors)
- **[Project Gutenberg](gutenberg.md)**: mostly older books but there are already some computer related books like [RMS's](rms.md) biography or [Jargon File](jargon_file.md)
- **University theses** (and scientific paper of course): many university theses are publicly accessible and usually nicely sum up topics, bachelor level theses may be better understandable than PhD/master theses.
- **Slides**: slides from various presentations are actually great resources as they condense the topic into its main points, they filter out the piles of noise.
- **Wikisource**, **Wikibooks** etc.
- **[books](book.md)**: Books are still of higher quality than online sources so you can [pirate](piracy.md) some and steal some facts from them. Check out Anna's archive, libgen, torrents etc.
- Wikisphere -- check out various wikis, there are thousands, a place to start searching is **Wikiindex**. Wikis like [installgentoowiki](https://wiki.installgentoo.com), encyclopedia dramatica, soyak wiki and lurkmorewiki may offer interesting insight into internet/tech culture, many times also less censored facts. Also check out progopedia, osdev wiki, esolang wiki, chess programming wiki, wikiwikiweb etcetc. 
- **[YouTube](youtube.md)**: Yes, sadly this is nowadays one of the biggest sources of information which is unfortunately hidden in videos full of ads and retarded zoomers, the information is unindexed. If you are brave enough, you can dig this information out and write it here as a proper text.
- [reddit](reddit.md): Sadly another SJW swamp of retards, however with many subcommunities almost about everything, if you have a question you can't find anywhere there is usually a subreddit where you can ask, if you dare.
- Try searching with different search engines than just Google (wiby, marginalia, Yandex, Bing, Yahoo, Internet Archive, ...).
- **old magazines**: If you can get your hands on old magazines somehow (physical, pdf, ...) about computers, cell phones, games etc., you may get a nice source of a lot of interesting, obscure and lost information. For example on the web it's impossible to find a good list of old games -- if you search for "top 50 old games", you get a list of complete shit games from 2015, which is now considered "old"; it's much better you get some old game magazine from say 2005 that lists top 50 games at the time. Furthermore these magazines are professionally made and actually [older](old.md), i.e. of better quality. You may also find nice gems, predictions of the future, politically incorrect articles etc.
- **4chan archives**: There are some cool 4chan archives with search features, it can bring up interesting discussions on obscure topics you wouldn't find otherwise.
- **non-English web**: Firstly search your native language web (RIP if your native language is English), secondly search languages you speak or can use translator for -- many countries have big websites unknown beyond the borders of the country (e.g. Russian Lurkmore wiki, the Asian Wikipedia alternatives and so on).
- **Non-web**: When web fails, you can search the [darknet](darknet.md), [gopher](gopher.md), [gemini](gemini.md), [usenet](usenet.md), [tor](tor.md) etc.
- ...

## Purpose

Basically the purpose of this wiki is to have fun and also create a coherent and consistent philosophy of a truly good software, technology and also to a related degree society.

Additionally we want to create a nice, completely public domain, suckless educational resource, an encyclopedia that's written in a nicer style than e.g. Wikipedia.

Another goal is to serve as a historical account of our age. We suppose that people in the future may want to read first-hand accounts of how people saw the society and its technology, what they thought was important, what they predicted etc. We like to do this ourselves thanks to e.g. Project Gutenberg. Kids in the future will be like "haha those idiots couldn't see they would bloat themselves to death", this Wiki will show that indeed we foresaw it, we were just in a huge minority. Future kids: don't repeat the same mistakes we did.