# The Venus Project

The Venus Project is a big project established by [Jacque Fresco](jacque_fresco.md), already running for decades, aiming for a voluntary and rational transition towards an ideal, highly technological and automated [society](society.md) without [money](money.md), scarcity, need for human [work](work.md), social [competition](competition.md), wars and violence, a society in which people would have abundance thanks to so called [resource based economy](resource_based_economy.md), where they would be [collaborating](collaboration.md), loving, respecting the nature, caring for others and free to pursue their true potential. It is similar to the [Zeitgeist Movement](zeitgeist_movement.md) and [TROM](trom.md). In its views, goals and means the Venus Project is extremely close to [LRS](lrs.md) and we highly support it, however watch out: while the ideas behind the project are good, the project itself is a bit [sus](sus.md) and may show internal corruption just as the [FSF](fsf.md), [TROM](trom.md) and other projects -- use your brain, follow ideas, not people.

There is a non-profit organization called [One Community](one_community.md) that tries to pursue goals set by the Venus Project and strive for what they call *Highest Good*. Its website is at https://www.onecommunityglobal.org.

## Overview

{ The following is based mainly on my understanding of what I've read in Fresco's book *The Best That Money Can't Buy*. I  recommend the book for an overall overview of the project. ~drummyfish }

The project is a child of [Jacque Fresco](jacque_fresco.md), a [generalist](generalism.md) futurist who sadly died in 2017, who worked on it for many decades with his life partner Roxanne Meadows. It has a center located in Florida and is a [nonprofit](nonprofit.md) organization that performs research, education and prototype technology according to their ideas of a future we should strive for.

Although the project seems to be avoiding specific political labels (possibly as to avoid historical associations), it is [de facto](de_facto.md) **[anarcho pacifist](anpac.md) [communist](communism.md)** movement (i.e. politically the same as [LRS](lrs.md)). Very nicely it also seems, at least as of 2022, uninfected with the [SJW](sjw.md) [cancer](cancer.md) -- [fight culture](fight_culture.md) and [fascism](fascism.md) goes directly against their goals and Fresco explicitly stated that we have to stop constantly fighting for human rights and rather establish a society with human rights built-in.

Fresco highly criticizes today's society and just as [us](us.md) says it only tries to cure the symptoms (search the solutions within the current framework and mindset) rather than the root cause of its issues (the system itself). He mainly criticizes the presence of the monetary system and laws -- currently taking the form of [capitalism](capitalism.md) -- which he correctly blames for most today's issues such as artificial scarcity, hunger, wars, [fascism](fascism.md), lack of social security, poverty, [wage slavery](wage_slavery.md), destruction of natural environment, waste, energy crisis, [planned obsolescence](plenned_obsolescence.md), deteriorating psychological health etc. He says with the presence of advanced technology we have this system is highly outdated (for example it forces artificial scarcity because only scarce resources can be sold, unlike for example air) and points out the fact that we have more than enough resources for everyone on Earth and could live in abundance and peace, practicing **[collaboration](collaboration.md) rather than [competition](competition.md)**. Therefore he argues that we have to eliminate [money](money.md), barter and markets from the society and change the very basis of whole society, down to our mentality and outdated historical associations (and eventually even language which should be closer to the scientific language).

He argues to replace the monetary system with so called **[resource based economy](resource_based_economy.md)** (RBE) which should be a pillar of the future society. RBE is called an "economy" but doesn't use any money or barter, it starts by declaring that all Earth's resources are a common heritage of all people on Earth -- it basically means that "everything is available to everyone", i.e. no one can own resources of the Earth, they belong to us all and whoever needs something can take it. RBE would be supported by high automatization and computer monitoring to deliver resources where they are needed. Normies usually can't comprehend that this could work, they say "but then someone will just steal everything", but Fresco correctly argues that with correct and rational use of our technology we can, unlike in the past, already extract as many resources as to satisfy everyone with high abundance; basically we can make for example food as abundant as is air nowadays -- no one will be (and can be) stealing food when there's more free food than anyone can eat, just as stealing air isn't a concern nowadays.

This should therefore also eliminate the need for complex laws -- when no one is stealing, we don't need laws against stealing etc. Elimination of money and laws will remove the need for [bullshit](bullshit.md) jobs such as lawyers, judges, politicians, marketing guys, bankers etc., freeing more people and getting rid of a lot of unnecessary work and burden of society.

Fresco supports this by the fact that **human behavior is determined by the environment and upbringing** -- nowadays we have criminality mostly because firstly people are poor, i.e. pushed into illegal activity, and secondly nurtured by the competitive propaganda that teaches them, right from little children, to [fight](fight_culture.md) and compete with others. In a caring society that provides all their needs and raises them in the spirit of collaboration and love towards others criminals will be almost non existent, there will simply be no gain from it.

The project further seeks to **eliminate the need for human [work](work.md)**: all work, including complex decision making, would be automated. Bullshit jobs would be removed and [maintenance](maintenance.md) reduced to minimum. People would be free to pursue their true interests and could fully and freely devote themselves to it. Again normies usually say something like "BUT THEN NOBODY AIN'T GONNA WORK". Well, firstly that wouldn't be an issue since no human work would even be needed anymore, and secondly Fresco correctly answers by saying that competition and force isn't the only drive of human activity, people are motivated for work and creative activity by other phenomena such as curiosity, sense of accomplishment, boredom, moral values etc., and usually even perform better than when forced to it. [Maslow's Hierarchy of Needs](maslows_hierarchy_of_needs.md) is a well known psychological model that says that once basic needs such as food and shelter are satisfied (which RBE will accomplish), people start voluntarily pursuing higher needs such as art, science and other creative work. People did work and create long before money and jobs existed. The idea of reducing or eliminating human work is already being considered nowadays in the form of [universal basic income](ubi.md) -- experiments have been confirming that it works.

Venus Project stresses the important of **[science](science.md)** -- their approach is strictly scientific -- technology (such as [AI](ai.md) and sensors all over the Earth) and [rationality](rationality.md) and argues for application of technology to everything as that, in their opinion, will allow RBE and remove the need for human government. **There should be no human governing the society**, decisions will be made mostly by machines in a network of decentralized cities all over the Earth ("technophobes" are informed that even nowadays we put our lives into the hands of machines, e.g. in planes or with pacemakers, and they do better job than humans). Technology should be sustainable, respect the nature and be aligned with it, i.e. not fight against it but rather direct its forces towards good causes. Protection of the environment and integration of natural elements in cities is stressed. Only clean and safe energy would be used. Earth carrying capacity should be respect, i.e. people would avoid overpopulation by voluntary birth control.

The project is for **absolute freedom of information** -- there would be no [intellectual property](intellectual_property.md) (copyright, patents, ...), no trade secrets, state secrets and probably also no personal secrets, as in a non-competitive society there wouldn't be a danger of abusing personal information. They argue that despite computer sensors being present everywhere, there would simply be no need for surveillance of people as there would be no corporations, no criminality etc.

It also opposes nationalism, racism and other forms of privilege and inequality. However this shouldn't be forced in the [SJW](sjw.md) style, it should rather come naturally thanks to fixing the the root cause of these issues (removing competition, governments, money etc.).

Education would play a huge role in the society -- again, it wouldn't be forced on children, they should want to go to school because education would be [fun](fun.md) and give them freedom to pursue their interests. There would be no grades and it should teach high scientific and critical thinking, rational discussion, nonviolent resolution of conflicts, collaboration through group project and collaborative games, love towards nature (e.g. by projects involving growing plants) etc. [Generalism](generalism.md) would be preferred before hyper [specialization](specialization.md) (which we see nowadays).

Fresco also addresses the fear of some people of people becoming too uniform and losing individuality -- he stresses that individuality would be focused on, uniformity would only lie in common goals and caring for all humans and nature. Unlike in current society, each human would have the freedom to pursue his true interests and goals.

The project claims it has years of research and seems to have a great number of specific ideas for what the technology might look like, how we would harness energy, travel etc. There are many 3D visualizations. Fresco claims that in the new society everyone would have a higher living standard than the rich have nowadays.

The transition towards this society should be **peaceful and evolutionary, NOT revolutionary**. It has to be voluntary and rational. The initial stage -- building the first center with the project ideas in mind -- has already been completed in Florida. Raising funds and educating the public should continue, then more cities in the spirit of the project should start to appear, interconnect and prove the ideas in practice. Then slowly the new cities and ideas would start to replace our current system.

## Comparison With LRS

We, [LRS](lrs.md), highly support and agree with the Venus Project as an idea, in its analysis of current society, goals and means of achieving it. At least as of 2022, we can't know if any single project will become corrupt in the future (e.g. with [SJWs](sjw.md)). We may still disagree on some details, focus a bit more on different areas etc. Here are a few points about that.

Venus Project seems to only focus on humans, unlike LRS which is based on the love of all life, i.e. also animals, possibly even alien life etc. Venus Project mentions that in the future there would possibly be fish farms -- for us this seems unacceptable as we advocate [vegetarianism](vegetarianism.md), even the lives of fish are precious to us. In a highly advanced society artificial meat (which we accept) would probably be available and replace meat from any living animals so we would eventually align with Venus Project, but the human-centeredness of Venus Project is still there.

It may seem we also focus on simplicity of technology (e.g. [sucklessness](suckless.md)) while Venus Project seems to advocate [bloat](bloat.md) and overapplication of technology. This may not be such an issue because a truly good technology that Venus Project advocates should converge towards simplicity naturally thanks to minimizing maintenance, maximizing safety (minimizing dependencies), removal of bullshit features etc. In other word even hi-tech advocated by Venus Project can be done in a suckless way, for example the automation would work on top of [Unix](unix_philosophy.md) operating systems. Still the future from LRS point of view may look less hi-tech, we might prefer simple buttons to voice recognition and so on :-)

And a bit more criticism: the project doesn't seem to practice [free culture](free_culture.md) and [free software](free_software.md), even though of course it would implement them in their society -- it kind of makes sense as they seem to be trying to be above current movements, they simply think we should focus beyond them. We might disagree and say that even looking into the far future we should still keep an eye on the now, education about free culture can greatly contribute to education about the advantages of information freedom etc. Furthermore they are selling some videos on their site, which we don't really like but the project justifies it as raising funds for their operation. To their credit they have many gratis videos and educational material, even the books can be found as "free download". Another criticism comes towards the materials themselves which are sometimes a bit unprofessional which is a shame (e.g. the book has many typos and is not so readable). Also there seems to be a bit of personality cult around Jacque and Roxanne, their faces are all over the place and even though they seem like really great people and even though it may simply be due to the lack of other "strong personalities", this makes the movement look like a religious cult to some critics. Tio, the guy behind [TROM](trom.md) who collaborated with Venus Project also expressed slight criticism of organization of the project, that they were too concerned about control over their materials and that he even met a few toxic people there, though he says the experience was till mostly positive. We have to keep in mind that people, teams and projects are imperfect, they can become spoiled and fail, however this changes nothing about the ideas the project presents, which we support. As always, we have to separate ideas and people -- the situation here is perhaps similar to [free software](free_software.md) as an idea, which we fully support, vs [free software foundation](fsf.md) as a project and team of people, which has a few issues.

## History

TODO

## See Also

- [less retarded society](less_retarded_society.md)
- [trade-free](trade_free.md)
- [Trash Magic](trash_magic.md)
- [Zeitgeist Movement](zeitgeist_movement.md)
- [TROM](trom.md)
- [freemasonry](freemasonry.md)
- [deep ecology](deep_ecology.md)
- [One Community](one_community.md)
- [Positive Revolution](positive_revolution.md)
