# Unfuck

Unfucking an already existing [software](sw.md) (or another piece of [technology](tech.md)) means taking said software and adjusting it to better comply with [less retarded software](lrs.md), i.e. *fixing it*. Doing so may be an efficient way to obtain good software without having to [write it from scratch](reinventing_the_wheel.md), but, indeed, a few prerequisites have to be met: for example the software will likely have to be [free (as in freedom)](free_software.md) (so that we can [fork](fork.md) it) and the energy invested into "fixing it" mustn't exceed the reinventing energy.

Unfucking software may involve for example the following:

- **Reverting to an older version.** [Older](old.md) software was always better, reverting to an older version of "[modern](modern.md)" software may itself do a great deal of unfucking such as removing "[privacy](privacy.md)" bullshit, transitioning to a simpler build system and an older standard of the language. Remember, the old version is still available, at least in source form -- [update](update_culture.md) addicts somehow think the old version is "gone" but of course that's not true, it may just be needed to invest a bit of time to compile it.
- **Switching to a simpler [build system](build_system.md).** Unusable build systems such as [CMake](cmake.md) plague every single [modern](modern.md) project -- these have to be removed and replaced with something usable such as simple Makefiles or a plain shell script.
- **Removing political bullshit and other crap ([COC](coc.md), lesbian flags, [Furry](furry.md) mascots, Ukraine flags, anime autism etc.).** For some reason [zoomers](zoomer.md) insert [fascist](fascism.md) symbolism and childish autist drawings into everything, these have to be removed.
- **Rewriting in a better [language](programming_language.md).** This may be more [work](work.md) so it won't happen often, but rewriting [C++](cpp.md) to [C](c.md) or C11 to C99 may be not that hard.
- **Removing other kinds of [bloat](bloat.md).** This just means generally improving the software: remove bullshit features, remove dependencies on [docker](docker.md), [systemd](systemd.md) and similar [cancer](cancer.md), remove/replace bullshit [libraries](library.md) etc.
- **Improving it in other ways.** I.e. for example cleaning the code, documenting it, rewriting it a bit to be more portable, [debugging](debugging.md) it etc.
- **[Porting](portability.md)**. Old software may have been good but will no longer run on "modern" systems simply because the interfaces have changed, i.e. some porting may be needed -- this will probably mean writing a new frontend, switching to some [I/O](io.md) library like [SDL](sdl.md) etc.
- **[Liberating](liberating.md)**. It may happen the software is only partially free -- for example old games may nowadays have their engine freed but assets will still remain [proprietary](proprietary.md). It may be therefore needed to substitute the assets with free ones. (See e.g. [Freedoom](freedoom.md).) 
- ...

## See Also

- [unretard](unretard.md)