# Selflessness

Selflessness means acting with the intent of helping others at least as much (or more) than helping self, and that without discrimination and harming, without gaining edge over others or taking advantage of them in any way. It is the opposite of selfish behavior, i.e. that motivated by [self interest](self_interest.md), [egoism](egoism.md), narcissism, self-centeredness, [fascism](fascism.md) (seeking benefit for one's own social group) etc. Selflessness is the basis of an [ideal society](less_retarded_society.md) and [good technology](lrs.md) (while sadly self interest is the basis of our current dystopian [capitalist](capitalism.md) society).

Selflessness is defined more by the **intent** behind behavior rather than the result of it, because all results are eventually subject to chance to some degree; for example being a [vegetarian](vegetarian.md) (or even [vegan](vegan.md)) for ethical reasons (to spare animals of suffering) is selfless while being a vegetarian only because of one's health concerns is not selfless. Similarly if a selfless behavior unpredictably results in harming someone, it is still a selfless behavior as long as the intent behind it was pure. (Note that this does **NOT** at all advocate the "[ends justify the means](ends_justify_the_means.md)" philosophy which acts with an intent to hurt someone with an excuse of "selfless intent".)

In the real world examples of absolutely pure selflessness may be very hard to come by even if we actively search for them, partly because selfless behavior by definition seeks no recognition (demanding recognition for selfless behavior means asking something extra only for oneself). There are relatively frequent accounts of mothers (father only rarely) showing selfless [love](love.md) for their children, it's not uncommon for a mother to sacrifice her life for a child if that's needed, and this act may a lot of times be seen as selfless, but not always (saving one's child in such way may just serve perpetuating own genes, it can also be done to posthumously increase one's fame etc.). An example of high selflessness may perhaps be so called [Langar](langar.md), a big community kitchen run by [Sikhs](sikhism.md) that prepare and serve free [vegetarian](vegetarian.md) food to anyone who comes without differentiating between religious beliefs, skin color, social status, gender etc. Sikhs sometimes also similarly offer a place to stay etc. The mentioned ethical vegetarianism and veganism is another example of selflessness, as well as [LRS](lrs.md) itself, of course. A not very typical example could also be posting a new, original meme on an anonymous image board: that who does this made some effort to entertain people at large (including himself of course) but doesn't benefit more than others, for he practically gave up his authorship (by posting anonymously) and everything that comes with it ([copyright](copyright.md), fame, attention, ...), but still someone could argue these acts may sometimes rather be motivated by [fascism](fascism.md) (wanting to help the group one is part of by sacrificing one's potential for benefit, calculating that helping the group will later on benefit himself on the detriment of people outside of the group, which of course is no longer selfless).

There exists a very common but faulty "argument" against selflessness, used by idiots as an excuse for own selfish behavior, and it goes like this: "All behavior is selfish because even selflessness seeks a good feeling as a reward, therefore selflessness doesn't exist and so I can just behave however I want." This is of course totally retarded. **Selflessness doesn't mean one seeks no reward**, there is practically always at least the reward of a good feeling for a selflessly behaving individual, but this isn't at all in conflict with our definition of selflessness. Selfless acts may also include physical rewards, for example if a programmer dedicates years of his life to developing a [free](free_software.md) [public domain](public_domain.md) software that will help all people, he himself will benefit from using that program. The key aspect here is that he doesn't use the program to harm others by reserving some privileges for himself, e.g. by charging money for it or even by using a license that requires others to credit him and so increase his reputation. Economically speaking such behavior would be equivalent to printing money, then giving everyone $1 and taking $10 for oneself, which again is nothing more than benefiting self. But as long as the programmer asks nothing extra for himself, we can say he selflessly sacrificed part of his life purely to increase good in the world for everyone without trying to gain an edge over others.

This reveals that what's many times called selflessness [nowadays](21st_century.md) is only **pseudoselflessness**, fake selflessness. This includes e.g. all the celebrities who publicly financially support charities; this seems like a nice gesture but it's of course just a PR stunt, the money spent on charities is money invested into promoting oneself, increasing fame, sometimes even tax hacking etc. This also goes for professional firefighters, doctors, [FOSS](foss.md) programmers that use licenses with conditions such as attribution etc. This is not saying the behavior of such people is always pure evil, just that it's not really selfless.

**Selflessness can cure the world epidemic of [depression](depression.md)** -- selflessness is something that is practically guaranteed to make you feel better, that gives your life a meaning AND which at the same time can be done by absolutely anyone and by everyone at the same time, it's a completely healthy cure to depressive thoughts which is also at the same time helpful to society. Contrast this with the capitalist "feel good drug" -- that of winning in competition and endlessly chasing "success". That is something that only very few can do -- only the most talented and lucky ones will get the psychological reward in a competitive system, after dedicating everything to it, and even those will only get it temporarily and will be craving more and more, like a heroin addict; by definition only one man can be a winner, others will be losers, hence the masses of depressed people in the population.

Selfless programs and art should be put into the [public domain](public_domain.md) with waivers such as [CC0](cc0.md). Using licenses (free or not) that give the programmer some advantage over others (even just let's say requiring attribution) are not selfless.

## See Also

- [charity](charity.md)
- [altruism](altruism.md)
- [dog](dog.md)