# Pseudo 3D

The term pseudo 3D, also 2.5D or primitive 3D (preferred by [us](lrs.md)), is used for [computer graphics](graphics.md) that only uses cheap techniques of [3D](3d.md) [rendering](rendering.md) (such as 2D [raycasting](raycasting.md), mode7 etc.) and so creates more of an "illusion of 3D" that poses many limitations (such as those on camera movement and rotation); genuine 3D rendering that uses more advanced techniques (typically triangle rasterization, [raytracing](raytracing.md) etc.) is then called "[true 3D](true_3d.md)" (also "6 degrees of freedom" etc.). However it's crucial to realize that EVERY 3D rendering is in the end only an illusion and so there is eventually no objective line separating primitive 3D and true 3D -- by convention some techniques ended up being assigned mostly to one group or the other, but the line is in the end drawn just arbitrarily. In the mainstream using the traditional pseudo 3D techniques is nowadays mostly a thing of the past as everything including cell phones now has a powerful [GPU](gpu.md) capable or most advanced 3D rendering (and so it is even used to "fake" the simpler techniques for aesthetic reasons), nevertheless for [suckless](suckless.md)/[KISS](kiss.md)/[LRS](lrs.md) programming the techniques used in the past are very valuable, interesting and useful, considering we greatly prefer [software rendering](sw_rendering.md).

To give an example: [BSP rendering](bsp.md) rendering in early games such as [Doom](doom.md) is traditionally called pseudo 3D in the [mainstream](mainstream.md), however, as stated above, it is pretty debatable what exactly should classify as true 3D and what not because any computer rendering technique will inevitably have some kind of simplification of the true 3D reality of real life. And so the debate of "Was Doom really 3D?" arises. In the end this is the same debate as "Is Pluto a planet or not?", it's just a matter or settling for a definition of a word. One side argues that in Doom's BSP rendering it for example wasn't possible to look up and down or have rooms above other rooms, all due to the limitations of the rendering system which this side deems "not sufficiently 3D". On the other hand Doom really internally functioned with 3 dimensions, player DID have a height coordinate (without it it would be impossible to smoothly fall from heights), but most importantly: any 3D renderer will always impose restrictions -- not even modern 3D renderers are spared from suffering limitations such as being able to only render models made out of [triangles](triangle.md) (when reality indeed shows a greater variety of shapes), having a limited resolution of textures (when reality shows infinitely detailed surfaces), being limited by resolution of [floating point](float.md) coordinates or neglecting relativistic spacetime deformations. If we rewrite Doom rendering in OpenGL while giving the camera freedom to look up and down but keep the technical limitations for maps, is it now true 3D or not? If we have a 3D game with complete freedom of camera but with all objects only being 2D sprites, is it true 3D or not? Is Minetest true 3D even if it can't render anything sphere-shaped? If a game uses traditional 3D rendering on the GPU to output an isometric 2D image without perspective, is it true 3D or not? Where to draw the line for "true 3D" is subjective -- we see it as reasonable to say that **if it looks 3D, it IS 3D**, i.e. we think Doom's graphics WAS really 3D, albeit limited. For this reason we also advise to rather use the term **primitive 3D** rather than pseudo 3D.

Techniques associated with primitive 3D are for example [2D raycasting](raycasting.md), [BSP rendering](bsp.md), [mode7](mode7.md), [parallax scrolling](parallax.md), [voxel space](voxel_space.md) terrain rendering or perspective-scaled [sprites](sprite.md).

## See Also

- [software rendering](sw_rendering.md)
- [bsp rendering](bsp.md)
- [raycasting](raycasting.md)
