# Proprietary

The word proprietary (related to the word *property*) describes intellectual works (such as texts, songs, computer programs, ...) that are not [free as in freedom](free.md), i.e. a proprietary work is one that is someone's "[intellectual property](intellectual_property.md)" (owned on grounds of [copyright](copyright.md), [patents](patent.md), [trademarks](trademark.md) etc.) that denies others at least one of the four essential freedom conditions agreed upon by movements such as [free software](free_software.md) or [free culture](free_culture.md). The word *proprietary* has a completely negative connotation, for such works serve [capitalist](capitalism.md) oppressors, their aim is to abuse and suppress freedom. The opposite of *proprietary* is therefore *free as in freedom* (also *libre*): free works are either those which are completely [public domain](public_domain.md) or those technically "owned" by someone but accompanied by a free (as in freedom) [license](license.md) that voluntarily waives all the most harmful legal "rights" (more correctly opportunities of oppression) of the "owner". There are two main kinds of proprietary works (and their free counterparts): proprietary [software](sw.md) (as software was the first area where these issues arose) (versus [free software](free_software.md)) and other proprietary [art](art.md) of other kind (music, pictures, data, ...) (versus [free cultural](free_culture.md) art).

Proprietary software is commonly agreed to be [evil](evil.md); it is mostly [capitalist software](capitalist_software.md) designed to abuse its user in one way or another. Proprietary code is often secret, not publicly accessible, although it's not uncommon to come across programs whose source code is [available](source_available.md) but which is still proprietary because no one except the "owner" has the necessary legal rights to using it, studying it, fixing it, improving it and/or redistributing it.

Examples of proprietary software are [MS Windows](windows.md), [MacOS](macos.md), [Adobe Photoshop](photoshop.md) and nearly every [videogame](game.md). Proprietary software does not only do extraordinary [harm](harmful.md) to [culture](culture.md), [technology](tech.md) and society as such, it is downright dangerous and on occasion life-threatening; see for example cases of medical implants such as pacemakers running secret proprietary code whose creator and maintainer goes out of business and can no longer continue to maintain such devices already planted into bodies of humans -- such situations have already appeared, see e.g. *Autonomic Technologies* nervous system implants.

Proprietary software licenses are usually called [EULAs](eula.md).

By extension besides proprietary software we also encounter other types of proprietary works, for instance proprietary [art](art.md) or [databases](db.md) -- these are all works that are not [free cultural](free_culture.md) works. Although for example a proprietary movie probably isn't IMMEDIATELY and DIRECTLY as dangerous as proprietary software, it may well pose the same danger to society in the long run. Examples of proprietary art is basically anything mainstream that's not older than let's say 50 years: [Harry Potter](harry_potter.md), all Hollywood movies, basically all pop music, virtually all AAA video [game](game.md) art and so forth.

**Is it ever fine to use proprietary software?** If you have to ask, the answer is no, you should avoid proprietary software as much as possible (considering in today's society you probably can't even take a shit without using some form of proprietary software). Proprietary software is [cancer](cancer.md), it is like hard drugs, poison, radioactive toxic material, biological virus -- you have to treat it as such. For this reason to most people, especially newcomers to the free world, the best, simplest and safest advice is to completely avoid anything proprietary; this helps you get out of the addiction, break out of the system, find free alternatives and avoid harm to yourself and others. Once one becomes an expert he start to see the answer may be more complex of course, as with everything -- for example in order to make a free [clone](clone.md) of something proprietary, we often have to [reverse engineer](reverse_engineering.md) it, which often means having to run it; however this has to only be done by experts who know the dangers and how to handle them, just like handling of a highly dangerous biological virus should only ever be done by an expert in safe laboratory under strictly controlled conditions.