# Proof

[Mathematical](math.md) proof is [logical](logic.md) reasoning that beyond any doubt shows given statement to be true. Such a proof is the best and most objective guarantee of truthfulness we can ever hope for -- this is not to say there can't ever exist any doubt about mathematical proof, but as long as we agree on the [axioms](axiom.md), believe logic itself holds and that there is no error in the proof, the proven statement has to hold. Mathematical proof is a **deductive** reasoning (despite the fact that, a bit confusingly, one type of mathematical proof is called *induction*) that absolutely eliminates any chance of being wrong, i.e. it is yet a stronger argument than inductive proofs provided by traditional [sciences](science.md), which typically just have high level of statistical confidence that however never reaches 100%. This is to say mathematical proof must never leave a slightest doubt about the conclusion, and so while presenting thousands or millions of samples supporting a hypothesis may in traditional science be good enough to call the hypothesis confirmed, it is not enough for a mathematical proof. Mathematical proofs are therefore hard and still amount to [art](art.md) requiring human brain (although some proofs can nowadays be assisted or even carried out completely autonomously by [computers](computer.md)), and so in practical life we often require mathematical proofs only in very critical areas -- for example [software](software.md) used in planes or medical devices has to be mathematically PROVEN to be correct (see [formal verification](formal_verification.md)), most other software is [debugged](debugging.md) just by [testing](testing.md), which is just a [good enough](good_enough.md) evidence it's mostly free of bugs.

TODO

**Why do we need mathematical proof if something is obvious?** Well, mathematicians need to be most precise and proof enables them to discover absolute truths without any shadow of a doubt (a luxury most other scientists don't have), so they set it as a standard because many things that seem obvious aren't in fact so -- for example numbers 31, 331, 3331, 33331, 333331, 3333331 and 33333331 are all [primes](prime.md) so you might think by this pattern also 333333331 will be a prime, but that's not the case because 333333331 = 19607843 * 17. Sometimes patterns deceive us, mathematicians only take proof for the ultimate solution. But indeed e.g. the industry sometimes accepts even unproven but highly likely conjectures to hold, e.g. that [P doesn't equal NP](p_vs_np.md), simply for economic reasons (the chance of being wrong is very low and profitability of being right is high).


**There are mathematical problems that cannot be proven** or disproved (under given set of axioms). See [decidability](decidability.md).
