# Project

Project is a highly planned, well thought through endeavor. All kinds of projects exist, from small personal ones (such as creating a piece of furniture), through professional projects conducted by teams of specialists which span several years (such as a mainstream AAA video [game](game.md)), to international megaprojects (such as the Suez Canal) and even perpetual projects which are never planned to be terminated (such as [Wikipedia](wikipedia.md)).

## How To Do Projects Well

**THIS IS NOT A "[PRODUCTIVITY](productivity_cult.md)"/"MOTIVATION" ARTICLE.** If you're seeking "productivity", go capitalisting somewhere else.

Firstly a foreword of warning: stuff about how to plan projects, lead them, get people "motivated" and so on is a huge, huge milking cow of "[productivity](productivity_cult.md)" writers and capitalists, to a large degree this is a bullshit topic growing alongside gigantic capitalist [bullshit](bullshit.md) projects and entrepreneurship religions. Never fall into this trap, never let concerns about how to make art take too much of the time that should actually be spent on making the art itself. With this said, we may offer some useful word of advice.

Also let it be known that everyone has to find his own way of conducting and managing his projects, it's just like with learning skills: everyone has his own approach, what works for one may not be good for another. The advice here will come firstly from the author's ([drummyfish](drummyfish.md)) personal experience and secondly from general [LRS](lrs.md) principles. Also even though we'll mostly be preoccupied with programming projects, a project can be anything really, what we say applies also to making a [music](music.md) CD, smashing wood or writing a [book](book.md). Here we go:

- **As always, keep everything [free](free_software.md), [LRS](lrs.md), well designed, non-commercial etcetc.** Minimize [dependencies](dependency.md); dependencies of your project are for example the [programming language](programming_language.md) you use, libraries for formats that you use, assets of third parties you use, minimum hardware demands of a computer that can handle the project etc. Make it tool-agnostic -- your programming project mustn't be a project for your programming IDE, your book shouldn't be directly written in LaTeX (rather write it Markdown which will enable you to compile to LaTeX as one of many target formats), your song mustn't be a project for your DAW etc. Just a reminder. Also think with your brain.
- **Prefer one man projects to many men projects**: Firstly LRS projects should be simple enough to be manageable by a single man, which has many advantages, for example ensuring a coherent artistic vision without any compromise, legal simplicity (e.g. with relicensing), ensuring that the project can REALLY be controlled by a single man (true [freedom](free_software.md)), and also very importantly the cost of collaboration. Multiple people on a project -- even just two -- introduce many inconveniences, issues and [friction](friction.md), e.g. that of communication (every thought has to be explained, put into words for others and they still may not completely get it, communication tools will have to be set up and maintained, ...), resolving editing conflicts (multiple people working on the same thing at once), making decisions (voting? discussions?), disagreements, arguments, "codes of conducts" and similar bullcrap. LRS does value collaboration, but mainly loose collaboration, i.e. making bigger things out of smaller things that are made by single people. But more people projects are cool, e.g. wikis or maybe projects by very close people who are already used to working together efficiently.
- **Do NOT be too ambitious, especially with first projects.** This is EXTREMELY important and you have to realize that even if you think something will be easy, it won't be so, a project will always be at least 20 times harder than you estimate (even if you already have experience in estimating project difficulty). Making a game is not just about programming it (which itself means debugging, refactoring, writing tests, debugging tests, organizing repos, designing APIs, studying libraries, ...), you'll also have to document it, play test it (many, many times over), debug it, optimize it, package it, make a website for it and a billion other things. If you decide to make a game like GTA (or even just Pokemon clone or something) but you haven't made at least 10 games already, YOU WILL FAIL, it will be a disaster and completely wasted time. Unless you've done like 10 projects already, choose dead simple things like Tetris clone or something (see [exercises](exercises.md) for beginner project tips). Remember, the goal of your first project isn't the thing in question but rather learning about making a project and finishing it.
- **[FINISH](finished.md) THE FUCKING PROJECT.** Unfinished project will just have wasted your time, it will leave you disgusted, broken, depressed and defeated, it will be of no use to anyone, you'll just feel like [shit](shit.md). For this it is important to choose something simple -- if you finish the thing, you'll be happy regardless of how simple it really was, you'll be eager to make more things, people will be able to use your project, they'll be thanking you for it which will further make you more happy and so on. Even if it's a freaking minesweeper, you've made your own game now, it brings happiness to people, you can take a look at it every time you'll be feeling down and be a bit happier. On the other hand however if your project still ends up failing don't become too depressed and try to take the best of it -- it's not the end of the world, you have acquired some experience and you may still try to reuse parts of the failed project elsewhere, just try to extract maximum good.
- **Take long breaks**, enjoy the luxury of it not being a "[job](work.md)" -- once you're fed up and sick of long work, indulge a pause and relaxation. If other projects are waiting, you may hop elsewhere, and if you're simply just overall tired, take a full vacation without feeling guilty, go play [games](game.md) or whatever. In a week, month or a year you'll start to feel the urge to get back and when you do, you know it's time, it's a sign your enthusiasm is returning, it's very likely you'll now experience a period of """[productivity](productivity_cult.md)""" (better said just enjoyment) and inspiration. Also when you get stuck or stand before an important decision taking a break is very much advised, you need a fresh mind and even if you make a decision, take a few more days to see if you still think it's good after some time.
- **Have multiple projects in progress**. This is cool for several reasons, for example it prevents a burn out of a single project -- if one projects becomes boring, shows to lead nowhere or you simply get tired of it for a while, you switch to a different one. Even if it fails completely and you delete it, you still have many other "children", it won't be a disaster. Sometimes you have a period when you want to program, so there's a programming project waiting for you, other times you feel like you wanna do music, and there is the project that needs some music, just ready for you. So this also stimulates you in different ways. And sometimes you get surprised if some small project turns into something unexpected maybe. It's just good to have this diversity in your art.
- **Do everything yourself and keep switching tasks**. This is similar to the other point about having multiple projects, just within a single project. Be your own programmer, graphic designer, musician, tester, writer and so on -- at least as much as possible. This not only helps you become a cool generalist, an independent, non-capitalist living being, but also prevents burn out from doing the same activity over and over.
- **Publish everything immediately**, don't wait until the project is "polished", this NEVER, never ends well. Really just have everything public at all times, keep no secrets, make it public even if it's buggy, shit, cringe, dangerous or whatever. This doesn't mean "go promote your buggy unfinished game", but simply "have your work-in-progress git repo public". This is not capitalism in which you work in secrecy and then "ship" a "product". Just make art and let anyone watch you, give you "feedback", advice and so on, get rid of shame, don't let others waste time on making what you're already making, don't let perfectionism paralyze you so that you'd never release your art. On the other hand, however, **leave the "official release" part for the very end** -- i.e. have the project public, but don't go actively showing it to people, don't waste time on adding it to repositories, making websites and similar stuff. Firstly this leaves you a kind of "reward" at the end, something you get for FINISHING the project. If you show a 50% finished game to the Internet and get a praise, you've gotten your treat ahead of time, you will no longer want to pursue finishing the thing. Secondly you may very likely abandon the project (and more so due to what's just been stated), leaving just a spam of unfinished half-baked ideas behind. Take a look a libregamewiki, vast majority of games are "50% finished" prototypes of no value to anyone.
- **If you ARE ambitious, separate it into multiple less ambitious projects**. Firstly this is just a [good design](unix_philosophy.md), you shouldn't be making a magnificent monolithic program but rather multiple smaller ones out of which it is easy to make the big thing. This achieves multiple positives: you'll have several parallel projects as advised above and also if you don't finish the grandiose piece, you'll still probably finish at least the smaller independent parts that will likely be useful on their own. The best thing is you're not making any compromise, you're not giving up on your dream of the big project, just not putting all eggs in one basket. So if you truly desire making that [GTA](gta.md) clone (and have at least 20 years of experience so that you can even think about it), rather make several projects such as a [3D renderer](3d_rendering.md), [physics engine](physics_engine.md), a pack of car [3D models](3d_model.md) etc. When all of the projects are ready, you may try to merge them into the magnum opus.
- **Before going ambitious, prepare to get brutally sick to your bones**. No matter how much you love and enjoy your craft, pushing it to limits will make you sick of it near the finish line, just like a marathon runner always does in pushing his personal record -- he is happy but vomits blood and sweats like a turkey. Take this into account and plan for it, leave pleasant tasks for latest stages, don't take additional burdens, plan to take a long break after.
- **"It would be cool" is not a good enough motivation for a bigger project.** You can't start a big thing just out of boredom. Finishing a greater thing will be painful, you'll be through sleepless nights, periods of desperation, headaches and burn outs, you'll sacrifice social life to hunting down bugs and rewriting shitty code. To keep yourself going through this it's not enough to know that "the result will be nice I guess". It needs more -- you must absolutely feel it is necessary to make the thing, you have to think the world NEEDs you to make it, only then you will keep torturing yourself to make it to the finish. So choose very wisely.
- **Before making a big thing of type X make a small thing of type X** or as it's been said "plan to throw one away". This is to say that you can't make a good game if it's the first game you're making, so you better make your first game small knowing that it ill suck rather than making a big game that would suck. The first thing is just for the experience. You can't prepare yourself for making an operating system just by reading a book, you have to make one to REALLY comprehend what it will be about, to see the whole picture and to properly plan it.
- **Don't spontaneously start projects, don't rush, only start well thought through things.** As a creative being you'll be getting hundreds and hundreds of amazing ideas -- don't think you're a genius, this is common for many people, even normies get many ideas for great games and "apps" and whatever, so don't get too excited, it is important you judge carefully what to do and what to leave for later: planning and actually MAKING the thing is the actual part that will distinguish you from the normie. Write your amazing ideas down if you need, but don't jump in on any new great idea that appears, always let any idea sit for at least half a year, maybe even several years. It is very tempting to start new things but you must have self control, or else you'll end up like the [dog](dog.md) that starts chasing any new smell it catches and will be just chaotically running around without any goal, making unplanned projects that will fail every time. If an idea should deserve your valuable time, it has to pass the great filter of time -- if it survives in your head after a few months, in all the avalanche of new and new ideas, you know it may truly be worth trying. Furthermore you also have to have a good plan for any project you start and this planning requires a lot of thinking ahead -- you should only start writing code once you have the whole project in your head. This planning CANNOT be rushed, you can't plan it over a weekend, this is not [capitalism](capitalism.md) where things are made on schedule, this is [art](art.md) that needs its time, it must wait for inspiration, small improvements and rethinks over the time that it's sitting in your head. In this meantime stay with your already work in progress projects.
- A simple psychological trick is this: **you can get a lot done on project *A* by "procrastinating" on project *B*.** It's the same as cleaning your house in order to avoid doing homework. Having a multitude of projects helps in this, you're lazily avoiding one project by doing another. { This wiki is mostly the result of "procrastination" on my programming projects. ~drummyfish }
- **Leave your session with something pleasant to be done next**: this will make you look forwards to come back to "work" on the project next time. If you're doing something painful, like being in a middle of [debugging](debugging.md) horror, try to finish it, and once there is something enjoyable next on the TODO, such as making game levels or playtesting, leave it for next time. In general **make it easy and pleasant for your future self to come back to the project**, i.e. don't leave in the middle of solving some complicated task -- rather finish it and leave with a choice of what to do next.
- On very rare occasion inspiration comes and a masterpiece is born within an hour, but moments like these are as common as finding a gold nugget in mounds of dirt -- rare sparks of genius are a small reward to diligent artists, but cannot be relied on. Most of the time **great art is simply made by sitting on it for hours without end and pouring TONS of time, sweat and blood in**, trying and failing over and over, rewriting and refining, testing and rebuilding from scratch. Do not wait for the muses, they won't come, you are wasting time. You must rely only on your patience to make something worthy of appreciation -- go do it right now. Miraculous accidental discoveries do happen, but they always happen to those who keep exploring tirelessly, never to those who just wait for something to fall from the sky.
- **Start small and humble (if it's meant to be big, it will become big naturally), focus on the thing you're making (not its promotion or "management").** Some nubs just see [Steve Jewbs](steve_jobs.md) or [Che Guevara](che_guevara.md) and think "I'LL BE A BIG PROJECT LEADER", they pick some shitty idea they don't even care too much about and then just start capitalisting, they buy a suit, coffee machine, web domains, set up a kickstarter, make a Jewtube video, Twitter account, logos, set up [promotional](marketing.md) websites, write manifestos and other shite. Yes, manifestos are cool, but only promise yourself to write it once the project is fucking done and worth something ;) Sometimes they hype a million people to jump on board, promising to make a HUGE, gigantically successful and revolutionary thing, while having 3 lines of code written so far. Congratulations, you now have nothing and the pressure of the whole world to make something big. This is the best way to hell. At BEST you will become a slave to the project, will hate it and somehow manage to make an ugly, rushed version of it because you didn't foresee what obstacles there would appear but which you would still have to solve fucking quickly because everything is falling on your head and people are shitting on you, angry that you're already two years late and you're already burned out and depressed and out of budget. Just don't be such a capitalist pussy, make a nice small thing in your basement and let its value show itself.
- **Make it a habit/routine to do your project**. As with everything requiring a lot of time investment and dedication (exercise, language learning, ...), it's important to make it a routine (unless of course you're taking a break) to really do something significant. A small, spontaneous, irregular polish of your project is great too, but to really do the biggest part you just need a habit. People often say they're lazy and can't get into it -- everyone is lazy and everyone can get into it. Here is the trick: start with trivial things, just to get into the habit, i.e. at first it's literally enough to write 1 line of code every day. At the beginning you're not really doing much of any significant "work", you are just setting up your habit. Anyone can write 1 line of code per day: just tell yourself to do this -- write 1 line and then, if you want, you're done. You will find that second or third day you'll be writing 10 lines and in a week you will quite likely be looking forward to it, soon you'll have the other problem -- getting yourself to stop.
- **Milestones and psychological mini rewards are nice to keep you going**. It's awesome to split the project into milestones so that you see your "progress", it's very good if each milestone adds something visible and tangible -- for instance with a game just the moment when you become able to physically move through the level always feels very rewarding, no matter how many times you've done it before, it's always a bit surprising what joy a simple feature can bring. Exploit this to increase joy of making your art.
- **Don't expect or aim for any reward other than the finished project**, don't expect/chase [money](money.md), fame, gratitude, don't expect that anyone will notice or thank you for the project. You are making it only because you want something that doesn't yet exist to exist and that's the only reward you can and should ever anticipate. Firstly this makes your project [selfless](selflessness.md), secondly it makes it pure, non-corruptable, only dedicated to its goal and nothing else, thirdly it spares you suffering from failed expectations.
- **When you're hard stuck, go away from it for a (possibly long) while.** As they say before making decisions: "sleep on it" (maybe even many times) -- there's something about letting your mind rest for a while that makes your subconsciousness solve things, or at least make you comprehend the issue better, see it from a different angle. Therefore when stuck, go do something else -- this is also why it's preferable to have several projects, but generally it's good to just take a break and do something meditative like going for a walk, making something out of wood, doing some sport, sleeping, listening to music and so on. Stop trying to solve the issue you had and just relax for a few days, maybe weeks. It is quite possible inspiration will come from somewhere, fresh air will help you think and maybe a solution will occur to you during this time [spontaneously](zen.md), but even if it doesn't, when you come back to the project you'll be very fresh, rested, your thoughts will be sorted, unimportant stuff filtered out, it's like you've got a different man on the task who will help the desperate past self. Sometimes you get back and immediately spot a simple and elegant solution. Really, this works like [magic](magic.md).
- **Stop talking to everyone.** If you want to do something, you have to quit all social media, destroy your cellphone, uninstall all chatting programs etc. During breaks you may turn them on again, but if you want to focus while there are people around, you won't do anything, it's too much of a distraction, even just their presence. Basically put yourself in a situation when you're stranded on a desert island and there is nothing else to do save for your project, otherwise you'll keep constantly talking to people or at least checking what they're talking about and that's going to constantly interrupt your thinking.
- **Masturbate before doing something**, it not think as much about sex and concentrate better.
- **How to plan something big? Where to start?** This is a hard one, the answer requires experience. In general you have to have the overall thing already finished in your head, even knowing it will likely turn out different. Then divide the beast carefully into parts and think of their interfaces, then start implementing smaller parts that can exist on their own, such as [libraries](library.md), [3D models](3d_model.md) etc. As you go, connect the parts together and KEEP REVISING them. Take notes, always carry a notepad. Every once in a while skim over the whole thing and [refactor](refactoring.md), rethink stuff, see if it still holds up. Upon spotting a defect, fix it immediately, as it will be much harder to fix a cog wheel that's already a substantial part of a big machine. Leave [optimization](optimization.md) for the latest part. Don't be afraid to throw away bad parts, make them again from scratch. When stuck or unsure, ask others for advice, even if they don't understand much -- they may spark an idea that didn't even occur to you. Etcetc.
- ...

## See Also

- [work](work.md)
- [needed projects](needed.md)
- [exercises](exercises.md)