# Pascal

Pascal (named after French [scientist](science.md) Blaise Pascal) is an [old](old.md) [imperative](imperative.md) [programming language](programming_language.md) that was commonly used to teach [programming](programming.md) and enjoyed wide popularity around [1980s](80s.md), though it's still used by some to this day. Compared to anything [modern](modern.md), such as [Python](python.md) and [JavaScript](js.md), Pascal was actually quite [good](good.md) -- it's somewhat similar to [C](c.md) in its [paradigm](paradigm.md) and level of [abstraction](abstraction.md), and is acceptable as a [LRS](lrs.md) language. The language was devised by Niklaus Wirth, a Swiss programmer, who implemented it in the year 1970; it was later on standardized by ISO in 1983 (now known as *Standard Pascal*) and 1990. Pascal also spawned an [object oriented](oop.md) dialect called *Object Pascal*, but that's of course [shit](shit.md) that only adds [bloat](bloat.md). Likely the best known [free software](free_software.md) implementations are **Free Pascal** and **[GNU](gnu.md) Pascal**.

A well known part of [hacker](hacking.md) lore is an essay called *[Real Programmers Don't Use Pascal](real_programmers_dont_use_pascal.md)* which in essence goes on a lengthy rant about how Pascal is just for pussies and that real men only use [assembly](assembly.md) and [punch cards](punch_card.md).

{ Pascal was actually my first language and I have fond memories of it, transitioning to C from Pascal was pretty easy because it had pointers and all this kind of stuff, it was mainly about learning the new syntax. ~drummyfish }

## Details

Pascal is an [imperative](imperative.md), [procedural](procedural.md), structured, relatively lower-level (having [pointers](pointer.md) etc.), strongly [typed](typing.md), usually compiled, relatively [simple](kiss.md) language.

**Compared to [C](c.md)**: Pascal's syntax is different, for example it uses `BEGIN` and `END` keywords instead of curly brackets denoting blocks of code; curly brackets are instead used for [comments](comment.md). The syntax is also case-insensitive. Local [variables](variable.md) have to always be declared at the start of a function, just like in the old C89. [Array](array.md) indices weirdly start with 1, not 0, which can nowadays be confusing. While in C we have 0 terminated [strings](string.md), Pascal uses length prefixed strings, i.e. the first value in a string array says the string length. There are also two types of [functions](function.md): `FUNCTION`s (return a value) and `PROCEDURE`s (don't return anything). Of course the differences don't end here, but these are about the most prominent ones.

Here is our standardized divisor tree program in Pascal:

```
program divisorTree;
uses crt;

{ recursive function, prints divisor tree of x }
procedure printDivisorTree(x: integer);
var
  a: integer;
  b: integer;
  i: integer;
begin
  a := -1;
  b := -1;

  for i := 2 to x div 2 do { find two closest divisors }
  begin
    if x mod i = 0 then
    begin
      a := i;
      b := x div i;
 
      if b <= a then
        break;
    end;
  end;

  write('(');

  if a > 1 then
  begin
    printDivisorTree(a);
    write(' ',x,' ');
    printDivisorTree(b);
  end
  else
    write(x);

  write(')');
end;

var
  number: integer;
  code: integer;
  userInput: string[16];

begin
  while true do { main loop, read numbers from the user }
  begin
    readLn(userInput);
    val(userInput,number,code);

    if code <> 1 then
    begin
      printDivisorTree(number);
      writeLn('');
    end
    else
      break;
  end;
end.
```

## See Also

- [C](c.md)
- [Fortran](fortran.md)
- [Basic](basic.md)
- [t3x](t3x.md): [minimalist](minimalism.md) language inspired by Pascal