# Number

WIP kind of

{ There's most likely a lot of BS, math people pls send me corrections, thank u. ~drummyfish }

Numbers (from Latin *numerus* coming from a Greek word meaning "to distribute") are one of the most elementary [mathematical](math.md) objects, building [stones](rock.md) serving most often as quantitative values (that is: telling count, size, length, order etc.) and labels, in higher math also used in much more [abstract](abstraction.md) ways which have only distant relationship to traditional counting. Examples of numbers are minus [one](one.md) half, [zero](zero.md), [pi](pi.md) or [i](i.md). Numbers constitute the basis and core of mathematics and as such they sit almost at the [lowest level](low_level.md) of it, i.e. most other things such as algebra, [functions](function.md) and [equations](equation.md) are built on top of numbers or require numbers to even be examined. In modern mathematics numbers themselves do not reside on the absolute bottom of the foundations though, they are themselves built on top of [sets](set.md), as set theory is most commonly used as a basis of whole mathematics, however for many purposes this is just a formalism that's of practical interest only to some mathematicians (as the topic gets closer to the fringes of mathematics and at times rather pertains to [philosophy](philosophy.md)) -- on the other hand numbers just cannot be avoided anywhere, by a mathematician or just a common folk. The word *number* may be the first that comes to our mind when we say *mathematics*. The area of [number theory](number_theory.md) is particularly focused on examining numbers (though it's examining almost exclusively integer numbers because these seem to have the deepest pattern related e.g. to divisibility). Interest in numbers isn't exclusive to mathematics -- numbers also play an important role in [culture](culture.md) and religion for example; some even believe in "[magical](magic.md)" power of numbers (see [numerology](numerology.md)).

Numbers must not be [mistaken](often_confused.md) for digits or figures (numerals) -- a number is a purely abstract entity while digits serve as symbols for numbers so that they can be written down. The same number may be represented with many different symbols, using one of many [numeral systems](numeral_system.md) (Roman numerals, tally marks, Arabic numerals of different [bases](base.md) etc.), for example 4 stands for a number than can also be written as IV, four, IIII, 8/2, 16:4, 2^2, 4.00 or 0b100. There are also numbers which cannot be exactly expressed with our traditional numeral systems, for some of them we have special symbols -- most prominent example is of course [pi](pi.md) whose digits in decimal expansion form an [infinite](infinity.md) series -- and there are even numbers lacking any symbolic representation, ones not well researched yet or not important enough, only described by equations to which they are the solution. Sure enough, a number by itself isn't too interesting and probably doesn't even make sense, it's only in context, when it's placed in relationship with other numbers (by ordering them, defining operations and properties based on those operations) that patterns and useful attributes emerge.

To embark on the [history](history.md) a bit, humans first started to use positive natural numbers (it seems as early as 30000 BC), i.e. 1, 2, 3 ..., so as to be able to trade, count enemies, days and so on -- since then they kept expanding the concept of a number with more [abstraction](abstraction.md) as they encountered more complex problems. First extension was to fractions, initially reciprocals of integers (like one half, one third, ...) and then general ones. Around 6th century BC Pythagoras showed that there even exist numbers that cannot be expressed as fractions ([irrational numbers](irrational_number.md), which in the beginning was a controversial discovery), expanding the set of known numbers further. A bit later (around 100 BC) negative numbers started to be used. Adoption of the number [zero](zero.md) also took some time (1st use of true zero seem to be in 4th century BC), with it first just having a limited use as a mere placeholder digit. Since 16th century a highly abstract concept of [complex numbers](complex_number.md) started to appear, which was later (19th century) expanded further to [quaternions](quaternion.md). With more advancement in mathematics -- e.g. with the development of set theory -- more and more concepts of new kinds of numbers appeared and still appear to this day. Nowadays we have greatly abstract numbers, ones existing in many dimensions, capable of counting and measuring infinitely large and infinitely small entities, and it seems we still haven't nearly discovered everything there is to know about numbers.

Basically **anything can be encoded as a number** which makes numbers a universal abstract "medium" -- this can be exploited in both mathematics and [programming](programming.md) (which are actually the same thing). Ways of encoding [information](information.md) as numbers may vary, for a mathematician it is natural to see any number as a multiset of its [prime](prime.md) factors (e.g. 12 = 2 * 2 * 3, the three numbers are inherently embedded within number 12) that may carry a message, a programmer will probably rather encode the message in [binary](binary.md) and then interpret the 1s and 0s as a number in direct representation, i.e. he will embed the information in the digits. You can probably come up with many more ways.

But what really is a number? What makes number a number? Where is the border between numbers and other abstract objects? Essentially number is an abstract mathematical object made to model something about [reality](irl.md) (most fundamentally the concept of counting, expressing amount) which only becomes meaninful and useful by its relationship with other similar objects -- other numbers -- that are parts of the same, usually (but not necessarily) infinitely large set. We create systems to give these numbers names because, due to there being infinitely many of them, we can't name every single one individually, and so we have e.g. the [decimal](decimal.md) system in which the name 12345 exactly identifies a specific number, but we must realize these names are ultimately not of mathematical importance -- we may call a number 1, I, 2/2, "one", "uno" or "jedna", it doesn't matter -- what's important are the relationships between numbers that create a STRUCTURE. I.e. a set of infinitely many objects is just that and nothing more; it is the relationships that allow us to operate with numbers and that create the difference between integers, real numbers or the set of colors. These relatinships are expressed by operations (functions, maps, ...) defined with the numbers: for example the comparison operation *is less than* (<) which takes two numbers, *x* and *y*, and always says either *yes* (*x* is smaller than *y*) or *no*, gives numbers order, it creates the number line and allows us to count and measure. Number sets usually have similar operations, typically for example addition and multiplication, and this is how we intuitively judge what numbers are: they are sets of objects that have defined operations similar to those of natural numbers (the original "cavemen numbers"). However some more "advanced" kind of numbers may have lost some of the simple operations -- for example [complex numbers](complex_number.md) are not so straightforward to compare -- and so they may get more and more distant from the original natural numbers. And this is why sometimes the border between what is and what isn't a number may be blurry -- for example it can't objectively be said if infinity is a number or not, simply because number sets that include infinity lose many of the nicely defined operations, the structure of the set changes a lot. So arguing about what is a number ultimately becomes subjective, it's similar to arguing about what is and isn't a planet.

An [interesting](interesting.md) remark: someone once plotted the number of occurrences of numbers in the online encyclopedia of integer series (OEIS) and discovered a curiosity (called Sloane's Gap). There is a clear gap separating numbers into two [clusters](cluster.md), one containing the "interesting numbers" and the other the rest ("boring numbers"). The interesting set contains primes, increments of powers of two and so on. This is partly [cultural](culture.md) (there is a bias towards base 10 for example), but it's very interesting the gap is so clear -- one would expect there would be a spectrum of how interesting numbers are, but it seems like it's just two clusters.

**[Order](order.md)** is an important concept related to numbers, we usually want to be able to compare numbers so apart from other operations such as addition and multiplication we also define the comparison operation. However note that not every order is total, i.e. some numbers may be incomparable (consider e.g. complex numbers).

Here are some [fun](fun.md) facts about numbers:

- Some people associate numbers with [colors](color.md), though what color each number has seems to be completely subjective. See [synesthesia](synesthesia.md).
- There is a funny hypothetical number between 6 and 7 called [thrembo](thrembo.md).
- There exist [illegal numbers](illegal_number.md), owing to the above mentioned fact that any information can be encoded as a number along with the fact that some information is illegal (see e.g. "[intellectual property](intellectual_property.md)").
- ...

```
 quaternions                . imaginary line
            projected       : (imaginary numbers)
 projected   j line     2i ~+~ ~ ~ ~ ~+ 1 + 2i
  k line       :            :         ,
     ...        :_          :         ,             complex numbers
        \___      \_ j      :         ,
            \___    +_   i ~+~ ~ ~ ~ ~+ 1 + i
                +___  \_    :         ,
               k    \___\_  :         ,
                        \_\_:         1         2         3         4
  - - -~|~-~-~-~-~|~-~-~-~-~+~-~-|-~-~|~-~-~|~-~|~-~-~-|-~|~|~-~-~-~|~- - -
       -2        -1        0:   1/2   ,    phi         e    pi           real line
                = i^2       :  = 0.5  ,    ~=         ~=   ~= 3.14...  (real numbers)
                            :         ,   1.61...    2.71...
                        -i ~+~ ~ ~ ~ ~+
                            :           1 - i
                            .
```

*Number lines and some notable numbers -- the horizontal line is real line, the vertical is imaginary line that adds another dimension and reveals complex numbers. Further on we can see quaternion lines projected, hinting on the existence of yet higher dimensional numbers (which however cannot properly be displayed using mere two dimensions here).*

The following is a table demonstrating just one way of how you can play around with numbers -- of course, we have generated it with a program, so we also practice [programming](programming.md) a bit ;) Here we just examine whole positive numbers (like number theorists would) up to 50 and take a look at some of their attributes -- we count each one's total number of divisors (excluding 1 and itself, 0 here means the number is [prime](prime.md) except for 1, if the number is highest in the series so far the number is called "highly composite"), unique divisors (excluding itself), minimum divisor (excluding 1 except for 1), maximum divisor (excluding itself except for 1), sum of total and unique divisors (if the number equal sum of unique divisors, it is said to be a "perfect number"), average "dividing spread" (distance of each tested potential divisor's remainder after division from half of this tested potential divisor, kind of "amount of not dividing the number") in percents, maximum dividing spread and normalized range between smallest and biggest divisor expressed in percents (-1 if there are none). You can make quite interesting graphs from similar data and discover cool and interesting patterns.

{ Be warned the following is just me making some quick unoriginal antiresearch, I may mess something up, it's just to show the process of playing around with numbers. ~drummyfish }

| number   | divisors |divisors uniq.|min. div.|max. div.|divisor sum|uniq. div. sum|avg. div. spread (%)|max div. spread (%)|div. range (%)|
| -------- | -------- | ------------ | ------- | ------- | --------- | ------------ | ------------------ | ----------------- | ------------ |
|        1 |        0 |            1 |        1|        1|         0 |            1 |                  0 |                 0 |           -1 |
|        2 |        0 |            1 |        2|        1|         0 |            1 |                  0 |                 0 |           -1 |
|        3 |        0 |            1 |        3|        1|         0 |            1 |                  0 |                 0 |           -1 |
|        4 |        2 |            2 |        2|        2|         4 |            3 |                 33 |               100 |            0 |
|        5 |        0 |            1 |        5|        1|         0 |            1 |                 16 |                50 |           -1 |
|        6 |        2 |            3 |        2|        3|         5 |            6 |                 43 |               100 |           16 |
|        7 |        0 |            1 |        7|        1|         0 |            1 |                 24 |                66 |           -1 |
|        8 |        4 |            3 |        2|        4|        10 |            7 |                 44 |               100 |           25 |
|        9 |        2 |            2 |        3|        3|         6 |            4 |                 36 |               100 |            0 |
|       10 |        2 |            3 |        2|        5|         7 |            8 |                 40 |               100 |           30 |
|       11 |        0 |            1 |       11|        1|         0 |            1 |                 34 |                80 |           -1 |
|       12 |        5 |            5 |        2|        6|        17 |           16 |                 53 |               100 |           33 |
|       13 |        0 |            1 |       13|        1|         0 |            1 |                 35 |                83 |           -1 |
|       14 |        2 |            3 |        2|        7|         9 |           10 |                 43 |               100 |           35 |
|       15 |        2 |            3 |        3|        5|         8 |            9 |                 44 |               100 |           13 |
|       16 |        7 |            4 |        2|        8|        24 |           15 |                 49 |               100 |           37 |
|       17 |        0 |            1 |       17|        1|         0 |            1 |                 38 |                87 |           -1 |
|       18 |        5 |            5 |        2|        9|        23 |           21 |                 47 |               100 |           38 |
|       19 |        0 |            1 |       19|        1|         0 |            1 |                 42 |                88 |           -1 |
|       20 |        5 |            5 |        2|       10|        23 |           22 |                 51 |               100 |           40 |
|       21 |        2 |            3 |        3|        7|        10 |           11 |                 45 |               100 |           19 |
|       22 |        2 |            3 |        2|       11|        13 |           14 |                 43 |               100 |           40 |
|       23 |        0 |            1 |       23|        1|         0 |            1 |                 42 |                90 |           -1 |
|       24 |        8 |            7 |        2|       12|        39 |           36 |                 55 |               100 |           41 |
|       25 |        2 |            2 |        5|        5|        10 |            6 |                 45 |               100 |            0 |
|       26 |        2 |            3 |        2|       13|        15 |           16 |                 45 |               100 |           42 |
|       27 |        4 |            3 |        3|        9|        18 |           13 |                 44 |               100 |           22 |
|       28 |        5 |            5 |        2|       14|        29 |           28 |                 49 |               100 |           42 |
|       29 |        0 |            1 |       29|        1|         0 |            1 |                 45 |                92 |           -1 |
|       30 |        6 |            7 |        2|       15|        41 |           42 |                 52 |               100 |           43 |
|       31 |        0 |            1 |       31|        1|         0 |            1 |                 45 |                93 |           -1 |
|       32 |        9 |            5 |        2|       16|        42 |           31 |                 48 |               100 |           43 |
|       33 |        2 |            3 |        3|       11|        14 |           15 |                 45 |               100 |           24 |
|       34 |        2 |            3 |        2|       17|        19 |           20 |                 47 |               100 |           44 |
|       35 |        2 |            3 |        5|        7|        12 |           13 |                 48 |               100 |            5 |
|       36 |       10 |            8 |        2|       18|        65 |           55 |                 54 |               100 |           44 |
|       37 |        0 |            1 |       37|        1|         0 |            1 |                 45 |                94 |           -1 |
|       38 |        2 |            3 |        2|       19|        21 |           22 |                 45 |               100 |           44 |
|       39 |        2 |            3 |        3|       13|        16 |           17 |                 46 |               100 |           25 |
|       40 |        8 |            7 |        2|       20|        53 |           50 |                 51 |               100 |           45 |
|       41 |        0 |            1 |       41|        1|         0 |            1 |                 47 |                95 |           -1 |
|       42 |        6 |            7 |        2|       21|        53 |           54 |                 51 |               100 |           45 |
|       43 |        0 |            1 |       43|        1|         0 |            1 |                 46 |                95 |           -1 |
|       44 |        5 |            5 |        2|       22|        41 |           40 |                 49 |               100 |           45 |
|       45 |        5 |            5 |        3|       15|        35 |           33 |                 47 |               100 |           26 |
|       46 |        2 |            3 |        2|       23|        25 |           26 |                 47 |               100 |           45 |
|       47 |        0 |            1 |       47|        1|         0 |            1 |                 47 |                95 |           -1 |
|       48 |       12 |            9 |        2|       24|        85 |           76 |                 53 |               100 |           45 |
|       49 |        2 |            2 |        7|        7|        14 |            8 |                 48 |               100 |            0 |
|       50 |        5 |            5 |        2|       25|        47 |           43 |                 49 |               100 |           46 |

Now we may start working with the [data](data.md), let's for example notice we can make a nice [tree](tree.md) of the numbers by assigning each number as its parent its greatest divisor:

```
                                     1
                                     |
 .----.-----------.------------.-----'--.-----.---.--.--.--.--.--.--.--.--.
 |    |           |            |        |     |   |  |  |  |  |  |  |  |  |
 2    3           5            7       11    13  17 19 23 29 31 37 41 43 47  <--- primes
 |    |           |            |        |     |   |  |  |
 |  .-'--.   .----+----. .---.-'-.--. .-'-. .-'-. |  |  |
 |  |    |   |    |    | |   |   |  | |   | |   | |  |  |
 4  6    9   10   15  25 14  21 35 49 22 33 26 39 34 38 46
 |  |    |   |    |    | |   |        |
 |  |  .-'-. |  .-'-.  | |   |        |
 |  |  |   | |  |   |  | |   |        |
 8  12 18 27 20 30 45 50 28  42       44
 |  |  |     |
 16 24 36    40
 |  |
 32 48
```

Here patterns start to show, for example the level one of the tree are all prime numbers. Also in this tree we can nicely find the [greatest common divisor](gcd.md) of two numbers as their closest common ancestor. Also if we go from low numbers to high numbers (1, 2, 3, ...) we see we go kind of in a zig-zag direction around the bottom-right diagonal -- what if we make a program that plots this path? Will we see something [interesting](interesting.md)? We could use this tree to encode numbers in an alternative way too, by indicating path to the number, for example *45 = {2,1,1}*. Would this be good for anything? Would such a representation facilitate some operations? You can just keep diving down rabbit holes like this.

## Numbers In Math

There are countless different types of numbers, in mathematics we classify them into [sets](set.md) (and if we additionally consider operations with numbers too, we also sort them into algebras and structures such as [groups](group.md), [fields](field.md) or [rings](ring.md)). Although we can talk about finite sets of numbers perfectly well (e.g. [modulo](mod.md) arithmetic, [Boolean algebra](boolean_algebra.md) etc.), we are often examining and using [infinite](infinity.md) sets (curiously some of these infinite sets can still be considered "bigger" than other infinite sets, e.g. by certain logic there is more real numbers than rational numbers, i.e. "fractions"). Some of these sets are subsets of others, some overlap and so forth. Here are some notable number sets (note that a list can potentially not capture all relationships between the sets):

- **all**: Anything conceivable as a number, even by stretch. E.g. [zero](zero.md), minus [infinity](infinity.md) or aleph one.
  - **[unknowable](knowability.md)**: Cannot be known for some reason, e.g. being non-computable or requiring more energy for their computation than will ever be present in our [Universe](universe.md).
    - **[noncomputable](computability.md)**: Cannot be computed, i.e. any such number has no [Turing machine](turing_machine.md) which when passed *N* on input would output *N*th digit of the number in finite time. E.g. Chaitin's constant (probability that a randomly generated program will halt).
  - **[transfinite (infinite) numbers](transfinite_number.md)**: Numbers that are in a sense "infinite", used to compare objects that are infinite in size (e.g. number sets themselves). E.g. omega, beth two or aleph one. 
  - **[surreal numbers](surreal_number.md)**, **\*R: hyperreal numbers**, **superreal numbers**, ...: Various extensions of real numbers, include also infinitesimals and some transfinite numbers.
    - **[infinitesimals](infinitesimal.md)**: Are closer to zero than any real number without actually being zero, i.e. "infinitely small" numbers, play big role in [calculus](calculus.md). E.g. 0.000...1 (with infinitely many 0 digits before the 1).
  - **Qp: [p-adic numbers](p_adic_number.md)**: Alternative way of generalizing rational numbers; p-adics are quite mindblowing as they may have infinitely many digits to the left side (for which they are sometimes called *leftist numbers*), there are numbers that are their own squares without either being 1 or 0, they also contain negative numbers and fractions without having to add extra symbols. There are different kinds of p-adic number sets for different *p*s, e.g. 10-adic, 3-adic and so on (prime number *p*s are chosen for good properties). E.g. (10-adic) ...333.33, ...87187, ...11112 etc.
  - **H: [quaternions](quaternion.md)**: A sum of real number, imaginary number and two other kinds of numbers, forming a number in four dimensional space. E.g. 1 + i + j - k, 50 - 0.6k or 2i + 7j.
    - **C: [complex](complex_number.md)**: A sum of real and imaginary number, forming a number in two dimensional plane. E.g. 3 + 2i, 0.5 - 13i or 100i.
      - **complex integers**: Complex numbers with both real and imaginary component being integer. E.g. 13 - 2i, 44i or 0.
      - **[algebraic](algebraic_number.md)**: Are roots of one variable [polynomials](polynomial.md) with integer coefficients. E.g. 4/3, the [golden ratio](golden_ratio.md) or square root of two.
      - **[transcendental](transcendental_number.md)**: Aren't algebraic. E.g. [pi](pi.md), [sine](sin.md) of [e](e.md) or two to the power of square root of two.
      - **[imaginary](imaginary_number.md)**: Are similar to real numbers but lie in another dimension, on a line perpendicular to the real number line, going through 0 -- they are connected to real numbers by the fact that imaginary unit ([i](i.md)) squared equals minus one. E.g. 0, 3i or -i.
      - **R: [real](real_number.md)**: Measure any continuous one dimensional quantity (such as height or length), the line they form is continuous. E.g. -0.3, [pi](pi.md) or cube root of 10000.
        - **negative**: Smaller than zero. E.g. -1, -123 or -1000.
        - **R0+: non-negative**: Aren't negative. E.g. 0, 1 or 1000.
        - **R+: positive**: Greater than zero. E.g. 1, 456 or 1000.
        - **irrational**: Aren't rational. E.g. [pi](pi.md), minus [e](e.md) or square root of 2.
        - **Q: [rational](rational_number.md)**: "Fractions", countable set, can be written as a fraction of two integers; between any two there is always another one, so they are very densely "packed", though the line they form is not truly continuous. E.g. -2/3, 0.12345 or 2135.
          - **Z: [whole (integers)](integer.md)**: Are [discrete](discrete.md), starting at zero, extending in positive and negative direction, all neighbors are spaced by the same distance of one unit. E.g. -5123, 32 or 0.
            - **even**: Are divisible by 2. E.g. -8, 0 or 1024.
            - **odd**: Aren't even. E.g. 1, -13 or 1023.
            - **N0: [natural](natural_number.md) (with zero)**:   E.g. 0, 16 or 1000.
              - **[Fibonacci](fibonacci.md)**: Are part of a sequence that starts with 0 and 1 and continues with numbers each of which is the sum of previous two. E.g. 0, 3 or 89.
              - **[modulo](mod.md) numbers**: Finite sets of numbers up to some *N* which are allowed to "[overflow](overflow.md)", basic operations like subtraction and multiplication are still well defined. Numbers in computer mostly behave this way. E.g. numbers modulo 5 are 0, 1, 2, 3 and 4.
              - **N: natural (without zero)**: "Caveman numbers", the kind of numbers people started to use first. E.g. 1, 10 or 945.
                - **[prime](prime.md)**: Are only divisible by 1 and themselves, excluding 1. E.g. 2, 7 or 809.
                - **composite**: Aren't primes, excluding 1. For example 4, 22 or 150.
                  - **highly composite**: Composite numbers that have more divisors than any lower number. E.g. 4, 36 or 1260.
                  - **[perfect](perfect_number.md)**: Equal to the sum of its divisors. E.g. 6, 28 or 8128.

One of the most [interesting](interesting.md) and mysterious number sets are the [prime numbers](prime.md), in fact many number theorists dedicate their whole careers solely to them. Primes are the kind of thing that's defined very simply but give rise to a whole universe of mysteries and whys, there are patterns that seem impossible to describe, conjectures that look impossible to prove and so on. Another similar type of numbers are the [perfect numbers](perfect_number.md).

Of course there are countless other number sets, especially those induced by various number sequences and functions of which there are whole [encyclopedias](encyclopedia.md). Another possible division is e.g. to *cardinal* and *ordinal* numbers: ordinal numbers tell the order while cardinals say the size (cardinality) of a set -- when dealing with finite sets the distinction doesn't really have to be made, within natural numbers the order of a number is equal to the size of a set of all numbers up to that number, but with infinite sets this starts to matter -- for example we couldn't tell the size of the set of natural numbers by ordinals as there is no last natural number, but we can assign the set a cardinal number (aleph zero) -- this gives rise to new kind of numbers.

Worthy of mentioning is also [linear algebra](linear_algebra.md) which treats [vectors](vector.md) and [matrices](matrix.md) like elementary algebra treats numbers -- though vectors and matrices aren't usually seen as numbers, they may be seen as an extension of the concept.

**Numbers are [awesome](awesome.md)**, just ask any number theorist (or watch a numberphile video for that matter). Normal people perceive numbers just as boring, soulless quantities but the opposite is true for that who studies them with [love](love.md) -- the world of numbers is without a doubt staggeringly beautiful, their study runs to depths without end, possibly as far as humans can ever hope to get a glimpse of the mechanisms behind the curtains of our [Universe](universe.md), and oftentimes once you pay a closer attention to a seemingly innocently looking detail, you reveal a breathtaking pattern and discover the [art](art.md) of nature. Each number has its own unique set of properties which give it a kind of "personality", different sets of numbers create species and "teams" of numbers. Numbers are intertwined in intricate ways, there are literally infinitely many patterns that are all related in weird ways -- normies think that mathematicians know basically everything about numbers, but in higher math it's the exact opposite, most things about number sequences are mysterious and mathematicians don't even have any clue about why they're so, many things are probably even [unknowable](knowability.md). Numbers are also self referencing which leads to new and new patterns appearing without end -- for example prime numbers are interesting numbers, but you may start counting them and a number that counts numbers is itself a number, you are getting new numbers just by looking at other numbers. The world of numbers is like a whole universe you can explore just in your head, anywhere you go, it's almost like the best, most free video [game](game.md) of all time, embedded right in this [Universe](universe.md), in [logic](logic.md) itself. Numbers are like animals, some are small, some big, some are hardly visible, trying to hide, some can't be overlooked -- they inhabit various areas and interact with each other, just exploring this can make you quite happy. { Pokemon-like game with numbers when? ~drummyfish }

There is a famous [encyclopedia](encyclopedia.md) of integer sequences at https://oeis.org/, made by number theorists -- it's quite [minimalist](minimalism.md), now also [free licensed](free_culture.md) (used to be [proprietary](proprietary.md), they seem to enjoy license hopping). At the moment it contains more than 370000 sequences; by browsing it you can get a glimpse of how deep the study of numbers goes. These people are also somewhat [funny](fun.md), they give numbers entertaining names like *happy numbers* (adding its squared digits eventually gives 1), *polite numbers*, *friendly numbers*, *cake numbers*, *lucky numbers* or *weird numbers*.

**Some numbers cannot be computed**, i.e. there exist [noncomputable](computability.md) numbers. This follows from the existence of noncomputable functions (such as that representing the [halting problem](halting_problem.md)). For example let's say we have a real number *x*, written in [binary](binary.md) as *0. d0 d1 d2 d3 ...*, where *dn* is *n*th digit (1 or 0) after the radix point. We can define the number so that *dn* is 1 if and only if a [Turing machine](turing_machine.md) represented by number *n* halts. Number *x* is noncomputable because to compute the digits to any arbitrary precision would require being able to solve the unsolvable halting problem.

**All [natural numbers](natural_number.md) are [interesting](interesting.md)**: there is a [fun](fun.md) [proof](proof.md) by contradiction of this. Suppose there exists a set of uninteresting numbers which is a subset of natural numbers; then the smallest of these numbers is interesting by being the smallest uninteresting number -- we've arrived at contradiction, therefore a set of uninteresting numbers cannot exist.

TODO: what is the best number? maybe top 10? would 10 be in top 10? what's the first number that's in top itself?

## Numbers In Programming/Computers

While mathematicians work mostly with infinite number sets and all kinds of "weird" hypothetical numbers like hyperreals and transcendentals, [programmers](programming.md) still typically deal with "normal" numbers pertaining to practical applications, and have to limit themselves to finite number sets because, of course, computers have limited memory and can only store limited number of numeric values -- computers typically work with [modulo](mod.md) arithmetic with some high power of two, e.g. 2^32 or 2^64, which is a [good enough](good_enough.md) [approximation](approximation.md) of an infinite number set. Mathematicians are as precise with numbers as possible as they're interested in structures and patterns that numbers form, programmers just want to use numbers to solve problems, so they mostly use [approximations](approximation.md) where they can -- for example programmers normally approximate [real numbers](real_number.md) with [floating point](float.md) numbers that are really just a subset of rational numbers. This isn't really a problem though, computers can comfortably work with numbers large and precise enough for solving any practical problem -- a slight annoyance is that one has to be careful about such things as [underflows](underflow.md) and [overflows](overflow.md) (i.e. a value wrapping around from lowest to highest value and vice versa), limited and sometimes non-uniform precision resulting in [error](error.md) accumulation, unlinearization of linear systems and so on. Programmers also don't care about strictly respecting some properties that certain number sets must mathematically have, for example integers along with addition are mathematically a [group](group.md), however signed integers in [two's complement](twos_complement.md) aren't a group because the lowest value doesn't have an inverse element (e.g. on 8 bits the lowest value is -128 and highest 127, the lowest value is missing its partner). Programmers also allow "special" values to be parts of their number sets, especially e.g. with the common IEEE [floating point](float.md) types we see values like plus/minus [infinity](infinity.md), [negative zero](negative_zero.md) or [NaN](nan.md) ("not a number") which also break some mathematical properties and creates situations like having a number that says it's not a number, but again this really doesn't play much of a role in practical problems. Numbers in computers are represented in [binary](binary.md) and programmers themselves often prefer to write numbers in binary, hexadecimal or octal representation -- they also often meet powers of two rather than powers of ten or primes or other similar limits (for example the data type limits are typically limited by some power of two). There also comes up the question of specific number encoding, for example direct representation, sign-magnitude, [two's complement](twos_complement.md), [endianness](byte_sex.md) and so on. Famously programmers start counting from 0 (they go as far as using the term "zeroth") while mathematicians rather tend to start at 1. Just as mathematicians have different sets of numbers, programmers have an analogy in numeric [data types](data_type.md) -- a data type defines a set of values and operations that can be performed with them. The following are some of the common data types and representations of numbers in computers:

- **numeric**: Anything considered a number. In very high level languages there may be just one generic "number" type capable of storing any kind of number, automatically choosing the best representation behind the scenes, dynamically allocating memory as it changes size etc.
  - **[unsigned](unsigned.md)**: Don't allow negative values -- this is sufficient in many situations, more straightforward to implement and can reach higher values in the positive direction.
  - **[signed](signed.md)**: Permit both positive and negative values which brings up the question of what representation to choose -- for integers the most common one nowadays is [two's complement](twos_complement.md).
  - **fixed size**: Most common, each number takes some fixed size in memory, expressed in [bits](bit.md) or [bytes](byte.md) -- this naturally determines the maximum number of possible values and thus also the minimum and maximum representable number. Going beyond or below the range typically results in an [overflow](overflow.md).
    - **8bit**: Can store 256 value (e.g. integers from 0 to 255 or -128 to 127).
    - **16bit**: Can store 65536 values.
    - **32bit**: Can store 4294967296 values.
    - ...
  - **[arbitrary size](arbitrary_size_int.md)**: Can store arbitrarily high/low and/or precise value, take variable amount of memory depending on how much is needed, used only in very specialized cases when absurdly high numbers may appear, may be considerably slower due to the overhead and lack of direct hardware support for extremely large numbers.
  - **[integer](int.md)**: Integer values, most common, usually using direct or [two's complement](twos_complement.md) representation.
  - **fractional**: Have higher precision than integers, allow storing fractions, are often used to [approximate](approximation.md) real numbers.
    - **[fixed point](fixed_point.md)**: Are represented by a number with radix point in fixed place, have uniform precision.
    - **[floating point](float.md)**: Have movable radix point which is more [complicated](bloat.md) but allows for representing both very high and very small values due to non-uniform precision. Here again it's also important to choose the right representation, most notable ones include for IEEE 754 and [posits](posit.md). 
    - ...
  - **[complex](complex_number.md)**: Analogous to mathematical complex numbers.
  - **[quaternion](quaternion.md)**: Analogous to mathematical quaternions.
  - **symbolic**: Used in some specialized mathematical software to perform symbolic computation, i.e. computation done in a human-like way, by manipulating symbols without using concrete values that would have to resort to approximation.
  - ...

However some programming languages, such as [Lisp](lisp.md), sometimes treat numbers in very abstract, more mathematical ways (for the price of some performance loss and added [complexity](bloat.md)) such as exactly handling rational numbers with arbitrary precision, distinguishing between exact and inexact numbers etc. The question of number representation is an important one. Though most commonly we meet direct representation, two's complement, floating and fixed point representations, many more alternatives exist that may facilitate storing or manipulation of the values we are to work with. Among these alternatives are for example fractions (numerator and denominator), p-adics, RNS (number stored as its modulo against a fixed set of relatively prime numbers), [BCD](bcd.md) (binary coded decimal digits), factorial base number system and many others.

## Notable Numbers

*See also https://mrob.com/pub/math/numbers.html.*

Here is a table of some numbers and "number like objects" worthy of mention, mostly relevant in math and programming but also some famous ones from [physics](physics.md) and popular [culture](culture.md) (note: the order is roughly from lower numbers to higher ones, however not all of these numbers can be compared easily or at all, so the ordering isn't strictly correct; notes: *&* means base 8, *b3* means base 3).

| number                              | value                | equal to, AKA                            |                    notes                                |
| ----------------------------------- | -------------------- | ---------------------------------------- | ------------------------------------------------------- |
| not a number (NaN, undefined, ...)  | none                 | 1/0, 0^0, tan(pi/2)                      | error value                                             |
| minus [infinity](infinity.md)       |                      |                                          | not always considered a number, smallest possible value |
|                                     | -9223372036854776000 | -1 * 2^64 / 2                            | minimum two's complement signed 64 bit number           |
|                                     | -2147483648          | -1 * 2^32 / 2                            | minimum two's complement signed 32 bit number           |
| minus thirty two thousand seven ... | -32768               | -1 * 2^16 / 2                            | minimum two's complement signed 16 bit number           |
| minus one hundred twenty eight      | -128                 | -1 * 2^7                                 | minimum value of signed byte (two's complement)         |
| minus/negative one                  | -1                   | i^2, j^2, k^2                            |                                                         |
| minus one twelfth                   | -0.08333...          | -1/12                                    | infamous, by some methods the result of 1 + 2 + 3 + ... |
|                                     | -3.402823... * 10^38 |                                          | smallest number storable in IEEE-754 32 bit float       |
|                                     | -1.797693... * 10^308|                                          | smallest number storable in IEEE-754 64 bit float       |
| "[negative zero](negative_zero.md)" | "-0"                 | 0                                        | non-mathematical, sometimes used in programming         |
| [zero](zero.md) (none, nil)         | 0                    | "-0", e^(i * pi) + 1, lim x->inf 1/x     | "nothing", additive identity                            |
| epsilon                             |                      | 1 / omega                                | infinitesimal, "infinitely small" non-zero              |
|                                     | 4.940656... * 10^-324|                                          | smallest pos. number storable in IEEE-754 64 bit float  |
|                                     | 1.401298... * 10^-45 |                                          | smallest pos. number storable in IEEE-754 32 bit float  |
|                                     | 1.616255... * 10^-35 |                                          | Planck length in meters, smallest "length" in Universe  |
| one hundredth                       | 0.01                 | 1/100, 1%, 0b0.000000101000111101...     |                                                         |
|                                     | 0.065988...          | 1/(e^e)                                  | lowest x such that x^x^x^... is bounded (by 1/e)        |
|                                     | 0.071111111111111... | 0x0.123456789abcdef101...                | base 16 Champernowne constant                           |
| one tenth                           | 0.1                  | 1/10, 10%, 0b0.000110011001100111...     |                                                         |
|                                     | 0.123456789101112... | 0b0.000111111001101011...                | base 10 Champernowne constant, normal number            |
| one eight                           | 0.125                | 2^-3, 0b0.001, 0x0.2                     |                                                         |
|                                     | 0.163264812105216... | &0.1234567101112131415...                | base 8 Champernowne constant                            |
|                                     | 0.207879...          | i^i, e^(-pi/2)                           |                                                         |
| one fourth                          | 0.25                 | 25%, 2^-2, 1 - 2 + 3 - ..., 0b0.01, 0x0.4|                                                         |
| one over pi                         | 0.318309...          | 1/pi, pi^-1                              |                                                         |
| one third                           | 0.333333...          | 3^-1, ...1313132 (5adic), 1 - 2 + 4 - ...|                                                         |
| one over e                          | 0.367879...          | 1/e                                      | optimal solution to the "secretary problem"             |
| Thue-Morse constant                 | 0.412454...          | 0b0.011010011001011010...                | keep appending negated binary strings (start with 0)    |
| prime constant                      | 0.414682...          | 0b0.011010100010100010...                | binary number that encodes primes in fractional digits  |
| one half                            | 0.5                  | 50%, 2^-1, 0b0.1, 0x0.8                  |                                                         |
| Euler's constant (gamma)            | 0.577215...          | 1 + 1/2 + 1/3 + 1/n ... - log(n)         | some kinda deep and important constant `O_O`            |
|                                     | 0.598958...          | base3(0.121011122021221001...)           | base 3 Champernowne constant                            |
| one over square root of two         | 0.707106...          | 1/sqrt(2), sin(pi/4), cos(pi/4), 2^(-1/2)|                                                         |
|                                     | 0.862240124493837... | 0b0.110111001011101111...                | base 2 Champernowne constant                            |
| [one](one.md)                       | 1                    |2^0, 0!, 0.999..., sqrt(1), I, 0b1, cos(0)| NOT a prime, unit, multiplicative identity              |
|                                     | 1.261859...          | ln(4)/ln(3)                              | Hausdorff dimension of Koch snowflake fractal           |
| [square root](sqrt.md) of two       | 1.414213...          | sqrt(2), 2^(1/2), 0b1.0110101            | irrational, diagonal of unit square, important in geom. |
| ten over seven                      | 1.428571...          | 10/7                                     | common approximation of sqrt(2)                         |
| supergolden ratio                   | 1.465571...          | solve(x^3 - x^2 - 1 = 0)                 | similar to golden ratio, bit more difficult to compute  |
|                                     | 1.584962...          | log(3)/log(2)                            | Hausdorff dimensions of Sierpinski triangle fractal     |
|phi ([golden ratio](golden_ratio.md))| 1.618033...          | (1 + sqrt(5)) / 2, solve(x^2 - x - 1 = 0)| irrational, visually pleasant ratio, divine proportion  |
| square root of three                | 1.732050...          | sqrt(3), 3^(1/2), 0b1.1011101            | irrational                                              |
| square root of pi                   | 1.772453...          | sqrt(pi)                                 |                                                         |
| [two](two.md) (couple, pair)        | 2                    | 2^1, 2!, 2!!, 0b000010, II, 0b10         | (only even) prime, base of [binary](binary.md) system   |
| [silver ratio](silver_ratio.md)     | 2.414213...          | 1 + sqrt(2), solve(x^2 - 2 * x - 1 = 0)  | similar to golden ratio                                 |
| nineteen over seven                 | 2.714285...          | 19/7                                     | common approximation of e                               |
| [e](e.md) (Euler's number)          | 2.718281...          | 0b10.1011011                             | base of natural [logarithm](log.md)                     |
| [three](three.md)                   | 3                    | 2^2 - 1, III, Ob11, 2^1.584...           | prime, max. number on 2 bits, regular plane tilings     |
| [pi](pi.md)                         | 3.141592...          | 2 * asin(1), 0b11.0010010                | circle circumference to its diameter, irrational        |
| twenty two over seven               | 3.142857...          | 22/7                                     | common approximation of pi                              |
| square root of ten                  | 3.162277...          | sqrt(10)                                 | approximation of pi                                     |
| [four](four.md)                     | 4                    | 2^2, 0b000100, IV, 0b100                 |first composite number, min. needed to color planar graph|
| Feigenbaum constant                 | 4.669201...          |                                          | related to [chaotic](chaos.md) systems                  |
| [five](five.md)                     | 5                    | 3^2 - 2^2, V, 0b101, fib(5)              | (twin, triplet, super) prime, num. of plat. solids, Fib.|
| [six](six.md) (half dozen)          | 6                    | 3!, 1 * 2 * 3, 1 + 2 + 3, VI, 0b110      | highly composite number, 1st perfect number, semiprime  |
| [tau](tau.md)                       | 6.283185...          | 2 * pi, 360 degrees                      | radians in full circle, defined mostly for convenience  |
| [thrembo](thrembo.md)               | ???                  |                                          | the hidden number                                       |
| [seven](seven.md)                   | 7                    | 2^3 - 1, VII, &7, 0b111                  |(twin) prime, days in week, max. unsigned n. with 3 bits |
| [eight](eight.md)                   | 8                    | 2^3, 0b001000, VIII, &10, 0b1000, fib(6) | base of [octal](oct.md) system, 7th Fibonacci number    |
|                                     | 8.539734...          | pi * e                                   |                                                         |
| [nine](nine.md)                     | 9                    | 3^2, 1^3 + 2^3, sqrt(81), IX, 0b1001     | semiprime                                               |
| pi squared                          | 9.869604...          | pi^2                                     |                                                         |
| [ten](ten.md)                       | 10                   |10^1, 1 + 2 + 3 + 4, X, 0b1010, 2^3.321...| your IQ? :D base of our decimal system, semiprime       |
| eleven                              | 11                   | 0xb, b3(102), &13, 0b1011, XI            | palindromic twin&super(4) prime                         |
| twelve (dozen)                      | 12                   | 2 * 2 * 3, 0xc, 0b1100, XII              | highly composite number                                 |
| thirteen (long or devil's dozen)    | 13                   | fib(7), trib(7), 0xd, 0b1101, XIII       | prime considered unlucky (in west and China), Fib. num. |
| fourteen                            | 14                   | &112, 0b1110, 0xe, XIV                   | semiprime                                               |
| fifteen                             | 15                   | 2^4 - 1, 0b1111, 0xf, 1 + 2 + 3 + 4 + 5  | maximum unsigned number storable with 4 bits            |
| [sixteen](sixteen.md)               | 16                   | 2^4, 4^2, 2^2^2, 0b010000, &20, 0x10, XVI| base of [hexadecimal](hex.md) system                    |
| seventeen                           | 17                   | 0b10001, &21, 0x11, XVII                 | twin&sexy&super(2) prime, binary palindrome             |
| eighteen                            | 18                   | 0b10010, &22, 0x12, XVIII                |                                                         |
| nineteen                            | 19                   | 0b10011, &23, 0x13, XIX                  | twin&sexy prime                                         |
| twenty                              | 20                   | 0b10100, &24, 0x14, XX, score            | largest number of faces for a Platonic solid            |
| twenty one                          | 21                   | 0b10101, 0x15, BB(3), fib(8), 0x15, XXI  | maximum number of 1s produced by 3 state Turing Machine |
| twenty three                        | 23                   | 0b10111, &27, 0x17, XXIII                | sexy prime                                              |
| twenty four                         | 24                   | 2 * 2 * 2 * 3, 4!, trib(8), 0x18, XXIV   |highly composite number, possible ways to order 4 objects|
| twenty five                         | 25                   | 5^2, sqrt(625), 0x19, XXV                |                                                         |
| twenty seven                        | 27                   | 3^3, 0b11011, 0x1b, &33, 0x1b, XXVII     | palindrome in base 2 and 8                              |
| twenty eight                        | 28                   | 0b11100, 0x1c, XXVIII                    | 2nd perfect number                                      |
| twenty nine                         | 29                   | 0b11101, &1002, 0x1d, XXIX               | twin&sexy prime                                         |
| thirty                              | 30                   | 0b11110, &1010, 0x1e, XXX                |                                                         |
| thirty one                          | 31                   | 2^5 - 1, 0b11111, &37, 0x1f, XXXI        |max. unsigned number storable with 5 bits, Mersenne prime|
| [thirty two](thirty_two.md)         | 32                   | 2^5, 0b100000, &40, 0x20, XXXII          | number of possible values storable with 5 bits          |
| thirty three                        | 33                   | 1! + 2! + 3! + 4!, XXXIII                |                                                         |
| thirty four                         | 34                   | fib(9), 0x22, XXXIV                      | Fibonacci number                                        |
| thirty six                          | 36                   | 2 * 2 * 3 * 3, XXXVI                     | highly composite number                                 |
| thirty seven                        | 37                   | 0b100101, 0x25, XXXVII                   | most commonly picked 1 to 100 "random", permutable prime|
| forty                               | 40                   | 0b101000, 0x28, XL                       |                                                         |
| forty one                           | 41                   | 0b101001, 0x29, XLI                      | twin&sexy prime                                         |
| [forty two](42.md)                  | 42                   | XLII                                     | cringe number, answer to some stuff, unlucky in Japan   |
| forty three                         | 43                   | 0b101011, 0x2b, XLIII                    | twin&sexy prime, 4th Sylvester's number                 |
| forty four                          | 44                   | trib(9), 0b101100, 0x2c, XLIV            | Tribonacci number                                       |
| forty seven                         | 47                   | 0b101111, 0x2f, XLVII                    | sexy prime                                              |
| forty eight                         | 48                   |2^5 + 2^4, 2 * 2 * 2 * 2 * 3, XLVIII, 0x30| highly composite number                                 |
| forty nine                          | 49                   | 7^2, XLIX                                |                                                         |
| fifty                               | 50                   | 0x32, L                                  |                                                         |
| fifty three                         | 53                   | 0b110101, 0x35, LIII                     | sexy prime                                              |
| fifty five                          | 55                   | fib(10), 1 + 2 + ... + 10, LV            | sum of numbers up to 10, 11th Fibonacci number          |
| fifty nine                          | 59                   | 0b111011, 0x3b, LIX                      | twin&sexy&super(3) prime                                |
| sixty                               | 60                   | 2^2 * 3 * 5, 0x3c, LX, threescore        | (super.) highly composite number, used in time measuring|
| sixty one                           | 61                   | 0x3d, LXI                                | twin&sexy prime                                         |
| sixty three                         | 63                   | 2^6 - 1, 0b111111, &77, 0x3f, LXIII      | maximum unsigned number storable with 6 bits            |
| [sixty four](sixty_four.md)         | 64                   | 2^6, 0b1000000, &100, 0x40, LXIV         | number of squares on a chess board                      |
| sixty seven                         | 67                   | 0x43, LXVII                              | sexy&super(2) prime                                     |
| [sixty nine](69.md)                 | 69                   | 0x45, LXIX                               | sexual position                                         |
| seventy                             | 70                   | 0x46, LXX                                |                                                         |
| seventy one                         | 71                   | 0x47, LXXI                               | twin prime                                              |
| seventy three                       | 73                   | 0b1001001, 0x49, LXXIII                  | twin&sexy prime, binary palindrome                      |
| seventy five                        | 75                   | 0x5b, LXXV                               |                                                         |
| seventy nine                        | 79                   | 0x4f, LXXIX                              | sexy prime                                              |
| eighty                              | 80                   | 0x50, LXXX                               |                                                         |
| eighty one                          | 81                   | trib(10), 3^4, 9^2, XXCI                 | Tribonacci number                                       |
| eighty three                        | 83                   | LXXXIII                                  | sexy&super(2) prime                                     |
| eighty eight                        | 88                   | 0x58, LXXXVIII                           | number of essentially different cellular automata       |
| eighty nine                         | 89                   | fib(11), 0x59, LXXXIX                    | Fibonacci number, sexy prime                            |
| ninety                              | 90                   | 0x5a, XC                                 |                                                         |
| ninety six                          | 96                   | 2^5 + 2^6, 5! - 4!, 0x60, XCVI           | alternative sexual position                             |
| ninety seven                        | 97                   | XCVII                                    | sexy prime                                              |
| ninety nine                         | 99                   | 10^2 - 1, 0b1100011                      | palindrome in base 2 and 10                             |
| one hundred                         | 100                  | 10^2, 0x64, C, 2^6.643...                |                                                         |
| one hundred seven                   | 107                  | BB(4), CVII                              | maximum number of 1s produced by 4 state Turing machine |
| one hundred eight                   | 108                  | 0x6c, CVIII, 1 * 2^2 * 3^3, hyperfact(3) |                                                         |
| one hundred twenty                  | 120                  | 2^3 * 3 * 5, 5!, C(10,3), CXX            | possible ways to order 5 objects, highly composite      |
| one hundred twenty one              | 121                  | 11^2, CXXI                               | [palindromic](palindrome.md), semiprime                 |
| one hundred twenty five             | 125                  | 5^3, CXXV                                |                                                         |
| one hundred twenty seven            | 127                  | 2^7 - 1, 0b01111111, &177, 0x7f, CXXVII  |maximum value of signed byte, 4th Mersenne&super(6) prime|
| one hundred twenty eight            | 128                  | 2^7, 0x80, &200, CXXVIII, 10^2.107...    | number of values storable with 7 bits                   |
| one hundred forty four (gross)      | 144                  | 12^2, fib(12), CXLIV                     | 13th Fibonacci number, 12 dozen                         |
| one hundred fifty                   | 150                  | 0x96, CL                                 |                                                         |
| one hundred sixty eight             | 168                  | 24 * 7, CLXVIII                          | hours in week                                           |
| one hundred eighty                  | 180                  | 2^2 * 3^2 * 5, 0xb4, CLXXX               | highly composite, degrees in half of full angle         |
| two hundred                         | 200                  | 0xc8, CC                                 |                                                         |
| twi hundred forty                   | 240                  | 0xf0, CCXL                               | highly composite                                        |
| two hundred forty three             | 243                  | 3^5, 0xf3, CCXLIII                       |                                                         |
| two hundred fifty five              | 255                  | 2^8 - 1, 0b11111111, &377, 0xff, CCLV    |maximum value of unsigned [byte](byte.md), hex palindrome|
| two hundred fifty six               | 256                  | 2^8, 4^4, 16^2, 0x100, ((2^2)^2)^2, CCLVI| number of values that can be stored in one byte         |
| two hundred eighty eight            | 288                  | 0x120, CCLXXXVIII, 1^1 + 2^2 + 3^3 + 4^4 |                                                         |
| three hundred                       | 300                  | 0x12c, CCC                               |                                                         |
| three hundred forty three           | 343                  | 7^3, CCCXLIII                            | palindrome                                              |
| three hundred sixty                 | 360                  | 2 * 2 * 2 * 3 * 3 * 5, CCCLX             | highly composite number, degrees in full circle         |
| three hundred sixty five            | 365                  | 0x16d, CCCLXV                            | days in a year, binary palindrome                       |
| four hundred                        | 400                  | 0x190, CD                                |                                                         |
| four hundred twenty                 | 420                  | 0x1a4, CDXX                              | stoner shit (they smoke it at 4:20), divisible by 1 to 7|
| four hundred ninety six             | 496                  | 0x1f0, CDXCVI                            | 3rd perfect number                                      |
| five hundred                        | 500                  | 0x1f4, D                                 |                                                         |
| five hundred eleven                 | 511                  | 2^9 - 1, DXI                             | largest number storable with 9 bits                     |
| five hundred twelve                 | 512                  | 2^9, 2^(3^2), DXII                       | number of values storable with 9 bits                   |
| six hundred twenty five             | 625                  | 25^2, 5^4, DCXXV                         |                                                         |
| six hundred and sixty six           | 666                  | 0x29a, DCLXVI                            | number of the beast, palindromic                        |
| seven hundred nine                  | 709                  | 0x2c5, DCCIX                             | first super prime of order 7                            |
| seven hundred twenty                | 720                  | 2^4 * 3^2 * 5, 6!, 3!!, DCCXX            | possible ways to order 6 objects, highly composite      |
| seven hundred twenty nine           | 729                  | 3^6, (3^2)^3, DCCXXIX                    |                                                         |
| seven hundred fifty                 | 750                  | 0x2ee, DCCL                              |                                                         |
| shitload                            | ???                  | clusterfuck, a lot                       | expressed a bigger quantity                             |
| nine hundred ninety nine            | 999                  | 10^3 - 1, 0x3e7, CVXCIX                  | palindromic                                             |
| one thousand (grand)                | 1000                 | 1K, 10^3, M, 0x3e8, 2^9.965...           |                                                         |
| one thousand twenty three           | 1023                 | 2^10 - 1, &1777, 0x3ff, MXXIII           | largest number storable with 10 bits                    |
| one thousand twenty four            | 1024                 |2^10, 4^5, &2000, 0x400, MXXIV, 10^3.01...| number of values storable with 10 bits                  |
| one thousand three hundred ...      | 1337                 | 0x539, MCCCXXXVII                        | [leet](leet.md) number                                  |
| one thousand six hundred eighty     | 1680                 | 0x690, MDCLXXX                           | highly composite, often used as horizontal resolution   |
| one thousand seven hundred ...      | 1729                 | 0x6c1, MDCCXXIX                          | Ramanujan number, taxican number, part of math lore     |
| one thousand eight hundred ...      | 1807                 | 0x70f, MDCCCVII                          | 5th Sylvester's number                                  |
| one thousand eight hundred ...      | 1836.152673...       |                                          |proton to electron mass ratio, unitless, uncertainty err.|
| two thousand                        | 2000                 | 0x7d0, MM                                |                                                         |
| two thousand forty eight            | 2048                 | 2^11, 0x800, MMXLVIII                    | number of values storable with 11 bits                  |
|two thousand one hundred eighty seven| 2187                 | 3^7, 0x88b, MMCLXXXVII                   |                                                         |
| two thousand four hundred one       | 2401                 | 7^4, MMCDI                               |                                                         |
| three thousand one hundred ...      | 3125                 | 5^5, MMMCXXV                             |                                                         |
| three thousand nine hundred ...     | 3999                 | MMMCMXCIX                                | largest number that can be written with Roman numerals  |
| four thousand ninety five           | 4095                 | 2^12 - 1, &7777, 0xfff                   | maximum unsigned integer storable with 12 bits          |
| four thousand ninety six            | 4096                 | 2^12, 2^(3^4), &10000, 0x1000            | number of values storable with 12 bits                  |
| five thousand                       | 5000                 | 0x1388                                   |                                                         |
| five thousand forty                 | 5040                 | 7!, 1 * 2 * ... * 7                      | possible ways to order 7 objects                        |
| five thousand fifty                 | 5050                 | 1 + 2 + ... + 100                        | sum of numbers up to 100                                |
|five thousand three hundred eight one| 5381                 | 0x1505                                   | sexy, first super prime of order 8                      |
| six thousand five hundred sixty one | 6561                 | 3^8, 3^(2^3)                             |                                                         |
|six thousand seven hundred sixty five| 6765                 | fib(20), 0x1a6d                          | Fibonacci number                                        |
| seven thousand seven hundred ...    | 7734                 | 0x1e36                                   | on a calculator say "hello" (upside down)               |
| eight thousand one hundred ...      | 8128                 | 0x1fc0                                   | 4th perfect number                                      |
|eight thousand one hundred ninety one| 8191                 | 0x1fff, 2^13 - 1                         | 5th Mersenne prime                                      |
|eight thousand one hundred ninety two| 8192                 | 0x2000, 2^13                             | number of values storable with 13 bits                  |
| ten thousand (myriad)               | 10000                | 10^4, 100^2, 2^13.287...                 |                                                         |
| fifteen thousand six hundred ...    | 15625                | 5^6, 0x3d09                              |                                                         |
| sixteen thousand three hundred ...  | 16384                | 2^14, 0x4000                             | number of values storable with 14 bits                  |
| sixteen thousand eight hundred ...  | 16807                | 7^5, 0x41a7                              |                                                         |
| nineteen thousand six hundred ...   | 19683                | 3^9, 3^(3^3), 0x4ce3                     |                                                         |
|twenty seven thousand six hundred ...| 27648                | 1 * 2^2 * 3^3 * 4^4, hyperfact(4)        |                                                         |
|thirty two thousand seven hundred ...| 32767                | 2^16 / 2 - 1, 0x7fff                     | maximum two's complement signed 16 bit number           | 
|thirty two thousand seven hundred ...| 32768                | 2^15, 0x8000                             | number of values storable with 15 bits                  |
| forty thousand three hundred twenty | 40320                | 8!, 1 * 2 * ... * 8, 0x9d80              | possible ways to order 8 objects                        |
| ... (enough lol)                    | 52711                |                                          | twin prime, first super prime of order 9                |
|                                     | 59049                | 3^10, 0xe6a9                             |                                                         |
|                                     | 65504                |                                          | largest number storable in IEEE-754 16 bit float        |
|                                     | 65535                | 2^16 - 1, &177777, 0xffff                | maximum unsigned number storable with 16 bits           |
|                                     | 65536                |2^16, 256^2, &200000, 0x10000, 2^(2^(2^2))| number of values storable with 16 bits                  |
|                                     | 72078                |                                          | number of possible chess positions after 4 half moves   |
|                                     | 80085                |                                          | looks like BOOBS                                        |
|                                     | 86400                | 60 * 60 * 24                             | seconds in a day                                        |
| hundred thousand                    | 100000               | 10^5, 2^16.609...                        |                                                         |
|                                     | 131071               | 2^17 - 1                                 | 6th Mersenne prime                                      |
|                                     | 307200               | 640 * 480                                | number of pixels in god's resolution                    |
|                                     | 362880               | 9!, 1 * 2 * ... * 9                      | possible ways to order 9 objects                        |
|                                     | 500500               | 1 + 2 + ... + 1000                       | sum of numbers up to 1000                               |
|                                     | 648391               |                                          | first super prime of order 10                           |
| one [million](million.md)           | 1000000              | 1M, 10^6, 0xf4240, 2^19.931...           |                                                         |
|                                     | 3197281              |                                          | number of possible chess games after 4 half moves       |
|                                     | 3263443              |                                          | twin prime, 6th Sylvester's number                      |
|                                     | 3628800              | 10!, 1 * 2 * ... * 10                    | possible ways to order 10 objects                       |
|                                     | 9737333              |                                          | first super prime of order 11                           |
|                                     | 16777216             | 2^24, 16^6, 0xffffff                     | number of distinct 24 bit values, no. of RGB24 colors   |
|                                     | 16777217             | 2^24 + 1, 0x1000000                      | min. pos. int. unstorable in 32b float (prec. falls < 1)| 
|                                     | 43046721             | 3^16                                     |                                                         |
|                                     | 47176870             | BB(5)                                    | maximum number of 1s produced by 5 state Turing machine |
|                                     | 31556926             |                                          | seconds in a year                                       |
|                                     | 33550336             |                                          | 5th perfect number                                      |
|                                     | 39916800             | 11!, 1 * 2 * ... * 11                    | possible ways to order 11 objects                       |
|                                     | 86400000             | 1 * 2^2 * 3^3 * 4^4 * 5^5, hyperfact(5)  |                                                         |
|                                     | 479001600            | 12!, 1 * 2 * ... * 12                    | possible ways to order 12 objects                       |
| one [billion](billion.md)           | 1000000000           |1B, 10^9, milliard, 0x3b9aca00, 2^29.89...|                                                         |
|                                     | 2147483647           | 2^32 / 2 - 1                             |maximum two's complement signed 32 bit number, Mer. prime|
|                                     | 3735928559           | 0xdeadbeef                               | one of famous hexadeciaml constants, spells out DEADBEEF|
|                                     | 4294967295           | 2^32 - 1, 0xffffffff                     | maximum unsigned number storable with 32 bits           |
|                                     | 4294967296           | 2^32, ((((2^2)^2)^2)^2)^2, 0x100000000   | number of values storable with 32 bits                  |
|                                     | 6227020800           | 13!, 1 * 2 * ... * 13                    | possible ways to order 13 objects                       |
|                                     | 8589869056           | 0x1ffff0000                              | 6th perfect number                                      |
|                                     | 9876543210           | 0x24cb016ea                              | all decimal digits from highest to lowest               |
|                                     | 87178291200          | 14!, 1 * 2 * ... * 14                    | possible ways to order 14 objects                       |
| hundred billion                     | 100000000000         | 10^11                                    | approximate number or stars in Milky Way galaxy         |
|                                     | 137438691328         | 0x1ffffc0000                             | 7th perfect number                                      |
|                                     | 500000500000         | 1 + 2 + ... + 1000000                    | sum of numbers up to 1000000                            |
| one trillion                        | 1000000000000        | 10^12, billion (LS)                      |                                                         |
|                                     | 1307674368000        | 15!                                      | possible ways to order 15 objects                       |
|                                     | 4031078400000        | 2^2 * 3^3 * 4^4 * 5^5 * 6^6, hyperfact(6)|                                                         |
|                                     | 10650056950807       |                                          | 7th Sylvester's number                                  |
|                                     | 20922789888000       | 16!                                      | possible ways to order 16 objects                       |
| thirty trillion                     | 30000000000000       |                                          | approximate number of cells in human body               |
|                                     | 355687428096000      | 17!                                      | possible ways to order 17 objects                       |
| bazillion                           | ???                  |                                          | used to just express a very large value                 |
| quadrillion                         | 1000000000000000     | 10^15                                    |                                                         |
|                                     | 6402373705728000     | 18!                                      | possible ways to order 18 objects                       |
|                                     | 9007199254740992     |                                          | precision of IEEE double falls below 1 after this num.  |
|                                     | 121645100408832000   | 19!                                      | possible ways to order 19 objects                       |
| quintillion                         | 1000000000000000000  | 10^18                                    |                                                         |
|                                     | 2305843008139952128  | 0x1fffffffc0000000                       | 8th perfect number                                      |
|                                     | 2432902008176640000  | 20!                                      | possible ways to order 20 objects                       |
|                                     | 9223372036854776000  | 2^64 / 2 - 1                             | maximum two's complement signed 64 bit number           |
|                                     | 18364758544493064000 | 0xfedcba9876543210                       | all hexadecimal digits from highest to lowest           |
|                                     | 18446744073709551615 | 2^64 - 1, 0xffffffffffffffff             | maximum unsigned number storable with 64 bits           |
|                                     | 18446744073709551616 | 2^64                                     | number of values storable with 64 bits                  |
|                                     | 43252003274489856000 |                                          | number of possible Rubik's cube configurations          |
|                                     |2015099950053364471960|                                          | number of possible chess games after 15 half moves      |
|                                     |6670903752021072936960|                                          | possible valid filled [sudoku](sudoku.md) grids         |
|                                     | 1.000000... * 10^30  | 1000000000000066600000000000001          | Belphegor's prime, evil (666, 13 zeroes), palindromic   |
|                                     | 1.267650... * 10^30  | 2^100                                    | number of values storable with 100 bits                 |
|                                     | 2.658455... * 10^36  |                                          | 9th perfect number                                      |
|                                     | 3.402823... * 10^38  | (2 - 2^(-23)) * 2^127                    | largest number storable in IEEE-754 32 bit float        |
|                                     | 3.402823... * 10^38  | 2^128                                    | number of values storable with 128 bits                 |
|                                     | 1.915619... * 10^53  |                                          | 10th perfect number                                     |
|                                     | 1.157920... * 10^77  | 2^256                                    | number of values storable with 256 bits                 |
| bazillionplex                       | ???????              | 10^bazillion                             | one followed by bazillion zeros                         |
|                                     | 10^80                |                                          | approx. number of atoms in observable universe          |
| [googol](googol.md)                 | 10^100               |                                          | often used big number                                   |
| Shannon number                      | 10^120               |                                          | estimated number of possible games in [chess](chess.md) |
| [asankhyeya](asankhyeya.md)         | 10^140               |                                          | religious number, often used in [Buddhism](buddhism.md) |
|                                     | 1.340780... * 10^154 | 2^512                                    | number of values storable with 512 bits                 |
|                                     | 9.332621... * 10^157 | 100!                                     | possible ways to order 100 objects                      |
|                                     | 4.65... * 10^185     |                                          | approx. number of Planck volumes in observable universe |
|                                     | 1.797693... * 10^308 |                                          | largest number storable in IEEE-754 64 bit float        |
|                                     | 1.797693... * 10^308 | 2^1024                                   | number of values storable with 1024 bits                |
|                                     | 3.231700... * 10^616 | 2^2048                                   | number of values storable with 2048 bits                |
|                                     | 2.601218... * 10^1746| 3!!!                                     |                                                         |
|                                     | 4.023872... * 10^2567| 1000!                                    | possibe ways to order 1000 objects                      |
| [googolplex](googolplex.md)         | 10^(10^100)          | 10^googol                                | another large number, number of genders in 21st century |
|                                     | 10^^10               | 9PT10, 10^10^10^10^10^10^10^10^10^10     |                                                         |
| [Graham's number](grahams_number.md)|                      | g64                                      | extremely, unimaginably large number, > googolplex      |
| TREE(3)                             | unknown              |                                          | yet even larger number, > Graham's number               |
| [infinity](infinity.md)             |                      | lim x->0 1/x, 1 + 1 + 1 + ...            | not always considered a number, largest possible value  |
| [aleph](aleph.md) zero              |                      | beth zero, cardinality(N)                | infinite cardinal number, "size" of the set of nat. num.|
| [i](i.md) (imaginary unit)          |                      | j * k                                    | part of complex numbers and quaternions                 |
| [j](j.md)                           |                      | k * i                                    | one of quaternion units                                 |
| [k](k.md)                           |                      | i * j                                    | one of quaternion units                                 |
| 1/sqrt(2) + i/sqrt(2)               |                      | sqrt(i)                                  | one of the square roots of imaginary unit               |
| -1/sqrt(2) - i/sqrt(2)              |                      | sqrt(i)                                  | one of the square roots of imaginary unit               |

## See Also

- [real number](real_number.md)
- [pseudonumber](pseudonumber.md)
- [not a number](nan.md)
- [illegal number](illegal_number.md)
- [offensive number](offensive_number.md)
- [binary numbers](binary.md)
