# LRS: Projects Needed

*See also [exercises](exercises.md).*

{ If you want to maybe start some project here I'll be glad if you let me know before you start, it can be good to talk about it first as I already have some ideas about how to make some of these projects, I just don't have time to work on them, I will just give you the ideas I have if you want, we can discuss how to best write the code etc. Of course it's all up to you, I'm just offering advice and discussion :) ~drummyfish }

Here is a list of some projects and project ideas which we, [LRS](lrs.md), need to make in order to pursue our goals. The projects here are mostly basic things and tools that already exist in some form, but that have to be made from scratch according to [LRS](lrs.md) philosophy, i.e. in a KISS/suckless way, under public domain, in a good language (C, comun, ...) etc. This is kind of a dirty list serving some rough organization. If you have the skills and will (or know someone who does), you may take inspiration here, pick one up and make it, or contribute to some of the projects listed here. Also note that it's still possible to make multiple projects of the same type, e.g. you may still create another chess engine even though we already have one, just watch out that this is justified (it should offer something worth the extra effort).

NOTE: **We also desperately need [suckless](suckless.md) rewrites of "FOSS" software**, i.e. of [shitware](shitware.md) that perhaps has "open soars" written on it but is generally unusable: this includes for example anything that uses [Docker](docker.md), [Rust](rust.md), [CMake](cmake.md), encryption libraries, anything that needs "up-to-date" packages, Internet connection and so on -- this software is equivalent to [proprietary](proprietary.md) software in that it cannot be used. Rewrite it in plain old C (or Forth or something sane).

NOTE 2: See **[how to do projects well](project.md)**.

| what                                   | difficulty | implementation                  | by           |  status             | comment                                                         | similar/for now use       |
| -------------------------------------- | ---------- | ------------------------------- | ------------ | ------------------- | --------------------------------------------------------------- | ------------------------- |
| 2D image editor                        | mid?       | Blitz's [LRSketch](lrsketch.md) |              | WIP                 | KISS GIMP clone needed! Use LRS GUI lib. Glorified MS paint?    | ped, GIMP, classic colors |
| 2D raycasting engine (C)               | mid        | [raycastlib](raycastlib.md)     | drummyfish   | done                |                                                                 |                           |
| 3D modelling software                  | mid/hard?  |                                 |              |                     | Blender clone needed! LRS GUI lib + small3dlib, just .obj files | Blender :(                |
| 3D physics engine (C)                  | hard       | [tinyphysicsengine](tpe.md)     | drummyfish   | done                | could use a true rigid body one too                             |                           |
| 3D raytracing library                  | mid?       |                                 |              | had vague plans     |C lib for shooting 3D rays, allows raycast., RT, pathtr., ...    | POV-RAY                   |
| 3D renderer (C)                        | mid/hard   | [small3dlib](small3dlib.md)     | drummyfish   | done                |                                                                 | TinyGL, PortableGL        |
| 3D voxel renderer (C)                  | mid/hard?  |                                 |              |                     | like Ken Silverman's voxlap, looks very nice                    | voxlap                    |
| [Anarch](anarch.md) mods               | easy       |                                 |              | more would be nice  | for fun                                                         |                           |
| artificial human language              | hard?      |                                 |              | thinking bout it    |need LRS lang., big problems with definitions of words tho, think| Esperanto, Lojban, ...    |
| Arduino/Pokitto/... computer           | mid/hard?  |                                 |              |                     | until we have PD computer, we'll need a nice tiny embedded comp.|                           |
| audio/music editor                     | mid/hard?  |                                 |              |                     | for waveforms and/or MIDI (tracker music), can even be CLI/TUI  | Audacity, LMMS, ...       |
| chat software                          | mid?       | dumbchat                        | drummyfish   | one done            | make it KISS, no encryption, no Unicode, ... just chat!         | [IRC](irc.md)             |
| [chatbot](chatbot.md)                  | mid?       |                                 |              | plans in my head    | probably NOT neural net, KISS lib for good enough chatbot       |                           |
| [cheating](cheating.md) tools          | mid        |                                 |              |                     | support cheating, e.g. chess (use engine but in human like way) | Stockfish, ...            |
| [chess](chess.md) engine/library (C)   | mid/hard   |[smallchesslib](smallchesslib.md)| drummyfish   | done                | it's not very strong tho :/                                     |                           |
| [compression](compression.md) lib/util | mid?       | shitpress/comunpress            | ...          | one so far          |                                                                 |                           |
| data, datasets                         | easy/mid?  |                                 |              |can never have enough|simple format CC0 data (CSV etc.): txt dictionaries, star DB, ...| Wikidata, ...             |
| dating/friend searching website        | mid?       |                                 |              |                     | we are lonely + don't wanna use proprietary dating shit         |                           |
| [free universes](free_universe.md)     | mid/hard?  |                                 |              |                     | need at least one fantasy and one sci-fi, for games n shit      |                           |
| fiction, stories, books                | mid?       |                                 |              |have some plans      | fairytales, sci-fi from LRS society etc.                        |                           |
| free cultural [porn](porn.md) website  | mid?       |                                 |              |                     | libre porn + suckless site (no JS), prev. attempts failed       | WMC porn, freedomporn.org |
| freedom-friendly computer              | hard       |                                 |              |                     |not just "FOSS", must be also [KISS](kiss.md), cheap + fully free| RPI, Arduino, ...         |
| forum, chat, git/file host/mirror, ... | easy/mid?  |                                 |              |                     |for LRS community, if you have a server you could host something | email, IRC                |
| [gamebook](gamebook.md)                | easy/mid?  |                                 |              |                     |can be done by nonprogrammers and later be made into PC game too |                           |
| game engine/fantasy console (tiny)     | easy/mid   | [SAF](saf.md)                   | drummyfish   | done                |                                                                 |                           |
| game engine: point n click adventure   | mid        |                                 |              |                     |                                                                 |                           |
| game: Advance Wars clone               | mid        |                                 |              |                     | extremely cool game, not hard to make (2D, pixel art, ...)      |                           |
| game: [Doom](doom.md) clone            | hard       | [Anarch](anarch.md)             | drummyfish   | done                |                                                                 | Freedoom                  |
| game: [GTA](gta.md) clone              | hard       |                                 |              |                     |                                                                 |                           |
| game: [Minecraft](minecraft.md) clone  | hard?      |                                 |              |                     | Minetest is bloated as fuck, also bad license and SJWs          | Minetest :(               |
| game: text adventure                   | easy       |                                 |              |                     | pure CLI text adventure, maybe "US citizen simulator"? :)       |                           |
| game: [Trackmania](trackmania.md) clone| hard       | [Licar](licar.md)               | drummyfish   | done                | still could use a super KISS 2D TM-like game!                   | [racetrack](racetrack.md) |
| game: [Pokemon](pokemon.md) clone      | hard?      |                                 |              |                     | catchable monsters game, procedurally generated ones? SAF?      | Tuxemon, ...              | 
| game: fantasy [RPG](rpg.md)            | hard?      |                                 |              |                     | Dream: Elder Scrolls clone, also just a dungeon crawler, ...    |                           |
| game: [arena shooter](afps.md)         | hard       |                                 |              |                     | Xonotic died, OpenArena is imperfect, we need a suckless one    | OpenArena?                |
| game: [MMORPG](mmorpg.md)              | hard       |                                 |              |                     |prolly 2D, maybe wait for [free universe](free_universe.md) first|                           |
| game: Jump King clone (likely SAF)     | easier     |                                 |              |                     | easy to make, potentially lot of fun                            |                           |
| game: Marble Blast clone (C?)          | mid/hard?  |                                 |              |                     | like Neverball but KISS, better controls, wouldn't be so hard   | Neverball                 |
| game: battle simulator clone (3D or 2D)| mid-hard   |                                 |              | thinking about it   | clone Ultimate Epic Battle Simulator, could be combined with RTS| CPU vs CPU in RTS games   |
| game: 3D light-gun shooter (with S3L)  | mid        |                                 |              |                     | nice relaxation game, not that hard to make                     |                           |
| game: Uther Party clone                | mid        |                                 |              |                     |                                                                 |                           |
| game: virtual aquarium/farm            | easier     |                                 |              |                     | just a relaxing game, glorified Tamagotchi                      |                           |
| game: [marble racing](marble_race.md)  | mid        |                                 |              |                     | toy for causal entertainment, can be just 2D in SAF             |                           |
| game: Warcraft III clone (prolly 2D)   | mid-hard   |                                 |              |                     | RTS with multiplayer, can be combined with the battle sim. etc. |                           |
| game: world's hardest game clone (SAF) | easy       |                                 |              |                     |                                                                 |                           |
| game: zero player simulators/toys      | mid/easier | [procball](procball.md)         | drummyfish   |done, more is better | games you don't play, just watch, to replace TV, streams etc.   |                           |
| games: tiny ones                       | easy       | [uTD](micro_td.md), ...         | ...          |can never have enough| very tiny games, SAF is ideal for this, nice learning project   |                           |
| game servers w/o rules (allow cheating)| mid?       |                                 |              |                     | e.g. for chess, MT, AFPS and so on, allow everything            |                           |
| [go](go.md) engine/library (C or comun)| mid?       |                                 |              |                     |                                                                 |                           |
| [GUI](gui.md) library                  | easy/mid   |                                 |              |                     |like SAF but for "PC" GUI (mouse, sound, ...), now GUI's a mess  |                           |
| image/2D data library                  | mid?       |                                 |              |                     | C/comun lib for bitmaps (FFT, formats, ...), needs good planning|                           |
| logic circuit library/simulator (comun)| mid/hard?  |                                 |              |                     | will be needed for PD computer                                  |                           |
| [LRS](lrs.md) commons                  | mid?       |                                 |              |                     | like WM commons but more free speech and don't ban drummyfish   | WM commons etc.?          |
| "[micronation](micronation.md)"        | ???        |                                 |              |                     | kinda joke, has to be anarchist, no money/government/army       |                           |
| [MUD](mud.md) codebase (C or comun)    | mid        |                                 |              |                     | AFAIK there is no nice MUD codebase now                         |                           |
| nice polished concise encyclopedia     | mid/hard?  |                                 |              |                     | nice printable UNCENSORED encyclop. (clone of Larousse Desk E.) |                           |
| neural net/other ML library            | hard?      |                                 |              |                     | could use something KISS in pure C without needed python n shit | nothing                   |
| non capitalist mouse                   | harder?    |                                 |              |                     | simple no BS free HW mouse, can be ball, good if handles gamyes |capitalist mice :( keyboard|
| non [SJW](sjw.md) non-profits/services | harder?    |                                 |              |                     | git hosting, web hosting etc. that doesn't censor EVERYTHING    | self host?                |
| [operating system](os.md)              | HARD       |                                 |              |                     | 100% LRS OS is far future, LRS-like BSD distro would be cool now| GNU, BSD, duskOS, ...     |
| steganography hosting anywhere         | easy/mid   |                                 |              |planning in head...  |embedding uncensored data anywhere on the Inet with steganography| darknet n shit            |
| [unfuck](unfuck.md) third party SW     | easy?      |                                 |              |                     |take existing SW, remove cmake and other bloat, rewrite to C etc.|                           |
|[PD computer](public_domain_computer.md)| very hard  |                                 |              |                     | needs prerequisites done first (language, logic circ. lib., ...)| Thinkpads :)              |
| PD computer "[operating system](os.md)"| mid?       | [comun shell](comun_shell.md)?  | drummyfish   | highly WIP          |                                                                 | BSDs? DuskOS?             |
| [portal renderer](portal_rendering.md) | mid/hard?  |                                 |              |                     | for Anarch II? :)                                               | Doom engine, BUILD        |
| propaganda materials                   | easy       |                                 |              |can never have enough|wallpapers, songs, videos, translations, tutorials, games, ...   |                           |
| programming language                   | mid/hard   | [comun](comun.md)               | drummyfish   | done, continuing    |                                                                 | C, comun, FORTH, ...      |
| rape/gore simulator                    | mid?       |                                 |              |                     | so ppl. can satisfy need for violence and not have to do it IRL |                           |
| [search engine](search_engine.md)      | mid/hard?  |                                 |              |                     |like wiby, marginalia, ... support gopher, KISS (no DB, just txt)| wiby, marginalia, ...     |
| soundfonts                             | easy/mid   |                                 |              | working on one      | nice CC0 soundfonts so we can make completely PD MIDI           |                           |
| text editor (C, comun)                 | mid?       |                                 |              |                     | likely more will be made, need a standard KISS editor in comun  | vim etc.                  |
| translation/dictionary software        | mid?       |                                 |              |                     | Google translate alt., KISS, offline, even just word for word   |                           |
| vector fonts                           | mid?       | GirlsAreDumb, ...               | ...          | one done            | nice CC0 fonts for texts, there are too few of those            |Aileron, GirlsAreDumb, ... |
| web (gopher, ...) browser              | easy/mid?  |                                 |              |                     | like badwolf basically, but yet nicer (support gopher etc.)     |badwolf, netsurf, lynx, ...|
| wiki                                   | mid        | [LRS wiki](lrs_wiki.md)         | drummyfish   | done, continuing    |                                                                 |                           |
