# NC

*See also [ND](nd.md).*

In the context of [licenses](license.md) the acronym NC stands for *non-commercial* and means "only non-commercial use allowed", which is an unpopular limitation that makes such a license **by definition [proprietary](proprietary.md) (i.e. NOT a [free cultural](free_culture.md) license)**. This means that a work shared under a license with NC clause is prohibited from being used commercially (which itself is a very unclear statement), greatly limits the freedom of such work and opens the door for legal fuzziness and therefore possible bullying. The NC limitation appears most notably in two [Creative Commons](creative_commons.md) licenses: CC BY-NC-SA and CC BY-NC-ND; again, despite these licenses being Creative Commons, they are **NOT [free as in freedom](free_culture.md)** licenses -- note that this is not an opinion or controversial statement, NC licenses very clearly break the consensual definition of free cultural works and Creative Commons themselves clearly state this is the case; they justify NC licenses as part of the proprietary-free license spectrum, standing somewhere in between "all rights reserved" and free cultural licenses. Even though to free culture newcomers NC licenses don't seem like such a big deal, they are in fact extremely [harmful](harmful.md) to free culture, **DO NOT USE NC LICENSES**. NC is similar (and similarly harmful) to another proprietary license limitation: [ND](nd.md) (no derivatives allowed). If you use an NC license, you're a huge cocksucker.

**Why are NC licenses bad?** Firstly the *Definition of Free Cultural Works* project that maintains the widely accepted definition of free culture has an article on this: https://freedomdefined.org/Definition. Let us write a summary of the arguments ALONG WITH [our own](lrs.md) arguments:

- **"Commercial use" isn't just selling, it possibly prohibits beneficial uses you would want to allow.** Imagine you create e.g. an educational image that you would like many people to see -- by using an NC license you will however prohibit for example other people from showing the image on social media if they are people who make money from social media, for example YouTubers that make money from ads on their videos will be prohibited (or at least greatly discouraged) from showing your educational image in their videos, you may also rule out use by ethical non-profits who still need to make some money to sustain themselves etc. Of course, the author may allow commercial use in individual cases and "on the go", in the spirit of [permission culture](permission_culture.md), however this may be practically impossible in cases of big collaborative works similar to e.g. [Wikipedia](wikipedia.md) with possibly thousands of authors.
- **It is very unclear what commercial use means which opens door to legal fear and avoidance of NC works.** "Commercial use" may be interpreted not just as directly selling the work but as doing pretty much anything with the work that somehow, even indirectly, leads to some kind of profit -- consider e.g. printing an NC picture on your shirt (allowed by the NC license) and then wearing that shirt while promoting something you're selling -- if such shirt could be seen as helping you get attention of more customers and so result in making more money, you're potentially violating the license and the author can sue you. I.e. by using NC works you will always have to worry to not come close to anything that could be seen, even by a stretch, as a "commercial use". This is a worry that will exist as long as copyright on the work, i.e. certainly for your whole life. For this reason people simply avoid using such works and even choose to use lower quality works that don't pose such dangers. Using an NC license will therefore make your work much less popular, less visible and, of course, much less useful.
- **It makes the work incompatible with other licenses.** Works under NC license cannot be included in free cultural works, for example text written on the Citizendium encyclopedia (licensed NC) cannot be copied to Wikipedia (licensed free under CC-BY-SA).
- **It adds huge legal [bloat](bloat.md).** Similarly to e.g. [copyleft](copyleft.md), the NC clause has to either be very vague and unclear or extremely long and complex in explaining what it really means. This of course leads to unclarities, legal bugs, confusion, payments of lawyers etc.
- **It strengthens the idea of [intellectual property](intellectual_property.md).** The basic aim of free culture is to relax "intellectual property" laws, not to strengthen them or continue the ways of [permission culture](permission_culture.md), therefore the strict NC limitation is very unpopular among proponents of free culture. We, [LRS](lrs.md), strongly reject the very idea of being able to own information, so stricter legal conditions are always worse in our view.
- **NC license may be in some cases worse than no license at all.** Even though Creative Commons NC licenses give basic rights such as that for non-commercial sharing, the explicit prohibition of commercial use may in specific cases result in more harm than if there was no license attached to the work, because breaking a rule that's stated explicitly may in court be seen as a bit more serious and intentional than breaking an implicit rule. (Similar reasoning was used to reject [CC0](cc0.md) by [OSI](osi.md).)
- **NC license is [proprietary](proprietary.md), i.e. all arguments against proprietary works apply.**
- ...

{ Nice parody is the CC BY-NV license :D https://questioncopyright.org/cc-by-nv/trackback.html ~drummyfish }

## See Also

- [ND](nd.md)
- [CC BY-NV](cc_by_nv.md)