# Minigame

Minigame is a very small and [plain](kiss.md) [game](game.md) intended to entertain its player in a simple way and, unlike a full fledged game, usually only for a brief time. A lot of times minigames can be seen embedded in big games (as an [easter egg](easter_egg.md) or as part of a game mechanic such as lock picking), they may come as an extra feature on primarily non-gaming systems, or appear in collections as a part of a bigger package (e.g. various party game collections). Minigames include such games as [minesweeper](minesweeper.md), [sokoban](sokoban.md), the [Google](google.md) [Chrome](chrome.md) T-rex "infinite runner", [Simon Tatham's Portable Puzzle Collection](stppc.md), as well as many of the primitive old games such as [Pong](pong.md) and [Tetris](tetris.md). Minigames are nice from the [LRS](lrs.md) point of view for being [minimalist](minimalism.md), simple to create and possibly [portable](portability.md), while still maintaining potential for providing a lot of [fun](fun.md). Minigames are an ideal project for learning [programming](programming.md) for not being overly ambitious but still remaining highly rewarding and fun to both develop and test.

It is possible to further subdivide the minigame genre into subcategories such as [one button games](one_button_game.md), [one input games](one_input_game.md), quick time events, endless runners, memory games, physics minigames, multiplayer "party" minigames and so on.

In spite of the primary purpose of minigames to provide casual entertainment and only help "pass some time on the bus", there are still some who pour in horrendous hours into systematic training and grinding to achieve high skill, typically for competition such as [speedrunning](speedrun.md). In the end this not so surprising, a minigame will typically be an "[easy to learn, hard to master](easy_to_learn_hard_to_master.md)" type of game, just like many serious [sports](sport.md) and video games.

Unlike big games, minigames are still very often built on the arcade principles such as getting the highest score or the fastest time. For this they can greatly benefit from [procedural generation](procgen.md) (e.g. endless runners).

## List Of Minigames

Almost any traditional game idea can be made into a minigame if we simplify it enough, but for inspiration here is a list of some common minigames and minigame types.

- **[2048](2048.md)**
- **[arithmetic](arithmetic.md) minigame**
- **[arkanoid](arkanoid.md)**
- **[asteroids](asteroids.md)**
- **[backgammon](backgammon.md)**
- **[battleships](battleships.md)**
- **bomb diffusion**
- **Boulder Dash clone**
- **button smasher**: Games whose goal is achieved mainly by smashing a button as quickly as possible, usually e.g. sprint simulators. This may perhaps even include a game that requires you to press a button as quickly as possible (achieve fastest reaction time).
- **[card games](card_game.md)** ([solitaire](solitaire.md), [poker](poker.md), ...)
- **[checkers](checkers.md)**
- **[chess](chess.md) puzzles**
- **city bomber**: A plane is descending on the screen, player has to drop bombs to destroy building so that it can land.
- **concentration**
- **[donkey kong](donkey_kong.md)**
- **[dots and boxes](dots_and_boxes.md)**
- **[endless runner](endless_runner.md)** (car hill climbing, Flappy Bird clone, Subway Surfers clone, T-rex jumper, ...)
- **fast typing**
- **"Find Waldo"**, "find N differences", ...
- **[fifteen](fifteen.md)**
- **[flappy bird](flappy_bird.md)**
- something based on **[game of life](gol.md)** or another [cellular automaton](cellular_automaton.md)
- **frog crossing the road**
- **[go](go_game.md)**, especially a small board one or variants such as atari go
- **guess a number**
- **[hangman](hangman.md)**
- **[invaders](invaders.md)**
- **[jigsaw puzzle](jigsaw.md)**
- **knowledge quiz**
- **[loderunner](loderunner.md)**
- **[ludo](ludo.md)**
- **[lunar lander](lunar_lander.md)**
- **[mahjong](mahjong.md)**
- **[marble racing](marble_racing.md)**
- **maze**
- **[minigolf](minigolf.md)**
- **[minesweeper](minesweeper.md)**
- **[multitasking](multitasking.md)** (various [work](work.md) simulators such as a factory worker, chef making pizzas, ...)
- **[music](music.md) minigame** (drumming, dancing, singing, remembering melody, ...)
- **[nonogram](nonogram.md)**
- **[pacman](pacman.md) clone**
- **physics-based** (tower building, Angry birds clone, ...)
- **[pinball](pinball.md)**, [pachinko](pachinko.md)
- **pipes**
- **[pong](pong.md)**
- **precision games** (lock picking, tracing shapes, aiming, ...)
- **[racetrack](racetrack.md)**
- **[rock-paper-scissors](rock_paper_scissors.md)**
- **[Rubik's Cube](rubiks_cube.md)**
- **[shoot'em up](shmup.md)**
- **slot machine**
- **[snake](snake.md)**
- **[sokoban](sokoban.md)**
- **[sports](sport.md) minigame** (minigolf, penalty kicks, duck hunting, racing, ...)
- **[sprouts](sprouts.md)**
- **[sudoku](sudoku.md)**
- **survival** (defending against infinite hoards of enemies)
- **[tangram](tangram.md)**
- **[tetris](tetris.md) clone** (block game, "tetris" is [trademarked](trademark.md)
- **text-based** (riddles, police negotiator simulator, interrogations, quizes, tests, [anagrams](anagram.md), synonyms, ...)
- **[The Witness](the_witness.md) puzzles**: The sort of puzzles that appear in the game The Witness.
- **[tic-tac-toe](tic_tac_toe.md)**
- **[tower of hanoi](tower_of_hanoi.md)**
- **[tron](tron.md)**
- **[untangle](untangle.md)**
- **whack a mole**
- **[QWOP](qwop.md)**
- ...

# See Also

- [easy to learn, hard to master](easy_to_learn_hard_to_master.md)