# Mathematics

Mathematics (also math or maths, from Greek *mathematicos*, *learned*) is the best [science](science.md) (yes, it is a formal science), which deductively deals with [numbers](number.md) and other [abstract](abstraction.md) structures with the use of pure [logic](logic.md), in as rigorous and objective way as possible. In fact it's the only true science that can actually prove facts thanks to its tool of mathematical [proof](proof.md) (other sciences may only disprove or show something to be very [probable](probability.md)). It's an immensely important discipline for [programming](programming.md) and [computer science](compsci.md). Mathematics is possibly intellectually the most difficult field to study in depth, it's the purest intellectual endeavor meant only for the smartest; the difficulty, as some mathematicians point out, comes especially from the exceptionally deep [abstraction](abstraction.md) (pure mathematics often examines subjects with no obvious connection to reality and only exist as a quirk of logic itself). It is said that mathematics is the only **universal [language](language.md)** in our [universe](universe.md) -- if we were ever to establish contact with an intelligent alien civilization, we'd likely use mathematics for communication. While most people only ever learn basic algebra and some other mechanical operations that are necessary for mathematics, true mathematics is not about blind calculation, it is a creative discipline and [art](art.md) of constructing [proofs](proof.md) from basic [axioms](axiom.md), sometimes so difficult that a solution demands many lifetimes of the brightest minds.

Some (especially the [English](english.md) speaking world) perceive math not as a science but rather a discipline that develops formal tools for "true sciences". The reasoning is usually that a science has to use [scientific method](scientific_method.md), but that's a limited view as scientific method is not the only way of obtaining reliable knowledge. Besides that math can and does use the principles of scientific method -- mathematicians first perform "experiments" with numbers and generalize into [conjectures](conjecture.md) and later "strong beliefs", however this is not considered [good enough](good_enough.md) in math as it actually has the superior tool of [proof](proof.md) that is considered the ultimate goal of math. I.e. math relies on [deductive](deduction.md) reasoning (proof) rather than less reliable [inductive](induction.md) reasoning (scientific method) -- in this sense mathematics is more than a science.

Mathematics as a whole is constructed with [logic](logic.md) from some basic system -- [historically](history.md) it was based e.g. on [geometry](geometry.md), however modern mathematics has since about 19th century been built on top of **[set theory](set_theory.md)**, i.e. all thing such as [numbers](number.md), [algebra](algebra.md) and [functions](function.md) are all derived from just the existence of [sets](set.md) and [classes](class.md) and some basic operations with them. Specifically *Zermelo–Fraenkel set theory with [axiom of choice](axiom_of_choice.md)* (ZFC, made in the beginning of 20th century) is mostly used nowadays -- it's a theory with 9 [axioms](axiom.md) that we can consider kind of ["assembly"](assembly.md) of mathematics.

[Soydevs](soydev.md), coding monkeys (such as webdevs) and just retards in general hate math because they can't understand it. They think they can do programming without math, which is just ridiculous. This delusion stems mostly from these people being highly incompetent and without proper education -- all they've ever seen was a shallow if-then-else [python](python.md) "[coding](coding.md)" of baby programs or point-and-click "coding" in gigantic [GUI](gui.md) frameworks such as [Unity](unity.md) where everything is already preprogrammed for them. Of course this is not completely their fault (only partially), the [shitty system](capitalism.md) just produces robot slaves who can't really think, just do some task to blindly produce goods for the economy etcetc. By Dunning–Kruger they can't even see how incompetent they are and what real programming is about. In reality, this is like thinking that being able to operate a calculator makes you a capable mathematician or being able to drive a car makes you a capable car engineer. Such people will be able to get jobs and do some repetitive tasks such as web development, [Unity](unity.md) game development or system administration, but they will never create anything innovative and all they will ever make will be ugly, [bloated](bloat.md) [spaghetti](spaghetti.md) solution that will likely do more harm than good.

On the other hand, one does not have to be a math [PhD](phd.md) in order to be a good programmer in most fields. Sure, knowledge and overview of advanced mathematics is needed to excel, to be able to spot and sense elegant solutions and to innovate in big ways, but beyond these essentials that anyone can learn with a bit of will it's really more about just not being afraid of math, accepting and embracing the fact that it permeates what we do and studying it when the study of a new topic is needed.

Very remarkable and perhaps even staggering is the fact that **the power of math is limited** because the power of [logic](logic.md) itself is limited. In 1930s this actually caused a big crisis in mathematics, connected to so called Hilbert's program which aimed to establish a completely "bulletproof" system to become the foundation of all mathematics, however in 1932 [Kurt Godel](godel.md) mathematically proved, with his [incompleteness theorems](incompleteness.md), that (basically) there are logical truths which math itself can never prove, and that, put in a simplified way, "math itself cannot prove its own consistency", which of course killed Hilbert's program and baffled many; since then we simply know we will never have a logically perfect system. This is related to the limited power of [computers](computer.md) due to [undecidability](undecidability.md) (there are problems a computer can never decide), proven by [Alan Turing](turing.md).

**What is mathematics really about?** Elementary school dropouts think math is about calculations and [numbers](number.md) -- sure, these are a big part of it but mathematicians mostly give a different answer. The core and [art](art.md) of high mathematics is constructing **[proofs](proof.md)**, but it also involves exploration, a common theme is e.g. **[generalization](generalization.md)**: mathematicians love to take already existing knowledge and patterns and extend them into other domains, find more general rules of which currently known rules are only a [special case](special_case.md). By this they are discovering universal laws and find that even seemingly unrelated concepts may have a lot in common. In a very general way we could perhaps say that mathematics is simply about exact **problem solving**.

## Overview

Following are some math areas and topics which a programmer should be familiar with:

- **basics** (high-school level math): arithmetic, algebra, expressions, basic [functions](function.md), [equations](equation.md), geometry, [trigonometry](trigonometry.md)/goniometry, systems of linear equations, quadratic equations, [complex numbers](complex_number.md), [logarithms](log.md), [analytic geometry](analytic_geometry.md) (many problems are equivalent to relationships of shapes in N dimensional spaces), [polynomials](polynomial.md) (used in many areas, e.g. error correction codes in networking), ...
- **advanced notation**: ability to understand the notation that's often used in papers etc. (the big sigma for sum, calculus notation etc.)
- **formal [logic](logic.md)**: computers are based on [Boolean](boolean.md) logic, knowing basic formulas and theorems here is crucial (e.g. the completeness of [NAND](nand.md) or [De Morgan's laws](de_morgan.md)), formal logic is also just generally used in formal texts, one should know about predicate vs propositional logic etc.
- **[proofs](proof.md)**: core of high level mathematics, one should know the basic proof techniques (direct, [contradiction](contradiction.md), [induction](induction.md), ...).
- **[linear algebra](linear_algebra.md)**: aka "vectors and matrices", essential in almost every field ([graphics](graphics.md), [machine learning](machine_learning.md), ...).
- **[calculus](calculus.md) and [differential equations](differential_equation.md)**: just essential for advanced math and many fields (graphics, machine learning, [electronics](electronics.md), physics, any optimization, ...).
- **theoretical [computer science](compsci.md)**: [computational complexity](computational_complexity.md) (very important), [computability](computability.md), [formal languages](formal_language.md), computational models ([automata](automaton.md), [Turing machines](turing_machine.md), ...), ...
- **[graph theory](graph.md)**: generally useful tools, especially important e.g. in networks or indexing structures in [databases](database.md).
- **[number](number.md) and [set](set.md) theory**: [sets](set.md) and operations with them (basis of all mathematics), [classes](class.md), sets of numbers ([natural](natural_number.md), [rational](rational_number.md), [real](real_number.md), [complex](complex_number.md), ...), [prime numbers](prime.md) (important e.g. for [cryptography](cryptography.md), [quantum computing](quantum.md), ...), ...
- **discrete math**: basic structures such as [groups](group.md) and [fields](field.md), [abstract algebras](abstract_algebra.md) and the properties of these structures.
- **[signal processing](signal_processing.md)**: [Fourier transform](fourier_transform.md) and other integral transforms (important e.g. for [compression](compression.md) and analysis of signals), [aliasing](aliasing.md), filter theory, ...
- **[numerical methods](numerical.md)**: for simulations and [approximations](approximation.md) of solutions to problems we can't solve exactly.
- **[probability](probability.md)/statistics**: encountered practically everywhere but very important e.g. in [cryptography](cryptography.md).
- **other**: things important in specific fields and/or other weird stuff, e.g. [topology](topology.md), [category theory](category_theory.md), [quaternions](quaternion.md) (graphics, physics), [lambda calculus](lambda_calculus.md), [game theory](game_theory.md), [fractal geometry](fractal.md), ...

## See Also

- [knowability](knowability.md)
- [logic](logic.md)
- [computer science](compsci.md)
- [physics](physics.md)
- [science](science.md)
- [thrembo](thrembo.md)
- [math rock](math_rock.md)