# Logic Gate

Logic gate is a basic element of [logic circuits](logic_circuit.md), a simple device that implements a [Boolean function](bool.md), i.e. it takes a number of [binary](binary.md) (1 or 0) input values and transforms them into an output binary value. Logic gates are kind of "small boxes" that eat 1s and 0s and spit out other 1s and 0s. Strictly speaking a logic gate must implement a mathematical function, so e.g. [flip-flops](flip_flop.md) don't fall under logic gates because they have an internal state/[memory](memory.md).

NOTE: Logic gate is a term used in [hardware](hardware.md), but the principles of logic gates are present everywhere in [programming](programming.md) and [computer science](compsci.md), the term *logic gate* is practically equivalent to what we otherwise call **Boolean functions, logical operators, binary operations etc.** So this article will talk about all of these at once; the knowledge is crucial not just for hardware engineers but for anyone interested in [hacking](hacking.md) computers in any way.

Logic gates are to logic circuits kind of what [resistors](resistor.md), [transistors](transistor.md) etc. are for electronic circuits. They implement basic functions that in the realm of boolean logic are equivalents of addition, multiplication etc.

Behavior of logic gates is, just as with logic circuits, commonly expressed with so called [truth tables](truth_table.md), i.e. a tables that show the gate's output for any possible combination of inputs. But it can also be written as some kind of equation etc.

There are 2 possible logic gates with one input and one output:

- **[identity](identity.md) (buffer)**: Output equals the input. This doesn't have any function from the logic perspective but can e.g. be used as a placeholder or to introduce intentional delay in the physical circuit etc.
- **[NOT](not.md)**: Negates the input (0 to 1, 1 to 0).

There are 16 possible logic gates with two inputs and one output (logic table of 4 rows can have 2^4 possible output values), however only some of them are commonly used and have their own names. These are:

- **[OR](or.md)**: Gives 1 if at least one input is 1, otherwise 0.
- **[AND](and.md)**: Gives 1 if both inputs are 1, otherwise 0.
- **[XOR](xor.md) (exclusive OR)**: Gives 1 if inputs differ, otherwise 0.
- **[NOR](nor.md)**: Negation of OR.
- **[NAND](nand.md)**: Negation of AND.
- **[XNOR](xnor.md)**: Negative XOR (equality).

The truth table of these gates is as follows:

| x | y | x OR y | x AND y | x XOR y | x NOR y | x NAND y | x XNOR y |
|---|---|--------|---------|---------|---------|----------|----------|
| 0 | 0 |   0    |   0     |   0     |   1     |    1     |    1     |
| 0 | 1 |   1    |   0     |   1     |   0     |    1     |    0     |
| 1 | 0 |   1    |   0     |   1     |   0     |    1     |    0     |
| 1 | 1 |   1    |   1     |   0     |   0     |    0     |    1     |

```
    ___             ___              _____            _____
 ---\  ''-.      ---\  ''-.      ---|     '.      ---|     '.
     )     )---      )     )O--     |       )---     |       )O--
 ---/__..-'      ---/__..-'      ---|_____.'      ---|_____.'
     OR              NOR             AND              NAND
    ___             ___             .                .
 --\\  ''-.      --\\  ''-.         |'.              |'.
    ))     )---     ))     )O--  ---|  >---       ---|  >O--
 --//__..-'      --//__..-'         |.'              |.'
     XOR             XNOR           ' BUFFER         ' NOT

 alternatively:
     ____          ____          ____          ____
 ---|=> 1|     ---| &  |     ---|= 1 |        | 1  |
    |    |---     |    |---     |    |---  ---|    |o--
 ---|____|     ---|____|     ---|____|        |____|
     OR            AND           XOR           NOT

 or even:
    ___        ___        ___        ___
 --|OR |--  --|AND|--  --|XOR|--  --|NOT|--
 --|___|    --|___|    --|___|      |___|
```

*symbols often used for logic gates*

Functions NAND and NOR are [functionally complete](functional_completeness.md) which means we can implement any other gate with only one of these gates. For example NOT(x) = NAND(x,x), AND(x,y) = NAND(NAND(x,y),NAND(x,y)), OR(x,y) = NAND(NAND(x,x),NAND(y,y)) etc. Similarly NOT(x) = NOR(x,x), OR(x,y) = NOR(NOR(x,y),NOR(x,y)) etc. NAND and NOR are the only two functions that are functionally complete by themselves, but there are more functionally complete sets of multiple functions, for example OR together with NOT can also implement any other function (which can be seen from the fact that we can implement NOR as NOT(OR(x,y)), and we know NOR is already functionally complete). More detail on this will follow below.

## More Detail On Boolean Functions

TODO

Now please see to the following gigatable of all 16 existing boolean functions of two variables (also called logical operators, conjunction etc.). It's clear there are exactly 16 such functions because two input binary variables result in 4 rows of a truth tables, each of which can be either 0 or 1, which gives 2^4 = 16 possible truth tables. These functions are related in various ways, for example to every function there is always another function which is basically the same, just with negated truth table. The table should highlight some of these patterns.

```
symbol| 0        ; &        ; >        ; X        ; <        ; Y        ; ~        ; |        ; v        ; =        ; !Y       ; @        ; !X       ; ?        ; ^        ; 1        
------+----------+----------+----------+----------;----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
 alt. | F f      ; * ^ A .  ; -/>      ; A p      ; </-      ; B q      ; </> ^ != ; + V U || ; !|       ; <=> <->  ; ~Y -Y Y' ; <- <=    ; ~X -X X' ; -> =>    ; !&       ; T t      
 sym. |          ; x &&     ;          ;          ;          ;          ; (+)      ;          ;          ; ==       ; oY       ;          ; oX       ;          ;          ;          
------+----------+----------+----------+----------;----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
XY 00 | 0        ; 0        ; 0        ; 0        ; 0        ; 0        ; 0        ; 0        ; 1        ; 1        ; 1        ; 1        ; 1        ; 1        ; 1        ; 1        
   01 | 0        ; 0        ; 0        ; 0        ; 1        ; 1        ; 1        ; 1        ; 0        ; 0        ; 0        ; 0        ; 1        ; 1        ; 1        ; 1        
   10 | 0        ; 0        ; 1        ; 1        ; 0        ; 0        ; 1        ; 1        ; 0        ; 0        ; 1        ; 1        ; 0        ; 0        ; 1        ; 1        
   11 | 0        ; 1        ; 0        ; 1        ; 0        ; 1        ; 0        ; 1        ; 0        ; 1        ; 0        ; 1        ; 0        ; 1        ; 0        ; 1        
------+----------+----------+----------+----------;----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
names | zero     ; AND      ; NIMPLY   ; repeater ;rev.nonim.; repeater ; XOR      ; OR       ; NOR      ; NXOR     ; NOT      ;rev. impl.; NOT      ; IMPLY    ; NAND     ; one      
      | false    ; conjunct.;nonimplic.; buffer   ;less than ; buffer   ;exclus. OR; disjunct.; non-disj.; XNOR     ; negat.   ;          ; negat.   ;implicat. ;          ; true     
      | low      ; times    ; minus    ; identity ;          ; identity ;not equals; plus     ;          ; equival. ; inverse  ;          ; inverse  ;if then   ;          ; high     
      |contradic.; carry    ; greater  ;projection;          ;projection; XAND     ;          ;          ; equals   ; flip     ;          ; flip     ;condition.;          ;tautology 
      |          ;          ;          ;          ;          ;          ;biconditi.;          ;          ; only if  ;          ;          ;          ;          ;          ;          
------+----------+----------+----------+----------;----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
arity | 0        ; 2        ; 2        ; 1        ; 2        ; 1        ; 2        ; 2        ; 2        ; 2        ; 1        ; 2        ; 1        ; 2        ; 2        ; 0        
comm. | yes      ; yes      ; no       ; no       ; no       ; no       ; yes      ; yes      ; yes      ; yes      ; no       ; no       ; no       ; no       ; yes      ; yes      
assoc.| yes      ; yes      ; no       ; yes      ; no       ; yes      ; yes      ; yes      ; no       ; yes      ; no       ; no       ; no       ; no       ; no       ; yes     
dual  | 1        ; |        ; @        ; X        ; ?        ; Y        ; =        ; &        ; ^        ; ~        ; !Y       ; >        ; !X       ; <        ; v        ; 0        
neg.  | 1        ; ^        ; ?        ; !X       ; @        ; !Y       ; =        ; v        ; |        ; ~        ; Y        ; <        ; X        ; >        ; &        ; 0        
adj.  | 0        ; &        ; <        ; Y        ; >        ; X        ; ~        ; |        ; v        ; =        ; !X       ; ?        ; !Y       ; @        ; ^        ; 1        
======+==========+==========+==========+==========+==========+==========+==========+==========+==========+==========+==========+==========+==========+==========+==========+==========
^     |(X^(X^X))^: (X^Y)^   :(X^(X^X))^: X        :(X^(X^X))^: Y        :((Y^X)^Y)^: (X^X)^   :((X^X)^   : ((X^X)^  : Y^Y      : (Y^X)^Y  : X^X      : (X^Y)^X  : X^Y      : X^(X^X)  
      |(X^(X^X)) : (X^Y)    :((X^Y)^X) :          :((Y^X)^Y) :          :((X^Y)^X) : (Y^Y)    :(Y^Y))^   : (Y^Y))^  :          :          :          :          :          :          
      |          :          :          :          :          :          :          :          :(X^(X^X)) : (X^Y)    :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
v     | Xv(XvX)  : (XvX)v   : (YvX)vY  : X        : (XvY)vX  : Y        : ((XvX)v  : (XvY)v   : XvY      :((YvX)vY)v: YvY      :(Xv(XvX))v: XvX      :(Xv(XvX))v:((XvX)v   :(Xv(XvX))v
      |          : (YvY)    :          :          :          :          : (YvY))v  : (XvY)    :          :((XvY)vX) :          :((XvY)vX) :          :((XvY)vY) :(YvY))v   :(Xv(XvX)) 
      |          :          :          :          :          :          : (XvY)    :          :          :          :          :          :          :          :(Xv(XvX)) :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
| !   |!((!X)|X) : !((!X)   :!(Y|(!X)) : X        :!(X|(!Y)) : Y        :!((!(X|Y)): X|Y      : !(X|Y)   :(!(X|Y))| : !Y       : X|(!Y)   : !X       : Y|(!X)   :(!X)|(!Y) : (!X)|X   
      |          : |(!Y))   :          :          :          :          :|(!((!X)| :          :          : (!((!X)| :          :          :          :          :          :          
      |          :          :          :          :          :          : (!Y))))  :          :          : (!Y)))   :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
& !   | (!X)&X   : X&Y      : X&(!Y)   : X        : Y&(!X)   : Y        :(!(X&Y))& : !((!X)   :(!X)&(!Y) :!((!(X&Y)): !Y       :!(Y&(!X)) : !X       :!(X&(!Y)) : !(X&Y)   :!((!X)&X) 
      |          :          :          :          :          :          : (!((!X)& : &(!Y))   :          :&(!((!X)& :          :          :          :          :          :          
      |          :          :          :          :          :          : (!Y)))   :          :          : (!Y))))  :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
? !   | !(X?X)   :!(Y?(!X)) : !(X?Y)   : X        : !(Y?X)   : Y        : (X?Y)?   : (!X)?Y   :!((!X)?Y) : !((X?Y)? : !Y       : Y?X      : !X       : X?Y      : Y?(!X)   : X?X      
      |          :          :          :          :          :          : (!(Y?X)) :          :          : (!(Y?X))):          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
@ !   | !(X@X)   :!((!X)@Y) : !(Y@X)   : X        : !(X@Y)   : Y        : (!(X@Y))@: Y@(!X)   :!(Y@(!X)) :!((!(X@Y)): !Y       : X@Y      : !X       : Y@X      : (!X)@Y   : X@X      
      |          :          :          :          :          :          : (Y@X)    :          :          :@(Y@X))   :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
? 0   | 0        :(Y?(X?0)) : (X?Y)?0  : X        : (Y?X)?0  : Y        : (X?Y)?   : (X?0)?Y  :((X?0)?Y) :((X?Y)?((Y: Y?0      : Y?X      : X?0      : X?Y      : Y?(X?0)  : 0?0      
      |          : ?0       :          :          :          :          : ((Y?X)?0):          : ?0       :?X)?0))?0 :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
@ 0   | 0        :0@        : 0@(Y@X)  : X        : 0@(X@Y)  : Y        :(0@(X@Y)) : Y@(0@X)  : 0@       :0@((0@(X@Y: 0@Y      : X@Y      : 0@X      : Y@X      : (0@X)@Y  : 0@0      
      |          :((0@X)@Y) :          :          :          :          : @(Y@X)   :          :(Y@(0@X)) :))@(Y@X)) :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
? ~   | X~X      :(Y?(X?(X~X: (X?Y)~   : X        : (Y?X)~   : Y        : X~Y      : (X~(X?X)):((X~(X?X)): (X~Y)~   : Y~(Y?Y)  : Y?X      : X~(X?X)  : X?Y      : Y?       : X?X      
      |          :)))?(X~X) : (X?X)    :          : (X?X)    :          :          : ?Y       :?Y)~(X?X) : (X?X)    :          :          :          :          : (X?(X~X)):          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
@ ~   | X~X      :(X~X)@(((X: (Y@X)~   : X        : (X@Y)~   : Y        : X~Y      : Y@       :(Y@(X~(X@X: (X~Y)~   : Y~(Y@Y)  : X@Y      : X~(X@X)  : Y@X      : ((X~X)@X): X@X      
      |          :~X)@X)@Y) : (X@X)    :          : (X@X)    :          :          : (X~(X@X)):)))~(X@X) : (X@X)    :          :          :          :          : @Y       :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
? >   | X>X      : (Y?(X?   : X>Y      : X        : Y>X      : Y        : (X?Y)?   : (X?(X>X)):((X?(X>X)):((X?Y)?((Y: Y?(Y>Y)  : Y?X      : X?(X>X)  : X?Y      : Y?       : X?X      
      |          : (X>X)))  :          :          :          :          : ((Y?X)?  : ?Y       :?Y)?(X>X) :?X)?(X>X)):          :          :          :          : (X?(X>X)):          
      |          : ?(X>X)   :          :          :          :          : (X>X))   :          :          :)?(X>X)   :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
? <   | X<X      : (Y?(X?   : Y<X      : X        : X<Y      : Y        : (X?Y)?   : (X?(X<X)):((X?(X<X)):((X?Y)?((Y: Y?(Y<Y)  : Y?X      : X?(X<X)  : X?Y      : Y?       : X?X      
      |          : (X<X)))  :          :          :          :          : ((Y?X)?  : ?Y       :?Y)?(X<X) :?X)?(X<X)):          :          :          :          : (X?(X<X)):          
      |          : ?(X<X)   :          :          :          :          : (X<X))   :          :          :)?(X<X)   :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
@ >   | X>X      : (X>X)@   : X>Y      : X        : Y>X      : Y        : ((X>X)@  : Y@       :(X>X)@(Y@ :(X>X)@(((X: (Y>Y)@Y  : X@Y      : (X>X)@X  : Y@X      : ((X>X)@X): X@X      
      |          : (((X>X)  :          :          :          :          : (X@Y))@  : ((X>X)@X):((X>X)@X)):>X)@(X@Y)):          :          :          :          : @Y       :          
      |          : @X)@Y)   :          :          :          :          : (Y@X)    :          :          :@(Y@X))   :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
@ <   | X<X      : (X<X)@   : Y<X      : X        : X<Y      : Y        : ((X<X)@  : Y@       :(X<X)@(Y@ :(X<X)@(((X: (Y<Y)@Y  : X@Y      : (X<X)@X  : Y@X      : ((X<X)@X): X@X      
      |          : (((X<X)  :          :          :          :          : (X@Y))@  : ((X<X)@X):((X<X)@X)):<X)@(X@Y)):          :          :          :          : @Y       :          
      |          : @X)@Y)   :          :          :          :          : (Y@X)    :          :          :@(Y@X))   :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
> !   | X>X      : X>(!Y)   : X>Y      : X        : Y>X      : Y        :!((!(X>Y)): !((!X)>Y): (!X)>Y   :(!(X>Y))>(: !Y       : !(Y>X)   : !X       : !(X>Y)   : (!X)>Y   : !(X>X)   
      |          :          :          :          :          :          :>(!(!(Y>X):          :          :!(!(Y>X))):          :          :          :          :          :          
      |          :          :          :          :          :          :)))       :          :          :          :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
< !   | X<X      : (!Y)<X   : Y<X      : X        : X<Y      : Y        :!((!(!(X<Y: !(Y<(!X)): Y<(!X)   :(!(!(X<Y)): !Y       : !(X<Y)   : !X       : !(Y<X)   : Y<(!X)   : !(X<X)   
      |          :          :          :          :          :          :)))<(!(Y<X:          :          :)<(!(Y<X)):          :          :          :          :          :          
      |          :          :          :          :          :          :)))       :          :          :          :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
> 1   | 1>1      : X>(1>Y)  : X>Y      : X        : Y>X      : Y        :1>((1>(X>Y: 1>((1>X) : (1>X)>Y  :(1>(X>Y))>: 1>Y      : 1>(Y>X)  : 1>X      : 1>(X>Y)  : (1>X)>Y  : 1        
      |          :          :          :          :          :          :))>(1>(1>(: >Y)      :          :(1>(1>(Y>X:          :          :          :          :          :          
      |          :          :          :          :          :          :Y>X))))   :          :          :)))       :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
< 1   | 1<1      : (Y<1)<X  : Y<X      : X        : X<Y      : Y        :((((X<Y)<1:(Y<(X<1)) : Y<(1<X)  :(((X<Y)<1): Y<1      : (X<Y)<1  : X<1      : (Y<X)<1  : Y<(X<1)  : 1        
      |          :          :          :          :          :          :)<1)<((Y<X: <1       :          :<1)<((Y<X):          :          :          :          :          :          
      |          :          :          :          :          :          :)<1))<1   :          :          :<1)       :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
> =   | X>X      : Y>       : X>Y      : X        : Y>X      : Y        : (X=Y)=   :((X=(X>X)): (X=(X>X)): X=Y      : Y=(Y>Y)  : (X=X)>   : X=(X>X)  : (X=X)>   :(Y>(X=(X> : X=X      
      |          : (X=(X>X)):          :          :          :          : (X>X)    : >Y)=(X>X): >Y       :          :          : (Y>X)    :          : (X>Y)    :X)))=(X>X):          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
< =   | X<X      : (X=(X<X)): Y<X      : X        : X<Y      : Y        : (X=Y)=   :(Y<(X=(X<X: Y<       : X=Y      : Y=(Y<Y)  : (X<Y)<   : X=(X<X)  : (Y<X)<   :((X=(X<X)): X=X      
      |          : <Y       :          :          :          :          : (X<X)    :)))=(X<X) : (X=(X<X)):          :          : (X=X)    :          : (X=X)    :<Y)=(X<X) :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
| = 0 | 0        : ((X=0)|  :((X=0)|Y) : X        :((Y=0)|X) : Y        : (X=Y)=0  : X|Y      : (X|Y)=0  : X=Y      : Y=0      : (Y=0)|X  : X=0      : (X=0)|Y  : (X=0)|   : 0=0      
      |          : (Y=0))=0 : =0       :          : =0       :          :          :          :          :          :          :          :          :          : (Y=0)    :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
| = ~ | X~X      :((X=(X~X)):(((X=(X~X): X        :(((Y=(X~X): Y        : X~Y      : X|Y      : (X|Y)=   : X=Y      : Y=(Y~Y)  :((Y=(X~X) : X=(X~X)  :((X=(X~X) :(X=(X~X))|: X=X      
      |          :|(Y=(X~X) : ))|Y)    :          : ))|X)    :          :          :          : (X~X)    :          :          : ))|X     :          : ))|Y     :(Y=(X~X)) :          
      |          :)=(X~X)   : =(X~X)   :          : =(X~X)   :          :          :          :          :          :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
| ~ 1 | 1~1      : ((X~1)|  :((X~1)|Y) : X        :((Y~1)|X) : Y        : X~Y      : X|Y      : (X|Y)~1  : (X~Y)~1  : Y~1      : (Y~1)|X  : X~1      : (X~1)|Y  : (X~1)|   : 1        
      |          : (Y~1))~1 : ~1       :          : ~1       :          :          :          :          :          :          :          :          :          : (Y~1)    :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
& = 0 | 0        : X&Y      : (Y=0)&X  : X        : (X=0)&Y  : Y        : (X=Y)=0  : ((X=0)&  : ((X=0)&  : X=Y      : Y=0      :((Y=0)&X) : X=0      :((X=0)&Y) : (X&Y)=0  : 0=0      
      |          :          :          :          :          :          :          : (Y=0))=0 : (Y=0))   :          :          : =0       :          : =0       :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
& = ~ | X~X      : X&Y      : X&(Y=    : X        : Y&(X=    : Y        : X~Y      :((X~(X=X)):(X~(X=X))&: X=Y      : Y=(Y~Y)  :(Y&(X=(X~X: X=(X~X)  :(X&(Y=(X~X: (X&Y)=   : X=X      
      |          :          : (X~X))   :          : (X~X))   :          :          :&(Y~(X=X)):(Y~(X=X)) :          :          :)))=(X~X) :          :)))=(X~X) : (X~X)    :          
      |          :          :          :          :          :          :          : )~(X=X)  :          :          :          :          :          :          :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
& ~ 1 | 1~1      : X&Y      : X&(Y~1)  : X        : Y&(X~1)  : Y        : X~Y      : ((X~1)&  : (X~1)&   : (X~Y)~1  : Y~1      : (Y&(X~1)): X~1      : (X&(Y~1)): (X&Y)~1  : 1        
      |          :          :          :          :          :          :          : (Y~1))~1 : (Y~1)    :          :          : ~1       :          : ~1       :          :          
------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------+----------
```

Comments on the table:

- Top shows all 16 boolean functions of two variables along with symbols we will use for them, alternative symbols that are often used, commonly used names, their truth tables etc.
- The *arity* row says how many arguments the function's output depends on.
- The *comm* and *assoc.* rows say if the function is [commutative](commutativity.md) (result is the same with swapped arguments) and [associative](associativity.md) (result doesn't depend on bracketing, i.e. order of evaluation) respectively.
- The *dual*, *neg.* and *adj.* say the dual function (equivalent via De Morgan's laws, i.e. its truth table is flipped vertically and negated), negated function (function that gives the same results, just negated) and adjoint function (function giving the same results if we flip the arguments, i.e. its truth table has the middle two rows flipped vertically) respectively.
- The bigger part of the table shows how the function is implemented when we're limited to any of the 26 existing functionally complete sets of functions (of course there exist many ways, here we show hopefully one of the most minimal expressions). This shows that we can implements ALL of the 16 functions using as few as one single function (NAND or NOR).
- Formally all functions here take exactly two input variables, but effectively some of them (namely !X, !Y, X, Y, 0 and 1) behave as [nullary](nullary.md) or [unary](unary.md) functions (have arity 0 or 1) because they ignore one or both inputs. Out of convenience we treat them accordingly in our notation, i.e. for example we'll write just `0` instead of `X0Y` or `!X` instead of `X!Y`, and consequently in our expressions we see `!` as a single unary function to which we feed just one argument, but just keep in mind that eventually `!` is actually secretly two functions: `!X` and `!Y`.
- Notice patterns in the table, i.e. that adjoint functions such as `<` and `>` use the same formula just with *X* and *Y* switched, that the negated function of a function is always the one that's mirrored by the table center etc.

## See Also

- [logic circuit](logic_circuit.md)
- [quantum gate](quantum_gate.md)
- [bit hack](bit_hack.md)

