# Logic

Logic (from Greek *logos* -- thought/reason/word) is the study of rational reasoning. Logic as such is a term very general -- there is common sense logic, philosophical logic, formal and [mathematical](math.md) logic, deductive and inductive logic, logic in [circuits](logic_circuit.md), [programming](programming.md), [fuzzy](fuzzy.md) logic and many other kinds of logic. Logic is closely intertwined with [mathematics](math.md) because mathematics is built on top of logic and adopts many of its tools and concepts, for example axiomatic systems, and in turn mathematicians help further develop deeper knowledge about logic with tools they obtained. As always, here we will focus mainly on logic from programmer's point of view.

TODO: moar stuff here, different orders of logic etc.

Formal logic is also usable as one of many **programming [paradigms](paradigm.md)** -- a typical example of logic programming language is [Prolog](prolog.md).

**Power of logic is limited** (for more please read this excellent resource: http://humanknowledge.net/Thoughts.html) -- though logic presents the strongest and most stable platform for knowledge to stand on, it is still not infinitely powerful and indeed does have its limits, despite what any reddit [atheist](atheism.md) tells you or even what he believes. This sadly [dooms](doom.md) us to certain eternal inability to uncover all there is, we are forced to accept that from a certain point we are completely blind and not even logic will help us see further. [Kurt Godel](godel.md) (along with others, e.g. Tarski) mathematically proved, with his [incompleteness theorems](incompleteness.md), that we simply won't be able to prove everything, not even the validity of formal tools we use to prove things. More specifically he showed that there must exist statements whose truthfulness we'll be fundamentally unable to ever prove OR disprove, that we'll forever remain in uncertainty about their truthfulness, and that we won't even be able to prove that what we CAN prove is indeed correct because we cannot prove the logic we used for the proof is correct (for more details please see also [knowability](knowability.md)). Even just in intuitive terms: on the lowest level we start using logic to talk about itself, i.e. if we for instance try to prove that "logic works" using logical arguments, we cannot ever succeed, because if we succeed, the proven fact that "logic works" relies on the fact that logic indeed works; if it perhaps doesn't work and we used it to prove its own validity, we might have simply gotten a wrong result (it's just as if we trust someone saying "I am not a liar", he may as well be lying about not being a liar). By this logic even the previous sentence may or may not actually be true, we simply don't know, sometimes the best we can do is simply hold on to stronger or weaker beliefs. Imagine we have a function *isTrue(x)* that automatically checks if statement *x* is true (returns *true* or *false*), now image we have statement *y* that says *isTrue(y) = false*; our *isTrue* function will fail to correctly evaluate statement *y* (it can't return neither *true* nor *false*, both will lead to contradiction) -- this is a proof that there can never be a computable function that in all cases correctly decides whether something is true or not. Logic furthermore cannot talk about many other things; it can tell us how the world works but not for example WHY it works like it does or whether it will ever start working differently. Checkmate [atheists](atheist.md).

## What Is Logic In Its Essence? How Universal Is It? And Other Mysteries

{ Thought diarrhea incoming, beware of unoriginal research. ~drummyfish }

Are laws of logic inherent to every kind of existence, constant and unchanging under all possible conditions or are they specific to our [Universe](universe.md) and something we simply learn empirically like anything else? Is logic fundamentally different from any other kind of knowledge or "skill"? I.e. it seems logical that for example if *A* implies *B* and *A* holds, *B* will hold too -- but does it always have to be so or is it just so around our specific spacetime coordinates and we simply LEARN this rule, accepting it as a general interdimensional law? It seems logical that putting two individual [rocks](rock.md) together forms a single pair of rocks, but maybe in another universe putting two rocks together forms three rocks -- would beings in this universe have different laws of logic and different mathematics? This is probably a great philosophical question we can't satisfyingly answer here, but quite likely it may be the case that such questions [cannot be answered](knowability.md) at all.

Indeed, what even is logic? It may be defined as a language, way of thought, the set of lowest level laws of [mathematics](math.md) and in many other ways, but how to grasp the true MEANING of what's logical and what isn't? Let us try to look at the problem from one possible perspective -- that of [computer science](compsci.md) -- and define logic as the most fundamental part of the [algorithm](algorithm.md) that our brains run, the most "basic code" for how a brain thinks. Logic to us is now just a "program" executed by our brains in order to make a decision in life (and note this will apply to computation in general without loss of generality, as computing any [number](number.md) can be broken down to deciding the value of its individual [binary](binary.md) digits). It is clear that each human's brain runs a slightly different algorithm due to different [DNA](dna.md), physical structure of brain matter, upbringing, life experience, learned biases and so on, meaning there are many problems that different humans solve (decide, compute, ...) differently. Logic is however the part of this grand algorithm that is somehow shared by at least MOST humans, i.e. it's that part of the algorithm that decides problems so that MOST humans will agree on the solution (because they share the "decision code" and so presented with the same input have to arrive at the same output). In this sense we might view logic as a "[BIOS](bios.md)" or perhaps an "[operating system](os.md)" that comes preinstalled in all brains and serves the purpose of a "platform", enabling us to acquire more knowledge ("install more software") -- it's a very universal code and so it's the same for (almost) everyone, and as the brains live, they use logic to deduce new knowledge, to "install" and "personalize" the whole brain software, but the basic code at the bottom remains, and that is logic. Now it is also clear that there are humans, whom we might call "insane" or "stupid", who use faulty logic or don't accept or understand basic logic, and the same probably goes for almost all animals -- these individuals simply have a different "base code" of logic. This is in line with the "you can't argue with a retard" rule, it IS impossible to force someone to believe logic if he simply refuses to, you can't logically prove your logic correct if you're using the very same logic for the proof.

Where did this "base code" in brain come from? It probably [evolved](evolution.md) like anything else: by natural selection. We, with the kind of logic we all use, are the result of nature's long trial and error process leading to organisms that survive and reproduce. In other words we could say that logic isn't anything magical and different from any other knowledge, but simply a "[good enough](good_enough.md)" universal algorithm, which when installed in an organism's brain leads to the organism surviving and thriving, mainly because this base code allows adaptation, deduction and acquiring of new [abstract](abstraction.md) knowledge. Note the term "good enough" however: it's used to show that our logic may indeed be faulty and fail sometimes, and like mentioned above, we cannot ever prove correctness of our own logic, we use it simply because "[it works](just_werks.md)" for us, but it may be the case that our logic would fail us in other parts of the universe, that we could mathematically prove a falsehood true. By this we can hypothesize that logic, like other very basic brain functions, is "preprogrammed" and "hard wired" in a newborn's brain, instilled by evolution, and that's why we all share logic and can agree on what's fundamentally logical. It could even theoretically be possible that our civilization's logic is incorrect and a mutation occurred in some lone human to use a different, CORRECT system of logic, but we see him as a schizophrenic and lock him up in an asylum, when he's in fact right and the whole world is wrong.

We don't know if our logic is always correct or not, we only know it's useful to us, but we DO know (from the incompleteness theorems) that our logic is limited and will be unusable to prove certain specific problems. And this immediately begs the question: is our logic the only possible one? Could there be an organism that would have evolved a different kind of logic, perhaps one that could prove the problems we cannot prove with our logic? All points to the answer that yes, this is possible, but then of course this new logic will have its own set of undecidable problems, ones that OUR logic may be able to decide. But wait -- if we met with the aliens with this kind of different logic, couldn't we collaborate on deciding ALL problems? Couldn't they solve our undecidable problem for us in return solving theirs? No, we couldn't understand each other's logic and we couldn't trust their solutions, it might well be that we meet aliens with faulty logic and the solutions they provide to us would be wrong -- remember, we couldn't verify correctness of solutions to our undecidable problems with our logic. This also make sense if we imagine us and the aliens forming a new metaorganism that uses a new kind of logic, or ALGORITHM, by merging our logic and the aliens' -- in the end a combination of algorithms is again a single algorithm and therefore must also suffer the curse of undecidablity etc. So to summarize:

- Our logic most likely came from evolution.
- We don't know if our logic is correct.
- We know it is useful and so we assume it's at least mostly correct.
- We know our logic is limited (won't be able to answer some questions).
- There can probably exist different systems of logic, similar to our own.
- Trying to use many different systems of logic together however won't help, in the end any merger is just a new logic with its own flaws.

DIGRESSION: Can we in fact be sure that our logic has limitations if arrived at this conclusion using this exact, potentially faulty logic? Indeed not, here we meet the ultimate uncertainty, eventually we cannot be sure of absolutely ANYTHING. By stating we are "sure" of anything here we merely mean we are "as sure as we can ever be" about anything, which nonetheless doesn't imply absolute certainty.

Let's now poke a bit on specific examples of different logic systems, demonstrated by a table:

| logic                                          | values                     | correct?            |
| ---------------------------------------------- | -------------------------- | ------------------- |
| ground truth (undecidable, answers everything) | `100110101100010011010...` | yes, by definition  |
| logic A (answers nothing)                      | `?????????????????????...` | yes, can't be wrong |
| logic B (always tries to give an answer)       | `011000111010011100010...` | no, can't be        |
| logic C (answers something)                    | `??????1????0?????0?1?...` | yes                 |
| logic D (negation of logic C)                  | `??????0????1?????1?0?...` | no                  |
| logic E (answers something)                    | `10010?101100?10011?10...` | yes                 |
| logic F (answers something)                    | `100?001011000100?1?10...` | yes                 |
| logic G (similar to logic F)                   | `100?011011001100?1?10...` | no                  |
| ...                                            | ...                        | ...                 |

The *logic* column lists a selection of possible logic systems (correct or not), and the first one is *ground truth*, i.e. the definitive correct answer to all decision problems, which however cannot be attained in our universe due to incompleteness theorems -- it serves here as a reference to compare other systems of logic to. The *values* column shows an answer to some subset of questions we might ask -- each question has a definitive answer `1` (true) or `0` (false), given by *ground truth*, but logic systems are allowed to also answer `?`, or "I don't know". This is very important because by definition ANY computable logic that always gives a definitive `1`/`0` answer, like *logic B*, HAS TO be wrong at least in some cases, and so the only systems that can be correct are those that sometimes admit they don't know the answer, i.e. output `?`. This proves *logic A* correct as that simply always answers `?`, it's practically equivalent to a lack of logic -- if you never answer, you can never be wrong. Then there is *logic C* that demonstrates this: it answers only a few questions but always correctly (maybe it's not very powerful and only limits itself to answering just very trivial questions). Our human logic could perhaps be *logic E*: it answers many questions but also doesn't know ALL of the answers, which is a prerequisite for correctness. The alien logic might be *logic F*, which is very similar and differs in (correctly) answering some of our (*logic E's*) questions, but for giving up the ability to answer something we can. Now note *logic G* that's almost the same as *logic F* -- it might be yet a different alien civilization logic -- it similarly answers some of our unanswerable questions, but WRONGLY, and this is why we can't trust the aliens: for us there is no way to decide if we should trust *logic F* or *logic G* on questions where their answers differ. And note here that *logic G* itself also can't know that it's incorrect, it's giving many correct answers but also a few wrong ones, and from evolutionary perspective this may not matter because they may be highly abstract questions unimportant for survival, and so it may well be the case that our logic is *logic G*: a good, useful logic, but sometimes a faulty one, and we locked a poor innocent man in an asylum.

## See Also

- [math](math.md)
- [philosophy](philosophy.md)
- [mindfuck](mindfuck.md)
- [epistemology](epistemology.md)
- [knowability](knowability.md)
- [science](science.md)