# Lines of Code

Lines of code (LOC, KLOC = 10K LOC, MLOC = 1M LOC etc., also SLOC = source LOC) is a [metric](metric.md) of [software](sw.md) [complexity](complexity.md) that simply counts the [number](number.md) of lines of program's [source code](source_code.md). It is by no means a [flawless](perfect.md) measure but despite some [soyboys](soydev.md) shitting on it it's actually pretty good, especially when using only one language ([C](c.md)) with consistent [formatting style](code_formatting.md). However it must also be used well -- here are the main caveats:

- **[Logarithmic](log.md) scale should be used**, i.e. rather than exact line count we should sort into categories such as: under 10 LOC, under 100 LOC, under 1000 LOC and so on.
- When you use it as a [productivity](productivity_cult.md) measure at [work](work.md), you're guaranteed your slave peasants are gonna just shit out as much meaningless code as possible in which case the measure crumbles under a spectacular fountain of code diarrhea and fails again. Here also the logarithmic scale doesn't make much sense, so basically using it as a performance measure just sucks. Fortunately, at [LRS](lrs.md) we don't have such problems :)
- Of course it also becomes [shitty](shit.md) when you have a project in 20 [programming languages](programming_language.md) written by 100 pajeets out of which every one formats code differently. This we also do not practice.

Of course it may also be necessary to define what a "line of code" means exactly. Usually we distinguish **raw lines** (every single one) and **logical lines** (only those that "matter", may exclude comments and empty lines). Does a long line with a line break count as a single line or two? Do we include line count of [libraries](library.md) we use? What if instead of lines we rather measured source code file size? Or programming language token count? Just make sure you know what you're measuring and why.

A comfy tool for counting lines is [`cloc`](cloc.md), but you can also just use `wc -l` to count raw lines.

Here are (sometimes very) approximate line counts for some programs written (mainly) in [C](c.md), in ascending order: [hello world](hello_world.md) (~5), [brainfuck](brainfuck.md) interpreter (~50), [Fairy-Max](fairy_max.md) chess (~1000), [raycastlib](raycastlib.md) (~2000), [dwm](dwm.md) (~2500), [SAF](saf.md) (~5000), [Anarch](anarch.md) (~15000), [tcc](tcc.md) (~25000), [Lua](lua.md) (~30000), [Doom](doom.md) (~35000), [Quake](quake.md) (~100000), [Pokemon](pokemon.md) Emerald (~500000), [OpenBSD](openbsd.md) (~10000000), [Linux](linux.md) (~30000000), [Windows](windows.md) XP (~40000000).