# Left Vs Right (Vs Pseudoleft)

Left and right are two basic opposing political sides and forces, roughly coming down to pro-equality (left) and pro-hierarchy (right). In politics the division to left and right is the most common and basic one despite very frequent disagreements about its meaning and significance. By [historical](history.md) point of view the terms *left* and *right* arose from the opposing sides at which members of national assembly physically sit during 1789 French revolution, however since then they evolved into possessing more generalized meanings of simply anti and pro hierarchy. Unfortunately there is a lot of confusion and vagueness about the terms, so let us now define them as used on [this wiki](lrs_wiki.md):

- The (true) **left is pro social equality**, i.e. against social hierarchies of any kind. This includes equality of all living beings, period. Note that social equality does NOT imply people being made (or being made to appear) equal in other ways, e.g. physically -- true left accepts difference between people and [races](race.md) and doesn't hide them. Even if the perfectly ideally leftist society can't be completely achieved, true left tries to get **as close to it as possible**. The values of true left are for example sharing, [love](love.md), [pacifism](pacifism.md), [selflessness](selflessness.md), [altruism](altruism.md), forgiveness, sharing and nonviolence. Groups and movements that are at least highly truly leftist include [anarcho pacifism](anpac.md), [veganism](veganism.md), [free software](free_software.md), [free culture](free_culture.md) and of course [LRS](lrs.md).
- The **right is pro social hierarchy**, i.e. against social equality. This means some people standing above others, be it by strength, power, wealth, social status, privileges etc. The rightist values are mostly those associated with [evil](evil.md), i.e. violence, oppression, conflict, war, revenge, survival of the fittest etc. Among rightism can be included [fascism](fascism.md), [capitalism](capitalism.md), US republican party, states, [military](military.md) etc. One of right's identifying features is **hypocrisy**, i.e. it judges what's good/bad only by against whom it is targeted, e.g. violence is bad when targeted against "us" ("those Muslims are bad, they want to kill us!") but good when targeted against "them" ("we have to kill those Muslims because they're violent!"); so animals killing humans is judged as "bad" but humans killing animals is "good". In other words right has no sense of morality, only the sense of [self interest](self_interest.md).
- The **pseudoleft** is pretending to be left while [in fact](de_facto.md) being right due to e.g. using non-leftist means (such as violence) or even having non-leftist goals (e.g. benefit of a specific minority as opposed to benefit of everyone). Among pseudoleftist movements are [feminism](feminism.md), [LGBT](lgbt.md), [Antifa](antifa.md) or [Marxism](marxism.md). This fact is also supported by the [naming](name_matters.md) of these movements.

There exists a "theory" called a *horse shoe*, stating that the opposite extremes of the left-right spectrum tend to be alike (violent, hating, radical, ...), just like the two ends of a horse shoe come closer together. This is only an illusion caused by ignoring the existence of pseudoleft. The following diagram truthfully illustrates the situation:

```
TRUE LEFT (peace, selflessness, forgiveness, ...)
     <-------------------.
               /          \
              |            |  <== illusion of horse shoe
              |            |
               \          /
                V        V
           PSEUDOLEFT  RIGHT
    (violence, conflict, aggressivity, ...)
```

We observe pseudoleft is something that commenced by going in opposite direction to the right, but slowly turned around back to approach the rightist values again, just from a slightly different direction. This is due to rightism being very easy and attractive, it offers tempting short-term solutions such as violence, and so it extorts a kind of magnetic force on every human -- most cannot resist and only very few manage to continue heading towards truly leftist values.

The current [US](usa.md)-centered [culture](culture.md) unfortunately forces a **right-pseudoleft false dichotomy**. It is extremely important to realize this dichotomy doesn't hold. Do not become [type A/B fail](fail_ab.md).

What's called *left* in the [modern](modern.md) western [culture](culture.md) usually means *pseudoleft*. The existence of pseudoleftism is often overlooked or unknown. It used to be found mainly in the [US](us.md), however globalization spreads this [cancer](cancer.md) all over the world. Pseudoleft justifies its actions with a goal that may seem truly leftist, such as "equality", but uses means completely unacceptable by true left (which are in fact incompatible with equality), such as [violence](violence.md), bullying, lynching, [cancelling](cancel_culture.md), [censorship](censorship.md) or brainwashing. Pseudoleft is aggressive. It believes that **"ends justify the means"** and that **"it's fine to bully a bully"** ("eye for an eye"). A pseudoleftist movement naturally evolves towards shifting its goals from a leftist one such as equality towards a [fascist](fascism.md) one such as a (blind) *fight for some group's rights* (even if that group may already have achieved equality and more).

While rightist are typically direct, open about wanting to fight and destroy, pseudoleft is extremely wicked, sneaky, hypocrite, using the lowest of evil tricks and tactics such as psychological tricks played on the young, it's the cowardly evil that silently poisons and spreads like a cancer while trying to look like the good guy. One such trick is for example abusing [shortcut thinking](shortcut_thinking.md): manipulating language and shifting meanings of words; for example where some historical figure argued for human "equality", in the sense of SOCIAL equality, i.e. valuing all people the same no matter their physical differences, pseudoleft slowly redefines "equality" to PHYSICAL equality and starts to argue PHYSICAL differences between people have to be eliminated, which is of course a completely dystopian idea, but which pseudoleft now argues was supported by the said historical figures. This works extremely well on young people who are defenseless against such sneaky tricks -- spotting this requires a lot of life experience that's impossible to be acquired during 18 years of life. See also for example [Hitlerjugend](hitlerjugend.md).

The difference between left and pseudoleft can be shown in many ways; one of them may be that pseudoleft always wants to **[fight](fight_culture.md)** something, usually the right (as they're essentially the same, i.e. natural competitors). True left wants to end all fights. Pseudoleft invents [bullshit](bullshit.md) artificial issues such as [political correctness](political_correctness.md) that sparks conflict, as it lives by conflict; it also uses manipulation, populism, rhetoric tricks and things such as abusing [idiot fallacies](idiot_fallacy.md) to push lies that simply gain it more power. Left tries to find peace by solving problems. Pseudoleft sees it as acceptable to do bad things to people who committed something it deems bad. True left knows that violence creates violence, it "turns the other cheek", it cures hate with love.

Pseudoleft is extra harmful by deceiving the public into thinking what it does really is leftist. Most normal people that don't think too much therefore stand between a choice of a lesser of two evils: the right and pseudoleft. True left, the true good, is not known, it is overshadowed. Let us now compare a few existing movements/ideologies/groups:

|                            | [LGBT](lgbt.md)   | [Feminism](feminism.md) | [Antifa](antifa.md) | [Nazism](nazi.md) | [MGTOW](mgtow.md) | [BLM](blm.md)       | [Marxism](marxism.md)| [LRS](lrs.md) |
| -------------------------- | ----------------- | ----------------------- | ------------------- | ----------------- | ----------------- | ------------------- | -------------------- | ------------- |
| class                      | pseudoleft        | pseudoleft              | pseudoleft          | right             | right?            | pseudoleft          | pseudoleft           | true left     |
| fights for                 | gay/bi/etc.       | women                   | antifa, pseudoleft  | own race/nation   | men               | black               | proletariat          | no one        |
| fights against             |straight, anti-LGBT| men, anti-Feminists     | right, anti-Antifa  | Jews, other r/n   | women             | non-black, anti-BLM | other classes        | no one        |
| motto                      | gay power!        | woman power!            | rebel power!        | white power!      | men power!        | black power!        | proletariat power!   | love everyone |
| official motive            | "social justice"  | "social justice"        | "self defense"      | "self defense"    | "self defense"    | "self. def.", ...   | superiority          | love          |
| bullying/violence?         | yes               | yes                     | yes                 | yes               | yes               | yes                 | yes                  | no            |
| fanaticism/hysteria?       | yes               | yes                     | yes                 | yes               | probably          | yes                 | yes                  | no            |
| propaganda/brainw./censor.?| yes               | yes                     | yes                 | yes               | probably          | yes                 | yes                  | no            |
|cults of personality/heroes?| yes               | yes                     | yes                 | yes               | yes               | yes                 | yes                  | no            |
| ends justify the means?    | yes               | yes                     | yes                 | yes               | probably          | probably            | yes                  | no            |

Why is there no pseudoright? Because it doesn't make sense :) Left is good, right is a sincere evil and pseudoleft is an evil pretending to be good. A good pretending to be evil doesn't probably exist in any significant form.

**Centrism** means trying to stay somewhere mid way between left and right, but it comes with issues. From our point of view it's like trying to stay in the middle of good and evil, it is definitely pretty bad to decide to be 50% evil. Another issue with centrism is that it is **unstable**. Centrism means balancing on the edge of two opposing forces and people naturally tend to slip towards the extremes, so a young centrist will have about equal probabilities of slipping either towards extreme left or extreme right, and as society polarizes this way, people become yet more and more inclined to defend their team. Knowing centrism is unsustainable, we realize we basically have to choose which extreme to join, and we choose the left extreme, i.e. joining the good rather than the evil.

{ I came to the realization that rightists are actually much more bearable than pseudoleftists -- it makes sense though, pseudoleft is like right, fascist, but with extra evil of added pretence and sneakiness. While rightists are at their core evil, they are actually many times tolerant as they often value free speech, so you can coexist with a rightist, he will tell you your opinions are stupid but he will let you share them, he is like that one friend who you disagree with but still can have a talk with. Yes, that's right, **a rightist is more tolerant than pseudoleftist**. I do by no means defend rightism, it is pure evil, but the fact that it seems bearable compared to pseudoleft says something about pseudoleft -- pseudoleft is just pure psychopathy. A rightist sometimes at least holds some values, for example he will respect your courage to stand behind an opinion you hold even if he hates it, a pseudoleftist has none of that, an SJW just has no emotion except for hate and rage, he has that soulless robotic stare with the word "EXTERMINATE" flashing before his eyes. You mention a trigger word and he bans you on all servers, you'll be lucky if he doesn't call for your public lynching. ~drummyfish }

## See Also

- [SJW](sjw.md)
