# Information

*Information wants to be free.*

Information (from Latin *informare*: shape/describe/represent) is knowledge that can be used for making reasonable decisions. Information stands for interpreted [data](data.md), i.e. while data itself may not give us any information, e.g. if it's [encrypted](encryption.md) with unknown key or if we simply have no clue what the data signifies or implies, information emerges once we make sense of the data (someone once placed information in this relationship: data leads to information, information leads to knowledge and knowledge leads to [wisdom](wisdom.md)). Information is contained e.g in [books](book.md), on the [Internet](internet.md), in nature, and we access it through our senses. [Computers](computer.md) can be seen as machines for processing information and since the computer revolution information has become the focus of our society; we commonly encounter terms such as [information technology](it.md), informatics, information war, information age etc. [Information theory](information_theory.md) is a [scientific field](science.md) studying information.

**Information wants to be [free](free_culture.md)** -- unlike any other kind of commodity it is free naturally unless we stupidly decide to limit its spread and exchange with [malice](shit.md) such as [intellectual property](intellectual_property.md) laws. What do we mean by "free"? That plain but miraculous property of information which allows us to duplicate it without any significant cost. Once we have certain information, we may share it with others without having to give up our own knowledge of the information -- **we give but suffer no loss**! Copying a file from one computer to another won't delete the file from the original computer. This is unlike with physical objects which if given to someone are lost to the giver. Imagine if you could make a piece of bread and then duplicate it infinitely for the whole world -- information works like this! We see it as a crime to want to restrict such a miracle. We may also very nicely store information in our heads. For all this information is [beautiful](beauty.md). It is sometimes discussed whether information is created or discovered -- if a mathematician comes up with an equation, is it his creation or simply his discovery of something that belongs to the nature and that has always been there? This question isn't so important because whatever terms we use, we at [LRS](lrs.md) decide to create, spread and freely share information without limiting it in any way, i.e. neither discovery nor invention should give rise to any kind of [property](property.md).

[Capitalists](capitalism.md) try to destroy the miracle of information, they try to treat it as "property", censor it, criminalize sharing, and they will literally kill people. For just downloading academic papers [Aaron Swartz](aaron_swartz.md) was sentenced to 35 (!!!) years in human cage, after which he unsurprisingly ended up committing [suicide](suicide.md). Meanwhile [Anders Breivik](breivik.md) who intentionally killed 77 people, mostly young and children, is serving just 21 years, and Kaylee Whitehall who stabbed a man to death got just 4 years. That's the world we live in. { Thanks to a friend for this info. ~drummyfish }

In [computer science](compsci.md) the basic unit of information amount is 1 **[bit](bit.md)** (for *binary digit*), also known as [shannon](shannon.md). It represents a choice of two possible options, for example an answer to a *yes/no* question (with each answer being equally likely), or one of two [binary](binary.md) digits: 0 or 1. From this we derive higher units such as [bytes](byte.md) (8 bits), [kilobytes](memory_units.md) (1000 bytes) etc. Other units of information include [nat](nat.md) or [hart](hart.md). With enough bits we can encode any information including text, sounds and images. For this we invent various [formats](file_format.md) and encodings with different properties: some encodings may for example contain [redundancy](redundancy.md) to ensure the encoded information is preserved even if the data is partially lost. Some encodings may try to hide the contained information (see [encryption](encryption.md), [obfuscation](obfuscation.md), [steganography](steganography.md)). For processing information we create [algorithms](algorithm.md) which we usually execute with [computers](computer.md). We may store information (contained in data) in physical media such as [books](book.md), computer [memory](memory.md) or computer storage media such as [CDs](cd.md), or even with traditional potentially [analog](analog.md) media such as photographs.

Keep in mind that the **amount of physically present bits doesn't have to equal the amount of information** because, as mentioned above, data that takes *N* bits may e.g. utilize redundancy and so store less information that would theoretically be possible with *N* bits. It may happen that the stored bits are [correlated](correlation.md) for any reason or different binary values convey the same information (e.g. in some number encodings there are two values for number zero: positive and negative). All this means that the amount of information we receive in *N* bit data may be lower (but never higher) than *N* bits, i.e. if we e.g. store a file on a 1 GB flash drive, the actual theoretical information contained may be lower -- the exact size of such theoretical information depends on probabilities of what can really appear in the file and MAY CHANGE with the knowledge we posses, i.e. the amount of information stored on the flash drive may change by simply us coming to know that the file stored on the drive is a movie about cats which rules out many combinations of bits that can be stored there. Imagine a simplified case when there is file which says whether there exists infinitely many [prime numbers](prime.md) -- to a mathematician who already knows the answer the file gives zero information, while to someone who doesn't know the answer the file provides 1 bit of information. However in practice we often make the simplification of equating the amount of physically present bits to the contained "information".

Information is related to **information [entropy](entropy.md)** (also Shannon entropy, similar to but distinct from the concept of thermodynamic entropy in physics); they're both measured in same units (usually [bits](bit.md)) but entropy measures a kind of "uncertainty" or average information received from a certain event when we know its probability distribution -- in a sense information and entropy can be seen as opposites: before we receive information we lack the information but there exists entropy, once we receive the information there is information but no entropy.

In signal theory information is also often used as a synonym for **[signal](signal.md)**, however a distinction can be made: signal is the [function](function.md) that carries information. Here we also encounter the term **[noise](noise.md)** which means an unwanted signal mixed in with the desired signal which may make it harder to extract the information carried by the signal, or even obscure some or all of the information so that it can't be retrieved.

According to the [theory of relativity](relativity.md) **information can never travel [faster than light](speed_of_light.md)** -- even if some things may move faster than light, such as a shadow, so called "spooky action at a distance" (usually associated with quantum [entanglement](entanglement.md)) or even matter due to the expansion of space, by our best knowledge we can never use this to transfer information faster than light. For this it seems our communication technology will always be burdened by [lag](lag.md), no matter how sophisticated.

## See Also

- [data](data.md)
- [wikidata](wikidata.md)