# HTML

HTML, short for *Hypertext Markup Language*, is a relatively simple [computer](computer.md) language for describing documents with hyperlinks ("clickable pointers to other such documents"), serving to create websites on the [World Wide Web](www.md). This makes it **the most basic language of the web**, it's a text format in which websites are sent over the [Internet](internet.md). HTML is **NOT a [programming language](programming_language.md)**, just one for describing documents -- it contains the text of the website along with special tags marking parts of it as paragraphs, heading etc. **HTML is easy!** Even [women](woman.md) can learn it.

By traditional definitions **HTML is NOT a [programming language](programming_language.md)** because it doesn't express [algorithms](algorithm.md), only a structure and content of a document (webpage), so boasting about being an "HTML programmer" results in nothing but cringe and embarrassment. HTML webdevs are therefore NOT necessarily programmers. Going by a more liberal definition of a "programming language" (such as that of the [esolang](esolang.md) wiki) a 200 [IQ](iq.md) nerd can claim HTML is ACKCHUALLY a programming language of a very odd sort, specifically a [declarative](declarative.md) one that's not [Turing complete](turing_completeness.md). But that's like stretching the definition of "[music](music.md)" to include any kind of audible noise, like farting for example, so that anyone who farts can be called a musician.

**[History](history.md) and context**: HTML emerged as a part of the [world wide web](www.md) framework created circa 1990 by Tim Berners-Lee. Later on it got standardized every once in a few years or so; the latest standard is HTML5 from 2014. In [syntax](syntax.md) HTML is of resemblance to another widely popular language called [XML](xml.md). This is due to both languages descending from [SGML](sgml.md), a standard for markup languages. HTML and XML differ, however, in both syntax and semantics (unlike with XML, HTML tags are case insensitive, closing tags aren't required, semantics of tags is predefined etc.), and so in general HTML and XML require different [parsers](parser.md) and [libraries](library.md). There was once an effort to make a version of HTML conforming to XML rules, so called [XHTML](xhtml.md), but it was kind of fruitless as hardly anyone adopted it.

HTML can be (and often is) intermixed with other web languages, namely [CSS](css.md) and [JavaScript](javascript.md). As we know, JavaScript is a [shitty](shit.md) retarded [scripting](script.md) language for embedding sneaky, automatically executed programs to the HTML document, such as [crypto](crypto.md) miners, [keyloggers](keylogger.md), [bloat](bloat.md) and other [malware](malware.md), so good programmers consider use of JavaScript a very bad practice, so henceforth we'll just ignore it. CSS serves to give the HTML document a specific visual style, for instance specify concrete [fonts](font.md), background [color](color.md), paragraph spacing etc. In its beginning HTML actually contained its own ways for manipulating the visual appearance of the document (and for backwards compatibility still does), but later on a new [paradigm](paradigm.md) was adopted, stating that HTML should only define the "structure and content" of the document, while its appearance would be dictated separately by another language. CSS is crap too, but using it correctly and moderately is justifiable, i.e. as long as the CSS is light and the document stays fine when the style is removed, everything's cool.

**Is HTML [bloat](bloat.md)? Is it acceptable?** By a strict measure it's neither the most [minimal](minimalism.md) language, nor the most elegant one, but it definitely leans towards the more [KISS](kiss.md) part of the spectrum. I.e. it is completely acceptable and usable, especially when limited to a subset of most commonly used tags. A nicely made HTML can relatively easily be auto-converted to other formats too, so in the end it doesn't matter too much whether a document is in HTML or Markdown or whatever. Unfortunately the vast majority of websites nowadays are not a nice HTML, but this is due to retarded [soydevs](soydev.md). HTML's advantage is mainly in its [historical](history.md) status as the most widely supported common denominator of the web -- a plain HTML page can be viewed in EVERY web browser, and of course in the end it's even human readable. HTML is incomparably simpler and more [sucklesss](suckless.md) when contrasted with formats such as [PDF](pdf.md), [Latex](latex.md) or MS Word, but formats such as [Markdown](md.md) or even plaintext [ASCII](ascii.md) [txt](txt.md) are indeed yet a lot simpler and more often than not objectively better than HTML. Full HTML compliance is bloat of course, but the same probably holds even for Markdown. To sum up: using HTML is cool if we do it well.

Back in the day webdevs used to write all HTML manually, nowadays [soydevs](soydev.md) use various filthy cancerous "frameworks" that do everything for them and that's why typical websites today take such magnificent amounts of memory and bandwidth. Of course this is retardation, we want to do it the old way. The [small web](smol_internet.md) community already recognized this as well, a few already start to revert back to manually written pages, but our numbers are still small.

## Example

HTML is literally easy as [fuck](fuck.md), here's more or less how it works:

The whole glorious HTML document (webpage) is in fact just a text file with *.html* extension. So to make a page create an empty file, name it *mypage.html* (or something) and open it with a [text editor](text_editor.md) ([gedit](gedit.md), [vim](vim.md), [emacs](emacs.md) or what have you), then start editing. To see the result just open the file simultaneously in any [web browser](web_browser.md) (drag-and-drop should [just work](just_werks.md)), then after every edit just refresh the page. NOTE: default page on a website is always named *index.html*, so name your main page like this.

PRO TIP: When you're done making the page, always validate it! Browsers tolerate errors and will show the page even if it's faulty, but stupider browsers may not handle it, so you want to make sure there are actually no errors. Just look up "HTML validator" on the web.

Now for the content of the HTML itself. The language works with so called **tags**. A tag named *abc* starts with `<abc>` and ends with `</abc>`, potentially having some text in between, for example `<abc> something </abc>`. Tags can also have attributes, e.g. `<abc something="somevalue">`. The names of tags and their possible attributes are predefined, they can be looked up on the Internet, but most of the important ones are demonstrated by the example below. Tags may also be nested and some may not require an end tag. White spaces don't matter, so you can indent the code however you like. Multiple whitespaces in text will be reduced to just one space, so you can break longer text to multiple lines. That's basically it. The rest will be demonstrated by an example (just copy paste it and play around with it):

```
<!DOCTYPE HTML>        <!-- Must be here so that programs know this is HTML. -->

<!-- This is a comment, programs ignore it. You can sign yourself here etc. -->

<html>                                     <!-- Must be here. -->
  <head>                                   <!-- Holds meta information. -->
    <title> Cool Site </title>             <!-- Name (for bookmarks etc.). -->
    <meta charset="utf-8">
  </head>
  
  <body>                                   <!-- Actual content goes here. -->
    <h1> Awesome Webpage </h1>             <!-- Level 1 heading (biggest). -->

    <p> Welcome to this amazing page. </p> <!-- Paragraph of text. -->

    <p>
      Another paragraph with more text. It can span
      multiple lines, all will be displayed as a
      continuous text.
    </p>

    <br>                                   <!-- Adds a newline. -->

    <p>
      What if we want to render the less than/greater than symbols? it's done
      like this: &lt; &gt;.
      <b>This text is bold</b> and <i>this one is italics</i>.
      <a href="https://www.tastyfish.cz">This</a> is a link to some other page.
      And <a href="#morestuff">this</a> links to a heading below.
      We can also create<sub>subscripts</sub> and<sup>superscripts</sup>.
      Now let's include an image of a cat:
    </p>

    <img src="https://opengameart.org/sites/default/files/catfree.png" alt="cat image">

    <h2 id="morestuff"> More Stuff </h2>  <!-- Level 2 heading (smaller). -->

    <table>
      <tr> <th> column 1 </th> <th> column 2 </th> </tr>
      <tr> <td> value 1  </td> <td> value 2  </td> </tr>
      <tr> <td> value 3  </td> <td> value 4  </td> </tr>
    </table>

    <hr>                                  <!-- Horizontal line. -->

<pre>
Preformatted text, usually used for code and ASCII
art. Will use monospace font and preserve all
whitespaces, which is why we can't indent it like
the other stuff.
</pre>

  </body>
</html>
```

## See Also

- [Markdown](markdown.md)
- [json](json.md)
- [PDF](pdf.md)
- [XML](xml.md)
- [txt](txt.md)
- [www](www.md)
