# Future-Proof Technology

[Future](future.md)-[proof](proof.md) [technology](technology.md) is that which is very likely to stay functional for a very long time with minimal to no [maintenance](maintenance.md), even assuming significant changes in state of technology and society as a whole. In a world of complex, ever changing technology, such as that of [computers](computer.md), this feature is generally not easy to achieve, but [today's](21st_century.md) [consumerist](consumerism.md) society makes all yet much worse by focusing on immediate profit without long-term planning and by actually aiming to MITIGATE long lasting technology via [planned obsolescence](planned_obsolescence.md), by introducing [bloat](bloat.md), intentional complexity and [obscurity](obscurity.md), incompetent developers, unnecessary [dependencies](dependency.md) and [update culture](update_culture.md). With good approach, such as that [we](lrs.md) are advocating, future-proof technology is absolutely possible to be achieved. It doesn't have to be the case that programs rot like food.

A [truly good technology](lrs.md) is trying to be future-proof because that of course saves us the high (and unnecessary) costs of maintenance and reinventing wheels and by this gives its users comfort from being an ever updating slave and safety from the threat of losing their tools; users of future-proof technology know they can build upon it without fearing it will suddenly break.

Despite the godawful situation in the mainstream not all hope is lost, at least for those staying away from the mainstream. At least in the world of [software](software.md) future-proofing can be achieved by:

- [Free (as in freedom) software](free_software.md) -- making source code available, legally modifiable and shareable is a basic step towards making it easy to repair, backup and adopt to new technology (e.g. compile for a new [CPU](cpu.md) architectures etc.). 
- Building on top of already well established, time-tested and relatively [simple](kiss.md) technology such as the [C language](c.md) or [Forth](forth.md). Choosing to use the older standards with fewer features helps greatly as the less feature-rich versions of languages are always better supported (for example there are many more C89 compilers than C17 compilers) and can even be relatively simply reimplemented if needed. Another example is e.g. [OpenGL](opengl.md) -- you should use the oldest (simplest) version you can settle for in order to make a program more future proof.
- Minimizing [dependencies](dependency.md) to absolute bare minimum and offering alternatives and [fallbacks](fallback.md) in cases where you can't avoid introducing a dependency (e.g. you should always offer an option for [software rendering](software_rendering.md) in any program that by default uses [GPU](gpu.md) for 3D graphics). Dependencies are likely the single biggest cause of software death because if one of your hard dependencies dies, you whole [project](project.md) dies, and this applies [recursively](recursion.md) for all of the dependencies of the dependencies etc. This usually means software [libraries](library.md) but also goes for other software such as [build systems](build_system.md) and also [hardware](hardware.md) dependencies such as requiring [GPU](gpu.md), [floating point](float.md), special CPU instructions etc.
- Practicing [minimalism](minimalism.md) and reducing complexity which minimizes the maintenance cost and therefore raises the probability of someone being able to fix any issues that arise over time (see also [freedom distance](freedom_distance.md)). Minimalism is necessary and immensely important, [bloat](bloat.md) makes a program very prone to dying as that will depend on a large community of programmers that maintain it and such community will itself always be very prone to disappearing (internals disagreements, stopped funding, loss of interest, ...).
- Making your program [portable](portability.md) -- this ensures your program can be adapted to new platforms and also that you use [abstractions](abstraction.md) that untie you from things such as hardware dependencies (be careful with abstraction though, too much of it is bad as well).
- Generally just avoiding the hyped "[modern](modern.md)" "feature-rich" ([bloated](bloat.md)) technology arising from the consumerist market or mainstream places such as [GitHub](github.md). Stick to ancient software.
- Aiming to [finish](finished.md) the program, avoiding [update culture](update_culture.md), practices and mindset of "modern" software developments.
- ...

Just **think**: in order to reveal how likely your program is to live a short life just ponder for a moment: what parts is it composed of and what are the probabilities of any one stopping to work? How easy will it be to fix the ones that break? It's like with a car or a house. Observe that probability of breaking increases with complexity and effort required for a fix increases with simplicity (because a fix has a higher cost: needing more time, energy, skill and so on). Is the program written in a simple language already supported by 20 compilers and which can be reimplemented in a month if needed? Then it's likely not endangered by the threat of compiler death or death of anything that would kill the compiler itself such as a different [operating system](os.md) or a new CPU architecture. Is it written in a 5 year old language that's still changing under your hands, has a single compiler and which itself relies on 100 highly complex libraries?  The bells already toll for your program, it's almost certain it will break with the next update of the language, or the one after that, you'll have to be around to fix and update, and then a month later and then another month and so on until your own death, for every program you have written in this language. Does your program only need two [libraries](library.md), both of which can easily be drop-in replaced by something else? Congratulations, your program won't die by the hand of a library! Does your program use 10 very convenient but highly complex libraries, each of which additionally boasts a dependency on 10 other libraries itself? In a simplified way you can see your program depending on 100 other libraries now, if a chance of one such library breaking during one year is 1%, the chance of your program breaking in one year is 1 - 0.99^100 ~= 63%; if it doesn't break this year, then the next or the one after that -- yeah, someone will likely fix a library that breaks, but maybe not, projects get abandoned due to financial issues, burnouts, boredom, developer conflicts, in favor of new ones etc., and a fix of your dependency may also come with the need for you to be around and update your own program because of [API](api.md) change. Does your program depend on a piece of consumerism hardware that's planned to be replaced ("modernized") in two years? Or some specific operating system or Internet service posing similar dangers? This is additional danger on your watch list. If your program is broken without you being around, how likely will it be fixed by someone else? How many people in the world will be capable and willing to fix it? If the program is simple, likely any average programmer can do it in 10 minutes, someone will most likely do it just out of boredom. If your program is 100 thousands [lines of code](loc.md) long, requires knowledge of 10 specific framework APIs and its inner architecture looks like a space station, average programmer won't ever be able to fix it, he won't even attempt it -- if there is someone able to do the job, he won't fix it unless someone pays him a fortune. Your program is basically already dead.

Below is a table showing how the newest, hyped technology is usually the one to avoid:

| technology          | description                                                                                         | born           | dead                          |
| ------------------- | --------------------------------------------------------------------------------------------------- | -------------- | ----------------------------- |
| [Lisp](lisp.md)     | programming langauage                                                                               | 1960           | not before you                |
| [Forth](forth.md)   | programming langauage                                                                               | 1970           | not before you                |
| [C](c.md)           | programming langauage                                                                               | 1972           | not before you                |
| Objective-C         | C++ but owned by a corporation, everyone start using this!                                          | 1984           | 2014 (officially)             |
| RPG maker           | Easily make RPG games just by clicking your mouse!                                                  | 1992           | basically a zombie            |
| Java Applets        | Make platfotm-independent games and web "apps", a comfortable platform to unify them all!           | 1995           | 2017 (officially)             |
| Delphi              | Comfortable IDE for rapid development of GUI "apps", a platform to unify them all!                  | 1995           | on deathbed                   |
| J2ME                | Make mobile games with this multiplatform framework to unify them all!                              | 1999           | 2015 (de facto)               |
| Adobe Flash         | Make impressive interactive games and web "apps", a comfortable platform to unify them all!         | 2007           | 2020 (officially)             |
| Facebook Apps       | Easily make web "apps", a comfortable platform to unify them all!                                   | 2007           | 2020 (de-facto)               |
| Blender Game Engine | Easily make 3D games without even knowing any programming, comfortable platform to unify them all!  | 2000           | 2019 (officially)             |
| Unity 3D            | Easily make multiplatform 3D games!                                                                 | 2005           | currently dying               |
| JavaScript + React  | Easily make impressive web "apps"!                                                                  | 2013           | surely won't die, right?      |
| Godot Engine        | Easily make multiplatform 3D games!                                                                 | 2014           | surely won't die, right?      |

## See Also

- [finished](finished.md)
- [sustainability](sustainability.md)
- [portability](portability.md)
- [software death](sw_death.md)
- [future](future.md)
- https://unixsheikh.com/articles/how-to-write-software-that-will-keep-working-for-decades.html
- [idiotproof](idiot_proof.md)
