# Freedom

*Only when man loses everything he becomes actually free. Freedom is about letting go.*

Freedom denotes the possibility to act as one desires without suffering negative consequences. The opposite of freedom is [slavery](slavery.md) (being forced to do what one doesn't want to do). Clearly the word *freedom* is so vague, general and [culturally](culture.md) significant that whole libraries could be filled up to the roof only with books exploring this single concept. Aiming to describe what the word means in general we could say freedom is the size of the [set](set.md) of options an entity has available to freely choose from at given moment: the fewer option there are, the less freedom it has. Very important in this is to realize that options which are formally available but [de facto](de_facto.md) excluded must be treated as unavailable as long as we're interested in REAL freedom, as opposed to just "freedom on paper", i.e. if for example one has the legal right ("freedom") to criticize a mafia boss but the option is de facto excluded because doing so will lead to one being killed by mafia, there is no REAL freedom to criticize the mafia boss -- the freedom is only illusory.

[Freedom](freedom.md) is an essential value of [less retarded society](less_retarded_society.md) which aims to bring happiness to all [life](life.md): a living being having many choices can choose the one it really likes, as opposed to an enslaved life form which [has to do](work.md) a thing it most likely dislikes.

From its definition we can reason that **freedom can almost be equated with [minimalism](minimalism.md)** and those searching genuine freedom find themselves on the path towards minimalism. At first the reason may seem unclear and obscured by our primitive desire for satisfying needs, at first we tend to think of freedom as MAXIMIZING consumption and property to bring ever more pleasure and satisfaction of craving, but this couldn't lead us further from the truth. In fact freedom and minimalism are inevitably connected: minimalism stands for [needing](dependency.md) little; needing something enslaves us by FORCING us to satisfy the need and freeing ourselves of the need gives us the extra choice: to do something or not to do it, as it is now no longer obligatory. Therefore minimalism implies more choice and so, by definition, more freedom. Minimalism is not about having little, but needing little; a minimalist doesn't own a car or luxury house not because he couldn't achieve one, but because it's pointless to do so, just as it's pointless to buy things that will never be of any use or value. In the same fashion minimalist technology offers more choice: more people can understand it, repair it, improve it; minimalist software is less demanding and so there is more choice of where it can be installed and used, it is smaller so there is more choice in how to share it (unlike big software it may be shared via floppy disk, low bandwidth connection or even on paper), and so on. It is only natural that people who seriously look for attaining mental/spiritual freedom have often resorted to [asceticism](asceticism.md), at least for a period of time ([Buddha](buddha.md), [Diogenes](diogenes.md) etc.) -- this is very commonly not done with the intent of actually giving up all materialistic pleasures forevermore, but rather to let go of the [dependency](dependency.md) on the them, to know and see that one really can live without them if needed so that one becomes less afraid of losing them, which is often what internally enslaves us. It's a way for attaining minimalism. Without even realizing it we are nowadays addicted to many things (games, social media, overeating, shiny gadgets, ...) like an alcoholic is to booze; it is not necessarily bad to drink alcohol, but it is bad to be addicted to it -- to free himself the alcoholic needs to abstain from alcohol for a long period of time. Our chains are often within ourselves: for example we often don't have the freedom to say what we want to say because that might e.g. ruin our career, preventing us from enjoying our expensive addictions -- once we don't worry about this, we gain the freedom to say what we want. Once you rid yourself of fear of jail, you gain the freedom to do potentially illegal things, and so on. Additionally going through the experience of letting go of pleasures very often opens up your eyes and mind, new thoughts emerge and one reevaluates what's really important in life.

By the same reasoning we'll find that **[generalism](generalism.md) and self sufficiency** increase freedom because, once again, they decrease dependence and reliance on others, opening up more possibilities and becoming harder to enslave. If one can grow own food, he can still choose to work and buy food for money he makes, but he also has up his sleeve the option to stop working and make his own food if for example the employer starts to abuse him, force him to work more for less money etc. So just BEING self sufficient alone may force the employer to treat the employee better, seeing he HAS the card and could leave if treated badly; a specialized robot however has no other option than to accept whatever conditions the employer establishes -- he is a slave. This is why [capitalism](capitalism.md) pushes people towards specialization: specialization comes at the cost of abandoning generalism and self sufficiency, making the individual depend completely on the system, becoming slave and someone who will be very easily blackmailed -- if you don't do what the system wants, you won't get what you need to live.

**Solitude** is associated with freedom too, and naturally so: not only does it help with becoming more self sufficient and less limited by other people (who naturally limit what we can do even just by their presence, removing some of our freedom), but most importantly it removes distraction, which helps meditation, attaining a more detached and objective view of reality, realizations of what is truly necessary and what isn't. People such as Christopher Knight, who voluntarily spent 27 years in complete solitude, said it clearly: "I was absolutely free". A common folk doesn't have to go as far as spending several decades in absolute isolation, but probably everyone should go through shorter periods of solitude at least a few times a year.

**In society it is impossible to have freedom while also safely ensuring it won't be abused at the same time.** You have to choose one or the other.

**Freedom implies elimination of responsibility.** Beginners often erroneously think that freedom must come with responsibility, but investing about a minute of thinking reveals the opposite is in fact true. Responsibility implies punishment for bad decisions, even if the punishment is only internal (feeling bad about what one has done etc.) and a threat of punishment for some decision effectively removes the option, i.e. ad absurdum responsibility is like having a man pointing gun at you, saying "don't you dare do A, or else" -- you are not physically prevented from doing A, but the threat effectively makes you not be able to choose A, reducing freedom. The logic of "freedom with responsibility" therefore argues that for example people under oppressive totalitarian regimes have [freedom of speech](free_speech.md) because their mouth is not physically sewed shut to prevent them from speaking, they can really say anything they want, they just have to accept they will be executed along with their whole family if they say something bad. Establishing responsibility therefore only means making external enslavement into internal enslavement.

NOTE: One may ask how will [LRS](lrs.md) deal with the above? If we argue for true freedom, do we argue for feeling no responsibility even for things like murder etc.? The answer is basically this: to make people not do bad things don't remove their freedom to do bad things, keep their freedom to do anything while making them want to choose to do good things.

Freedom is something promised by most (if not all) ideologies/movements/etc.; this is because without further elaborating on the definition, the term is so broad it says very little -- as a matter of fact, of course, **there is no such thing as general freedom**; one kind of freedom restricts other types of freedom -- for instance the so called "freedom of market" allows a rich capitalist the "freedom" to do whatever he desires, which leads to him enslaving people, taking freedom away from these people. **Wrong understanding of freedom (present especially in the [USA](usa.md)) -- also pseudofreedom -- is that of "law of the jungle**, i.e. letting everyone just follow [self interest](self_interest.md) by any means necessary -- this is just tyranny of self interest and those strong enough to enforce their self interest on the detriment of others. In such society most people can NOT do whatever they want because they're FORCED (perhaps not by law but [de facto](de_facto.md) e.g. by [fear](fear_culture.md) and physical oppression) to do the bidding of the stronger. Therefore this by definition NOT real freedom, it is the rule of the strong, no different from any other kind of dictatorship. It is what eventually results in the strongest becoming absolute ruler who starts writing down orders (which at this point will be called "[laws](law.md)") enforced by his personal army (which will be called [police](police.md), [justice](justice.md) system etc.). Real freedom means lawlessness which however MUST also be rid of self interest and principles of the jungle -- [less retarded society](less_retarded_society.md). Only then will everyone be as free as possible: though it's impossible to ensure that everyone would always be able to do whatever it is he wishes to do without restricting the freedom of others, it is possible to maximize this kind of freedom, to get very close to the situation when mostly one CAN do whatever it is he wishes to do.

What kind of freedom is [LRS](lrs.md) interested in? Basically the freedom for living beings to do what makes them happy -- of course this can't be achieved 100% (if one desires to enslave others, their freedom would disappear), however we can get very close (make a [society](less_retarded_society.md) in which people don't wish to enslave others). For this goal we choose to support such freedoms as [free speech](free_speech.md), [free software](free_software.md), [free culture](free_culture.md), free love etc.

## See Also

- [free software](free_software.md)
- [free culture](free_culture.md)
- [FreeDoom](freedoom.md)
- [freedom distance](freedom_distance.md)
- [slavery](slavery.md)