# Free Will

*You can do what you want, but you can't want what you want.*

Free will is a [logically](logic.md) erroneous [egocentric](egoism.md) belief that humans (and possibly other living beings) are special in the [universe](universe.md) by possessing some kind of "soul" which may disobey laws of [physics](physics.md) and somehow [miraculously](magic.md) make spontaneous, unpredictable decisions according to its "independent" desires. Actually that's the definition of *absolute* *indeterminate* free will; weaker definitions are also possible, e.g. *volitional free will* means just that one's actions are determined internally, or for the purposes of law definitions based on one's sanity may be made. But here we'll focus on the philosophical definition as that's what most [autism](autism.md) revolves around. The Internet (and even academic) debates of free will notoriously reach unbelievably retarded levels, similarly to e.g. debates of [consciousness](consciousness.md) (which is a similar, but separate and distinct concept).

{ Sabine nicely explains it here [https://yewtu.be/watch?v=zpU_e3jh_FY](https://yewtu.be/watch?v=zpU_e3jh_FY). Amlux recently published an excellent commentary on determinism and free will: [https://inv.nadeko.net/watch?v=opjVNbCvaGw](https://inv.nadeko.net/watch?v=opjVNbCvaGw) which even has a text version: [https://pantsuprophet.xyz/writings/essays/along-for-the-ride.html](https://pantsuprophet.xyz/writings/essays/along-for-the-ride.html). ~drummyfish }

The question of free will typically comes up during discussions related to **[determinism](determinism.md)**, the concept of everything (including human thought and behavior) being completely predetermined from the start of the universe. Determinism is the most natural and most probable explanation for the working of our universe; it states that laws of nature dictate precisely which state will follow from current state and therefore everything that will every happen is only determined by the initial conditions (start of the universe). Without any doubt, as human brain is just matter like any other, it is no exception to the laws of nature. Determinism doesn't imply we'll be able to make precise predictions (see e.g. [chaos](chaos.md) or [undecidability](undecidability.md)), just that all is essentially already set in [stone](rock.md) as a kind of unavoidable fate. The only alternative option to this is that there would exist some kind of "true [randomness](randomness.md)", i.e. that laws of nature don't specify an exact state to follow from current state but rather multiple states out of which one is "taken" at random -- this is proposed by some [quantum](quantum.md) physicists as quantum physics seems to be showing the existence of inherent randomness. Nevertheless **quantum physics may still be deterministic**, see the theory of hidden variables and [superdeterminism](superdeterminism.md) (no, Bell test didn't disprove determinism). But **EVEN IF the universe is non deterministic, free will still CANNOT exist**. And thus the whole debate is meaningless.

**Why is there no free will?** Because it turns out to not be logically possible, just as for example the existence of omnipotent God shows to be logically impossible (could he make a toast so hot he wouldn't be able to eat it?). Either the universe is deterministic and your decisions are already predetermined, or there exists an inherent randomness and your decisions are determined by a mere dice roll (which no one can call a free will more than just making every decision in life based on a coin toss). In the end it's even unknowable to us whether true randomness exists or if we're simply missing some hidden variables or lacking computational power to perfectly predict the future, this question pertains to metaphysics and whatever the answer might be, it doesn't even matter to our case, we know randomness exists because we cannot predict the future, the mechanisms behind randomness (our inability to predict future) are irrelevant. In either case your decisions are made for you by something "external". Even if you follow a basic definition of free will as "acting according to one's desires", you find that your decisions are DETERMINED by your desires, i.e. something you did not choose (your desires, which are determined by your DNA and your environment) makes decisions for you. There is no way but rejection of logic itself.

For some reason retards (basically everyone) don't want to accept this, as if accepting it changed anything, stupid [capitalists](capitalism.md) think that it would somehow belittle their "achievements" or what? Basically just like the people who used to let go of geocentrism. This is ridiculous, they hold on to the idea of their "PRECIOOOOUUUSS FREE WILL" to the death, then they go and consume whatever a TV tells them to consume. Indeed one of the most retarded things in the universe. 

Similarly free will is neither a logical consequence for nor a prerequisite of consciousness. There can be consciousness without free will (wherein the conscious soul is just a spectator, like a train passenger looking out of the window) -- this is to say that consciousness isn't, as some think, a proof of free will. Consciousness is a metaphysical concept and the presence of consciousness (or lack thereof) in others can never be proven by [science](science.md), it is knowledge unobtainable within our universe.

## See Also

- [anthropocentrism](anthropocentrism.md)
- [snowflake](snowflake.md)
- [magic](magic.md)
- [determinism](determinism.md)
- [consciousness](consciousness.md)
- [ai](ai.md)