# Frameless Rendering

Frameless rendering is a technique of [rendering](rendering.md) animation by continuously updating an image on the screen by updating single ([pseudo](pseudorandomness.md))[randomly](randomness.md) selected [pixels](pixels.md) rather than by drawing a quick succession of whole discrete frames. This is an alternative to the [mainstream](mainstream.md), typically [double buffered](double_buffering.md) frame-based rendering traditionally used nowadays.

This approach is typically compatible with [image order](image_order.md) rendering methods, i.e. ones that can immediately and independently compute the final [color](color.md) of any pixel on the screen -- for example [raytracing](raytracing.md). It won't work with object order techniques such as the commonly used 3D rasterization.

The main advantage of frameless rendering lies of course in saving a large amount of memory normally reserved for double buffering, and usually also increased performance (fewer pixels are processed per second, [overhead](overhead.md) of processing frames is eliminated, ...). The animation may also seem more smooth and responsive -- reaction to input is seen faster. Another advantage, and possibly a disadvantage as well, is the kind of **"[motion blur](motion_blur.md)"** created as a side effect of not updating the whole screen at once. Changes appear gradually and are spread over the screen and through time: some pixels show the scene at a newer time than others, so the previous images kind of blend with the newer ones. This may add realism and also prevent temporal [aliasing](aliasing.md), but blur may sometimes be undesirable, and also the kind of blur we get is "pixelated" and [noisy](noise.md).

Selecting the pixels to update can be done in many ways, often using [pseudorandom](pseudorandom.md) patterns ([jittered sampling](jittered_sampling.md), [Halton sequence](halton_sequence.md), Poisson Disk sampling, ...), but regular ones may also be used. There have been papers that implemented adaptive frameless rendering detecting where it's best to update pixels to minimize noise.

Historically similar (though different) techniques were used on computers that didn't have enough memory for a double buffer or redrawing the whole screen each frame was too intensive on the CPU; programmers had to identify which pixels had to be redrawn and only update those. This resulted in techniques like *adaptive tile refresh* used in scrolling games such as [Commander Keen](commander_keen.md).

## See Also

- [interlacing](interlacing.md)