# Easy To Learn, Hard To Master

"Easy to learn, hard to master" (ETLHTM) is a type of [game](game.md) design (and by extension a potential property of any [art](art.md) or [skill](skill.md)) which makes it relatively easy to learn to play while mastering the play (playing in near optimal way) remains very difficult. This stems from a complex system emerging from simple rules, a property typical of [chaotic systems](chaos.md). The opposite is [hard to learn, easy to master](hard_to_learn_easy_to_master.md), although such a property is quite rare; more commonly we encounter either ETLHTM games or games that are both hard to learn and hard to master.

Many examples are found among video games such as [tetris](tetris.md), [minesweeper](minesweeper.md) or [Trackmania](trackmania.md). The board game of [go](go.md) shows an extreme contrast between simplicity of learning the rules and actually playing well: learning the rules can take just 5 minutes, learning a VERY low level of play usually takes at least weeks and most people won't suffice with their lifetime to reach master levels.

[LRS](lrs.md) sees the ETLHTM design as immensely useful and desirable as it allows for creation of [suckless](suckless.md), simple games that offer many hours of [fun](fun.md), usually with relatively low effort -- if the game is simple in nature, it's also usually simple to program. With this philosophy we get a great amount of value for relatively little effort.

The fun in ETLHTM games may also come from **self imposed goals**, another very important and useful concept in games. Self imposed goals are those which the player sets for himself, for example completing the game without killing anyone (so called "pacifist" gameplay) or completing it very quickly ([speedrunning](speedrun.md)), blindfolded etc. Here the game serves only as a platform, a playground at which different games can be played and invented -- inventing games is fun in itself. Again, a game supporting self imposed goals can be relatively simple and offer years of fun, which is extremely cool.

The simplicity of learning a game comes from simple rules while the difficulty of its mastering arises from the complex emergent behavior these simple rules imply. Mastering of the game is many times encouraged by [competition](competition.md) among different people but also competition against oneself (trying to beat own score). In many simple games such as [minesweeper](minesweeper.md) there exists a competitive scene (based either on direct matches or some measurement of skill such as [speedrunning](speedrun.md) or achieving high score) that drives people to search for strategies and techniques that optimize the play, and to training skillful execution of such play.

## See Also

- [hard to learn, easy to master](hard_to_learn_easy_to_master.md)
- [easier done than said](easier_done_than_said.md)
- [speedrun](speedrun.md)