# Doom

Doom is a legendary video [game](game.md) released in December [1993](1990s.md), perhaps the most famous video game of all time, the game that popularized the [first man shooter](first_person_shooter.md) genre and shocked by its at the time extremely advanced 3D graphics (yes, **Doom is 3D**) and caused one of the biggest revolutions in video game [history](history.md). It was made by [Id Software](id_software.md), most notably by [John Carmack](john_carmack.md) (graphics + engine programmer) and [John Romero](john_romero.md) (tool programmer + level designer) -- all in all the game was developed by about 5 to 6 men in about a year. Doom is sadly [proprietary](proprietary.md), it was originally distributed as [shareware](shareware.md) (a gratis "demo" was available for playing and sharing with the option to buy a full version). However the game engine was later (1999) released as [free (as in freedom) software](free_software.md) under [GPL](gpl.md) which gave rise to many source [ports](port.md) and "improved" "[modern](modern.md)" engines (which however look like shit, the original looks by far the best, if you want to play Doom use Chocolate Doom or Crispy Doom, avoid anything with GPU rendering). The assets remain non-free but a completely free alternative is offered by the [Freedoom](freedoom.md) project that has created [free as in freedom](free_culture.md) asset replacements for the game. [Anarch](anarch.md) is an official [LRS](lrs.md) game inspired by Doom, completely in the [public domain](public_domain.md).

{ NOTE: Some followers expressed disgust about the fact that I "glorify" Doom, a proprietary game -- yes, Doom is proprietary and thus an unethical piece of shit. Ethical "fixes" exist, namely Freedoom. Here I merely describe the historical significance of "Doom as a concept", it's the same as with "[Unix](unix.md)" as a concept -- Unix was also proprietary, but its invention was very significant historically, it was a discovery of a certain kind of formula, almost like discovering a law of nature in science. Even if this is initially seized and held by capitalists, later on free clones usually manage to at least partially free the concept from proprietary hands. Just so we understand each other: I am fully AGAINST proprietary games, but things aren't black and white, a disaster may have historical significance and lead to something good, and vice versa. I am just capturing facts. ~drummyfish }

Doom has a cool wiki at https://doomwiki.org.

Only pussies play Doom on low difficulty. { Sorry Ramon, love u <3 :D ~drummyfish }

{ Great books about Doom I can recommend: *Masters of Doom* (about the development) and *Game Engine Black Book: Doom* (details about the engine internals). Also recently John Romero, who has a rare condition of being able to perfectly recall every day of his life, has written a book about the development, called *Doom Guy*. ~drummyfish }

In part owing to the release of the engine under a [FOSS](foss.md) [license](license.md) and its relatively [suckless](suckless.md) design ([C](c.md) language, [software rendering](sw_rendering.md), ...), Doom has been [ported](port.md), both officially and unofficially, to a great number of platforms (e.g. [Gameboy Advance](gba.md), [PS1](playstation.md), even [SNES](snes.md)) and has become a kind of **de facto standard [benchmark](benchmark.md)** for computer platforms -- you will often hear the phrase: **"but does it run Doom?"** Porting a Doom to any platform has become kind of a [meme](meme.md), purportedly someone even ported it to a pregnancy test (though it didn't actually run on the test, it was really just a display). { Still [Anarch](anarch.md) may be even more portable than Doom :) ~drummyfish }

The major leap that Doom engine's graphics brought about was unprecedented, but Doom was not just a game with good graphics, it had fantastic gameplay, brutally good [music](music.md) and a fitting, badass [art](art.md) style, all polished and coherent in a very beautifully gory harmony, and on top of that there was the novel and revolutionary [deathmatch](deathmatch.md) multiplayer (the name *deathmatch* itself was coined by Romero during Doom multiplayer sessions), as well as a HUGE modding and mapping scene. Doom was a success in every way -- arguably no other game has since caused a revolution of greater proportions (no, not even [Minecraft](minecraft.md), [World of Warcraft](wow.md) and whatever else). Many game magazines just started reviews with: "OK, Doom is clearly the best game ever made, let's just examine the details...". The game's overall style and atmosphere were just "cool", as were the developers themselves, Doom was very appealing by its sincere message that read "fuck it, we don't give a shit, let's make a great game". It was a pure metal/bloody/gory/demon slaying shooter without any [corporate](corporation.md) garbage stuffed in for more popularity and profit that you'd see today. It was a game made by a bunch of guys doing it their own way without giving much shit about family friendliness or marketing bullshit, you won't see that anymore. Doom didn't pretend, it didn't care about backstory, everyone knew it was about shooting and so they just made it a bloody shooter. John Carmack famously stated that story in a video game is like story in a [porn](porn.md) movie -- it's expected to be there but not very important. Nowadays you may at best see developers try to artificially imitate this attitude but it's always laughably transparent, it will only ever be a pretense as the times when you could simply make a game with artistic freedom, without having to bow to managers, gender departments, publishers and other overlords are simply long gone by.

Doom wasn't the first 3D game, nor was it the first FPS, some of its predecessors could even be considered "more 3D" in a sense -- for example flight simulators -- what was so special and breathtaking about Doom was the mastery with which it combined all the graphic tricks in a novel way and still managed to complement them with excellent gameplay to deliver unprecedented "immersion", such that mere mortals of the [1990s](90s.md) couldn't expect and weren't ready for. Doom had fully textured environments, including floors and ceilings, which along with the fog, sector lighting, level verticality and interactivity made the player really feel present in the game despite not being able to look up and down. Games had textured walls before, and others had textured floors, some had lighting effects and distance fog, but Doom was the first to have it all and have it done the right way.

As stated, the game's backstory was simple and didn't stand in the way of gameplay, it's basically about a tough marine (so called *Doomguy*) on a Mars military base slaying hordes of demons from hell, all in a rock/metal style with a lot of gore and over-the-top violence (chain saws n stuff).

*Doom* was followed by *Doom II* in 1995, which "content-wise" was basically just a data disc, the same game with new levels and some minor additions. More Doom games followed, notably *Final Doom* and *Doom 64*, but these are a bit less known now. After the turn of the new millennium *Doom III* came out in 2004, which was a kind of "reboot" rather than a sequel. The game also got an expansion pack. *Doom IV* was in development but got canceled, so the next official game was *Doom 2016* -- another reboot. In 2020 *Doom: Eternal* was released.

Some **[interesting](interesting.md) trivia** about Doom include:

- Someone created a Doom system monitor for [Unix](unix.md) systems called [psDooM](psdoom.md) where the monsters in game are the operating system [processes](process.md) and killing the monsters kills the processes.
- In 2024 some researchers made an experimental completely [neural network](neural_net.md) [AI](ai.md) game engine (called GameNGen) and implemented Doom with it -- basically they just made the network play Doom for a long time and so trained it to estimate the next frame from current input and a few previous frames. It can be played at 20+ FPS and looks a lot like Doom but it's also "weird", glitching, and having little persistence (it only remembers a few seconds back). Still pretty impressive.
- Although the game was officially released on [Gameboy Advance](gba.md), fans still made their own port to the console. It is called *gbaDoom* and is a prBoom engine port, adding many more features against the official release: for example the exact same maps as in original Doom without reduced geometry, normal blood, better graphics and even allowing mods that aren't too heavy on performance, including Freedoom.
- The Crispy Doom engine adds `GOOBERS` cheat code which makes all floors and ceilings the same height, effectively making the game a flat [wolf3d](wolf3d.md)-style game.
- By simple modification of the engine (making the [pseudorandomness](pseudorandom.md) generator always return the same value, e.g. [zero](zero.md)) it's possible to essentially turn off all randomness and the game then becomes quite weird. For example the "melting" screen effect turn to just a screen swipe, strobe light effects disappear, weapon fire loses any spread and all monsters always make the same death sound.
- Someone (kgsws) has been [hacking](hacking.md) the ORIGINAL Doom engine in an impressive way WITHOUT modifying the source code or the binary, rather using [arbitrary code execution](arbitrary_code_execution.md) bug; he added very advanced features known from newer source ports, for example an improved 3D rendering algorithms allowing geometry above geometry etc. (see e.g. https://yt.artemislena.eu/watch?v=RdbRPNPUWlU). It's called the Ace engine.
- A special mod of Doom, called Marine Doom, was at one point used for [military](military.md) training.
- Doom sprites were made from photos of physical things: weapons are modified photos of toys, enemies were made from clay and then photographed from multiple angles (actually a great alternative to [3D modeling](3d_model.md) that's less dependent on computers and produces more realistic results). The clay models still exist.
- The strongest weapon in the game is name BFG9000, which stands for "big fucking gun".
- There is some kind of "controversial" Doom mod called *Moon Man* where you shoot feminists, jews, niggas and such, apparently it triggers [SJWs](sjw.md) or something.
- It's estimated that by late 1995 Doom was installed on more computers than [Windows](windows.md) 95.
- The name *Doom* comes from a line in a movie called *The Color of Money*.
- Arguably the greatest Doom [speedrunner](speedrun.md), but likely one of the greatest speedrunners ever, is ZeroMaster, a guy from Norway who just keeps beating record after record, many of which were thought to literally be impossible. He also writes tool and scripts to help search for new bugs and viable strategies and also makes insane [tool assisted speedruns](tas.md).
- The initial release even featured support for a three-monitor wide view, something truly advanced for the time. This was disabled in newer versions but the code stayed and later source ports, such as Cholocate Doom, reenabled it.
- According to DYKG, the engine initially supported even sloped floors, but the feature was later on scratched.

## Doom Engine/Code

*See also [game engine](game_engine.md) for the list of different Doom engines. Tl;dr: to play doom nowadays use either Chocolate Doom or Crispy Doom.*

Doom source code is written in [C89](c.md) and is about 36000 [lines of code](loc.md) long, spread over some 124 files, of which some were auto-generated (e.g. the [AI](ai.md) [state machines](finite_state_machine.md)). The original system requirements stated roughly a 30 MHz [CPU](cpu.md) and 4 MB [RAM](ram.md) as a minimum. It had 27 levels (9 of which were shareware), 8 weapons and 10 enemy types. The engine wasn't really as flexible in a way "[modern](modern.md)" programmers expect, many things were hard coded, there was no [scripting](script.md) or whatever (see? you don't fucking need it), new games using the engine had to usually modify the engine internals. Compared to its predecessor ([Wolf 3D](wolf3d.md)), successor ([Quake](quake.md)) and competition ([Duke 3D](duke3d.md)), Doom's code is arguably the nicest and closest to [LRS](lrs.md).

The code itself looks alright, files are conveniently organized into groups by their prefix (`g_`: game, `r_`: rendering, `s_`: sound etc.). The same goes for the function names. There seems to be tabs mixed with spaces though, sometimes a bit shitty formatting, but overall MUCH better than [duke 3D](duke3d.md)'s code (well, that doesn't say much though). [Comments](comment.md) are plentiful.

The game only used [fixed point](fixed_point.md), no [float](float.md)!

The **Doom engine** (also called *id Tech 1*) was revolutionary and advanced (not only but especially) video game graphics by a great leap, considering its predecessor [Wolf3D](wolf3D.md) was really primitive in comparison (Doom basically set the direction for future trends in games such as driving the development of more and more powerful [GPUs](gpu.md) in a race for more and more impressive visuals). In early stages the game used a [portal renderer](portal_rendering.md) but it turned out running too slow with more complex scenes, so John Carmack switched to a new technique called **[BSP rendering](bsp.md)** (levels were made of convex 2D sectors that were then placed in a BSP tree which helped quickly sort the walls for rendering front-to-back) that was able to render [realtime](realtime.md) 3D views of textured (all walls, floors and ceilings) environments with primitive lighting (per-sector plus diminishing lighting), enemies and items represented by 2D [billboards](billboard.md) ("[sprites](sprite.md)"). The BSP rending was especially elegant in that it always drew each screen pixel exactly once, without overdraw or "holes" left behind, and thanks to this it wasn't even necessary to clear the video buffer inbetween frames. No [GPU](gpu.md) acceleration was used, graphics was rendered purely with [CPU](cpu.md) (so called [software rendering](sw_rendering.md), GPU rendering would come with Doom's successor [Quake](quake.md), and would also later be brought to Doom by newer community made engines, though the original always looks the best). This had its limitations, for example the camera could not look up and down, there could be no tilted walls and the levels could not have rooms above other rooms. The geometry of levels was only static, i.e. it could not change during play (only height of walls could, which is why walls always opened upwards), because rendering was dependent on precomputed BSP trees (which is what made it so fast). For these reasons some call Doom "[pseudo 3D](pseudo3d.md)" or 2.5D rather than "true 3D", some retards took this even as far as calling Doom 2D with its graphics being just an "illusion", as if literally every 3D graphics ever wasn't a mere illusion. Nevertheless, though with limitations, Doom did present 3D views and internally it did work with 3D coordinates (for example the player or projectiles have 2D position plus height coordinate), despite some dumb YouTube videos saying otherwise. For this reason we prefer to call Doom a **primitive 3D** engine, but 3D nonetheless. Other games later used the Doom engine, such as Heretic, Hexen and Strife. The Doom engine was similar to and competing with [Build](build_engine.md) engine that ran games like [Duke Nukem 3D](duke3d.md), Blood and Shadow Warrior. All of these 90s shooters were amazing in their visuals and looked far better than any [modern](modern.md) shit. Build engine games had similar limitations to those of the Doom engine but would improve on them (e.g. faking looking up and down by camera tilting, which could in theory be done in Doom too, or allowing sloped floor and dynamic level geometry).

The game [data](data.md) is stored in so called **WAD files** (short for *where's all the data*). While many things are hardcoded in the engine, such as the total number of levels or types of weapons, most other things such as textures, levels, color palettes, weapons and enemy sprites are in the WAD files and so can be replaced without having to mess with the engine itself. There are two types of WAD files (both however still come with the same .wad extension, they are distinguished only by the file magic number): IWAD (internal WAD) and PWAD ([patch](patch.md) WAD). IWAD is the most important one, representing the base game, so for example Doom, Hexen and Freedoom will all have their own specific IWAD. Only one IWAD is loaded at any time. PWAD allows to add or modify things in the IWAD which makes it possible to easily correct bugs in the game data and make mods. Unlike with IWADs, multiple PWADs can be loaded at any time -- when loaded, a resource that's present in the PWAD will override the same resource in the base IWAD. All resources in the WAD files are stored as so called *lumps* which we may simply see as "blobs of data" or "files". A nice [CLI](cli.md) tool for working with WADs is e.g. [deutex](deutex.md).

Doom WAD (full version) is a bit over 11 MB in size (MD5 1cd63c5ddff1bf8ce844237f580e9cf3), Doom 2 WAD is over 14 MB (MD5 25e1459ca71d321525f84628f45ca8cd).

Indexed ([palette](palette.md)) mode with "only" 256 colors was used for rendering. Precomputed color tables were used to make dimming of colors faster. Similarly a [look up table](lut.md) was used for [random number generation](rng.md) -- two independent [pseudorandom](pseudorandomness.md) generators are present, one is used for things such as visual effects while the other one is utilized purely for the game simulation so that it stays deterministic independently on graphics etc.

Doom also has a [deterministic](determinism.md) [FPS](fps.md)-independent physics which allows for efficient recording of [demos](demo.md) of its gameplay and creating [tool assisted speedruns](tas.md), i.e. the time step of game simulation is fixed (35 tics per second). Such demos can be played back in high quality while being minuscule in size and help us in many other ways, for example for verifying validity of [speedruns](speedrun.md). This is very nice and serves as an example of a well written engine (unlike later engines from the same creators, e.g. those of [Quake](quake.md) games which lacked this feature -- here we can see how things get progressively shittier in computer technology as we go forward in time).

There is no [antialiasing](antialiasing.md) in the engine, i.e. aliasing can be noticed on far-away textures, but it is suppressed by the use of low-res textures and dimming far-away areas. There is also no edge smoothing (kind of misleadingly known as "antialiasing") in the geometry rendering, the engine is [subpixel](subpixel.md) accurate in rendering of the top and bottoms of the walls, i.e. the line these boundaries form may result in rasterizing slightly different pixels even if the start and end pixel is the same, depending on the subpixel position of the start and endpoint -- this feature doesn't much help in static screenshots but makes animation nicer.

Some **[interesting](interesting.md) places in code**: `m_random.c:31`: pseudorandom number table; `i_main.c`: the C main function (for DOS); `d_main.c:354`: game loop; `r_main.c:870`: 3D rendering function. `am_map.c:992`: variable named `fuck` (the code contains total of 20 lines containing "[fuck](fuck.md)").

## See Also

- [Anarch](anarch.md)
- [Freedoom](freedoom.md)
- [Duke 3D](duke3d.md)
- [Wolf 3D](wolf3d.md)
- [Cytadela](cytadela.md)
- [Gloom](gloom.md) (fun [Amiga](amiga.md) Doom clone)
- [Quake](quake.md)
- [Postal](postal.md)
- [Blood](blood.md)
- [Jedi engine](jedi_engine.md)
- [Build engine](build_engine.md)
- [Chasm: The Rift](chasm_the_rift.md)
- [raycasting](raycasting.md) (not used in Doom but achieves similar look)
- [Doomer](doomer.md)
- [Boomer](boomer.md)
