# Deferred Shading

In computer [graphics](graphics.md) [programming](programming.md) deferred shading refers to a specific technique of speeding up the rendering of (mainly) [shaded](shading.md) [3D graphics](3d_rendering.md) (i.e. graphics with textures, materials, [normal maps](normal_mapping.md) etc.) by delaying (deferring) [shading](shading.md) to a time at which it's already known which parts of the rendered scene are visible. Today this technique is in very common use and will be found practically in every advanced 3D engine. In principle the general idea behind it may also be used in 2D graphics (and possibly even outside graphics).

The principle is following: in normal forward (non-deferred) shading the shading computation is applied immediately to any rasterized [pixel](pixel.md) (fragment). However, as objects can overlap, many of these expensively computed pixels may be overwritten by pixels of other objects, so many pixels end up being expensively computed but eventually invisible (this is called *overdraw*). This is of course wasted computation. Deferred shading only computes shading of the pixels that will end up actually being visible -- this is achieved with **two rendering passes**:

1. Geometry is first rendered without shading, only with information that is needed for shading (for example [normals](normal.md), material IDs, texture IDs etc.). The rendered image is stored in so called *G-buffer* which is basically an image where every pixel stores the above mentioned shading information.
2. The second pass applies the shading effects by applying the pixel/fragment [shader](shader.md) on each pixel of the G-buffer.

This is especially effective when using very expensive/complex pixel/fragment shaders while at the same time having many overlapping objects. **Sometimes deferred shading may be replaced by simply ordering the rendered models**, i.e. rendering front-to-back, which may achieve practically the same speed up (but may in turn lose speed at the sorting step). In simple cases deferred shading may not even be worth it -- in [LRS](lrs.md) programs we may use it only rarely. As always, the [overhead](overhead.md) may make many cases worse off than going the simpler way, plus we add [bloat](bloat.md).

Deferred shading also comes with complications, for example **rasterization [anti aliasing](antialiasing.md) can't be used** because, well, anti-aliasing in G-buffer doesn't really make sense. This is usually solved by some [screen-space](screen_space.md) antialiasing technique such as [FXAA](fxaa.md), but of course that may be a bit inferior. **Transparency also poses an issue** (for blending G-buffer would somehow have to store information about more than one surface).