# De Facto

De facto is [Latin](latin.md) for "in fact" or "by facts", it means that something holds in practice; it is contrasted with [de jure](de_jure.md) ("by law"). We use the term to say whether something is actually true in reality as opposed to "just on paper".

For example in [technology](tech.md) a so called [de facto standard](de_facto_standard.md) is something that, without it being officially formalized or forced by law in prior, most developers naturally come to adopt so as to keep [compatibility](compatibility.md); for example the [Markdown](md.md) format has become the de facto standard for [READMEs](readme.md) in [FOSS](foss.md) development. Of course it happens often that de facto standards are later made into official standards. On the other hand there may be standards that are created by official standardizing authorities, such as the state, which however fail to gain wide adoption in practice -- these are official standards but not de facto one. TODO: example? :)

Regarding politics and society, we often talk about **de facto [freedom](freedom.md)** vs **de jure freedom**. For example in the context of [free (as in freedom) software](free_software.md) it is stressed that software ought to bear a free [license](license.md) -- this is to ensure de jure freedom, i.e. legal rights to being able to use, study, modify and share such software. However in these talks the **de facto freedom of software is often forgotten**; the legal (de jure) freedom is worth nothing if it doesn't imply real and practical (de facto) freedom to exercise the rights given by the license; for example if a piece of "free" (having a free license) software is extremely [bloated](bloat.md), our practical ability to study and modify it gets limited because doing so gets considerably expensive and therefore limits the number of people who can truly exercise those rights in practice. This issue of diminishing de facto freedom of free software is addressed e.g. by the [suckless](suckless.md) movement, and of course our [LRS](lrs.md) movement.

There is also a similar situation regarding [free speech](free_speech.md): if speech is free only de jure, i.e. we can "in theory" legally speek relatively freely, BUT if then in reality we also CANNOT speek freely because e.g. of fear of being [cancelled](cancel_culture.md), **our speech is de facto not free**.

## See Also

- [freedom distance](freedom_distance.md)