# Chess

Chess (from Persian *shah*, *king*) is a very [old](old.md) two-player board [game](game.md), perhaps most famous and popular among all board games in [history](history.md). To the common folk familiar with video games it could be described as a turn-based strategy, in [mathematical](math.md) terms it's a [zero sum](zero_sum.md), [complete information](complete_information.md) game with no element of [randomness](randomness.md), that simulates a battle of two armies on an 8x8 board with different battle pieces, also called *chessmen* or just *men* (also [stones](rock.md), pieces or juicers). Chess is also called the King's Game, it has a worldwide [competitive](competition.md) scene and is considered an intellectual [sport](sport.md) but it's also been a subject of rigorous research and [programming](programming.md) (countless chess engines, [AI](ai.md)s and frontends are being actively developed). Chess is similar to games such as [shogi](shogi.md) ("Japanese chess"), [xiangqi](xiangqi.md) ("Chinese chess") and [checkers](checkers.md). As the estimated number of chess games is bigger than [googol](googol.md), it is unlikely to ever get solved; though the complexity of the game in sheer number of possibilities is astronomical, among its shogi, go and xiangqi cousins chess is actually considered one of the "simplest" (the board is relatively small and the game tends to simplify as it goes on as there are no rules to get men back to the game etc.). In [2020s](21st_century.md) the game received more mainstream attention and popularity, which under [capitalism](capitalism.md) means a disaster, influx of [toxicity](toxic.md) and [SJWs](sjw.md), commercialization, "chess platforms" full of [ads](marketing.md) and [microrape](microtheft.md), retarded influencers, [women](woman.md), [furries](furry.md), [trannies](tranny.md), [anticheating](cheating.md) malware, idiotic propaganda movies and much more -- this crap is to be avoided. It has to be especially stressed that chess is **NOT** an "esport".

{ There is a nice black and white indie movie called *Computer Chess* about chess programmers of the 1980s, it's pretty good, very oldschool, starring real programmers and chess players, check it out. ~drummyfish }

[Drummyfish](drummyfish.md) has created a suckless/[LRS](lrs.md) chess library [smallchesslib](smallchesslib.md) which includes a simple engine called *smolchess* (and also a small chess game in [SAF](saf.md) with said library) -- it is very weak but may be fun to play around with :)

**At [LRS](lrs.md) we consider chess to be one of the best games** for the following reasons:

- It's just a deeply [interesting](interesting.md), profound game in which luck plays minimal role.
- **It is highly [suckless](suckless.md)**, the rules are truly simple, it can be implemented on simple 8bit computers. Of course the game doesn't even require a computer, just a board and a few men -- chess masters don't even need a board to play (they can completely visualize the games in memory). In the end one can in theory just play against himself in his head, achieving the ultimate [freedom](freedom.md): the only [dependency](dependency.md) of the game is one's brain, i.e. it becomes a [brain software](brain_software.md). Chess is extremely inexpensive, doesn't discriminate against poor people and will survive even the most extreme technological [collapse](collapse.md).
- **No one [owns](intellectual_property.md) chess**, the game is hundreds of years old and many books about it are also already in the [public domain](public_domain.md). It is extremely free.
- It is a basis for other derived games, for example many different chess variants or chess puzzles which can be considered a "singleplayer chess game".
- It is a source of many interesting [mathematical](math.md) and programming challenges.
- It seems to strike the right balance of simplicity and complexity, it is very simple but not so trivial as to be ever solved in a foreseeable future.

Chess is a marvelous game but not a perfect one, many still perceive [go](go.md) as the supreme king of board games, yet more [beautiful](beauty.md), both more minimal and more difficult to master, with playing experience unlike any other. Thankfully there is no need to choose one or the other -- why not play both? :)

**Where to play chess online?** It won't come as a surprise that many chess [servers](server.md) exist, such as https://chess.com or https://chess24.com -- however these ones are [proprietary](proprietary.md), shitty, cancerous and unusable, NEVER touch them. { The cocsuckers from chess.com just started to hardcore spam my mail when I registered there lol. ~drummyfish } A much better one is **Lichess** ([libre](libre.md) chess) at https://lichess.org which is not only [FOSS](foss.md), but also gratis, without [ads](marketing.md) and is actually superior in all ways even to the proprietary sites, allowing users to run their own bots, offering [public domain](public_domain.md) database of all the games and positions, [API](api.md), analysis board, puzzles, chess variants, minigames, TV and much more -- however it requires [JavaScript](js.md). Another server, a more [suckless](suckless.md) one, is **Free Internet Chess Server** (FICS) at https://www.freechess.org/ -- on this one you can play through telnet (`telnet freechess.org 5000`) or with graphical clients like pychess. Online servers usually rate players with Elo/Glicko just like FIDE, sometimes there are computer opponents available, chess puzzles, variants, analysis tools etc.

Chess as a game is not and cannot be [copyrighted](copyright.md), but **can chess games (moves played in a match) be copyrighted?** Thankfully there is a pretty strong consensus and precedence that say this is not the case, even though [capital worshippers](capitalism.md) try to play the intellectual property card from time to time (e.g. 2016 tournament organizers tried to stop chess websites from broadcasting the match moves under "trade secret protection", unsuccessfully).

**Chess and [IQ](iq.md)/intelligence** (a quite comprehensive summary of the topic is available here: http://www.billwallchess.com/articles/IQ.htm): there is a debate about how much of a weight general vs specialized intelligence, IQ, memory and pure practice have in becoming good at chess. It's not clear at all, everyone's opinion differs. A popular formula (Levitt equation) states that *highest achievable Elo = 1000 + 10 * IQ*, though its accuracy and validity are of course highly questionable. All in all this is probably very similar to language learning: obviously some kind of intelligence/talent is needed to excel, however chess is extremely similar to any other sport in that putting HUGE amounts of time and effort into practice (preferably from young age) is what really makes you good -- without practice even the biggest genius in the world will be easily beaten by a casual chess amateur, and even a relatively dumb man can learn chess very well under the right conditions (just like any dumbass can learn at least one language well); many highest level chess players admit they sucked at math and hated it. As one starts playing chess, he seems to more and more discover that it's really all about studying and practice more than anything else, at least up until the highest master levels where the genius gifts a player the tiny nudge needed for the win -- at the grandmaster level intelligence seems to start to matter more. Intelligence is perhaps more of an accelerator of learning, not any hard limit on what can be achieved, however also just having fun and liking chess (which may be just given by upbringing etc.) may have similar accelerating effects on learning. Really the very basics can be learned by literally ANYONE, then it's just about learning TONS of concepts and principles (and automatizing them), be it tactical patterns (forks, pins, double check, discovery checks, sacrifices, deflections, smothered mates, ...), good habits, positional principles (pawn structure, king safety, square control, piece activity, ...), opening theory (this alone takes many years and can never end), endgame and mating patterns, time management etcetc.

{ NOTE (speculative): I think I've heard some research suggested that it's not so much the spatial/visual part of the brain that's responsible for playing chess but rather the language part, it really seems like learning chess might be more similar to learning a foreign language -- it takes about the same time to become "fluent" at chess and the key to being good at it is starting at young age. I.e. the relationship of chess and intelligence is probably similar to that of language learning and intelligence. ~drummyfish }

**[Fun](fun.md) [historical](history.md) fact**: chess used to be played over [telegraph](telegraph.md), first such game took place probably in 1844.

Fun fact 2: in 2022 a chess playing robot took and broke a finger of a 7 year old opponent lol.

**How to play chess with yourself?** Should you lack a computer or humans to play against, you may try playing against yourself, however playing a single game against oneself doesn't really work, you know what the opponent is trying to do -- not that it's not interesting, but it's more of a search for general strategies in specific situations rather than actually playing a game. One way around this could be to play many games at once (you can use multiple boards but also just noting the positions on paper as you probably won't be able to set up 100 boards); every day you can make one move in some selected games -- randomize the order and games you play e.g. with dice rolls. The number of games along with the randomized order should make it difficult for you to remember what the opponent (you) was thinking on his turn. Of course you can record the games by noting the moves, but you may want to cover the moves (in which case you'll have to be keeping the whole positions noted) until the game is finished, so that you can't cheat by looking at the game history while playing. If this method doesn't work for you because you can keep up with all the games, at least you know you got real good at chess :) { This is an idea I haven't tried yet, I'm leaving it here as a note, will probably try it one day. ~drummyfish } Also check out single player chess variants.

**Is there any luck or [randomness](randomness.md) in chess?** Not in the rules itself of course, there are no dice and hidden [information](information.md), but still luck and randomness is present in the meta game (playing as white vs black may be decided randomly, your opponent may be assigned to you randomly etc.) and then [de facto](de_facto.md) in the fact that although no information is hidden, no one can ever have a complete information due to the sheer complexity of the game, so in practice playing chess involves risk, intuition and educated guessing at any human and superhuman (computer) level. So chess players do commonly talk about luck, outcome of a game is always a matter of [probability](probability.md) which is however given by the relative skill of both players. Computer chess engines evaluate positions probabilistically, i.e. telling the probability of white versus black winning, even though in theory a perfect play from any given position has a strictly determined outcome: win, loss or draw. So not even best computers can consider chess completely determined. In human play probability of a hobbyist beating professional in a fair game, unlike e.g. in some card games, can effectively be considered [zero](zero.md), which indeed proves chance plays a minimal role.

## Chess In General

Chess evolved from ancient board games in India (most notably Chaturanga) in about 6th century -- some sources claim that the game's predecessors used dice to determine which man a player was allowed to move but that this element of randomness had to be removed as dictated by anti-gambling laws. Nowadays the game is internationally governed by **FIDE** which has taken on the role of an authority defining the official rules: FIDE rules are considered to be the standard rules of the game. FIDE also organizes tournaments, promotes the game and keeps a list of registered players whose performance it rates with so called **[Elo](elo.md)** system --⁠ based on the performance it also grants titles such as **Grandmaster** (GM, strongest, around 2000 in the world), **International Master** (IM, second strongest, roughly 4000 in the world), **FIDE Master** (FM, roughly 8000 in the world) or **Candidate Master** (CM). In chess you are basically your rating. The game of chess is so entertaining on its own that it doesn't need to be spiced by money and bets, like so many other games ([poker](poker.md), [backgammon](backgammon.md), ...).

Chess skill is often divided into two broad areas (it is also common to divide strong players into these two categories depending on where their main strength lies):

- **positional play**: Strategic, long term, big picture patterns leading to general advantages and opportunities and easy choices of good moves, trying to get a "good position" with men on strong squares, guarding each other, controlling key parts of the board, putting enemy under pressure, taking away his maneuvering space,    ensuring safety of own king, good pawn structure, leading pawns close to promotion etc.
- **tactical play**: Short term, quick action, tricks and calculation skills that win advantages, often material, with tools such as forks, pins, discovery checks, double attacks, sacrifices, zugzwangs etc.

Of course this is not the only possible division, another one may be for example offensive vs defensive play etc., but generally chess revolves around position and tactics.

A single game of chess is seen as consisting of three stages: **opening** (starting, theoretical "book" moves, developing men), **middlegame** (seen as the pure core of the game) and **endgame** (ending in which only relatively few men remain on the board, sometimes also defined as play without queens). There is no clear border between these stages and at times they are defined differently, however each stage plays a bit differently and may require different skills and strategies; for instance in the endgame kings become active while in the opening and middlegame they try to stay hidden and safe.

The study of chess openings is called **opening theory** or just *theory*. The opening stage is distinct by being based on memorization of this theory, i.e. hundreds and thousands of existing opening lines that have been studied and analyzed by computers, rather than by performing mental calculation (logical "thinking ahead" present in middlegame and endgame) and creativity. Many now see opening theory as the ugly, [harmful](harmful.md) part of chess, one forcing players to spending energy on pure memorization of opening lines. One of the chess legends, Bobby Fischer, held this opinion strongly and devised a chess variant with randomized starting positions so as to do away with this memorization -- the variant is called *chess 960* (aslo *Fischer random* or *freestyle chess*).

**[Elo](elo.md) rating** is a [mathematical](math.md) system of numerically rating the performance of players (apart from chess also used in many other sports); Elo essentially assigns players a rating [number](number.md) that expresses the player's skill. Given two players with Elo rating it is possible to compute the probability of the game's outcome (e.g. white has 70% chance of winning etc.). The FIDE set the parameters so that the rating is roughly this: < 1000: beginner, 1000-2000: intermediate, 2000-3000: master (currently best humans rate close to 3000). More advanced systems have also been created, namely the Glicko system, however these are often quite [bloated](bloat.md) and complicated, so Elo stays the most commonly used rating system. **Alternative ways** of determining player skills also exist, for example so called accuracy, which says how closely one played to the perfect play according to some strong engine such as stockfish. The advantage here is that to rate a player we don't need too much data like with Elo (which needs to see many games of the player against other already rated players) -- it may be enough to let the player play a few games against a computer to determine his skill. A disadvantage however lies in how exactly to compute accuracy because that gets a little complicated by other factors, for example many times finding the best move is trivial (like retaking a queen in an exchange) while in others gets much more difficult, or the fact that humans often DON'T want to play the mathematically best move but rather a bit weaker, more comfortable one, so even grandmasters often choose a weaker move even though they know the theoretically best move. Another idea may be to use a standard set of puzzles, basically like an [IQ](iq.md) test. Yet another idea is for example to compute so called [Erdos number](erdos_number.md), i.e. the minimum length of a chain of victories from the world's best player, i.e. for example rating player A with number 3 says he defeated someone who defeated someone who defeated the world's best. A guy called tom7 devised a method for measuring performance of weak chess engines by basically mixing stockfish (the strongest chess engine) with a random move bot in certain ratios -- i.e. making an engine that with certain probability (given by the mixture ratio) plays either a move by stockfish or a random move -- and then determining the mixture ratio at which this monstrosity becomes indistinguishable from the tested engine (i.e. we can say "the tested engine is a mixture of stockfish and random moves in this ratio"). Along these lines we may similarly try to compute how much of a different kind of handicap -- let's say material or time (or, with humans, amount of alcohol) -- we have to give to the strong engine for it to become on par with the tested entity (i.e. the ratio of wins and losses is about 1).

The rules of chess are fairly simple ([easy to learn, hard to master](easy_to_learn_hard_to_master.md)) and can be found anywhere on the Internet. In short, the game is played on a 8x8 board by two players: one with **[white](white.md)** men, one with **[black](black.md)** (LOL IT'S [RACIST](racism.md) :D). Each man has a way of moving and capturing (eliminating) enemy men, for example bishops move diagonally while pawns move one square forward and take diagonally. The objective is to **checkmate** the opponent's king, i.e. put the king under attack while leaving him no way of escape. There are also lesser known rules that noobs often miss and ignore, e.g. so called en-passant or the 50 move rule that declares a draw should there occur no "significant" move for 50 consecutive turns.

At the competitive level **clock** (so called *time control*) is present to impose a time limit on making moves: with unlimited move time games would be painfully long and more of a test of patience rather than skill. Clock can also conveniently help balance unequal opponents by reducing the stronger player's thinking time. Based on the amount of time to move we recognize several game formats, most notably **correspondence** (slowest, days for a move), **classical** (slow, hours per game), **rapid** (faster, tens of minutes per game), **blitz** (fast, a few seconds per move) and **bullet** (fastest, units of seconds per move). Most frequently each player is given a total time for making all his moves plus a so called *increment*, a small time amount added back after every move. There is also a category called cyborg or centaur chess in which computer assistance is allowed (which would normally be seen as [cheating](cheating.md)) -- this category usually greatly overlaps with correspondence chess.

Currently the best player in the world -- and by now almost undeniably the best player of all time -- is very convincingly Magnus Carlsen (born 1990), a [white](white.md) man from Norway with Elo rating 2800+. On most days he habitually wipes the floor with all the other top players effortlessly, he was winning the world championship over and over before giving up the title out of boredom.

During the [covid](covid.md) pandemic (circa 2020) chess has experienced a small boom among [normies](npc.md) and [YouTube](youtube.md) chess channels have gained considerable popularity. This boosted chess as such and gave rise to [memes](meme.md) such as the bong cloud opening popularized by a top player and streamer Hikaru Nakamura; the bong cloud is an intentionally [shitty](shit.md) opening that's supposed to taunt the opponent (it's been even played in serious tournaments [lol](lol.md)).

**White is generally seen as having a slight advantage over black** (just like in [real life](irl.md) lol). This is because he always has the first move -- statistics confirm the claim as white on average wins a little more often (even in the world of computers which is spared of psychological factors). The advantage is very small, estimated by engines to be around a very small fraction of a pawn, and this slight imbalance doesn't play such as big role in beginner and intermediate games but starts to become apparent in master games where the play can be very equal. How big the advantages is exactly is a matter of ongoing debate, most people are of the opinion there exists a small advantage for the white (with imperfect, human play, i.e. that white plays easier, has more choices, tolerates slightly less accurate play), though most experts think chess is a draw with perfect play (pro players can usually quite safely play for a draw and secure it if they don't intend to win; world championships mostly consist of drawn games as really one player has to make a mistake to allow the other one to win). Minority of experts think white has theoretical forced win. Probably only very tiny minority of people think white doesn't have any advantage or even that black is in a better overall position. Some argue that even if black doesn't have an overall advantage, he still has a number of smaller advantages over white, as it's true that sometimes the obligation to make a move may be a disadvantage (this is called [zugzwang](zugzwang.md)). It's for example true that the theoretical fastest possible checkmate is delivered by black, not white. Probably no one thinks black has a forced win though, but as that's not disproved yet so maybe someone actually believes it.

**Blindfold play**: it's quite impressive that very good players can play completely blindfold, without any actual chessboard, and some can even play many games simultaneously this way. This is indeed not easy to do and playing blindfold naturally decreases one's strength a bit (it seems this is more of a case on lower level of play though). It is however not the case that only an exceptional genius could play this way, probably anyone can learn it, it's just a matter of training (it's a matter of developing an efficient mental representation of the board rather than actually exactly remembering the whole board -- in psychology called *chunking*). Probably all masters (above FIDE ELO 2000) can play blindfold. They say the ability comes naturally just by playing countless games. How to learn playing blindfold then? Just play a lot of chess, it will come naturally -- this is the advice probably most often given. However if you specifically long with your whole heart to just learn blindfold play as a cool party trick, you may focus on it, e.g. by training blindfold against a very weak computer { Smolchess is IDEAL for this :] ~drummyfish }. Some software chess boards offer a mode in which one can see the position and color of all men but not which type they are -- this may perhaps be a good start. It may possibly also be done very gradually -- for example start by covering just part of the board and every week cover yet more squares; eventually you'll have them all covered.

On **perfect play**: as stated, chess is unlikely to be ever solved so it is unknown if chess is a theoretical forced draw or forced win for white (or even win for black), however many simplified endgames and some simpler chess variants have already been solved. Even if chess was ever solved, it is important to realize one thing: **perfect play may be unsuitable for humans** and so even if chess was ever solved, it might have no significant effect on the game played by humans. Imagine the following: we have a chess position in which we are deciding between move *A* and move *B*. We know that playing *A* leads to a very good position in which white has great advantage and easy play (many obvious good moves), however if black plays perfectly he can secure a draw here. We also know that if we play *B* and then play perfectly for the next 100 moves, we will win with mathematical certainty, but if we make just one incorrect move during those 100 moves, we will get to a decisively losing position. While computer will play move *B* here because it is sure it can play perfectly, it is probably better to play *A* for human because human is very likely to make mistakes (even a master). For this reason humans may willingly choose to play mathematically worse moves -- it is because a slightly worse move may lead to a safer and more comfortable play for a human. This fact has also recently been demonstrated by a modified Leela engine that specifically focuses on handicapped play (playing without one knight or rook) against humans -- even though Stockfish is objectively a better engine than Leela, this specific Leela version achieves better results under stated conditions, i.e. it more often beats human grandmasters in odds games, and that's because it learned to play moves that are not objectively methematically best, but rather best AGAINST HUMANS, i.e. creating confusion, tension, tricky and unusual situations and psychological pressure that favor precise engines.

[Fun](fun.md) fact: there seem to be **almost no black people in [chess](chess.md)** :D the strongest one seems to be Pontus Carlsson which rates number 1618 in the world; even [women](woman.md) seem to be much better at chess than black people. [This](http://www.billwallchess.com/articles/Black%20chess%20players.htm) website says that as of 2015 there were only 3 black grandmasters in the whole world. But how about black women? [LMAO](lmao.md), it seems like there haven't even been any black female masters :'D The web is BLURRY on these facts, but there seems to be a huge excitement about one black female, called Rochelle Ballantyne, who at nearly 30 years old has been sweating for a decade to reach the lowest master rank (the one which the nasty oppressive white boys get at like 10 years old) and MAYBE SHE'LL DO IT, she seems to have with all her effort and support of the whole Earth overcome the 2000 rating, something that thousands of amateurs on the net just causally do every day without even trying too much. But of course, it's cause of the white male oppression =3 lel { anti-disclaimer :D Let's be reminded [we](lrs.md) love all people, no matter skin color or gender. We are simply stating facts about nature, which don't always respect political correctness. ~drummyfish } EDIT: We seem to have missed Tuduetso Sabure who became a WOMAN grandmaster (i.e. NOT a regular grandmaster) in 2005, however her peak rating is merely 2075, which is quite low, seems very sus.

## Chess And Computers

{ [This](https://www.youtube.com/watch?v=DpXy041BIlA) is an absolutely amazing video about weird chess algorithms :) And here is a very lovely article about someone's memories of his old competitive chess program: https://www.lkessler.com/brutefor.shtml. ~drummyfish }

[Computers](computer.md) not only help people play chess, train their skills, analyze positions and perform research of games, but they also allow mathematical analysis of the game of chess itself and present a platform for things such as [artificial intelligence](ai.md). Knowledge gained from programming chess engines can then be applied in other areas as well. Since the dawn of the computer era computer chess has been a topic of passion and interest to [computer scientists](compsci.md) and [programmers](programming.md) -- not just because nerds usually love both chess and computer and it's only natural they will desire to combine the two, and not only because making a machine beat human at the most famous and iconic of all intellectual games is just a great and symbolic achievement in itself, but also because computer chess is just so much [fun](fun.md). For example you may let various engines play against each other, just sit back and make your own mini computer engine tournament, compare the strength of your engines, let them play from funny starting positions, let a strong engine with material handicap play a weak engine, program a strong engine to play the worst moves possible or program it completely arbitrary or weird goals such as that it can only checkmate with a pawn or that it will just want to place all its pieces on white squares, and then watch it try hard to achieve the goal. It's endless joy.

**Chess [software](software.md)** is usually separated to **[libraries](library.md)**, **chess engines** and **[frontends](frontend.md)**. Library is just that -- a programming library that will help a programmer create some kind of chess program. Chess engine on the other hand is a complete program whose main purpose is to compute good chess moves, it is typically a [CLI](cli.md) program capable of playing chess but also doing other things such as evaluating arbitrary positions, hinting best moves, saving and loading games etc. -- commonly the engine has some kind of custom CLI interface (flags, interactive commands it understands, ...) plus a support of some standardized text communication protocol, most notably XBoard (older one, more [KISS](kiss.md)) and/or UCI (newer, more [bloated](bloat.md)). It is also a must for an engine to support other standard formats such as **FEN** (Forsyth–Edwards notation, way of encoding a chess position as a text string), **PGN** (portable game notation, way of encoding games as text strings) etc. And then there are frontends (also called *boards*) -- these are, almost by definition, [GUI](gui.md) programs that help mere mortal people interact with the underlying engine (and do other things like play against other humans, annotate games and so on). There also exist other kinds of programs, e.g. tournament managers that automatically run a tournament of several chess engines, calculate their strength etc. As seen, the chess "ecosystem" exemplifies a textbook modularity (it is possible to easily drop-in replace any part of your chess system as they are all just black boxes with the same interface) and the whole system stands on a solid, standardized, relatively simple plain text protocols, giving a shining example of [Unix philosophy](unix_philosophy.md) and [good design](lrs.md) in practice. In an [ideal world](less_retarded_society.md) all games would be implemented this way.

Computers have already surpassed the best humans in their playing strength (we can't exactly assign [Elo](elo.md) rating to an engine alone, as hardware it runs on plays a vital role, but as a general statement it's nowadays easy for anyone to carry around a pocket chess computer rated high above 3000 FIDE, i.e. capable of easily shattering even the world champion). As of 2023 the strongest chess engine is undoubtedly the [FOSS](foss.md) engine **[Stockfish](stockfish.md)**, with other strong ones being e.g. Leela Chess Zero (also FOSS), AlphaZero ([proprietary](proprietary.md) by [Google](google.md)) or Komodo Dragon (proprietary). [GNU Chess](gnu_chess.md) is a fairly strong [free software](free_software.md) engine by [GNU](gnu.md). There are world championships for chess engines such as the *Top Chess Engine Championship* or *World Computer Chess Championship*. [CCRL](https://ccrl.chessdom.com/ccrl/4040/) is a list of chess engines along with their Elo ratings deduced from tournaments they run. Despite the immense strength of modern engines, there are still some specific artificial situations in which a human beats the computer (shown e.g. in [this](https://www.youtube.com/watch?v=R9IZWgArWUE) video); this probably won't last long though.

The first chess computer that beat the world champion (at the time Gary Kasparov) was famously [Deep Blue](deep_blue.md) in 1997. [Alan Turing](turing.md) himself has written a chess playing [algorithm](algorithm.md) but at his time there were no computers to run it, so he executed it by hand -- nowadays the algorithm has been implemented on computers (there are bots playing this algorithm e.g. on lichess).

Playing strength is not the only possible measure of chess engine quality, of course -- for example there are people who try to make the **smallest chess programs** (see [countercomplex](countercomplex.md) and [golfing](golf.md)). As of 2022 the leading programmer of smallest chess programs seems to be Oscar Toledo G. (https://nanochess.org/chess.html). Unfortunately his programs are [proprietary](proprietary.md), even though their source code is public. The programs include Toledo Atomchess (392 [x86](x86.md) instructions), Toledo Nanochess (world's smallest [C](c.md) chess program, 1257 non-blank C characters) and Toledo Javascript chess (world's smallest [Javascript](javascript.md) chess program). He won the [IOCCC](ioccc.md). Another small chess program is micro-Max by H. G. Muller (https://home.hccnet.nl/h.g.muller/max-src2.html, 1433 C characters, Toledo claims it is weaker than his program). Other engines try to be strong while imitating human play (making human moves, even mistakes), most notably Maia which trains several neural networks that play like different rated human players.

{ Nanochess is actually pretty strong, in my testing it easily beat [smallchesslib](smallchesslib.md) Q_Q ~drummyfish }

Visualizing chess state space can be [interesting](interesting.md). Here is one idea: draw the board with all squares black except the ones with men which can be moved -- color these white. Now [recursively](recursion.md) replace each square with a similar picture: the black ones will stay black, the white ones will be replaced by boards where only the square to which the man in question can be moved will be colored white. And so on until certain depth. Of course the image will be getting very large quickly and will also be quite black, so some kind of improvement may be employed: for example make the black square as small as possible. Additional fanciness can also be added, e.g. maybe don't redraw the squares but just keep brightening them or whatever. Any chess game played can then be visualized as zooming into this large image. This kind of visualization may also be applied to any other game which is played on a board by "clicking" squares, i.e. also tic tac toe, go etc.

### Programming Chess

NOTE: our [smallchesslib](smallchesslib.md)/smolchess engine is very simple, educational and can hopefully serve you as a nice study tool to start with :)

There is also a great online [wiki](wiki.md) focused on programming chess engines: https://www.chessprogramming.org.

Programming chess is a [fun](fun.md) and enriching experience and is therefore recommended as a good exercise. There is nothing more satisfying than writing a custom chess engine and then watching it play on its own.

The core of chess programming is writing the [AI](ai.md). Everything else, i.e. implementing the rules, communication protocols etc., is usually pretty straightforward (but still a good programming exercise). Nevertheless, as the chess programming wiki stresses, one has to pay a great attention to eliminating as many [bugs](bug.md) as possible; really, the importance of writing automatic tests can't be stressed enough as debugging the AI will be hard enough and can become unmanageable with small bugs creeping in. However to make the AI good it's important to [optimize](optimization.md) the functions that work with the board, i.e. it's important to be able to generate moves quickly, quickly detect checks/mates and so on (because the AI will be checking billions of positions, any optimization will allow to search many more positions). Thought has to go into choosing right [data structures](data_structure.md) so as to allow nice [optimizations](optimization.md), for example board representation plays an important role -- main approaches here are for example having a 8x8 2D array holding each square's man, keeping a list of men (each explicitly recording its coordinates) or bitboards (8x8 times bit arrays, one for each piece type, recording where each man is placed).

The AI itself works traditionally on the following principle: firstly we implement so called static **evaluation function** -- a function that takes a chess position and outputs its evaluation number which says how good the position is for white vs black (positive number favoring white, negative black, zero meaning equal, units usually being in pawns, i.e. for example -3.5 means black has an advantage equivalent to having extra 3 and a half pawns; to avoid fractions we sometimes use centipawns, i.e. rather -350). This function considers a number of factors such as total material of both players, pawn structure, king safety, men mobility and so on. Traditionally this function has been hand-written (also called HCE, hand crafted evaluation), nowadays it is being replaced by a learned [neural network](neural_network.md) ([NNUE](nnue.md)) which showed to give superior results (e.g. Stockfish still offers both options, however the neural net seems to save about half of the computation time); for starters you probably want to write a simple evaluation function manually. However even a manually crafted evaluation function may later on be fine tuned by some kind of machine learning -- the algorithm stays the same but the parameters, such as exact values of chessmen or bonus points for certain patterns on the board (connected rooks, good pawn structure etc.), may be determined e.g. by brute force trial and error or with smarter techniques like evolutionary programming, to maximize the playing strength of the engine.

Note: if you could make a perfect evaluation function that would completely accurately state given position's true evaluation (considering all possible combinations of moves until the end of game), you'd basically be done right there as your AI could just always make a move that would take it to the position which your evaluation function rated best, which would lead to perfect play by searching just to depth 1. Though neural networks got a lot closer to this ideal than we once were, as far as we can foresee ANY evaluation function will always be just an [approximation](approximation.md), an estimation, [heuristic](heuristic.md), many times far from perfect evaluation, so we cannot stop at this. We have to program yet something more. However some more relaxed engines that don't aim to be among the best can already work in the lazy way and be pretty good opponents -- see for example the Maia engine.

So secondly we need to implement a so called **search** algorithm -- typically some modification of the [minimax](minimax.md) algorithm, e.g. with alpha-beta pruning -- that [recursively](recursion.md) searches the game tree and looks for a move that will lead to the best result in the future, i.e. to position for which the evaluation function gives the best value (minimax in short: the evaluation of current position is the maximum of evaluations of all our moves, out of which evaluation of each is the minimum of all opponent's moves, i.e. the best opponent's response, then again we search for maximum of our moves, i.e. our best response, etc. until given depth). This basic principle, especially the search part, can get very complex as there are many possible weaknesses and optimizations. For example (somewhat counterintuitively) it turns out to be a good idea to do iterative deepening, i.e. first searching to depth 1, then to depth 2, then to depth 3 etc., rather than searching to depth N right away. But again, this is all too complicated to expand on here. Just note now that doing the search kind of improves on the basic static evaluation function by making it [dynamic](dynamic.md) and so increases its accuracy greatly (of course for the price of CPU time spent on searching).

Exhaustively searching the tree to great depths is not possible even with most powerful [hardware](hw.md) due to astronomical numbers of possible move combinations, so the engine has to limit the depth quite greatly and use various [hacks](hacking.md), [approximations](approximation.md), [heuristics](heuristic.md), [caches](cache.md) etc.. Normally it will search all moves to a small depth (e.g. 2 or 3 half moves or *plys*) and then extend the search for interesting moves such as exchanges or checks. Maybe the greatest danger of searching algorithms is so called **horizon effect** which has to be addressed somehow (e.g. by detecting quiet positions, so called *quiescence*). If not addressed, the horizon effect will make an engine misevaluate certain moves by stopping the evaluation at certain depth even if the played out situation would continue and lead to a vastly different result (imagine e.g. a queen taking a pawn which is guarded by another pawn; if the engine stops evaluating after the queen's pawn capture, it will think it's a won pawn, when in fact it's a lost queen). There are also many techniques for reducing the number of searched tree nodes and speeding up the search, for example pruning methods such as **alpha-beta** (which subsequently works best with correctly ordering moves to search), or **transposition tables** (remembering already evaluated position so that they don't have to be evaluated again when encountered by a different path in the tree). Furthermore we may try to combine many different things together, for example exhaustive search for some situations along with monte carlo in others; we may also try to employ more machine learning, e.g. make a special neural net just for suggesting which moves and to what depth should be searched etc.

**Alternative approaches**: most engines work as described above (search plus evaluation function) with some minor or bigger modifications. The simplest possible stupid AI can just make random moves, which will of course be an extremely weak opponent (though even weaker can be made, but these will actually require more complex code as to play worse than random moves requires some understanding and searching for the worst moves) -- one might perhaps try to just program a few simple rules to make it a bit less stupid and possibly a simple training opponent for complete beginners: the AI may for example pick a few "good looking" candidate moves that are "usually OK" (pushing a pawn, taking a higher value piece, castling, ...) and aren't a complete insanity, then pick one at random only from those (this randomness can further be improved and gradually controlled by scoring the moves somehow and adding a more or less random value from some range to each score, then picking the moves with highest score). One could also try to just program in a few generic rules such as: checkmate if you can, otherwise take an unprotected piece, otherwise protect your own unprotected piece etc. -- this could produce some beginner level bot. Another idea might be a "Chinese room" bot that doesn't really understand chess but has a huge database of games (which it may even be fetching from some Internet database) and then just looking up what moves good players make in positions that arise on the board, however a database of all positions will never exist, so in case the position is not found there has to be some fallback (e.g. play random move, or somehow find the "most similar position" and use that, ...). As another approach one may try to use some **non neural network [machine learning](machine_learning.md)**, for example [genetic programming](genetic_programming.md), to train the evaluation function, which will then be used in the tree search. Another idea that's being tried (e.g. in the Maia engine) is **pure neural net AI** (or another form of machine learning) which doesn't use any tree search -- not using search at all has long been thought to be impossible as analyzing a chess position completely statically without any "looking ahead" is extremely difficult, however new neural networks have shown to be extremely good at this kind of thing and pure NN AIs can now play on a master level (a human grandmaster playing ultra bullet is also just a no-calculation, pure pattern recognition play) -- a paper called *Grandmaster-Level Chess Without Search* managed to implement pure NN engine that on Lichess achieved rating of 2895, close to the strongest engines on the site. Next, **[Monte Carlo](monte_carlo.md) tree search** (MCTS) is an alternative way of searching the game tree which may even work without any evaluation function: in it one makes many random playouts (complete games until the end making only random moves) for each checked move and based on the number of wins/losses/draws in those playouts statistically a value is assigned to the move -- the idea is that a move that most often leads to a win is likely the best. Another Monte Carlo approach may just make random playouts, stop at random depth and then use normal static evaluation function (horizon effect is a danger but hopefully its significance should get minimized in the averaging). However MCTS is pretty tricky to do well. MCTS is used e.g. in Komodo Dragon, the engine that's currently among the best. Another approach may lie in somehow using several methods and [heuristics](heuristic.md) to vote on which move would be best.

Many other aspects come into the AI design such as opening books (databases of best opening moves), endgame tablebases (precomputed databases of winning moves in simple endgames), clock management, pondering (thinking on opponent's move), learning from played games etc. For details see the above linked chess programming wiki.

### Notable Chess Engines/Computers/People/Entities

*See also ratings of computer engines at https://www.computerchess.org.uk/ccrl/4040/.*

Here are some notable chess engines/computers/entities, as of 2024:

- **[Stockfish](stockfish.md)** (SF): [FOSS](foss.md) engine (written in [C++](cpp.md)), without any doubt **the strongest chess engine** that's been reliably winning all the computer tournaments for years now; its strength is far beyond any human, even if run on quite a weak device -- it actually caused some trouble because it's extremely easy to just download onto a cellphone and [cheat](cheating.md) even in OTB tournaments. Currently the engine is using a [neural network](neural_network.md) for evaluating positions but still also uses a search algorithm (a greatly optimized one so that it searches gigantic numbers of positions per second to very high depth) and offers using hand crafted evaluation as well. It's actually quite well written and only runs on the [CPU](cpu.md), it supports many different [architectures](isa.md) and is very [portable](portability.md), unlike for example LC0 which requires a bloated [GPU](gpu.md). Important part of Stockfish development is so called *Fishtest*, a distributed framework for testing and improving the engine's performance, it's one of the reasons why it good so strong. Stockfish's current CCRL Elo rating is 3639 (warning: this is incomparable to human Elos).
- **Magnus Carlsen**: Human, most likely the strongest player ever, has been quite comfortably winning every tournament he entered including the world championship until he quit, basically because he got "bored". His top FIDE Elo was 2882.
- **Komodo Dragon**: [Proprietary](proprietary.md), currently seems to be the second strongest engine, its main feature is [Monte Carlo] ("randomized") search algorithm. Current CCRL Elo is 3624.
- **Hikaru Nakamura**: Human, popularly considered "the second best" right after Magnus (who the mainstream likes to see as his biggest "rival") -- although this is not really so clear, he is definitely among the very top (his peak rating was 2816); We mention him here for his style of play: he likes to [troll](trolling.md) and do various lulz even on high level, many hate him for it. Some say he is a bit of a dick but his chess is definitely extremely entertaining. He also often plays strong computer engines, which is something that Magnus refuses to do (for commercial reasons Magnus only plays his shitty mobile "[app](app.md)"), so thanks to Nakamura we can really watch the best humans play the best computers.
- **Bobby Fischer**: [American](usa.md) player of the 20th century who is now dead already but who used to be, and by some still is, considered the best player of all time, although objectively speaking he probably isn't as good as some of the top today's players -- anyway he was funny in that he turned kind of [schizo](schizo.md) later on and started to make some lulz, which was yet amplified by the fact that he took part in the great cold war intellectual battle with Soviet Russia, his match against Spassky became legendary, it was extremely tense and also funny (look it up).
- **[Leela Chess Zero](lc0.md)** (lc0): FOSS engine (written in C++), among top strongest engines (currently top 50 on CCRL), it is interesting mainly for how it works: it is a neural network engine that's **completely self-taught** from the ground up, i.e. it didn't learn chess by watching anyone else play, it was only allowed to learn by playing against itself. Current CCRL Elo is 3441.
- **[Deep Blue](deep_blue.md)**: A historically famous supercomputer, the first one to have beaten the human world chess champion in 1997.
- **[GNU chess](gnu_chess.md)** Free engine by [GNU](gnu.md), not among absolute top by strength but still very strong. Current CCRL Elo is 2825.
- **Maia**: FOSS engine, or rather neural network, notable by not trying to be the strongest, but rather most human-like, i.e. tries to imitate human play, even with errors. There are several versions, each trained for different strength. It is also notable by using pure neural network, i.e. it doesn't perform any search, it's a pure "pattern recognition"/static engine that still manages to play quite well.
- **Toledo Nanochess**: Seems to be the world's smallest [C](c.md) chess engine, with only 1257 non-blank characters of source code.
- **[smallchesslib](smallchesslib.md)/smolchess**: Tiny [LRS](lrs.md) [C](c.md) library/engine, very weak but is quite simple, small and [portable](portability.md), may be [good enough](good_enough.md) in many situations.
- **Chessmaster**: A famous proprietary chess video games with its own engine, it was strong for a video game of its time (around 2000 Elo) but nowadays would be considered rather weak for an engine -- its significance is cultural, it's used for comparisons, many people played against it and still use it to test their engines against.
- **Turochamp**: Probably the first chess program ever, made by David Champernowne and [Alan Turing](turing.md) himself in 1948, in times when computers still couldn't execute it! It was very primitive, looking only two moves ahead, and was only ever executed manually -- of course, it got raped pretty bad the human opponent.
- ...

## Rules

The exact rules of chess and their scope may depend on situation, this is just a sum up of rules generally used nowadays. Nowadays the official rules are considered to be those defined by FIDE.

The start setup of a chessboard is following (lowercase letters are for black men, uppercase for white men, on a board with colored squares A1 is black):

```
        _______________
    /8 |r n b q k b n r|
 r | 7 |p p p p p p p p|
 a | 6 |. . . . . . . .|
 n | 5 |. . . . . . . .|
 k | 4 |. . . . . . . .|
 s | 3 |. . . . . . . .|
   | 2 |P P P P P P P P|
    \1 |R N B Q K B N R|
        """""""""""""""
        A B C D E F G H
        \_____________/
             files
```

Players take turns in making moves, white always starts. A move consists of moving one (or in special cases two) of own men from one square to another, possibly capturing (removing from the board) one opponent's man -- except for a special *en passant* move capturing always happens by moving one man to the square occupied by the opposite color man (which gets removed). Of course no man can move to a square occupied by another man of the same color. A move can NOT be skipped. A player wins by giving a **checkmate** to the opponent (making his king unable to escape attack) or if the opponent resigns. If a player is to move but has no valid moves, the game is a draw, so called **stalemate**. If neither player has enough men to give a checkmate, the game is a draw, so called **dead position**. There are additional situation in which game can be drawn (threefold repetition of position, 50 move rule). Players can also agree to a draw. A player may also be declared a loser if he cheated, if he lost on time in a game with clock etc.

The individual men and their movement rules are (no man can move beyond another, except for knight who jumps over other men):

| man            | symbol | ~value | movement                                                           |     comment           |
| -------------- | -------| ------ | ------------------------------------------------------------------ | --------------------- |
| pawn           | P      | 1      |1F, may also 2F from start, captures 1F1L or 1F1R, also *en passant*| promotes on last row  |
| knight         | N      | 3      |L-shape (2U1L, 2U1R, 2R1U, 2R1D, 2D1R, 2D1L, 2L1U, 2L1D), jumps over|                       |
| bishop         | B      | 3.25   | any distance diagonally                                            |stays on same color sq.|
| rook           | R      | 5      | any distance orthogonally (U, R, D or L)                           |can reach all sq.      |
| queen          | Q      | 9      | like both bishop and rook                                          |strongest piece        |
| king           | K      | inf    | any of 8 neighboring squares                                       |                       |

{ Cool players call knights *horses* or *ponies* and pawns *peasants*, rook may be called a *tower* and bishop a *sniper* as he often just sits on the main diagonal and shoot pieces that wonder through. Also pronounce *en passant* as "en peasant". Nakamura just calls all pieces a *juicer*. ~drummyfish }

**Check**: If the player's king is attacked, i.e. it is immediately possible for an enemy man to capture the king, the player is said to be in check. A player in check has to make such a move as to not be in check after that move.

A player cannot make a move that would leave him in check! This also implies that the two kings on the board can never stand right next to each other (this can be remembered by reminding oneself the kings aren't [gay](gay.md) and don't want to touch each other).

**Castling**: If a player hasn't castled yet and his king hasn't been moved yet and his kingside (queenside) rook hasn't been moved yet and there are no men between the king and the kingside (queenside) and the king isn't and wouldn't be in check on his square or any square he will pass through or land on during castling, short (long) castling can be performed. In short (long) castling the king moves two squares towards the kingside (queenside) rook and the rook jumps over the king to the square immediately on the other side of the king.

**Promotion**: If a pawn reaches the 1st or 8th rank, it is promoted, i.e. it has to be switched for either queen, rook, bishop or knight of the same color.

**Checkmate**: If a player is in check but cannot make any move to get out of it, he is checkmated and lost.

**En passant** (aka "surprise motherfucker", pronounced as *en peasant*): If a pawn moves 2 squares forward (from the start position), in the immediate next move the opponent can take it with a pawn in the same way as if it only moved 1 square forward (the only case in which a man captures another man by landing on an empty square).

Threefold repetition is a rule allowing a player to claim a draw if the same position (men positions, player's turn, castling rights, en passant state) occurs three times (not necessarily consecutively). The 50 move rule allows a player to claim a draw if no pawn has moved and no man has been captured in last 50 moves (both players making their move counts as a single move here).

## Stats And Records

Chess stats are pretty [interesting](interesting.md). Thanks a lot e.g. to OEIS and Lichess (and NOT thanks to fucking capitalist idiots like chess dot com) we have some great [public domain](public_domain.md) databases and analyses of billions of games played between both people and computers, and thanks to chess engines we can generate new and new on demand, so naturally many people create cool statistics, look for patterns and oddities. This can be very insightful and entertaining.

{ Some chess world records are here: https://timkr.home.xs4all.nl/records/records.htm. ~drummyfish }

**Number of possible games** is not known exactly, Shannon estimated it at 10^120 (lower bound, known as *Shannon number*). Number of possible games by plies played is 20 after 1, 400 after 2, 8902 after 3, 197281 after 4, 4865609 after 5, and 2015099950053364471960 after 15 ([OEIS A048987](https://oeis.org/A048987)). { I plotted the ratio of subsequent terms of the sequence and they seem to form a quite predictable pattern, a kind of zig-zag line. I tried to quickly extrapolate this with the curve (5 * x)^0.65 + 17 and estimated the number of games after ply 30 to be 13*10^44. ~drummyfish }

Similarly the **number of possibly reachable positions** (position for which so called *proof game* exists) is not known exactly, some upper estimates have been made, lower bounds are much harder to set. The estimates are placed around 10^40 or 10^50 at most. [Here](https://tromp.github.io/chess/chess.html) is a site that gives a proven upper estimate of 45193640626062205213735739171550309047984050718 (2^155), also providing a more precise one of 7728772977965919677164873487685453137329736522 (~10^45.888, ~2^152) which was however proven with a program that's a bit obscure and less trustworthy. Numbers of possible positions by plies are 20 after 1, 400 after 2, 5362 after 3, 72078 after 4, 822518 after 5, and 726155461002 after 11 ([OEIS A083276](https://oeis.org/A083276)).

**Shortest possible checkmate** is by black on ply number 4 (so called *fool's mate*); in fact there are 8 different games that can end like this. As of 2022 the **longest known forced checkmate** is in 549 moves -- it has been discovered when computing the Lomonosov Tablebases. EDIT: now it seems there is one in 584 moves. Please note this: there most likely exist much longer forced mates, these are just the KNOWN ones. Consider e.g. that if black blunders a queen in the opening, the game is very likely a theoretical win for white since then, i.e. a forced mate, and with perfect play black can probably resist for very long. However such situations are too complex to explore fully.

Average game of chess lasts 40 (full) moves (80 plies). **Average [branching factor](branching_factor.md)** (number of possible moves at a time) is around 33. **Maximum number of possible moves in a position** seems to be 218 (FEN: `R6R/3Q4/1Q4Q1/4Q3/2Q4Q/Q4Q2/pp1Q4/kBNN1KB1 w - - 0 1`). As for **total number of legal moves**, if we consider only *squareFrom-squareTo* notation (such as *e3e5*, without recording chessmen, promotions etc.), there are 1792 different moves that can ever legally be performed.

White wins about 38% of games, black wins about 34%, the remaining 28% are draws (38.7%, 31.1%, 30.3% respectively on Computer Chess Rating Lists).

What is the **longest possible game**? It depends on the exact rules and details we set, for example if a 50 move rule applies, a player MAY claim a draw but also doesn't have to -- but if neither player ever claims a draw, a game can be played infinitely -- so we have to address details such as this. Nevertheless the longest possible chess game upon certain rules has been computed by [Tom7](tom7.md) at 17697 half moves in a paper for [SIGBOVIK](sigbovik.md) 2020. Chess programming wiki states 11798 half moves as the maximum length of a chess game which considers a 50 move rule (1966 publication).

The **longest game played in practice** is considered to be the one between Nikolic and Arsovic from 1989, a draw with 269 moves lasting over 20 hours. For a shortest game there have been ones with zero moves; serious decisive shortest game has occurred multiple times like this: `1.d4 Nf6 2.Bg5 c6 3.e3 Qa5+` (white resigned).

**Best players ever**: a 2017 paper called *Who is the Master?* analyzed 20 of the top players of history based on how good their moves were compared to Stockfish, the strongest engine. The resulting **top 10** was (from best): Carlsen (born 1990 Norway, peak Elo 2882), Kramnik (born 1975 Russia, peak Elo 2817), Fischer (born 1943 USA, peak Elo 2785), Kasparov (born 1963 Russia, peak Elo 2851), Anand (born 1969 India, peak Elo 2817), Khalifman, Smyslov, Petrosian, Karpov, Kasimdzhanov. It also confirmed that the quality of chess play at top level has been greatly increasing. The **best [woman](woman.md) player** in history is considered to be Judit Polgar (born 1976 Hungary, peak Elo 2735), which still only managed to reach some 49th place in the world; by Elo she is followed by Hou Yifan (born 1994 China, peak Elo 2686) and Koneru Humpy (born 1987 India, peak Elo 2623). **Strongest players of black [race](race.md)** (NOT including brown, e.g. India): lol there don't seem to be many black players in chess :D The first black GM only appeared in 1999 (!!!) -- Maurice Ashley (born 1966 Jamaica, peak rating 2504) who is also probably the most famous black chess player, though more because of his commentator skills; Pontus Carlsson (peak Elo 2531) may be strongest. { Sorry if I'm wrong about the strongest black player, this information is pretty hard to find as of course you won't find a race record in any chess player database. So thanks to political correctness we just can't easily find good black players. ~drummyfish } **Strongest engine** is currently the latest version of Stockfish NNUE.

**How much [Elo](elo.md) is one pawn worth in odds games?** I.e. if we let a player start with a disadvantage of *N* pawns, how much will his Elo drop? Firstly this depends on the rating of both players -- giving a rook to a 200 Elo player does almost nothing while in a master-level game such disadvantage presents a fatal blow. According to [this website](https://wismuth.com/elo/calculator.html) one pawn advantage is approximately equal to 100, 200 and 300 Elo increase for average player ratings 1250, 2000 and 2500 respectively.

What is **the most typical game**? We can try to construct such a game from a game database by always picking the most common move in given position. Using the lichess database at the time of writing, we get the following incomplete game (the remainder of the game is split between four games, 2 won by white, 1 by black, 1 drawn):

```
1. e4 e5 2. Nf3 Nc6 3. Bc4 Bc5 4. c3 Nf6 5. d4 exd4 6. cxd4 Bb4+
7. Nc3 Nxe4 8. O-O Bxc3 9. d5 Bf6 10. Re1 Ne7 11. Rxe4 d6
12. Bg5 Bxg5 13. Nxg5 h6 14. Qe2 hxg5 15. Re1 Be6 16. dxe6 f6
17. Re3 c6 18. Rh3 Rxh3 19. gxh3 g6 20. Qf3 Qa5 21. Rd1 Qf5
22. Qb3 O-O-O 23. Qa3 Qc5 24. Qb3 d5 25. Bf1
```

**Note on good and BAD play**: as we'll be looking at WORST moves and games, there's a similar catch as when looking for the BEST ones (see note on perfect play above). When judging something as good or bad, we have to ask "good or bad considering WHAT kind of players?" (what skill, what goal, what kind of behavior, ...) -- best move for an engine may require precise play and so may not be best for human, and best move for a grandmaster may not be the best for average player, AND also a good move against human may be not best against a computer and vice versa. For example when looking for the worst move in a position, the first we think of is this: consider all moves and take the one which will take us to a position that has the worst evaluation by computer engine. This is quite cool, but not always and may not really be what we want, because when evaluating the position, the computer assumes GOOD play from both sides. So when we e.g. flip the rules and try to make computers play the worst moves and get themselves mated, they should rather assume the opponent to play the WORST moves, we want a different kind of estimate -- here it's not enough to offer opponent a checkmate, but also ensure he MUST give it. So these are some things to keep in mind.

What's **the best and worst opening move according to the engines?** With what's been said above, the answer will also depend on which engine (what evaluation function) you use and to what depth you search. The situation is basically this: both engines and humans are deciding between e4 or d4 for the best move, opinions differ and strongest engines currently oscillate between e4 and d4 as we keep analyzing the starting position deeper and deeper. According to Lichess cloud database (accessible via public API) that stores stockfish evaluations for various positions, e4 leads to the best evaluated position (18 centipawn, evaluated to depth 70), closely followed by d4 and Nf3 (both 17 centipawn, depth 47 and 56) and c4 (12 centipawn, depth 59). Lichess stockfish is currently an older version (14) also running in the web browser, so not absolutely strongest, but still very strong. On Chessbase (proprietary database) someone analyzed the starting position to depth 79 with stockfish 12, giving evaluation 0.17 and best move d4 (followed by Nf6 c4 ...). Running the strongest version of stockfish at this point (stockfish 17) to depth 65 (which took some 4 hours) also gives best move d4 (followed by Nf6), but as said, it just seems to go there and back between e4 and d4. So pick one. Worst move, as in "leading to worst evaluation in Lichess database" (also usually given by humans), is by far g4 with evaluation -96 centipawn (depth 52) -- almost a whole pawn, i.e. stockfish says that by playing this move you basically just throw away your pawn immediately. Another bad move is apparently f3 (-76, depth 40), Nh3 (-42), Na3 (-33), b4 or h4 (both -28). So g4 is likely the worst move under normal conditions, however if we play an opponent who is also trying to play the worst moves, i.e. we flip the rules and make each player try to get himself mated (in a computer engine flip the sign of the evaluation function), the engine actually elects e3 as the worst move, because that allows the white queen to immediately run out, attack the enemy king face to face and force him to take it.

How big is the **white's starting move advantage**? Based on the above evaluations of all starting moves the initial position is rated at about 18 centipawn (for the best move found, e4), i.e. with this specific engine and search depth we are told white has, in material terms, an advantage of almost a fifth of a pawn.

What's **the perfect game according to an engine**? Again, this will vary depending on new and better versions of engines coming out, on hardware, time we spend on computing moves etc. The following annotated draw was produced by taking a few first highly analyzed moves from the Lichess cloud database and letting the rest of the game be played by stockfish 17, the strongest available engine at the time, at a reasonably powerful desktop PC, giving each player 90 minutes plus 10 second increment, with endgame tablebases proving that since 7 men on the board the game is really a theoretical draw:

```
1.  e4    {Lichess } e5    {Lichess } 2.  Nf3  {Lichess } Nc6  {Lichess }
3.  Bb5   {Lichess } Nf6   {Lichess } 4.  O-O  {+0.10/49} Nxe4 {-0.06/49}
5.  Re1   {+0.12/46} Nd6   {-0.06/45} 6.  Nxe5 {+0.09/49} Be7  {-0.07/46}
7.  Bf1   {+0.09/47} Nxe5  {-0.06/42} 8.  Rxe5 {+0.15/44} O-O  {-0.10/43}
9.  Nc3   {+0.20/58} Bf6   {-0.09/43} 10. Re1  {+0.13/43} Re8  {-0.04/41}
11. Nd5   {+0.08/46} Rxe1  {-0.10/42} 12. Qxe1 {+0.12/49} b6   {-0.12/45}
13. Nxf6+ {+0.13/44} Qxf6  {-0.16/45} 14. c3   {+0.16/56} Bb7  {-0.14/40}
15. d3    {+0.12/42} Re8   {-0.13/42} 16. Qd1  {+0.12/43} c5   {-0.11/40}
17. Qg4   {+0.18/41} Bc6   {-0.12/42} 18. Bd2  {+0.10/43} g6   {-0.10/39}
19. Rc1   {+0.12/42} h5    {-0.10/46} 20. Qg3  {+0.13/39} b5   {-0.12/47}
21. b3    {+0.02/48} a5    {-0.02/40} 22. Bg5  {+0.03/47} Qe6  {-0.02/45}
23. Bd2   {+0.00/45} Qf6   {-0.01/44} 24. a3   {+0.08/48} Kh7  {+0.00/42}
25. Qf4   {+0.03/46} Qxf4  {+0.00/48} 26. Bxf4 {+0.00/38} Nf5  {+0.00/52}
27. f3    {+0.00/43} f6    {+0.00/54} 28. Kf2  {+0.00/47} Ra8  {+0.00/48}
29. Bc7   {+0.00/52} b4    {+0.00/63} 30. a4   {+0.00/56} Bd5  {+0.00/53}
31. d4    {+0.00/49} Bxb3  {+0.00/59} 32. dxc5 {+0.00/60} Bxa4 {+0.00/60}
33. Ra1   {+0.00/76} Bc6   {+0.00/63} 34. cxb4 {+0.00/53} axb4 {+0.00/47}
35. Rxa8  {+0.00/48} Bxa8  {+0.00/55} 36. Ba5  {+0.00/51} Nd4  {+0.00/56}
37. Bxb4  {+0.00/47} Kg7   {+0.00/50} 38. Bd2  {+0.00/54} h4   {+0.00/69}
39. Bf4   {+0.00/64} Bc6   {+0.00/61} 40. Bd3  {+0.00/50} Ne6  {+0.00/78}
41. Bd6   {+0.00/54} Nd4   {+0.00/63} 42. Bf4  {+0.00/69} Ne6  {+0.00/65}
43. Bd6   {+0.00/57} Ng5   {+0.00/56} 44. Bf4  {+0.00/68} Nf7  {+0.00/56}
45. Ke3   {+0.00/70} Nd8   {+0.00/56} 46. Bc7  {+0.00/58} Ne6  {+0.00/62}
47. Bd6   {+0.00/69} Nd8   {+0.00/62} 48. Kf4  {+0.00/63} Nf7  {+0.00/80}
49. Kg4   {+0.00/58} g5    {+0.00/60} 50. Kh3  {+0.00/46} Nd8  {+0.00/58}
51. Kg4   {+0.00/54} Ne6   {+0.00/66} 52. f4   {+0.00/50} Bxg2 {+0.00/66}
53. fxg5  {+0.00/47} fxg5  {+0.00/65} 54. Bf5  {+0.00/70} Kf6  {+0.00/85}
55. Bxe6  {+0.00/87} dxe6  {+0.00/78} 56. Bc7  {+0.00/80} h3   {+0.00/90}
57. Ba5   {+0.00/59} Ke5   {+0.00/73} 58. Kxg5 {+0.00/67} Kd5  {+0.00/85}
59. Bb6   {+0.00/65} e5    {+0.00/74} 60. Ba7  {+0.00/84} Bf1  {+0.00/69}
61. Kg4   {+0.00/72} e4    {+0.00/89} 62. Kf4  {+0.00/95} Bb5  {+0.00/89}
63. Bb6   {+0.00/65} Bc6   {+0.00/84} 64. Kg3  {+0.00/69} e3   {+0.00/66}
65. Kxh3  {+0/80,draw} e2  {+0.00/84} 66. Ba5  {+0.00/70} Kxc5 {+0.00/93}
67. Kg3   {+0.00/78} Kd4   {+0.00/85} 68. Kf2  {+0.00/89} Kd3  {+0.00/82}
69. Bb4   {+0.00/88} Be4   {+0.00/88} 70. Ba5  {+0.00/85} Bh7  {+0.00/91}
71. h4    {+0.00/77} Bg6   {+0.00/72} 72. Bb4  {+0.00/72} Bh5  {+0.00/81}
73. Be1   {+0.00/65} Bg6   {+0.00/85} 74. Kf3  {+0.00/83} Bh5+ {+0.00/69}
75. Kf2   {+0.00/87} Kc2   {+0.00/70} 76. Ke3  {+0.00/77} Kd1  {+0.00/76}
77. Kf2   {+0.00/69} Bf3   {+0.00/70} 78. Bb4  {+0.00/81} Bh5  {+0.00/77}
79. Ke3   {+0.00/65} e1=R+ {+0.00/76} 80. Bxe1 {+0.00/58} Kxe1 {+0.00/72}
81. Kf4   {+0.00/80} Kf2   {+0.00/87} 82. Kg5  {+0.00/84} Bf7  {+0.00/83}
83. h5    {+0.00/98} Bxh5  {+0.00/82} 1/2-1/2  {insufficient material}
```

What's the **theoretically worst game possible**, and how to find out? This is easy: just sit two [women](woman.md) at a chessboard and watch :D OK, [jokes](jokes.md) aside -- like with the perfect game we will probably never know, plus there are the pecularities mentioned above about how we really define "bad play". Anyway we may try this: take the best engine and just revert its evaluation function, i.e. literally flip the sign of evaluation (in practice we usually have to handle some additional stuff in the code that relied on normal evaluation) -- this should basically internally revert the rules of chess to trying to get mated, AND also make sure we assume the opponent is trying to do the same etc. This game will represent the serious effort to really force your opponent to beat you. Doing this with the current best engine, stockfish 17, giving both players 30 minutes plus 10 second increment, leaves us with the following beautifully terrible, excruciatingly long abomination of a game:

```
1. e3 e6 2. Qh5 Qg5 3. Qxf7+ Kd8 4. Qe7+ Kxe7 5. f4 Qg3+ 6. Ke2 Qf3+ 7. Kd3 Qd5+ 8. Ke2 Qd3+
9. Kf3 Qe2+ 10. Bxe2 Kf6 11. Bd3 Nc6 12. Kg4 h5+ 13. Kh3 Rh7 14. Bf5 Ba3 15. Nc3 Ke7
16. Bg4 Nd4 17. Ne4 hxg4+ 18. Kg3 Rh3+ 19. gxh3 Nf3 20. Nd6 c6 21. Ne2 Nf6 22. Nxb7 Ne4+
23. Kg2 Nh4+ 24. Kg1 Ng2 25. Nc3 Ke8 26. Nd5 Ng3 27. Kf2 Ne1 28. Nd8 Bb7 29. h4 a6
30. Ne7 Nf1 31. Kg1 d5 32. Nxe6 Nf3+ 33. Kf2 Ne1 34. Ke2 Nd3 35. Kd1 Nxb2+ 36. Ke2 Ng3+
37. Kf2 Nf1 38. Nc7+ Kf7 39. Ne8 Bc5 40. Nc8 Bxe3+ 41. Kg2 Bb6 42. Na7 Bd8 43. Nf6 Rb8
44. a3 Ke7 45. d4 Rc8 46. Be3 Bc7 47. Nb5 Be5 48. Rd1 Nd3 49. Rc1 Nb4 50. a4 Rg8
51. Nd7 Ke6 52. Nb6 Nd2 53. Bg1 Nf1 54. Kf2 Nd3+ 55. Ke2 Rc8 56. Nc4 Rb8 57. Nca3 Rd8
58. f5+ Ke7 59. h3 Ne3 60. f6+ Ke6 61. Nc7+ Kf5 62. Rf1+ Kg6 63. Na8 Nc1+ 64. Kd2 Bc7
65. Nb5 Ba5+ 66. c3 Nc2 67. Rf3 Rc8 68. h5+ Kh7 69. Re3 Rc7 70. h4 g6 71. Re4 Rg7
72. Kd1 Bxc3 73. f7 Ne3+ 74. Kxc1 Bb2+ 75. Kd2 Nc4+ 76. Ke2 Ne5 77. f8=N+ Kg8 78. Nd6 Rh7
79. Rh3 Bc1 80. Rf3 Bf4 81. Nf7 Rh6 82. Kf2 Nd7 83. Rh3 Rh7 84. Ke2 Nb8 85. Nh8 a5
86. Rh2 Ba6+ 87. Kf2 Be3+ 88. Ke1 Bd2+ 89. Kd1 Re7 90. Kc2 Kg7 91. Rh1 Re5 92. Nh7 Bb7
93. Nf7 Be1 94. Kd3 g5 95. Nh8 Ba6+ 96. Ke3 Bd2+ 97. Kf2 Be1+ 98. Ke3 Be2 99. h6+ Kg8
100. Nb6 Bd2+ 101. Kf2 g3+ 102. Kg2 Bf1+ 103. Kf3 Be2+ 104. Kg2 Bf1+ 105. Kf3 dxe4+
106. Kxg3 Be1+ 107. Bf2 Bh3 108. Nc8 Re7 109. Nf6+ Kf8 110. Ng6+ Kf7 111. Nd6+ Kxf6
112. Ne8+ Kf7 113. Ne5+ Kf8 114. Nd7+ Kg8 115. Nc7 Re5 116. Nd5 Bg2 117. Nb4 Bf1
118. Rh3 Bb5 119. Kg4 Ba6 120. Rf3 Rf5 121. Nc5 Kf8 122. d5 Ke7 123. Nd7 Rf4+ 124. Kh3 Rf6
125. Nc5 Bf1+ 126. Kg3 Rd6 127. Nxc6+ Ke8 128. Rf8+ Kxf8 129. Ne6+ Kf7 130. Nb4 Bh3
131. Nxg5+ Ke7 132. Ne6 Rb6 133. Kf4 Bf5 134. Bc5+ Rd6 135. Bg1 Bd2+ 136. Ke5 Rxd5+
137. Nxd5+ Kd7 138. Nb6+ Ke8 139. Bc5 Bf4+ 140. Kd4 Bd6 141. Bb4 Bg4 142. Kc3 Be2
143. Nc5 Na6 144. Nd3 Nc5 145. Nc8 Bd1 146. Kc4 Bb3+ 147. Kc3 Ne6 148. Kd2 Bd1 149. Ne5 Ng7
150. Nd3 Bc5 151. Nf2 Kd7 152. Kc3 Bd4+ 153. Kd2 Ke6 154. Ng4 Bc3+ 155. Ke3 Nf5+
156. Kf4 Bd2+ 157. Ne3 Bxe3+ 158. Kxe4 Be2 159. Bd6 Nd4 160. Ne7 Bd3+ 161. Kxe3 Ne2
162. Bb4 Be4 163. h5 Nf4 164. Nf5 Kd5 165. Ne7+ Ke6 166. Nf5 Ke5 167. Bc3+ Kd5 168. Bb4 Bf3
169. Kf2 Ke5 170. Kg3 Ne2+ 171. Kh4 Ng3 172. Ne3 Bg4 173. Bd6+ Ke4 174. Kg5 Kf3
175. Bb4 Ne4+ 176. Kg6 Bd7 177. Kf7 Nc3 178. Kf6 Kf4 179. Bd6+ Ke4 180. Bb4 Nd5+
181. Kg5 Bb5 182. Nc4 Ne3 183. Nd2+ Kd5 184. Nc4 Kd4 185. Kf4 Nd5+ 186. Kg5 Be8
187. Bc3+ Kd3 188. Bb4 Bd7 189. Nd6 Bb5 190. Nc4 Be8 191. Kf5 Ne3+ 192. Ke5 Ke2
193. Kf4 Ng2+ 194. Ke4 Bc6+ 195. Ke5 Ne3 196. Kf4 Kd3 197. Ke5 Nd5 198. Nb2+ Ke2
199. Nd3 Nf4 200. Ne1 Nd3+ 201. Kd4 Nc5 202. Nd3 Nb3+ 203. Ke5 Nd4 204. Nf4+ Kf3
205. Nd3 Be8 206. Ne1+ Ke3 207. Bd2+ Ke2 208. Kf4 Bxa4 209. Nd3 Kd1 210. Bb4 Ne2+
211. Kf5 Bd7+ 212. Ke5 Nc1 213. Ke4 Kc2 214. Nb2 Bc6+ 215. Ke3 Ne2 216. h7 Nc3
217. h8=N Nd1+ 218. Kf4 Ne3 219. Nf7 Nf1 220. Ng5 Bf3 221. Ne6 Kc1 222. Nc5 Bb7
223. Nb3+ Kb1 224. Nc1 Kc2 225. Nb3 Ba8 226. Kg4 Bb7 227. Bd2 Ng3 228. Bb4 Bf3+
229. Kh3 Bh1 230. Nc1 Bg2+ 231. Kh4 Bh3 232. Kg5 Ne2 233. Nb3 Bd7 234. Bc3 Nf4 235. Kh4 Ne2
236. Nd2 Ng3 237. Kg5 Ne2 238. Kh4 Be6 239. Nb3 Bg4 240. Na1+ Kb1 241. Nd3 Ng3 242. Kg5 Ne2
243. Bb2 Nf4 244. Kh4 Ne2 245. Nb4 Kxb2 246. Na2 Nf4 247. Kg3 Nh3 248. h6 Ka3 249. h7 Ka4
250. h8=N Kb5 251. Nb4 Ng5 252. Nf7 Ne4+ 253. Kh4 Kc4 254. Nb3 Kc3 255. Nd6 Ng5 256. Nc4 Bh3
257. Kh5 Bf5 258. Kh6 Bg6 259. Kg7 Nh7 260. Nd4 Nf6 261. Nb5+ Kb3 262. Nb2 Ng8 263. Nc2 Bf7
264. Kh7 Bg6+ 265. Kh8 Bh5 266. Nca3 Bf7 267. Na4 Kxa4 268. Nc3+ Kb4 269. Na4 Bd5
270. Kh7 Bf7 271. Kh8 Nf6 272. Kg7 Ng8 273. Kxf7 Kb3 274. Ke6 Ne7 275. Ke5 Nc6+
276. Kd5 Nb4+ 277. Kc5 Nc2 278. Nb5 Ka2 279. Nb2 Ne3 280. Nd4 Nc4 281. Nd3 Nd2 282. Nb3 Kb1
283. Na1 Ne4+ 284. Kd4 Nd6 285. Nc2 Ka2 286. Na1 Kb1 287. Nc2 Ka2 288. Nc5 Kb2 289. Kd3 Nc4
290. Na4+ Kc1 291. Nb2 Nxb2+ 292. Kc3 Na4+ 293. Kd3 Nc5+ 294. Kc3 Na4+ 295. Kd3 Nc5+
296. Kc3 Ne4+ 297. Kd3 Nf2+ 298. Kc3 Ne4+ 299. Kd3 Nf2+ 300. Kc3 Nd1+ 301. Kd3 Kb2
302. Ne1 a4 303. Kd2 Nf2 304. Ke2 Nh1 305. Nd3+ Kb1 306. Kf3 a3 307. Nb4 a2 308. Nxa2 Kxa2
1/2-1/2
```

Lichess analysis seems to only handle the first 150 moves, the evaluation graph explodes up and down and almost jumps through the roof. The following are the analysis results (for the first 150 moves). White: 15 inaccuracies, 15 mistakes, 97 blunders, 581 average centipawn loss, accuracy: 21%. Black: 11 inaccuracies, 17 mistakes, 97 blunders, 587 average centipawn loss, accuracy: 21%. That doesn't seem that bad, why aren't all moves blunders? Well, firstly the analysis is relatively quick (takes like 10 seconds for whole game), it likely doesn't see as deep as the engines who were given hours to play, but secondly we changed the rules of the game: the analyzing engine still assumes the players will be playing good moves, which is not the case.

For comparison here is another bad game in which we just take regular stockfish 17 and make moves like this: from all possible moves, minus the ones that draw, choose the one that leads to the position with worst evaluation for us. 3 seconds are given for evaluating each possible move, so we get something around a minute to make a move. For "mate in N" we take the move that gets us mated sooner as better, and to decide between several "mate in N" moves with same N we try to estimate the worst by taking an average static evaluation of the board to depth 3 (for technical reasons we use [smallchesslib](smallchesslib.md)'s evaluation) -- this should help us prefer positions in which there are more ways to get ourselves mated or in which we at least lost most material and other advantage on average. This game embodies the effort to make the worst blunder in each move in a regular game of chess -- as such we won't see too many "forced blunders", just great many generous offers that keep being turned down. In result this produced another terribly long game:

{ My computer basically spent the whole day computing this game instead of mining Monero, so please enjoy :D NOTE: I don't actually mine Monero of course, I'm not stupid enough for that. ~drummyfish }

```
1. g4 f5 2. f3 g5 3. Kf2 Kf7 4. Ke3 Ke6 5. Kd4 Qe8 6. b4 Qh5 7. f4 Kf6 8. Ke3 Qh3+ 9. Kd4 Qc3+
10. Kd5 Qb2 11. h4 h5 12. Nf3 Bh6 13. Kc5 a6 14. d4 Qxd4+ 15. Nxd4 Ra7 16. c4 Kg7 17. Bg2 Kf6
18. gxh5 c6 19. Qa4 Rh7 20. Qa5 Ra8 21. Qb6 Ra7 22. Qa5 Ra8 23. Qb6 Rf7 24. Bb2 d5 25. Nd2 Ra7
26. Rh3 a5 27. Qa6 e6 28. b5 g4 29. Rf3 Bd7 30. b6 Bg7 31. Kd6 Rf8 32. Kc7 Rf7 33. Kd6 Rf8
34. Kc7 Rd8 35. c5 g3 36. Kd6 Rf8 37. Kc7 Rf7 38. Kd6 Rf8 39. Kc7 Rf7 40. Kd8 Nxa6 41. Rc3 Ne7
42. Ne4+ fxe4 43. a4 Nb8 44. Nxe6 Kf5 45. Bf3 Rf6 46. Rd1 e3 47. Nf8 Kxf4 48. Be4 Rd6
49. Nxd7 Bf6 50. Rdd3 Kxe4 51. Rc2 Bd4 52. Rb3 Rf6 53. Nf8 Rf3 54. Rd2 Rf5 55. Ba1 Ng6
56. Rb5 g2 57. Bc3 Ne5 58. Bb2 Nbd7 59. Kc8 Nf6 60. Kd8 Ne8 61. h6 Nf6 62. Bc1 g1=B
63. Ke7 Rg5 64. Rbb2 Kf4 65. Nh7 Ne8 66. h5 Rg4 67. Kxe8 Nf7 68. Rdc2 Bf6 69. Kf8 Ke4
70. Rc3 Rg7 71. Ng5+ Kd4 72. Ke8 Bd8 73. Ne4 Bh2 74. h7 Rg8+ 75. Kd7 Bd6 76. h6 B8e7
77. Ng3 Ke5 78. Rc4 Bc7 79. Rd4 Kf6 80. h8=N Kg5 81. Rc4 Nd6 82. Rd2 Raa8 83. Nh1 Ra7
84. Ke6 Rg7 85. Ke5 Bcd8 86. bxa7 b6 87. Ng6 Nc8 88. Nf8 Nd6 89. a8=N b5 90. Ng6 Bb6
91. Bb2 Nc8 92. Nf8 Na7 93. Nc7 Bbxc5 94. h7 Bd4+ 95. Ke6 Ba3 96. Ng3 Bc3 97. Rxc6 b4
98. h8=N Nb5 99. Rd6 Kh6 100. Kf5+ Bf6 101. Nh7 d4 102. Na8 Rxh7 103. Nh5 b3 104. Ba1 Na7
105. Kf4 Rf7 106. Ng6 Re7 107. Nf8 Rb7 108. Ng7 d3 109. Kg3 Rb4 110. Ng6 Bg5 111. Rf6 Bf4+
112. Kh4 Rxa4 113. Rd6 dxe2 114. Be5 Nc8 115. Nb6 Ne7 116. Nh5 Bb2 117. Bd4 e1=R 118. Na8 Nc6
119. Bb6 Na7 120. Rc6 Nc8 121. Rc4 Ra3 122. Kg4 Kh7 123. Bd8 Rb1 124. Nh8 Bf6 125. Ng7 Kxg7
126. Rc5 Bh6 127. Rc4 Kf8 128. Nf7 Kg8 129. Rb4 Rd1 130. Nh8 Kg7 131. Kh5 Bf4 132. Be7 a4
133. Rf2 Bb8 134. Bd8 Rf1 135. Bb6 Bd4 136. Rf5 Rg1 137. Rf6 Na7 138. Rb5 Rc1 139. Kg5 Nc8
140. Ra5 Rc7 141. Rc5 Ba7 142. Rc4 Bc5 143. Rf8 Bd4 144. Rf6 Bc5 145. Rf8 Rf7 146. Rxa4 Bd4
147. Kh4 Bb8 148. Rd8 Ra1 149. Kh3 Rc7 150. Kh2 Rg1 151. Rg8+ Kf6 152. Rg2 Na7 153. Kh3 e2
154. Ba5 Bf2 155. Be1 Bh4 156. Ra5 Rf1 157. Rg7 Re7 158. Ra3 Rf7 159. Bf2 Ra1 160. Nb6 Ke7
161. Kg2 Re1 162. Nd7 Bf6 163. Ra1 Bh2 164. Bd4 Bb8 165. Ra2 Ra1 166. Rd2 Ra2 167. Nxf6 Ra1
168. Bb6 e1=R 169. Bd4 Re2+ 170. Bf2 Re3 171. Ne4 Ra6 172. Kg1 Re6 173. Nd6 Kf8 174. Rd1 R6e4
175. Rc1 Rc4 176. Be1 Rec3 177. Nf5 Rf4 178. Ne7 Rb4 179. Nf5 Rcc4 180. Nd6 Rb6 181. Rh7 Nc6
182. Ra1 Rc3 183. Bg3 Rc4 184. Be5 Ne7 185. Bf6 Ba7 186. Ra2 Rc2 187. Rh2 Ng6 188. Rd2 Re7
189. Kf2 Rc1 190. Rac2 Rg1 191. Bd4 b2 192. Nhf7 Rd7 193. Bxb2 Bb8 194. Ba1 Ra6 195. Nc8 Kg8
196. Rc6 Rd8 197. Rd3 Nh8 198. Bxh8 Rc1 199. Rc2 Ra8 200. Rd5 Rg1 201. Rd1 Bc7 202. Rc3 Ra6
203. Nb6 Rd7 204. Rc4 Bf4 205. Rc7 Bh6 206. Rc5 Rc7 207. Na8 Rb6 208. Rc2 Bf8 209. Rd4 Rg4
210. Rd6 Bh6 211. Ng5 Rc8 212. Ke3 Rd8 213. Rc1 Rc6 214. Rcd1 Rh4 215. Bd4 Bg7 216. Rh6 Bf8
217. Ne6 Rc4 218. Bf6 Rc5 219. Be5 Be7 220. Rc1 Rf8 221. Nb6 Bd8 222. Rb1 Rc6 223. Ng5 Rc7
224. Bd6 Rc2 225. Bc5 Rb2 226. Bd6 Rc2 227. Nd7 Rf5 228. Rb5 Rg2 229. Rb7 Rc2 230. Nc5 Rf7
231. Bc7 Bf6 232. Bh2 Rc1 233. Rc7 Be5 234. Rb6 Rcc4 235. Rb5 Rh8 236. Nh3 Rf2 237. Rcb7 Bb8
238. Rf7 Rd4 239. Rb2 Rf3+ 240. Ke2 Rd7 241. Ng1 Rb7 242. Kd2 Re3 243. Kc2 Rd3 244. Kb1 Rc3
245. Rb6 Rch3 246. Rb5 Rd7 247. Rb3 Rxh2 248. Ka1 R2h4 249. Na4 R4h5 250. Rd3 Re7 251. Re3 Bg3
252. Rf4 Re4 253. Ref3 Rf5 254. Rf1 Re2 255. R4f2 Kf8 256. Nf3 Rd5 257. Nd2+ Bf4 258. Kb2 Rd3
259. Rh2 Re4 260. Re2 Re8 261. Ka2 Rde3 262. Rb1 R3e4 263. Rbe1 Rc4 264. Ka3 Rh6 265. Nf1 Rb4
266. Rb1 Bb8 267. Rb3 Kg8 268. Re1 Kh8 269. Nb6 Rh2 270. Ng3 Rc4 271. Ne2 Rh3 272. Rf1 Ba7
273. Nc8 Bg1 274. Rf5 Rf4 275. Rg3 Re5 276. Nb6 Rd4 277. Rh5+ Rhxh5 278. Nc1 Rh3 279. Rb3 Re2
280. Na4 Rb4 281. Rd3 Bd4 282. Rf3 Kh7 283. Rg3 Kh8 284. Nc3 Bg1 285. Rg4 Rg3 286. Rf4 Rb5
287. Nd3 Rg4 288. Rb4 Rh4 289. Nf4 Rb8 290. Nd3 Re5 291. Nxe5 Re4 292. Na4 Rc4 293. Nc3 Re4
294. Na4 Rc4 295. Nc5 Bh2 296. Ra4 Ra8 297. Ncd7 Rb4 298. Ka2 Rb3 299. Nb8 Bg1 300. Ng4 Bb6
301. Ka1 Bd8 302. Ka2 Bb6 303. Ka1 Bd8 304. Ra2 Rd3 305. Ra6 Kg8 306. Nf6+ Kh8 307. Ng4 Rh3
308. Nh6 Rc3 309. Ng8 Rh3 310. Nh6 Ra7 311. Ra2 Re3 312. Kb2 Rc3 313. Ra5 Rf7 314. Nf5 Bg5
315. Ng7 Rd7 316. Nc6 Rd5 317. Ra3 Rb5+ 318. Rb3 Rb8 319. Rb6 Be7 320. Ne8 Kg8 321. Rb5 Bf6
322. Ka2 Re3 323. Nd8 Rb7 324. Ne6 Kh7 325. Rb4 Rd7 326. Ng5+ Kh8 327. Re4 Rf7 328. Kb1 Re2
329. Rb4 Ra2 330. Rf4 Bb2 331. Kc2 Rh7 332. Rf6 Ra6 333. Rc6 Rf7 334. Nf6 Rg7 335. Kd2 Ba3
336. Nfh7 Kg8 337. Nf8 Rf7 338. Ke2 Kh8 339. Ne4 Kg7 340. Nd6 Kxf8 341. Rc2 Rf5 342. Nf7 Rh6
343. Nh8 Rg6 344. Rd2 Rf4 345. Rd7 Rd4 346. Re7 Rd7 347. Kf2 Rc7 348. Re2 Rc2 349. Kf1 Bb2
350. Rd2 Bc1 351. Re2 Bb2 352. Ke1 Bc1 353. Nf7 Kg8 354. Nd8 Rf6 355. Re6 Rc4 356. Kd1 Rg6
357. Re5 Rc2 358. Re6 Bb2 359. Re2 Kh8 360. Re5 Rg5 361. Re6 Rg1+ 362. Re1 Kg8 363. Nf7 Re2
364. Rf1 Bf6 365. Ne5 Bh4 366. Ng4 Be1 367. Rf2 Rg3 368. Rf4 Rxg4 369. Kxe2 Kg7 370. Ke3 Bh4
371. Rd4 Bg3 372. Rc4 Kg6 373. Rd4 Kg7 374. Rd6 Rd4 375. Rh6 Kf8 376. Rd6 Rd1 377. Rd2 Kf7
378. Rd4 Ke6 379. Rd2 Bd6 380. Rxd6+ Ke5 381. Re6+ Kf5 382. Re7 Rf1 383. Re6 Kg5 384. Rh6 Rh1
385. Kd3 Kf4 386. Kd4 Rh3 387. Kc5 Kf3 388. Kd6 Rh5 389. Kc6 Rb5 390. Kd6 Rb3 391. Rg6 Ke3
392. Rh6 Ra3 393. Rg6 Rb3 394. Rh6 Ra3 395. Ke6 Ke4 396. Rh3 Kd4 397. Rh6 Rh3 398. Kf6 Kd5
399. Kf5 Kc4 400. Kf6 Kd4 401. Rh7 Kd3 402. Rh4 Kc3 403. Rc4+ Kb3 404. Ra4 Kc3 405. Ra6 Rg3
406. Ke6 Rf3 407. Kd6 Rg3 408. Ke6 Rf3 409. Kd6 Rh3 410. Ke7 Kd3 411. Ra7 Kc3 412. Ke8 Rf3
413. Kd7 Rg3 414. Ke7 Kd3 415. Rb7 Rh3 416. Ra7 Rg3 417. Rb7 Rg8 418. Rb8 Ke3 419. Rb7 Rd8
420. Rb8 Re8+ 421. Kd7 Re7+ 422. Kd8 Re8+ 423. Kd7 Re7+ 424. Kd8 Rb7 425. Ke8 Rb3 426. Kf7 Kf4
427. Rb7 Kf5 428. Ke7 Ke4 429. Kd7 Rxb7+ 430. Kd6 Re7 431. Kc5 Re5+ 432. Kd6 Re7 433. Kc5 Rd7
434. Kc4 Rd5 435. Kc3 Rd2 436. Kb4 Kd5 437. Kc3 Ke6 438. Kc4 Rd4+ 439. Kb3 Rc4 440. Ka2 Kd6
441. Kb2 Rc3 442. Ka1 Kc5 443. Ka2 Rb3 444. Ka1 Rb2 1/2-1/2
```

Again, Lichess only analyzed the first 150 moves and here it marked practically every move as a blunder (the rest are probably blunders so genius that the quick analysis didn't even reveal the genius behind that stupidity), because of our different definition of a bad move. Here are the statistics. White: 1 inaccuracy, 1 mistake, 147 blunders, 1610 average centipawn loss, accuracy: 2%. Black: 1 inaccuracy, 0 mistakes, 148 blunders, 1613 average centipawn loss, accuracy: 2%.

What is **the rarest move**? Some [YouTube](youtube.md) video tried to investigate this with the help of Lichess database. Things that immediately come to mind like en passant checkmates and checkmates by promoting to a knight are rare but not insanely rare. A crazily rare kind of move, which only appeared ONCE in the whole database, was a doubly disambiguatated (i.e. with the necessary specification of both rank and file of the bishop) checkmate by a bishop (specifically Bf1g2#, occurring in a 2022 game) -- this is rare because to need a double disambiguation for a bishop move it is necessary to underpromote two pawns to a bishop and then place them correctly. Yet rarer moves, which NEVER appeared in the database, were a doubly disambiguated knight checkmate with capture and doubly disambiguated bishop checkmate with capture, latter of which was judged less likely and therefore probably the rarest move ever.

The maximum number of **black and white queen pairs placed on an empty board so that none is attacked** is 12 (that is 12 white queens and 12 black ones). This number as a [function](function.md) of board size is the [OEIS sequence A250000](https://oeis.org/A250000) and starts like this: 0, 0, 1, 2, 4, 5, 7, 9, 12, 14, 17, 21, 24, 28, 32, ... Insofar as chess curiosities go, OEIS is a fairly cool place to check out too, they examine interesting things such as knight walks on infinite chessboards (see for example the beautiful [A316667](https://oeis.org/A316667)) and things of similar nature.

Anyway, you can try to derive your own stats, there are huge free game databases such as the Lichess [CC0](cc0.md) database of billions of games from their server, as well as powerful [free software](free_software.md) engines allowing you to arrange and automatically play out hundreds of thousands of games. Why not take the chance?

{ TODO: Derive stats about the best move, i.e. for example "best move is usually by queen by three squares" or something like that. Could this actually help the play somehow? Maybe could be used for move ordering in alpha-beta. ~drummyfish }

## Variants

Besides very similar games such as [shogi](shogi.md) there are many variants of chess with slight modifications of the rules, foremost worth mentioning is for example chess 960. The following is a list of some variants:

- **3D chess**: [3D](3d.md) generalization of chess, possible are also other dimensions (4D, 5D, ... maybe even 1D?).
- **antichess** ([suicide](suicide.md), ...): The goal is to lose all men or get stalemated, rules are a bit changed, e.g. castling and checks are removed and taking is forced.
- **balanced alternation**: Variant proposed in one [game theory](game_theory.md) paper (along with analysis and evidence for the claim of course), attempting to minimize the white's first move advantage with only a very slight rule change: second and third half move switch their order. I.e. white moves first, then black moves TWICE, then white also twice, then the game continues normally.
- **chess 324**: Chess with randomly modified starting position to prevent opening theory and draws, similar to chess 960. Here queens, knights and bishops are randomly shuffled in the start position with the condition that bishops must be on different color squares (no symmetry of position is required). Advantage against chess 960 is that otherwise the rules (i.e. basically castling) stay exactly the same, so basically any chess engine can also play chess 324 without modification.
- **chess 960** aka **Fischer's random** (nowadays also "freestyle chess"): Starting position is randomly modified by shuffling the non-pawn rows (with these rules: king must be between rooks, bishops on opposite colors and black/white's positions are mirrored). The rules are the same with a slight modification to castling. This was invented by Bobby Fischer to emphasize pure chess skill as opposed to memorizing the best opening moves, he saw the opening theory as harmful to chess. Chess 960 is nowadays even advocated by some to become the "main" version of chess.
- **[chess boxing](chess_boxing.md)**: Chess combined with box, players switch between the two games, one wins either by checkmate or knockout.
- **crazyhouse**: When a player captures a man, it goes into his reserve. From the reserve a man can be dropped (as a man of the current player's color) to an empty square instead of making a normal move. This is a rule taken from [shogi](shogi.md).
- **custom starting positions**: Creating custom starting positions is a big fun in itself, for example one can make an epic battle by replacing all pieces with queens, or a very strategic scenario in which both queens are trapped and have to be freed, or an asymmetric battle of many weak men versus a few stronger ones, or trollish ones such as the standard setup, only flipped vertically. Only one's imagination is the limit.
- **different board geometries/topologies:** e.g. [non-Euclidean](non_euclidean.md) ([hyperbolic](hyperbolic.md), [spherical](spherical.md), [torus](torus.md), ...), hexagonal chess (had some considerable following) etc.
- **different men**: Some variants use different men, e.g. empress (moves like rook and knight) or amazon (queen/knight).
- **duck chess**: After each move players place a duck on an empty square, the duck blocks the square. The duck cannot be left on the same square, it has to be moved. There are no checks, players win by capturing the king.
- **fog of war**: Makes chess an incomplete-information game by allowing players to only see squares they can immediately move to (this is similarly to some strategy video games).
- **horde chess**: Asymmetric starting position: large number of black pawns vs a white army of traditional men. Rules are slightly modified, e.g. black can only be defeated by having all pawns captured (there is no black king).
- **[infinite](infinity.md) chess**: Infinite chessboard. { Huge rabbithole with things like "mate in [omega](omega.md)" etc. ~drummyfish }
- **minichess**: Smaller chessboard, e.g. 4x4, 4x8 etc. Los Alamos chess is played at 6x6 board without bishops (also no promotion to bishop, no pawn double step, no en passant, no castling). Some are already solved (e.g. 3x3).
- **more players**: E.g. 3 man chess or 4 player chess allow more than two players to play, some use different boards.
- **old chess**: The rules of chess itself have been changing over time (e.g. adding the 50 move rule etc.). The older rule sets can be seen as variants as well.
- **racing kings**: The starting position has both players on the same side, the goal is to get one's king to the other side first.
- **r-mobility** (reset mobility): Modifications of rules so that draws become impossible (on very high level chess becomes very drawish, this is one way to deal with the issue, even if it's used e.g. in tiebreaks). R-mobility basically generalizes mate/stalemate and works as follows. When the game ends (mate, stalemate, timed out, ...) the player with lowest number *Rp* (*p* is the player) wins. *Rp* is computed like this: at start and after any pawn more or capture it is set to infinity (reset). After player *p*'s move if the the number of opponent's legal moves, plus 1/2 if he's not in check, is lower than *Rp*, it becomes the new *Rp* (i.e. we take the minimum). So checkmating opponent means achieving 0 (the best possible), stalemating him achieves 1/2 etcetc.
- **randomly chosen variant**: Here a chess variant to be played is chosen at random before the game, e.g. by dice roll. { This is an idea I got, not sure if this exists or has a different name. ~drummyfish }
- **singleplayer**: Many attempts were made at creating [solitaire](solitaire.md) versions of chess -- in our days it's now possible to play alone against a computer or possibly try to play against self (see a note on self play at the top). Here are some of the variants designed specifically for one player:
  - **puzzles**: Player is presented with real game situations and must find a solution, usually checkmate in N moves or finding the best move, but other goals are also possible (e.g. find the worst move). Puzzles still have to be created by someone (human or computer).
  - **solo chess**: Similar to puzzles but there are different rules. There are only same color men which can capture each other. The goal is to capture all of them but one. Each move must be a capture, each man can only capture once and if there is a king, he has to be the last man.
  - **safe passage**: Closer to actual game of chess, kind of similar in spirit to e.g. [peg solitaire](peg_solitaire.md). Basic setup and almost all rules stay the same as in normal chess, but there is no en passant or promotion. The easier goal is to make the two kings swap places, the harder goal is to also swap the queens. No man can move to a square where he could be captured, except for pawns which may even be captured. Changing starting positions/openings can create new challenges.
  - ...
- **sovereign chess**: A bigger variant of chess with different rules.
- ...

### Variant Ideas

This subsection will be dedicated to various not well tested ideas.

{ I'll be pasting my ideas here. It's possible that these variants already exist and I just haven't found them. If you recognize something in this section as an existing variant, please let me know <3 ~drummyfish }

**LRS chess**: { This one seems quite obvious, it probably already exists? ~drummyfish } chess is only mildly [bloated](bloat.md) but what if we try to unbloat it completely? Here we propose the LRS version of chess. The rule changes against normal chess are:

- No castling.
- No en passant.
- Promotion is always to queen.
- No checks or checkmates, king is just another man.
- Whoever takes the opponent's king first wins.
- If a player has no available moves, he loses.
- Only a single draw rule: if game doesn't end in 1024 half moves or fewer, it is a draw. I.e. there are no weird draw rules (50 move, repetition, ...). Of course players may still agree on draw anytime.
- Random: optionally random variant of LRS chess can be played. Here we randomly shuffle the white player's back row men in the starting position and mirror it for black (no weird conditions on men positions like in chess 960).

{ I was thinking about a variant that would completely remove the white's first move advantage and here is my idea: let the players make the moves simultaneously. In real life this can be done for example by players writing the moves on a piece of paper, then revealing them. Of course we'd have to address conflicting situations such as both players moving their kings so that the new position would be illegal. Perhaps the turn would be successful only if the two moves performed in either order would result in the same, legal position. If the turn was unsuccessful, the attempt at a turn would repeat and let's say after 3 unsuccessful attempts the game would be a draw. ~drummyfish }

{ I got another idea for a chess variant, inspired by [Warcraft 3](warcraft3.md): chess with [races](race.md). It would be an extension of normal chess, in which each player could choose a "race" to play with. Races would differ by the initial setup on the player's side and the default "human" race would just have the traditional chess setup. Other races could be created by giving some kind of advantage for a disadvantage, e.g. having some men already developed for the price of one pawn -- this would probably have to be tuned with help of an engine so that all matchups would be balanced. It would also be possible to add new types of men or special abilities for the new races, but then we'd lose the ability to play this variant with traditional chess engines. ~drummyfish }

{ Another quick idea: lose against random moves (draw or victory equates loss). I literally haven't tried it, maybe it's going to be too boring or too easy, but I thought it might be good for beginners (and advanced players could potentially make it harder by imposing further restrictions, like lose in N moves or fewer, lose N games in a row, give the opponent material disadvantage etc.). The point was that this is a single player variant that's very easy to program, can even be played without a computer (dice) and it could be educational in some ways, mainly by making you think from the opponent's point of view. ~drummyfish }

## Playing Tips

Some general tips and rules of thumb, mostly for beginners:

- Try to control the center of the board (D4, D5, E4, E5).
- Don't bring the queen out too early, the opponent can harass it and get ahead in development.
- Learn some universal setup openings or "systems" to play, e.g. London, King's Indian, the hippo etc. If you don't want to bother with openings, play chess 960.
- Develop your men before attacking, usually knights go out before bishops, bishops are well placed on the longest diagonals as "snipers".
- Learn basic tactics, especially **forks** (attacking two or more men at once so that one of them cannot escape capture) and **pins** (attack one man so that if he moves out of the way he will expose another one to be captured), but also other things like double checks, sacrifices, deflections etc.
- Learn basic types of checkmates and mating patterns, for example mating with two rooks, with king and queen, back rank mates (especially dangerous when starting, always make an escape square), smothered mates, how not to stalemate (giving check can't ever result in stalemate, leaving the opponent one pawn with a legal move also guarantees no stalemate, ...) etc.
- Watch out for hanging pieces! You usually want to have everything guarded.
- King safety is extremely important until endgame, castle very early but not extremely early. In the endgame (with queens out) king joins the battle as another active man.
- Learn when to exchange and when not -- usually when you're up material, trades are good for you because trading same value men increases the ratio of your material advantage. When attacking you probably don't want to trade because you need SOMETHING to attack with -- so when your opponent is attacking you and you're defending, you WANT to trade because he probably doesn't want that. Also when you have little space and are squeezed in your base, you probably want to trade and create more space. Trading your only bishop for opponent's bishop when he has both is probably good as a bishop pair is very valuable. Etc.
- Pawn structure is very important (avoid doubled and isolated pawn, watch out for the weak back pawns etc.).
- Rooks want to be on open files, you also want to CONNECT them (have both guard each other). Also a rook in the opponents second row (2nd/7th rank) is pretty good.
- Stack rooks, i.e. place them on the same open file -- this is very powerful. You can also stack two rooks and a queen and create a so called legendary triple stack which is extremely powerful.
- If you find a good move, look for a better one. There seems to be this pattern in which if you spot a good move, it indicates that opponent's position is falling apart and usually there is a much more powerful, crashing move to play.
- Bishops are generally seen a bit more valuable than knights, especially in pairs -- if you can trade your knight for opponent's bishop, it's often good. If your opponent has two bishops and you only have one, you want to trade yours for his so he doesn't have the pair. A knight pair is also pretty powerful though, especially when the knights are guarding each other.
- Consider the bishop difference: one only covers white squares, the other only black ones. Take this into account when exchanging bishops, sacrificing them, placing your pieces on white vs dark squares etc.
- "Knight on a rim is dim" (knights are best placed near the center). Also mobility in general is good (having more possible moves is generally better).
- Blocking the opponent's man so that he can't move (i.e. making it inactive) is almost as good as taking it. And vice versa: you want to activate all your men if possible, put them on good squares and make them do something. Take space from opponent and "squeeze" him, having little space and few moves is generally bad.
- Memorize and internalize the square names (A1, B2, ...). Not only is this crucial for reading recorded games and discussing them, it also somewhat helps visualizing the board in your head as each square now has its own label, a word that helps the brain distinguish and remember squares. You must learn the names so that you instantly know any square name when pointed at, counting them isn't enough. It's similar to remembering names of [numbers](number.md) -- this probably what allows us to add big numbers in our head.
- Nubs are weak against long range bishops, they can't see them. Place a bishop to corner on the long diagonal and just snipe the opponent's material. See also fianchetto.
- Don't play "hope chess", always suppose your opponent will play the best move he can. Don't give a check just because you can, always try to invalidate the move you want to play and only play it if you can't find an easy counter to it.
- If you can achieve something with multiple men, usually it's best to do it with the weakest one.
- Have a plan, even a simple one -- you mustn't just be answering the opponent's moves, you want to have goal (but you may change your goals quickly) such as "I wanna develop and castle, then start attacking this weak pawn here" etc.
- Think from opponent's point of view -- this seems to be an important skill that beginners lack. If you only think about what you want to do, you often find yourself in trouble because you ignored the opponent's threats. At the very least you should ALWAYS think after the opponent's move about WHY he made it to be aware of what his plan probably is and what you should be prepared for. If you don't see why he made a move he did, you must think harder: either he blundered (good for you, take the opportunity!) OR you missed something and you have to find what.
- Sometimes, usually in endgames, the obligation to make a move becomes a disadvantage -- this is called [zugzwang](zugzwang.md) and can be abused. For example if the opponent has a pawn and a king who guards another pawn, it may be so that blocking the first pawn will make it unable to move, leaving the opponent with only a move that will make his king stop guarding the other pawn which can then be taken.
- Practice endgame -- the play is quite different from middle game, the king joins the battle, you start to race your pawns and prevent opponent's pawns from promoting. { I don't know if it's a good advice but at least in puzzles I've found that if you aren't sure about your move in the endgame, pushing the pawn is usually the right move :D ~drummyfish }
- Upon entering the intermediate level it's probably good to start train many different areas, variants and formats: try to play puzzles, blitz, rapid and classical, against computer and humans, normal chess and chess 960 etc. The thing is that in order to seriously improve, many individual skill must be boosted -- deep calculation with a lot of time on the clock, quick intuitive play under time constraints, play with different combinations of men, offense and defense, playing with material advantage and disadvantage etc.
- Also to improve considerably, one must do a few things besides just playing, such as watching others play and especially analyze one's losses, to discover weaknesses and shortcoming that must be eliminated or at least minimized.
- TODO: moar

## How To Disrespect Your Opponent And Other Lulz In Chess

*see also [unsportmanship](unsportmanship.md)*

WORK IN PROGRESS, pls send me more tips :)

- OTB (over the board) only:
  - Turn your knights to face backwards or in another weird way (always face the opponent's king etc.). Also place the pieces unevenly on the squares to piss off opponents with OCD and autism.
  - Play anti-computer chess against human opponent.
  - Play `1. Qe9#`.
  - Behave weird, make weird faces, walk extremely far away from the board and walk in circles (or just get up and stand up directly behind your opponent in a completely upright position staring into the distance without moving at all like a robot lol), constantly sneeze (try to sneeze every time the opponent touches a piece), make very long unbroken eye contact with the opponent while smiling as if you know what he's thinking, call the referee constantly, go to the toilet after every move, pretend to fall asleep from boredom etc. Overeat on beans before the game so you fart a lot and always try to fart as loud as possible. Wear nice clothes but right before the game go sweat to the gym so that you smell like a pig and distract the opponent with toxic fume. If you're a [wimmin](woman.md) behave sexually, keep grabbing your boobs, lick your lips and opponent's captured pieces and silently moan sometimes as if you're having an orgasm, pretend to masturbate under the table; if your opponent is male he is almost definitely smarter than you, you gotta use your woman weapons, but it will probably work easily on the chess virgins.
  - In a tournament change play based on opponent's [race](race.md) or sex, for example play only one opening against white people and another opening against black people, see if anyone notices the pattern :D
  - Behave as if you're [cheating](cheating.md) when you're not, for example go to the toilet after every single move, keep looking in one direction as if you're communicating with someone etc. This firstly trolls people, they may start investigating but won't find anything, it will spawn immense paranoia and suspicions among everyone, which can be fun to watch, but importantly you may gain advantage in the game: it is known that players usually play worse when they think they're playing a cheater, they get stressed and keep focusing on your behavior instead of the game, you can exploit this to your advantage.
  - Outside tournament take advantage of the fact that you can do whatever the fuck you want: have one hand constantly on the clock and play with the other hand (considered rude and often forbidden), touch and knock over your opponent's pieces, take back your moves, ... and of course when you're losing, "accidentally" knock over the whole board and be like "oops, let's consider it a draw then" :D
  - Trash talk the referee.
  - Correct the opponent's pronunciation of *en passant*, insist it's pronounced "en peasant".
  - ...
- online only:
  - Be annoying and offensive in chat, if opponent blunders write `gg`, spam `ez` when you win. If he wins say it was a shit game and accuse him of [cheating](cheating.md).
  - Constantly ask for takebacks, offer draws, report legit opponents for cheating and offensive behavior.
  - Definitely wish your opponent BAD luck and that he gets heart attack during the game so that you win. Even though spiritual forces probably aren't real and wishing someone bad or good luck actually does nothing, the chance is still non-zero that gods and ghosts exist and will actually do what you say, so you can't risk lowering your chances of winning by wishing your opponent good luck. This also applies to any other game.
  - ...
- Play the bongcloud, fool's mate, 1. h3, 1. g4 or similar offensive opening, especially against a stronger player. Offer a draw after (or even before) the 1st move. Just play knight f3 and back constantly. Castle manually even if you don't have to. Play the exact mirror of opponent's moves -- if he tries to break it then just always try to get back to mirrored position or do some similar shit.
- When losing constantly offer draws, prolong the game AS MUCH AS POSSIBLE, before the very last move just let the clock run out.
- Repeatedly try to make swastikas on the board, especially against colored opponents.
- Underpromote pawns to knights or bishops.
- Just mirror the opponent's moves.
- Just sit and let your time run out before making the first move, especially when you're in finals of some kind of big tournament and people paid a lot of money for their tickets :D
- Any time you can play en passant do it no matter what and always follow by saying "google en passant".
- The rating equalizer (you must be somewhat good): play so that you give rating to low rated players and take it away from high rated ones.
- Say "MMR" instead of [Elo](elo.md).
- Yell "BLUNDER!" literally after every single move.
- When playing a noob don't just mate him but absolutely rape him, promote all pawns to knights before winning, then say you didn't even have to try and that he should look into another game as chess is clearly not his game. Research humiliating play: for example GM Aman Hambleton demonstrated on stream a so called *reset checkmate* in which one promotes all pawns so as to have the original back rank men and then delivers a checkmate by placing the men in the original starting position (furthermore he did this by premoving it all which adds to the humiliation).
- Look up chess etiquette and do the exact opposite of what it says.
- ...

## See Also

- [shogi](shogi.md)
- [go](go.md)
- [hexapawn](hexapawn.md)
- [hex game](hex_game.md)
- [checkers](checkers.md)
- [advance wars](advance_wars.md)
- [backgammon](backgammon.md)
- [solitaire](solitaire.md)
- [novuss](novuss.md)
- [Catan](catan.md)
- [Deep Blue](deep_blue.md)
- [stockfish](stockfish.md)
- [anal bead](anal_bead.md)