#!/bin/sh
# Checks for potential errors in articles.

echo "===== trailing spaces:"
grep -rno "   \+$" *.md

echo "===== weird links:"
grep -rno "\[[^]]*\]([^)]*\([^.)][^)][^)]\|[^)][^m)][^)]\|[^)][^)][^d)]\))" *.md \
  | grep -vi "\(\.htm\|.com\|.net\|.php\|\.org\|\.eu\|.cz\|.xyz\|.io\|\.top\)"

typos="("
typos="${typos}pubic|noticabl|occassion|ocassion|occure|occurres|adress"
typos="${typos}agressi|aggresi|aparrent|apparrent|concensu|definat|dissapoint|"
typos="${typos}dissappoint|disasterous|lmoa|cathegor|comming|commited|comitted"
typos="${typos}embarass|embarrasi|excede|harrass|harrase|fullfil|immitat|"
typos="${typos}taht|lightening|milleni|milenni|miniscule|mispell|neccessar|"
typos="${typos}necces|occasionaly|occurrance|occurence|passtime|posess|"
typos="${typos}possese|preceed|priviledge|reccom|refered|succesful|sucessful|"
typos="${typos}errorne|erorrne|superced|tommor|vaccu|wierd|wellfare|acknoleg"
typos="${typos}aparrent|collegue|deppres|automatize"
typos="${typos})"

echo "===== common typos:"
grep -rnoEi $typos *.md

echo "===== bad first headings:"
for f in *.md; do
  secondChar=`grep -m 1 "^#.*" $f | head -c 2 | tail -c 1`

  if [ "$secondChar" = "#" ]; then
    echo $f
  fi
done
