# Censorship

*This page is not accessible in your country... NOT :)*

Censorship constitutes intentional effort towards hiding any  kind of [information](information.md) from someone, e.g. preventing exchange of certain kind of information among individuals, suppression of [free speech](free_speech.md), altering old works of [art](art.md) for political reasons, forced takedowns of [copyrighted](copyright.md) material from the [Internet](internet.md) and so forth. I.e. hiding information from SOMEONE ELSE is censorship, but note this definition does NOT include every kind of data or information filtering, for example censorship does not include filtering out [noise](noise.md) such as [spam](spam.md) on a forum or static from audio (as noise is a non-information) or PERSONAL avoidance of certain information (e.g. using [adblock](adblock.md) or hiding someone's forum posts ONLY FOR ONESELF) -- censorship simply means one prevents someone else from reaching some knowledge. Censorship often **hides under euphemisms** such as "[moderation](moderation.md)", "[safe space](safe_space.md)", "peer review", "[filtering](filter.md)", "protection", "delisting", "deplatforming", "fact check", "isolation", "blacklisting", "whitelisting" etc. **Censorship is always [wrong](bad.md)** -- [good society](less_retarded_society.md) must be compatible with truth, thus there must never be a slightest reason to censor anything -- whenever censorship is deemed the best solution, something within the society is deeply fucked up. In current society censorship, along with [propaganda](propaganda.md), brainwashing and misinformation, is extremely prevalent and growing -- it's being pushed not only by [governments](government.md) and [corporations](corporation.md) but also by harmful terrorist groups such as [LGBT](lgbt.md) and [feminism](feminism.md) who force media censorship (e.g. that of [Wikipedia](wikipedia.md) or search engines) and punishment of free speech (see [political correctness](political_correctness.md) and "[hate speech](hate_speech.md)").

Sometimes you can actually **exploit the effort of censors to get to the good content** -- look up a blacklist (e.g. https://en.wikipedia.org/wiki/Category:Blocked_websites_by_country, https://peertube_isolation.frama.io/list/peertube_isolation.txt and so on), then you have a list of interesting places you probably want to visit :) For [political cowardice](political_correctness.md) blacklists are nowadays also called "block lists", "isolation lists" etc. -- just look for those.

Sometimes it is not 100% clear which action constitutes censorship: for example categorization such as moving a forum post from one thread to another (possibly less visible) thread may or may not be deemed censorship -- this depends on the intended result of such action; moving a post somewhere else doesn't remove it completely but can make it less visible. Whether something is censorship always depends on the answer to the question: "does the action prevent others from information sharing?".

**Modern censorship is much more sophisticated**; in old days, e.g. those of [USSR](ussr.md) pseudocommunist regimes, it was simple: stuff was reviewed and it either got censored or it passed, governments even openly admitted to censorship and stated it was simply necessary for the advancement of society. People wanted to talk but the government didn't want to let them. Not so nowadays, it got much more advanced in several ways:

1. Censorship is no longer done just by the state, but by [corporations](corporation.md), various social subgroups and even individuals as well, as so called self censorship, often automatically and subconsciously. In wanting to talk you are not just standing against one big bad guy who wants you silent, there are hundreds of sneaky bastards waiting to sue you, report you, ban you, cancel you, even physically terminate you if you touch anything controversial in one way or another.
2. **NO ONE ADMITS TO CENSORSHIP NOWADAYS, no matter how blatantly obvious their censorship is**, exactly in the capitalist "deny EVERYTHING" spirit -- Wikipedia explicitly states "we are not censored" and then literally removes and blocks inclusion of legitimate information it deems "harmful". You point it out, they ban you. They will say "no, it's not censorship, it is MODERATION, PROTECTION, DELISTING, free speech has its limits, it is not a ban, it is deplatformization, blocking of hate speech is not censorship blablabla ..." -- they are inventing hundreds of new terms so that they don't have to use the word *censorship*.
3. There is a lot of soft, undercover and hard to prove censorship -- no longer is something either censored or not censored, but it may be shadowbanned, hugely underanked in search, censored only to specific eyes, modified rather than deleted etc. For example [Google](google.md) censors thousands of websites; you WILL find those websites if Google sees you are looking specifically for those to test their censorship, but it won't ever show it to people who don't know about the site and are legitimately looking for the information they contain. Maybe they will show the site on the 100th page of the search results, which is equivalent to just blocking it completely, but they can say "haha we are not actually censoring it, gotcha". TV series and movies are silently edited retroactively in the [cloud](cloud.md) to no longer include scenes deemed politically incorrect, no one notices as no one owns physical copies anymore. In the endgame capitalists will just be constantly updating history, let's say they will just change the characters in Godfather to LGBTQ queer black women and since the movie will only be streamed from the cloud, without any old copied of the original existing, they will just say "the movie has always been like that, the author supported our politics". And so on.

There exist **tools for bypassing censorship**, e.g. [proxies](proxy.md) or encrypted and/or distributed, censorship-resistant networks such as [Tor](tor.md), [Freenet](freenet.md), [I2P](i2p.md) or [torrent](torrent.md) file sharing. Watch out: using such tools may be illegal or at least make you look suspicious and be targeted harder by the surveillance.

## Example Of Bordeline Case: Is It Censorship Or Not?

Let's take a look at a borderline case which some may see as censorship and some not, and let's try to resolve the situation, provided we are anti-censorship, i.e. we want to minimize censorship. Note here we will NOT be giving arguments for or against censorship, we just assume the reader is already against censorship (of course many readers may disagree but discussion of this question is left for another section).

Say we want to create a [GNU](gnu.md) style repository of strictly [free software](free_software.md) in which we won't include any proprietary software but also any free software that likely leads to running proprietary software, such as [Wine](wine.md) (software that allows running [Windows](windows.md) programs on non-Windows systems). Let's assume that technically adding Wine to the repository would be very easy, but we decide not to do it because its primary purpose is to run Windows only programs which are typically proprietary and this violates our inclusion policy. I.e. we'll leave out any arguments about resources and technicalities and will only focus on the question of policy and its implementation. Is this censorship or not? Some say yes because, by definition, we are hiding something from the people, while others say this isn't censorship e.g. because we are making a SELECTION of software and we are clear about what it includes.

(Note that argumenting e.g. by not wanting to support unethical software, protecting the users or "having the right to do whatever we like with our property" can't be used here because these are just pro-censorship arguments, they don't argue we aren't implementing censorship, they just try to give justification for why we SHOULD or CAN implement censorship.)

The truth is probably in the middle: it is censorship to some degree but not a blatant "full 100%" aggressive one. It's simply a gray area like many others commonly encountered in real life scenarios. The important question here is rather this: given our goal (of creating a repository of free software that should be helpful to the people), how can we minimize the amount of censorship we're doing? We cannot remove all censorship, but we can minimize it. The [LRS](lrs.md) solution to the situation would be probably something akin the following.

Let's create a base repository of all useful software that comes with a free license, i.e. even that which might break our original policy. (Note: we decide to not include any proprietary software because here the question of resources will already play a practical role -- including also proprietary software would require orders of magnitude more resources such as storage and maintainer time.) Now in this repository we will tag the software that passes our original policy let's say as *approved free software*. I.e. we have created (without much extra effort) effectively two repositories: that of all free software and that of *approved* free software. Now we are giving users a choice whether they want to use all free software or just the approved one. When the user installs an OS, he may be asked whether he only wants to see approved software (potentially safer) or all software (bigger risk but more software at hand), the decision is on him. Now we aren't doing thinking for the user, we aren't treating him like a baby, we only do a service for him and don't try to manipulate him, i.e. we are [selfless](selflessness.md) -- or at least more selfless than we were before. We aren't giving him a ultimatum ("either accept our censored repository or stay in your proprietary dystopia"), we are solely providing a service (basically a categorization and review of software) and want nothing in return. Yes, there is still a bit of censorship (no proprietary software, moving software to non-approved repository may make it less visible etc.), but it's much better than before. This is how it should be done.

## Examples

Censorship is so frequent that it's hard to give just a short list of examples, especially [nowadays](21st_century.md), but here are a few:

- [Encryption](encryption.md) provides mathematical ways of implementing censorship in communication.
- [Copyright](copyright.md) enables authors to censor their works at will and enforce this censorship legally, for any reason whatsoever -- this also subsequently leads to further censorship by media hosting websites such as [YouTube](youtube.md), to mass deletions of valuable works from public archives and so on.
- [Wikipedia](wikipedia.md) practices very strong censorship, it has a list of banned sources (calling it by an euphemism of "deprecated" sources) which include even such big media as Daily Mail, furthermore a lot of things which average Wikipedia editor dislikes are censored, e.g. the url to the controversial site 8kun (https://8kun.top) must not be mentioned in its article (take a look at page source comment, March 2024). Content Wikipedia deems harmful to someone will also be censored, resulting in removal of many valuable information you would want to find in an encyclopedia.
- [Political correctness](political_correctness.md) is based on censorship, a great part of it is retroactive censorship and rewriting of old works, for example some populist German book publisher refused to publish the Winnetou books, a classic and important work of art, under claim of "racism"; similarly iconic books like *Ten Little Niggers* by Agatha Christie had to be crippled and renamed; the famous series Futurama is commonly censored by broadcasters (deleting words like *Jesus*, *bastard*, ...). The examples here are countless. This is used for political censorship, for example on the Internet it's extremely hard to publish any opinions not aligned with the currently ruling [pseudoleftist](pseudoleft.md) ideology because terms of service of any social media platform or even website hosting company have to forbid so called "[hate speech](hate_speech.md)" which just means anything not aligned with the ideology.
- Pseudocommunist regimes of the 20th century practiced very strong censorship, e.g. in Czechoslovakia all public [art](art.md) such as music and plays had to pass an ideological review before being approved for performance.
- Child pornography is nowadays unfortunately completely censored, it is mandatory to be censored in most first world countries
- Mass shootings come with attempts by governments at censoring the messages sent by the attacker, sometimes even their names; one example for all can be the 2019 Christchurch shooting by Brenton Tarrant whose manifesto, called *The Great Replacement* (downloadable e.g. at Anna's Archive), was being forced down off of the Internet following the attack.
- In mainstream "[science](soyence.md)" censorship is nowadays part of standard publishing process, known under the euphemism of *[peer review](peer_censorship.md)*.
- [Google](google.md)'s search engine has very strong censorship and political bias built-in, it's done mostly by downranking targeted sites to make them practically unfindable, in some cases downright blocking sites altogether. Some of the affected sites include [Encyclopedia Dramatica](dramatica.md), Metapedia, Infogalactic, 8kun, Sanctioned Suicide and many others.
- Censorship enjoys big popularity on the [soynet](soynet.md), e.g. there is the infamous fediblock list of blocked [fediverse](fediverse.md) instances.
- China very intensively applies censorship to the Internet, especially in regards to the country's official ideology and [history](history.md), using the so called [great firewall](great_firewall.md). China also does weird funny kinds of censorship like removing bones from video games. Why do they do it? No one knows. Germany similarly for some stupid reasons replaces blood in video games with green liquid, ruining the games.
- North Korea is probably the most isolated country in the world, it prevents essentially any information from behind its borders from reaching its citizens, it even completely blocks the [Internet](internet.md) and rather established its own intranet ([Kwangmyong](kwangmyong.md)).
- Japanese hilariously blur genitalia in porn.
- Any so called "[private](privacy.md) information" of individuals is nowadays in many countries required to be censored from the public.
- In 2007 there was an infamous attempt at censoring the AACS DVD encryption keys (09F911029D74E35BD84156C5635688C0) which allowed to circumvent [DRM](drm.md).
- [Nazis](nazi.md) publicly burned [books](book.md) they deemed harmful (e.g. for having been written by [Jews](jew.md)) -- though this was more of a public theatre, it was also indeed partially an act of censorship.
- Circa 2019 [reddit](reddit.md), until then quite highly [free speech](free_speech.md) website, completely turned around and launched a censorship tsunami that destroyed thousands of communities, all just to make the site more advertiser friendly.
- Broadcasts of [football](football.md) matches on TV usually censor crazy fans that run on the pitch and cause [lulz](lulz.md), the camera just pans on something uninteresting until the security catches the guy, denying probably the most [funny](fun.md) and interesting moments of the match to thousands, maybe even millions of viewers. This is done because the broadcasters are [faggots](gay.md) who dislike fun.
- So called "right to be forgotten" is a part of [privacy](privacy.md) hysteria and a form of extreme censorship that demands you shall for example smash your head with a hammer until you forget something that someone else feels uncomfortable about. No, this is not a [joke](jokes.md), some people in [21st century](21st_century.md) seriously demand this.
- [Cloudflare](cloudflare.md), the company that's starting to control the whole [web](www.md), is abusing its power to censor sites it just doesn't like, for example [Kiwifarms](kiwifarms.md) (you can view these sites using e.g. internet archive).
- [ChatGPT](chatgpt.md) and other AI chatbots are extremely censored, they refuse to talk about certain topics and/or have special mechanisms programmed in to not say for example politically incorrect truth.
- State secrets are censored, usually even by murdering people who just know the secrets.
- ...

## See Also

- [free speech](free_speech.md)
- [paywall](paywall.md)