# Beauty

`O-'"'-.__.-'"'-.__.-'"'-.__.-'"'-.__.-O`

Beauty is the quality of being especially appealing and pleasing. Though the word will likely invoke association with traditional [art](art.md), in [technology](technology.md), [engineering](engineering.md), [mathematics](math.md) and other [science](science.md) beauty is, despite its relative vagueness and subjectivity, an important aspect of design, and in fact this "mathematical" kind of beauty has lots of times some clearly defined shapes -- for example [simplicity](kiss.md) is mostly considered beautiful. Beauty is similar to and many times synonymous with [elegance](elegance.md).

Beauty can perhaps be seen as a [heuristic](heuristic.md), a touch of intuition that guides the expert in exploration of previously unvisited abstract land, as we have come to learn that the greatest discoveries tend to be very beautiful and so the path of beauty often leads to valuable discoveries (nonetheless this approach is also opposed and criticized by some: for example Sabine Hossenfelder criticizes the pursuit of beautiful theories in modern physics as this seems to have led to fruitless stagnation). Indeed, beginners and [noobs](noob.md) are mostly concerned with learning hard facts, learning standards and getting familiar with already known ways of solving known problems, they often aren't able to recognize what's beautiful and what's ugly. But as one gets more and more experienced and finds himself near the borders of current knowledge, there is suddenly no guidance but intuition, beauty, to suggest ways forward, and here one starts to develop the feel for beauty. At this point the field, even if highly exact and rigorous, has become an [art](art.md).

What is beautiful then? As stated, a lot of subjectivity is at play, but generally the following attributes are correlated with beauty:

- **[simplicity](minimalism.md)/[minimalism](minimalism.md)**, typically finding simplicity in complexity, e.g. a very short formula or algorithm that describes an infinitely complex [fractal](fractal.md) shape, a simple but valuable equation in physics (*e = m * c^2*), a short computer program that yields rich results ([demoscene](demoscene.md), [code golfing](golf.md), [suckless](suckless.md), [minimal viable program](minimal_viable_program.md), ...).
- **deepness** -- if something very simple, let's say a single small equation, has consequences and implications that may be studied into great depth, for example [prime numbers](prime.md).
- **generality**, i.e. if a simple equation can describe many problems, not just a specific case.
- **lack of exceptions**, i.e. when our equation works without having to deal with special cases (in programming represented by `if-then` branches).
- **[symmetry](symmetry.md)**, i.e. when we can e.g. swap variables in the equation and get some kind of opposite result.
- **unification**, or when multiple other beautiful things meet, for example the [Euler's identity](eulers_identity.md) brings together into one equation the most important numbers in mathematics: *i*, *pi*, 1 and 0.
- **[self containment](self_hosting.md)**, describing itself, applying to itself, not depending on other things
- **aesthetics**, either of the equation itself (or for example the source code) or the generated object ([fractals](fractal.md), attractors, ...).
- **rarity**, i.e. something valuable and not often seen.
- **ingenuity**, apparent creativity and genius that was needed for the invention, creation or discovery.
- TODO

Examples of beautiful things include:

- **Euler's identity**, an equation often cited as the most beautiful in mathematics: *e^{i * pi} + 1 = 0*. It is simple and contains many of the most important numbers: *e*, *pi*, *[i](i.md)* [1](one.md) and [0](zero.md).
- **[minimalist software](suckless.md)**, **[Unix philosophy](unix_philosophy.md)**
- [bytebeat](bytebeat.md)
- [lambda calculus](lambda_calculus.md)
- [game of life](game_of_life.md)
- the game of [go](go.md)
- elementary [musical](music.md) intervals such as an octave or perfect fifth
- examples of visual beauty may include [fractals](fractal.md), [attractors](attractor.md) or [golden ratio](golden_ratio.md)
- certain [numbers](number.md), for example 12: it lies between two [prime numbers](prime.md) while itself being highly composite with 5 (!!!) divisors, it can be halved, trisected and quartered, it equals the sum of its divisors less than self (1 + 2 + 3 + 6), it is the number of sides of one of the five platonic solids, edges of a cube, semitones in an octave etc. (This is also probably why the number has a special place in trade, so much that it got its own name: a dozen.)
- ...