# Attribution

In the world of intellectual works (such as programs, texts, images etc.) attribution means visibly and properly acknowledging the work of collaborators, i.e. usually mentioning the names or pseudonyms of others that somehow took part in creation of the work. Sometimes we distinguish between merely giving *credit*, i.e. just recording collaborators somewhere, even in a less visible place such as some documentation file, and *proper attribution* which may have further conditions, e.g. mentioning the authors in a visible place (e.g. game's main menu) along with a link to their website and so on. Attribution is something that's often a condition of a [license](license.md), i.e. for example the [Creative Commons Attribution](cc_by.md) (CC BY) license grants everyone rights to the work as long as the original author is properly attributed. However we at [LRS](lrs.md) see such license requirements as [harmful](harmful.md); **forcing attribution with a [license](license.md) is a very bad idea!** Never do it. Please consider the following:

- Forcing attribution may cause practical problems and make your work unusable. While it's no issue to give proper attribution to one guy who made music for your game, consider also a different scenario: e.g. in development of [LMMS](lmms.md), a [FOSS](foss.md) music making program, the authors had to collect hundreds of short sound samples for their virtual instruments -- here they couldn't use CC BY-SA samples because doing so would require anyone who made music with their program to also carry on proper attribution of all the author of every single sample that was used in the music, which is practically almost impossible.
- Forcing attribution can make you be force signed under things you don't want to be signed under. Consider you make a comics for children and license it CC BY-SA, i.e. require attribution. By free culture principles someone can take the characters from your story and make porn or terrorist supporting videos with them and even if those guys knew you wouldn't want to be signed under this (because you e.g. made it clear on your blog that you hate porn and terrorism) and even if they would be willing to not name you, your license will force them to write your name PROPERLY, i.e. visibly, under the thing they make.
- You're still playing the [copyright](copyright.md) game -- even if you relax copyright, you still acknowledge of the idea you keep some basic rights and have to [enforce](fight_culture.md) a "correct use" of your work. Even if the difference between CC0 and CC BY was practically of small importance, your mindset will likely be very different with each of them. There is a pattern of people who use CC0 being completely cool while the "CC BY-SA" people oftentimes changing their mind, trying to make trouble with "moral rights" and so on. Just don't do this.
- It is just legal [bloat](bloat.md), it created [friction](friction.md), distract artists. It is unnecessary. Even if it's a small burden, it's still a burden for everyone -- the license has to be longer, it has to define what proper attribution means, what happens if it can't be technically achieved etc. You have to keep one more thing in your working memory, you have to observe if people respect this condition etc.
- It discourages many from using your work. For some of the mentioned reasons many people actually avoid reusing works that require attribution { Including me and many other people I know.  ~drummyfish }. There exist dangers like attribution getting unintentionally lost in some copy paste by which you start violating the license, people are aware of this danger so they firstly look for works with no conditions at all, just to be safer. By releasing your work without requiring attribution you usually get "extra points" from the free culture community for saving other headaches and trouble.
- You will almost certainly be attributed even if you don't force it. People naturally credit others and there is basically no reason not to, it's in everyone's interest. In practice many people use licenses/waiver that don't force attribution and basically no "abuse" of this is seen -- firstly people are [culturally](culture.md) very strongly taught to always attribute others and socially rewarded for doing so, but secondly it doesn't even make any sense to try to come up with any "abuse", there isn't a way to abuse this -- imagine someone wanted to take credit on social media for some work he didn't make: it would sooner or later be found he didn't make the work anyway -- the original author would comment or it would show the guy is incapable of producing more similar works etc., and this can be confirmed on the Internet by digging and finding the work posted previously by someone else. So the guy would just forever mark himself as a scammer, people just don't even try this. AND even if this happens -- e.g. with some nasty copycat Chinese scammers -- they just blatantly "steal" the work no matter the license, they literally don't care about licenses, they steal even proprietary Hollywood movie characters, license doesn't do anything here. { I've been using exclusively [CC0](cc0.md) (which doesn't require credit) for many years and literally never encountered a single case when someone wouldn't credit me, nor have I heard of any malicious attempts at abusing this anywhere. ~drummyfish }
- ...

## See Also

- [copyleft](copyleft.md)
- [NC](nc.md)
- [ND](nd.md)