# Artificial Intelligence

Artificial intelligence (AI, also artificial stupidity) is an area of [computer science](compsci.md) whose effort lies in making [computers](computer.md) simulate thinking of humans and possibly other biologically [living beings](life.md). This may include making computers play [games](game.md) such as [chess](chess.md), compose [music](music.md), paint pictures, understand and processing [audio](audio.md), images and [text](text.md) on high level of [abstraction](abstraction.md) and understanding (e.g. translation between [natural languages](human_language.md)), making predictions about complex systems such as stock market or weather or even exhibit a general human-like behavior such as simulated emotion. Even though today's focus in AI is on [machine learning](machine_learning.md) and especially [neural networks](neural_network.md), there are many other usable approaches and models such as "hand crafted" state tree searching algorithms that can simulate and even outperform the behavior of humans in certain specialized areas.

By about 2020, "AI" has become a [capitalist](capitalism.md) [buzzword](buzzword.md). They try to put machine learning into everything just for that AI label -- and of course, for a [bloat monopoly](bloat_monopoly.md).

By 2023 neural network AI has become extremely advanced in processing visual, textual and audio information and is rapidly marching on. Networks such as [stable diffusion](stable_diffusion.md) are now able to generate images (or modify existing ones) with results oftentimes indistinguishable from real photos just from a short plain language textual description. Text to video AI is emerging and already giving nice results. AI is able to write computer programs from plain language text description. Chatbots, especially the proprietary [chatGPT](chatgpt.md), are scarily human-like and can already carry on conversation mostly indistinguishable from real human conversation while showing extraordinary knowledge and intelligence -- the chatbot can for example correctly reason about advanced mathematical concepts on a level much higher above average human. This new "AI" has become [mainstream](mainstream.md) and is everywhere, normies are downloading "AI [apps](app.md)" on their phones that do funny stuff with their images while spying on them. In games such as [chess](chess.md) or even strategy video [games](game.md) neural AI has already been for years far surpassing the best of humans by miles.

There's a concern, subject to discussion with very varying opinions, about the dangers which the development of a very powerful AI could impose upon our civilization. Many fear the possibility of [technological singularity](tech_singularity.md), a scenario in which a super intelligent AI takes control over the world from human hands, leaving us at its mercy. This is likely not a near [future](future.md) concern and some even deny the danger altogether, but the prevailing view seems to be that it's a question of *when* rather than *if*. The sudden explosion of "AI" technology in early 2020s is already creating many immediate problems and fears, such as highly amplified Internet [noise](noise.md), floods of [spam](spam.md), made up news, [captchas](captcha.md) becoming unusable, "loss of [jobs](work.md)" ([good](good.md) from [LRS](lrs.md) point of view!), decrease in quality of [art](art.md) and a lot more.

For normies let's briefly tackle some of the most pressing questions such as: **What is this "modern" AI really about? Is it actually intelligent? Are AI chatbots superhuman in their reasoning?** Well, the "modern" AI is really based on mechanisms found in human brain and is relatively closely simulating them, although in very, very simplified ways (e.g. using simplified structures of neural networks and using a lot of preprocessing), with everything scaled down (in terms of neuron count) and limiting to very specific areas (e.g. only simulating part of what's found in our visual system), so we could say the machine is intelligent in the same way as us but not nearly to the same degree -- imagine the AI as someone who has something closer to a rat brain and who has never lived human life, never knew our pain or pleasure, need of sleep or eating, our kind of emotion or desires, who has for whole life focused on one extremely specialized task, such as recognizing faces in pictures or predicting weather from meteorological data (all of which really reduce to recognizing patterns in numerical sequences), over and over without taking any break. Questions about [consciousness](consciousness.md), self awareness etc. are better left to philosophers now -- it is possible this kind of AI has consciousness and even its own tiny kinds of desires and emotions (we may imagine it really really wanting to see certain patterns of numbers for example), but it would be more similar to that of a bug or plant, its world is completely different than ours. It may seem that [LLM](llm.md)s (the "AI chatbots" such as ChatGPT) speak like humans and so it's natural to assume there is internally some human thought existing, but even here the internal mechanisms of the AI are extremely simplified compared to humans (and they inevitably have to be e.g. due to incomparably lower number of neurons): all the LLM does is PREDICTING which word will come up next in a textual human communication based on having seen millions and millions of such conversations. I.e. if the AI sees an incomplete sentence that reads "Thank you very", it will predict that the word "much" will follow, and doing this repeatedly allows it to generate long texts, but it is not doing anything else. This means that opinions, personality and "facts" the AI knows reflect what it has seen in the data set -- if you train the AI on conversations happening on [reddit](reddit.md), it will talk like a redditor, it will make the same reasoning mistakes, assume the same incorrect facts etc. Furthermore there is a lot of [cheating](cheating.md) going on, just like computer [3D graphics](3d_rendering.md) has to resort to cheating and tricks because it couldn't simulate the infinite complexity of the real world -- for example language models typically don't see actual letters of the text, they operate on word tokens, so they normally cannot solve simple problems that require looking at the letters such as typing given word backwards. So we mustn't think such AI somehow gives definitive or highly superior answers to our questions, it only predicts (and sometimes very poorly) what answer a human would give. And we can say the same about different types of neural AIs -- for instance a program synthesizing images does really the same thing, just with pixels instead of words, and so we cannot think an image of a dinosaur drawn by this AI is somehow more biologically accurate, it will only mimic how humans draw dinosaurs. One way to think of these AIs is this: imagine you tell a human to spend whole life perfecting something extremely specialized without focusing on anything else -- this is what the AI will do, the only advantage being it can learn this in hours or day instead of 70 years, and it's a machine that doesn't need rest, salary and other things, so it's now very cheap and easy to create such specialized monkeys. To sum up: we are still far away from simulating something truly close to a fully functioning human brain, but we can now cheaply create programs that very effectively do very specialized tasks which previously only humans could do, most notably [art](art.md), manipulating languages, pictures and other things relying on intuition and "feel" rather than precise equations.

## Details

As programmers let's first answer ourselves this: what really is AI to us? A programmer/mathematician typically simplifies AI to signify only this much: **computer making decisions**. I.e. let's forget human brain, emotion, psychology and all this kind of stuff for a second and focus only on one thing: decision making, and how to program computers so that they make an intelligent decision from input data. Every single "AI" system never does anything more than just take a look at current situation (state, context, data, ..., just a bunch of numbers) and from all possible actions that may be taken from here it tries to pick the best one (i.e. output another number). Whether it's making the best move in [chess](chess.md), deciding which animal is captured in a photo, choosing how to translate a word from English to Spanish or choosing what pixel to draw on the screen so that the result will resemble human art, the problem is always reduced to only deriving a number from some other numbers.

AI to us is therefore nothing more than a mathematical [function](function.md) of state, outputting action (leading to another state). Also we will require this function to be pure, true and [deterministic](determinism.md) mathematical function, i.e. without any [randomness](randomness.md), hidden state etc., i.e. the function will always return the same result for the same input, the input depends SOLELY on the state we give it. In an extreme case every AI that works with finite memory could then literally be just a [table](lut.md) defining best action for any state -- but of course, such tables would be big and hard to make manually, so we typically try to create [algorithms](algorithm.md) that do the job of such table without taking so much space.

NOTE: Of course we sometimes want randomness, for example in chess we may want our AI to sometimes make a different move in the same position, but this added randomness always can (and SHOULD) be implemented outside of our AI function -- we may for example add an extra [seed](seed.md) parameter to our AI which will affect its choice, or we could make an AI that only ranks the quality of each move and then make our chess bot (built on top of this AI) randomly choose from let's say 3 best moves as judged by the AI.

The "modern" machine learning ([neural network](neural_net.md) etc.) AI is no exception here, neural network also implements a pure mathematical function in this sense. That is we are still facing the same problem, we are just trying to solve it by training a network that will make good choices. This approach is mostly about creating a good structure of the network, with good parameters (like number of neurons, layers etc.), encoding the states in good ways (i.e. mapping real world problems to numbers representing the state) and then training the network well, i.e. using right data sets, training algorithms etc. This art is very complex and can't be detailed here in depth.

The traditional non-machine-learning approach is a bit different -- it is based on manually programming **[state space search](state_space_search.md)** algorithms rather than training models. From [LRS](lrs.md) point of view this is probably the **more [KISS](kiss.md) way**, i.e. preferable, sufficient for many types of problems without needing extremely powerful machines or huge datasets. In essence we do this: we realize the states are basically nodes and actions are connections between the nodes, i.e. we get a **state space** which is a methematical **[graph](graph.md)**. Our program is always in some state, i.e. in some node, and the actions it may take are paths it may take in the graph, so really our AI is helping us travel through the graph so that we get from whatever state we're in to a better one (ideally best possible). Many different algorithms, [heuristics](heuristic.md) and optimizations exist here such as [depth first search](dfs.md), [breadth first search](bfs.md), [Monte Carlo](monte_carlo.md), [minimax](minimax.md) with alpha-beta pruning etc. -- they typically just [recursively](recursion.md) traverse the local space, i.e. take a look at states near the current one, and then say in which direction the best state lies. Let's remind ourselves this doesn't just have to be chess and chess moves, this may apply to flying a virtual plane or solving an equation. Again, the whole art of state space search can't be covered here in depth.

To sum up let's again compare the two mentioned approaches on the example of chess. Neural network machine learning will try to train a network (we could almost say by just [brute force](brute_force.md) trying many different parameters for the network) that takes a look at the chess board (which will be encoded into numbers) and then, by some kind of complex "[magic](magic.md)" that's really hidden from us somehow outputs the correct move (well, in practice it rather just scores the position, but let's neglect this now). Training such network will take a lot of time, data and electricity; it will result in a network that will pick good moves without us knowing HOW it really works (we just know it does), and the network will be just a network that filters input numbers into an output number. The traditional state search approach, on the other hand, will rather be a hand-made algorithm that will check all possible moves to certain depth and then return the move that it found will lead to a position that looks the best. I.e. here we know exactly what's going on, we have an algorithm simulating the human move calculation (looking ahead in the game for good moves), and the algorithm works iteratively, i.e. it has to perform many steps and playouts to actually see how to game evolves with different moves.

NOTE: State search is sometimes combined with neural networks -- good chess engines for example still do traditional state search but employ a neural network to decide how good each position is. This way we get the best of both world.

TODO: cont

# See Also

- [artificial life](artificial_life.md)
