# Acronym

Acronym is an abbreviation of a multi-word term formed usually by appending the starting letters of each word to create a new, unique and hopefully [funny](fun.md) word.

Here is a list of some acronyms (and similar kinds of abbreviations and/or pseudoacronyms):

- **[0D](0d.md)** ([zero](zero.md) [dimensional](dimension.md))
- **[1D](1d.md)** ([one](one.md) dimensional)
- **[2D](2d.md)** (two dimensional)
- **[2.5D](2_5d.md)** (two and a half dimensional)
- **[3D](3d.md)** (three dimensional)
- **[3DS](3ds.md)** (three dimensional dual screen)
- **[4D](4d.md)** (four dimensional)
- **[5G](5g.md)** (fifth generation)
- **[A](a.md)** (ampere)
- **[AA](aa.md)** (anti [aliasing](aliasing.md))
- **[AABB](aabb.md)** (axis aligned bounding box)
- **[AC](ac.md)** (alternating current, air conditioning)
- **[ACID](acid.md)** (atomicity consistency isolation durability)
- **[ACK](ack.md)** (acknowledgement)
- **[AD](ad.md)** (anno domini)
- **[ADD](add.md)** (attention deficit disorder)
- **[ADHD](adhd.md)** (attention deficit hyperactivity disorder)
- **[ADSL](adsl.md)** (asymmetric digital subscriber line)
- **[ADT](adt.md)** (abstract [data type](data_type.md))
- **[AF](af.md)** (as fuck)
- **[AFAIK](afaik.md)** (as far as I know)
- **[AFK](afk.md)** (away from keyboard)
- **[AFPS](afps.md)** (arena FPS)
- **[AFK](afk.md)** (away from keyboard)
- **[AGPL](agpl.md)** (Affero GPL)
- **[AI](ai.md)** (artificial intelligence)
- **[AIDS](aids.md)** (acquired immunodeficiency syndrome)
- **[AJAX](ajax.md)** (asynchronous [JavaScript](js.md) and [XML](xml.md))
- **[AK47](ak_47.md)** (Avtomat Kalashnikova 47)
- **[AKA](aka.md)** (also known as)
- **[ALAP](alap.md)** (as late as possible)
- **[ALGOL](algol.md)** (algorithmic language)
- **[ALSA](alsa.md)** (advanced [Linux](linux.md) sound architecture)
- **[ALU](alu.md)** (arithmetic logic unit)
- **[AM](am.md)** (amplitude modulation, ante meridiem)
- **[AMA](ama.md)** (ask me anything)
- **[AMD](amd.md)** (advanced micro devices)
- **[ANAL](anal.md)** (armas nucleares en America Latina)
- **[ANCAP](ancap.md)** (anarcho capitalist)
- **[ANCOM](ancom.md)** (anarcho communist)
- **[ANPAC](anpac.md)** (anarcho pacifist)
- **[ANSI](ansi.md)** ([American](usa.md) national standards institute)
- **[AO](ao.md)** ([ambient occlusion](ambient_occlusion.md))
- **[API](api.md)** (application programming interface)
- **[APM](apm.md)** (actions per minute)
- **[ARM](arm.md)** (advanced [RISC](risc.md) machines)
- **[ARPANET](arpanet.md)** (advanced research projects agency network)
- **[ASAP](asap.md)** (as soon as possible)
- **[ASCII](ascii.md)** (American standard code for information interchange)
- **[ASM](asm.md)** (assembly)
- **[ASMR](asmr.md)** (auto-synchronous meridian response)
- **[ASS](ass.md)** (automatic system security, assert)
- **[ATM](atm.md)** (at the moment, automated teller machine, ass to mouth)
- **[ATOI](atoi.md)** ([ASCII](ascii.md) to integer)
- **[AVI](avi.md)** (audio video interleave)
- **[AVPD](avpd.md)** (avoidant personality disorder)
- **[AVR](avr.md)** (Alf and Vegard's RISC)
- **[AWK](awk.md)** (Aho, Weinberger, Kernighan)
- **[B](b.md)** ([byte](byte.md), bit)
- **[B4](b4.md)** (before)
- **[BAI](bai.md)** (bienvenido a internet)
- **[BASH](bash.md)** (bourne again shell)
- **[BASIC](basic.md)** (beginner's all purpose symbolic instruction code)
- **[BB](bb.md)** (baby, bye bye, be back)
- **[BBC](bbc.md)** (big black cock)
- **[BBL](bbl.md)** (be back later)
- **[BBS](bbs.md)** (bulletin board system, big black [shit](shit.md))
- **[BBW](bbw.md)** (big beautiful woman)
- **[BC](bc.md)** ([bytecode](bytecode.md), before Christ, basic calculator)
- **[BCD](bcd.md)** (binary coded decimal)
- **[BCE](bce.md)** (before common era)
- **[BDFL](bdfl.md)** (benevolent dictator for life)
- **[BDSM](bdsm.md)** (bondage domination sadism masochism)
- **[BEQ](beq.md)** (branch if equal)
- **[BF](bf.md)** ([brainfuck](brainfuck.md), boyfriend)
- **[BFF](bff.md)** (best friends forever)
- **[BFG](bfg.md)** (big fucking gun)
- **[BG](bg.md)** (background, bad game)
- **[BGR](bgr.md)** (blue green red)
- **[BIOS](bios.md)** (basic [input/output](io.md) system)
- **[BITCH](bitch.md)** (babe In total control of herself)
- **[BJ](bj.md)** (blow job)
- **[BJT](bjt.md)** (bipolar junction transistor)
- **[BLM](blm.md)** (black lives matter)
- **[BNE](bne.md)** (branch if not equal)
- **[BNF](bnf.md)** (Backus-Naur form)
- **[BPM](bpm.md)** (beats per minute)
- **[BPP](bpp.md)** ([bits](bit.md) per [pixel](pixel.md))
- **[BPS](bps.md)** (bits per second)
- **[BRB](brb.md)** (be right back)
- **[BS](bs.md)** (bullshit)
- **[BSC](bsc.md)** (bachelor of science)
- **[BSD](bsd.md)** (Berkeley software distribution)
- **[BSOD](bsod.md)** (blue screen of death)
- **[BTFO](btfo.md)** (blown the fuck out)
- **[BTW](btw.md)** (by the way)
- **[BYOB](byob.md)** (bring your own bottle/booze/beer/...)
- **[C](c.md)** (Celsius)
- **[C64](c64.md)** (Commodore 64)
- **[CAD](cad.md)** (computer aided design)
- **[CAPTCHA](captcha.md)** (completely automated public Turing test to tell computers and humans apart)
- **[CC0](cc0.md)** (creative commons zero)
- **[CC](cc.md)** ([creative commons](creative_commons.md), [C](c.md) compiler)
- **[CC0](cc0.md)** (creative commons zero)
- **[CC BY](cc_by.md)** (creative commons [attribution](attribution.md))
- **[CC BY-NC](cc_by_nc.md)** (creative commons attribution sharealike [non-commercial](nc.md))
- **[CC BY-ND](cc_by_nd.md)** (creative commons attribution sharealike non-commercial [no derivatives](nd.md))
- **[CC BY-SA](cc_by_sa.md)** (creative commons attribution [sharealike](copyleft.md))
- **[CC BY-NV](cc_by_nv.md)** (creative commons attribution no value)
- **[CD](cd.md)** (compact disc, change directory)
- **[CDN](cdn.md)** (content delivery network)
- **[CE](ce.md)** (comon era)
- **[CEO](ceo.md)** (chief executive officer)
- **[CERN](cern.md)** (organisation europeenne pour la recherche nucleaire)
- **[CET](cet.md)** (central European time)
- **[CG](cg.md)** (computer [graphics](graphics.md))
- **[CGI](cgi.md)** (computer generated imagery)
- **[CIA](cia.md)** (central intelligence agency)
- **[CIDE](cide.md)** (collaborative international dictionary of [English](english.md))
- **[CISC](cisc.md)** (complex instruction set computer)
- **[CLI](cli.md)** (command line interface)
- **[CLK](clk.md)** (clock)
- **[CM](cm.md)** (centimetre, candidate master)
- **[CMOS](cmos.md)** (complementary metal oxide semiconductor)
- **[CMS](cms.md)** (content management system)
- **[CMYK](cmyk.md)** (cyan magenta yellow key)
- **[CNC](cnc.md)** (computer numerical control)
- **[COBOL](cobol.md)** (common business-oriented language)
- **[COC](coc.md)** (code of conduct, code of censorship)
- **[COLLADA](collada.md)** (collaborative design activity)
- **[COMPSCI](compsci.md)** (computer science)
- **[CP](cp.md)** (child porn, copy, checkpoint)
- **[CPI](cpi.md)** (cycles per instruction)
- **[CPP](cpp.md)** (C++)
- **[CPU](cpu.md)** (central processing unit)
- **[CR](cr.md)** (carriage return)
- **[CRAP](crap.md)** (can't realize a profit)
- **[CRC](crc.md)** (cyclic redundancy check, critical [race](race.md) theory)
- **[CRT](crt.md)** (cathode ray tube)
- **[CS](cs.md)** ([computer science](compsci.md), counter strike)
- **[CSFML](csfml.md)** ([C](c.md) SFML)
- **[CT](ct.md)** (computed tomography)
- **[CSG](csg.md)** (constructive solid geometry)
- **[CSH](csh.md)** (C shell)
- **[CSS](css.md)** (cascading style sheet)
- **[CST](cst.md)** (central standard time)
- **[CSV](csv.md)** (comma separated values)
- **[CTO](cto.md)** (chief technology officer)
- **[CTWM](ctwm.md)** (Claude's tab window manager)
- **[CUM](cum.md)** (cubic meter)
- **[CURL](curl.md)** (curl URL request library)
- **[CV](cv.md)** (curriculum vitae)
- **[CWM](cwm.md)** (calm window manager)
- **[CZ](cz.md)** (Citizendium)
- **[D](d.md)** (day, dick)
- **[DAC](dac.md)** (digital analog converter)
- **[DARCS](darcs.md)** (darcs advanced revision control system)
- **[DAW](daw.md)**(digital audio workstation)
- **[DB](db.md)** (database)
- **[DC](dc.md)** (direct current)
- **[DCT](dct.md)** (discrete cosine transform)
- **[DD](dd.md)** (data definition)
- **[DDA](dda.md)** (digital differential analyzer)
- **[DDOS](ddos.md)** (distributed denial of service)
- **[DDR](ddr.md)** (double data rate)
- **[DE](de.md)** (desktop environment)
- **[DFT](dft.md)** (discrete Fourier transform)
- **[DHCP](dhcp.md)** (dynamic host configuration protocol)
- **[DIY](diy.md)** (do it yourself, don't injure yourself)
- **[DK](dk.md)** (Donkey Kong)
- **[DL](dl.md)** (download)
- **[DLC](dlc.md)** (downloadable content)
- **[DLL](dll.md)** (dynamic link [library](library.md))
- **[DM](dm.md)** (deathmatch, decimetre, direct message)
- **[DMA](dma.md)** (direct memory access)
- **[DMCA](dmca.md)** (digital millennium copyright act)
- **[DNA](dna.md)** (deoxyribonucleic acid)
- **[DND](dnd.md)** (dungeons & dragons, do not disturb)
- **[DNS](dns.md)** (domain name system)
- **[DOA](doa.md)** (dead on arrival)
- **[DOF](dof.md)** (degrees of freedom)
- **[DOM](dom.md)** (document object model)
- **[DOS](dos.md)** (disk operating system, denial of service)
- **[DOTA](dota.md)** (defense of the ancients)
- **[DOTADIW](dotadiw.md)** (do one thing and do it well)
- **[DPI](dpi.md)** (dots per inch)
- **[DPRK](dprk.md)** (Democratic People's Republic of Korea)
- **[DRAM](dram.md)** (dynamic RAM)
- **[DRM](drm.md)** (digital restrictions management)
- **[DRY](dry.md)** (don't repeat yourself)
- **[DSL](dsl.md)** (digital subscriber line)
- **[DTFT](dtft.md)** (discrete time Fourier transform)
- **[DUI](dui.md)** (driving under influence)
- **[DVD](dvd.md)** (digital versatile disc)
- **[DVI](dvi.md)** (device independent file format)
- **[DW](dw.md)** (don't worry)
- **[DWM](dwm.md)** (dynamic window manager)
- **[E](e.md)** (electronic, electric)
- **[ED](ed.md)** ([Enyclopedia Dramatica](dramatica.md)))
- **[EEE](eee.md)** (embrace, extend, extinguish/exterminate)
- **[EEPROM](eeprom.md)** (electronically erasable programmable ROM)
- **[EG](eg.md)** (exempli gratia)
- **[ELI5](eli5.md)** (explain like I'm 5)
- **[ELF](elf.md)** (executable and linkable format, extensible linking format)
- **[EMACS](emacs.md)** (editing macros, eight megabytes and constantly swapping)
- **[ENIAC](eniac.md)** (electronic numerical integrator and computer)
- **[EOF](eof.md)** (end of [file](file.md))
- **[EOL](eol.md)** (end of line, end of life)
- **[EPUB](epub.md)** (electronic publication)
- **[EQ](eq.md)** (emotional quotient, equals)
- **[ERP](erp.md)** (erotic role play)
- **[ESP](esp.md)** (Espressif systems)
- **[ESR](esr.md)** (Erik Steven Raymond)
- **[EST](est.md)** (eastern standard time)
- **[ET](et.md)** (extra [terrestrial](earth.md))
- **[ETC](etc.md)** (et cetera)
- **[ETLETM](etletm.md)** (easy to learn, easy to master)
- **[ETLHTM](etlhtm.md)** (easy to learn, hard to master)
- **[EU](eu.md)** ([European](europe.md) union)
- **[EULA](eula.md)** (end user license agreement)
- **[F2P](f2p.md)** ([free](gratis.md) to play)
- **[FAG](fag.md)** (fuerza aerea Guatemalteca)
- **[FAP](fap.md)** (fuerza aerea del Peru, fair access policy, free address pool)
- **[FAT](fat.md)** ([file](file.md) allocation table)
- **[FAQ](faq.md)** (frequently asked questions)
- **[FB](fb.md)** ([Facebook](facebook.md))
- **[FBI](fbi.md)** (federal bureau of investigation)
- **[FE](fe.md)** (frontend)
- **[FEMCEL](femcel.md)** (female celibate)
- **[FEN](fen.md)** (Forsyth–Edwards notation)
- **[FET](fet.md)** (field effect transistor)
- **[FFA](ffa.md)** (free for all)
- **[FFMPEG](ffmpeg.md)** (fast forward MPEG)
- **[FFS](ffs.md)** (for fuck's sake)
- **[FFT](fft.md)** (fast Fourier transform)
- **[FIDE](fide.md)** (Federation Internationale des Echecs)
- **[FIFA](fifa.md)** (Federation Internationale de Football Association)
- **[FIFO](fifo.md)** (first in first out)
- **[FILO](filo.md)** (first in last out)
- **[FIR](fir.mf)** (finite impulse response)
- **[FLAC](flac.md)** (free lossless audio codec)
- **[FLOPS](flops.md)** ([floating point](float.md) operations per second)
- **[FLOSS](floss.md)** (free libre open source software)
- **[FM](fm.md)** (frequency modulation)
- **[FML](fml.md)** ([fuck](fuck.md) my life)
- **[FOMO](fomo.md)** (fear of missing out)
- **[FORTRAN](fortran.md)** (formula translation)
- **[FOSH](fosh.md)** (free and open source hardware)
- **[FOSS](foss.md)** (free and open source software)
- **[FOV](fov.mf)** (field of view)
- **[FP](fp.md)** ([floating point](float.md))
- **[FPGA](fpga.md)** (field programmable gate array)
- **[FPS](fps.md)** (frames per second, first "person" shooter)
- **[FPU](fpu.md)** (floating point unit)
- **[FQA](fqa.md)** (frequently questioned answers)
- **[FS](fs.md)** (file system, [free software](free_software.md))
- **[FR](fr.md)** (for real)
- **[FS](fs.md)** (Fourier series)
- **[FSF](fsf.md)** ([free software](free_software.md) foundation)
- **[FSM](fsm.md)** (finite state automaton)
- **[FT](ft.md)** ([Fourier transform](fourier_transform.md))
- **[FTFY](ftfy.md)** (fixed that for you)
- **[FTL](ftl.md)** (faster than [light](light.md))
- **[FTM](ftm.md)** ([female](woman.md) to male)
- **[FTP](ftp.md)** (file transfer protocol)
- **[FU](fu.md)** (fuck you)
- **[FW](fw.md)** (firewall)
- **[FXAA](fxaa.md)** (full screen anti aliasing)
- **[FYI](fyi.md)** (for your [information](information.md))
- **[G](g.md)** (gram)
- **[GB](gb.md)** ([gigabyte/gigabit](memory_unit.md), GameBoy, Gamebuino, Great Britain)
- **[GBA](gba.md)** (GameBoy Advance)
- **[GBC](gbc.md)** (GameBoy Color)
- **[GBPS](gbps.md)** (GB per second)
- **[GCC](gcc.md)** (GNU compiler collection)
- **[GDB](gdb.md)** (GNU debugger)
- **[GDP](gdp.md)** (gross domestic product)
- **[GDPR](gdpr.md)** (general data protection regulation)
- **[GF](gf.md)** (girlfriend)
- **[GFDL](gfdl.md)** (GNU free documentation license)
- **[GG](gg.md)** (good game)
- **[GH](gh.md)** (GitHub)
- **[GI](gi.md)** (global illumination)
- **[GIB](gib.md)** (gibibyte)
- **[GID](gid.md)** (group ID)
- **[GIF](gif.md)** (graphics interchange format)
- **[GIGO](gigo.md)** (garbage in garbage out)
- **[GIMP](gimp.md)** (GNU image manipulation program)
- **[GIT](git.md)** (global information tracker, goddamn idiotic truckload of shit)
- **[GL](gl.md)** (good luck)
- **[GLM](gl.md)** (OpenGL math)
- **[GLSL](glsl.md)** (OpenGL shading language)
- **[GLUT](glut.md)** (OpenGL utility toolkit)
- **[GM](gm.md)** (game master, grandmaster)
- **[GMO](gmo.md)** (genetically modified organism)
- **[GN](gn.md)** (good night)
- **[GNAA](gnaa.md)** (Gay [Nigger](nigger.md) Association of America)
- **[GNE](gne.md)** (GNE's not [encyclopedia](encyclopedia.md))
- **[GNOME](gnome.md)** (GNU network object model environment)
- **[GNG](gng.md)** (GNG's Not GNU)
- **[GNU](gnu.md)** (GNU's Not Unix)
- **[GOAT](goat.md)** (greatest of all time)
- **[GPG](gpg.md)** (GNU privacy guard)
- **[GPGPU](gpgpu.md)** (general purpose [GPU](gpu.md))
- **[GPIO](gpio.md)** (general purpose [I/O](io.md))
- **[GPL](gpl.md)** (GNU General Public License)
- **[GPLv2](gpl.md)** (GPL version 2)
- **[GPLv3](gpl.md)** (GPL version 3)
- **[GPS](gps.md)** (global positioning system)
- **[GPT](gpt.md)** (generative pretrained transformer)
- **[GPU](gpl.md)** (graphics processing unit)
- **[GREP](grep.md)** (global [regular expression](regexp.md) print)
- **[GRUB](grub.md)** (grand unified boot loader)
- **[GSM](gsm.md)** (global system for mobile communication)
- **[GTA](gta.md)** (Grand Theft Auto)
- **[GTFO](gtfo.md)** (get the [fuck](fuck.md) out)
- **[GTK+](gtk_plus.md)** (GIMP toolking)
- **[GTG](gtg.md)** (gotta go)
- **[GUI](gui.md)** (graphical user interface)
- **[GW](gw.md)** (gigawatt)
- **[H](h.md)** (hour, Henry)
- **[H8](hate.md)** (hate)
- **[HAL](hal.md)** (heuristically programmed algorithmic computer)
- **[HC](hc.md)** (hardcore)
- **[HCF](hcf.md)** (halt and catch fire)
- **[HD](hd.md)** (high definition)
- **[HDD](hdd.md)** (hard disc drive)
- **[HDMI](hdmi.md)** (HD multimedia interface)
- **[HF](hf.md)** (have fun)
- **[HIRD](hird.md)** (HURD of interfaces representing depth)
- **[HIV](hiv.md)** (human immunodeficiency virus)
- **[HL](hl.md)** (Half Life)
- **[HLSL](hlsl.md)** (high level shading language)
- **[HP](hp.md)** (Hewlett Packard, [Harry Potter](harry_potter.md), hit points)
- **[HR](hr.md)** (human resources)
- **[HSL](hsl.md)** (hue saturation lightness)
- **[HSV](hsv.md)** (hue saturation value)
- **[HTLETM](htlhtm.md)** (hard to learn, easy to master)
- **[HTLHTM](htlhtm.md)** (hard to learn, hard to master)
- **[HTML](html.md)** ([hypertext](hypertext.md) markup language)
- **[HTTP](http.md)** (hypertext transfer protocol)
- **[HTTPS](https.md)** (HTTP secure)
- **[HUD](hud.md)** (head up display)
- **[HURD](hurd.md)** (HIRD of Unix replacing demons)
- **[HW](hw.md)** (hardware)
- **[HQ](hq.md)** (high quality, headquarters)
- **[HYS](hys.md)** (hang yourself)
- **[HZ](hz.md)** (hertz)
- **[IANA](iana.md)** (internet assigned number authority)
- **[IANAL](ianal.md)** (I am not a lawyer)
- **[IB](ib.md)** (imageboard)
- **[IBM](ibm.md)** (international business machines)
- **[ICAAN](icaan.md)** (Internet corporation for assigned names and numbers)
- **[ICMP](icmp.md)** (internet control message protocol)
- **[ICQ](icq.md)** (I seek you)
- **[ICT](ict.md)** (information and communication technology)
- **[ICU](icu.md)** (intensive care unit)
- **[IDC](idc.md)** (I don't care)
- **[IDE](ide.md)** (integrated development environment)
- **[IDK](idk.md)** (I don't know)
- **[IE](ie.md)** (Internet Explorer, id est)
- **[IEEE](ieee.md)** (institute for electrical and electronic
- **[IFT](ift.md)** (inverse Fourier transform)
- **[IIR](iir.md)** (infinite impulse response)
- **[IIRC](iirc.md)** (if I recall correctly)
- **[IKR](ikr.md)** (I know, right?)
- **[IM](im.md)** (instant messaging, international master)
- **[IMAP](imap.md)** (internet message access protocol)
- **[IMHO](imho.md)** (in my honest opinion)
- **[IMO](imo.md)** (in my opinion)
- **[INB4](inb4.md)** (in before)
- **[INCEL](incel.md)** (involuntary celibate)
- **[INRI](inri.md)** ([Iesus](jesus.md) nazarenus rex [iudaeorum](jew.md))
- **[IO](io.md)** (input/output)
- **[IOCCC](ioccc.md)** (international [obfuscated](obfuscation.md) [C](c.md) code contest)
- **[IOT](iot.md)** (internet of things)
- **[IP](ip.md)** (internet protocol, intellectual property)
- **[IPS](ips.md)** (instructions per second)
- **[IPV4](ipv4.md)** (IP version 4)
- **[IPV6](ipv6.md)** (IP version 6)
- **[IQ](iq.md)** (intelligence quotient)
- **[IR](ir.md)** (infrared)
- **[IRC](irc.md)** (internet relay chat)
- **[IRL](irl.md)** (in real life)
- **[ISA](isa.md)** (instruction set architecture)
- **[ISO](iso.md)** (international organization for standardization)
- **[ISP](isp.md)** (internet service provider)
- **[ISS](iss.md)** (international space station)
- **[IS](is.md)** (information system)
- **[IT](it.md)** (information technology)
- **[ITT](itt.md)** (in this thread)
- **[J](j.md)** (Joule)
- **[J2ME](j2me.md)** ([Java](java.md) 2 micro edition)
- **[J2SE](j2se.md)** (Java 2 standard edition)
- **[JACK](jack.md)** (JACK audio connection kit)
- **[JB](jb.md)** ([jailbait](jailbait.md))
- **[JDK](jdk.md)** ([Java](java.md) development kit)
- **[JE](je.md)** (jump if equal)
- **[JIT](jit.md)** (just in time)
- **[JK](jk.md)** (just kidding)
- **[JNE](jne.md)** (jump if not equal)
- **[JPEG/JPG](jpg.md)** (joint photographic expert group)
- **[JRE](jre.md)** ([Java](java.md) runtime environment)
- **[JS](js.md)** (JavaScript)
- **[JSON](json.md)** (JavaScript object notation)
- **[K](k.md)** (Kelvin, OK)
- **[K&R](k_and_r.md)** (Kernighan and Ritchie)
- **[KB](kb.md)** ([kilobyte/kilobit](memory_unit.md))
- **[KBPS](kbps.md)** (KB per second)
- **[KCAL](kcal.md)** (kilocalorie)
- **[KDE](kde.md)** (K/Kool desktop environment)
- **[KEK](kek.md)** (a meme version of [LOL](lol.md) coming from World Of Warcraft)
- **[KFC](kfc.md)** (Kentucky fried chicken)
- **[KG](kg.md)** (kilogram)
- **[KHZ](khz.md)** (kilohertz)
- **[KIB](kib.md)** (kibibyte)
- **[KILL](kill.md)** (keep it [Linux](linux.md) loser)
- **[KISS](kiss.md)** (keep it simple stupid)
- **[KISP](kisp.md)** (keep it simple perfect)
- **[KISR](kisr.md)** (keep it simple retard)
- **[KJ](kj.md)** (kilojoule)
- **[KKK](kkk.md)** (ku klux klan)
- **[KLOC](kloc.md)** (kilo LOC)
- **[KM](km.md)** (kilometre)
- **[KMPH](kmph.md)** (kilometres per hour)
- **[KW](kw.md)** (kilowatt)
- **[KYS](kys.md)** ([kill yourself](suicide.md))
- **[L8](l8.md)** (late)
- **[LAMP](lamp.md)** (linux apache mysql php)
- **[LARP](larp.md)** (live action role play)
- **[LASER](laser.md)** ([light](light.md) amplification by stimulated emission of radiation)
- **[LAME](lame.md)** (LAME ain't MP3 encoder)
- **[LAN](lan.md)** (local area network)
- **[LCD](lcd.md)** (liquid crystal display)
- **[LD](ld.md)** (low definition)
- **[LED](led.md)** (light emitting diode)
- **[LER](ler.md)** (light emitting resistor)
- **[LERP](lerp.md)** (linear [interpolation](interpolation.md))
- **[LGBT](lgbt.md)** (lesbian gay bisexual trans)
- **[LGBTQ](lgbt.md)** (lesbian gay bisexual trans queer)
- **[LGPL](lgpl.md)** (lesser GPL)
- **[LIDAR](lidar.md)** (light detection and ranging)
- **[LIFO](lifo.md)** (last in first out)
- **[LILO](lilo.md)** (last in last out)
- **[LISP](lisp.md)** (list processing)
- **[LLM](llm.md)** (large language model)
- **[LLVM](llvm.md)** (low level virtual machine)
- **[LMAO](lmao.md)** (laughing my ass off)
- **[LMFAO](lmfao.md)** (laughing my fucking ass off)
- **[LOC](loc.md)** (lines of code)
- **[LOG](log.md)** (Legend of Grimrock)
- **[LOL](lol.md)** (laughing out loud, "League of Legends")
- **[LOTR](lotr.md)** (Lord of the Rings)
- **[LQ](lq.md)** (low quality)
- **[LRS](lrs.md)** (less retarded software/society)
- **[LRW](lrw.md)** ([less retarded wiki](less_retarded_wiki.md))
- **[LSB](lsb.md)** (least significant bit)
- **[LSD](lsd.md)** (lysergic acid diethylamide, Lucy in the sky with diamonds)
- **[LUT](lut.md)** (lookup table)
- **[LXDE](lxde.md)** (lightweight X11 desktop environment)
- **[LY](ly.md)** (light year)
- **[LZMA](lzma.md)** (Lempel-Ziv-Markov chain algorithm)
- **[M](m.md)** (metre, minute, month)
- **[M8](m8.md)** (mate)
- **[MB](mb.md)** (megabit, megabyte)
- **[MAC](mac.md)** (medium access control)
- **[MBA](mba.md)** (master of business administration)
- **[MBPS](mpbs.md)** (MB per second)
- **[MBR](mbr.md)** (master boot record)
- **[MC](mc.md)** (Minecraft)
- **[MCU](mcu.md)** (microcontroller unit)
- **[MD](md.md)** (markdown, medical doctor)
- **[MD5](md5.md)** (message digest 5)
- **[ME](me.md)** (management engine)
- **[MFW](mfw.md)** (my face when)
- **[MHZ](mhz.md)** (megahertz)
- **[MIB](mib.md)** (mebibyte)
- **[MIDI](midi.md)** (musical instrument digital interface)
- **[MILF](milf.md)** (mom I'd like to fuck)
- **[MIME](mime.md)** (multipurpose internet mail extension)
- **[MIP](mip.md)** (multum in parvo)
- **[MIPS](mips.md)** (millions of instructions per second)
- **[MIT](mit.md)** (Massachusetts Institute of Technology)
- **[MM](mm.md)** (millimetre)
- **[MMC](mmc.md)** (multimedia card)
- **[MMF](mmf.md)** (male, male, female)
- **[MMO](mmo.md)** (massively multiplayer online)
- **[MMORPG](mmorpg.md)** (MMO RPG)
- **[MMR](mmr.md)** (matchmaking ranking)
- **[MMS](mms.md)** (multimedia messaging service)
- **[MMU](mmu.md)** (memory management unit)
- **[MMX](mmx.md)** (multimedia extension)
- **[MOBA](moba.md)** (multiplayer online battle arena)
- **[MOSFET](mosfet.md)** (metal oxide semiconductor field effect transistor)
- **[MOTD](motd.md)** (message of the day)
- **[MP](mp.md)** (multiplayer)
- **[MPEG](mpeg.md)** (motion pictures experts group)
- **[MPH](mph.md)** (miles per hour)
- **[MPS](mps.md)** (meters per second)
- **[MR](mr.md)** (merge request, mister)
- **[MS/M$](ms.md)** (Micro$oft, millisecond)
- **[MSB](msb.md)** (most significant bit)
- **[MSC](msc.md)** (master of science)
- **[MSG](msg.md)** (message)
- **[MTF](mtf.md)** (male to [female](woman.md))
- **[MUD](mud.md)** (multi user dungeon)
- **[MW](mw.md)** (megawatt)
- **[N](n.md)** (no, Newton)
- **[N64](n64.md)** (Nintendo 64)
- **[NAN](nan.md)** (not a [number](number.md))
- **[NASA](nasa.md)** (national aeronautic and space administration)
- **[NAT](nat.md)** (network address translation)
- **[NATO](nato.md)** (north Atlantic treaty organization)
- **[NC](nc.md)** (non commercial)
- **[NDA](nda.md)** (non-disclosure agreement)
- **[NDS](nds.md)** (Nintendo Dual Screen)
- **[NEET](neet.md)** (not in education, employment or training)
- **[NEQ](neq.md)** (not equal)
- **[NES](nes.md)** (Nintendo Entertainment System)
- **[NFT](nft.md)** (non-fungible token)
- **[NGL](ngl.md)** (not gonna lie)
- **[NHL](nhl.md)** (national hockey league)
- **[NIGGER](nigger.md)** (nature is great, go enjoy reality)
- **[NN](nn.md)** (neural network)
- **[NOP](nop.md)** (no operation)
- **[NP](np.md)** (nondeterministic polynomial, no problem)
- **[NPC](npc.md)** (non-player character)
- **[NPM](npm.md)** (NPM is not an acronym)
- **[NPOV](npov.md)** (neutral point of view)
- **[NSA](nsa.md)** (national security agency)
- **[NSDAP](nsdap.md)** (nationalsozialistische Deutsche arbeiterpartei)
- **[NSFW](nsfw.md)** (not safe for [work](work.md))
- **[NSFL](nsfl.md)** (not safe for [life](life.md))
- **[NTFS](ntfs.md)** (NT file system)
- **[NVM](nvm.md)** (never mind)
- **[OA](oa.md)** (Open Arena)
- **[OBSD](obsd.md)** (OpenBSD)
- **[OC](oc.md)** (original creation)
- **[ODT](odt.md)** (open document text)
- **[OEM](oem.md)** (original equipment manufacturers)
- **[OG](og.md)** (original gangster)
- **[OGL](ogl.md)** (OpenGL)
- **[OLED](oled.md)** (organic light emitting diode)
- **[OMG](omg.md)** (oh my god)
- **[OMW](omw.md)** (on my way, OpenMW)
- **[OO](oo.md)** (object oriented, object obsessed, object obfuscated)
- **[OOB](oob.md)** (out of boundaries)
- **[OOP](oop.md)** (object oriented/obsessed programming)
- **[OP](op.md)** (original poster, original post, overpowered)
- **[OS](os.md)** (operating system, [open source](open_source.md))
- **[OSS](oss.md)** (open source software, open sound system)
- **[OSI](osi.md)** ([open source](open_source.md) initiative)
- **[OSINT](osint.md)** (open source intelligence)
- **[OTB](otb.md)** (over the board)
- **[OTF](otf.md)** (opentype font)
- **[P2P](p2p.md)** (peer to peer)
- **[PB](pb.md)** (petabyte, petabit, personal best)
- **[PBR](pbr.md)** (physically based rendering)
- **[PC](pc.md)** (personal computer, [political correctness](political_correctness.md), player character)
- **[PCB](pcb.md)** (printed circuit board)
- **[PCI](pci.md)** (peripheral component interconnect)
- **[PCM](pcm.md)** (pulse code modulation)
- **[PD](pd.md)** ([public domain](public_domain.md), personality disorder)
- **[PDA](pda.md)** (personal digital assistant)
- **[PDF](pdf.md)** (portable document format)
- **[PDP](pdp.md)** (programmed data processor)
- **[PENIS](penis.md)** (project ENIS, proton-enhanced nuclear induction spectroscopy)
- **[PET](pet.md)** (positron emission tomography)
- **[PETA](peta.md)** (people for the ethical treatment of animals, people eating tasty animals)
- **[PGM](pgm.md)** (portable graymap)
- **[PGN](pgn.md)** (portable game notation)
- **[PGP](pgp.md)** (pretty good privacy)
- **[PHD](phd.md)** (doctor of philosophy)
- **[PHP](php.md)** (personal home page, PHP: hypertext preprocessor)
- **[PID](pid.md)** (process ID)
- **[PIN](pin.md)** (personal identification number)
- **[PIP](pip.md)** (PIP installs packages)
- **[PITA](pita.md)** (pain in the ass)
- **[PM](pm.md)** (private message, post meridiem, Perl module)
- **[PMS](pms.md)** (premenstrual syndrome)
- **[PNG](png.md)** (portable network graphics, PNG's not GIF)
- **[POO](poo.md)** (programacion orientada a objetos)
- **[POOP](poop.md)** (post/pseudo object oriented programming)
- **[POP3](pop3.md)** (post office protocol version 3)
- **[POSIX](posix.md)** (portable operating system interface)
- **[POV](pov.md)** (point of view)
- **[PPC](ppc.md)** (power PC)
- **[PPM](ppm.md)** (portable pixmap)
- **[PPU](ppu.md)** (picture processing unit)
- **[PR](pr.md)** (pull request, public relations)
- **[PS](ps.md)** ([Photoshop](photoshop.md), [Postscript](postscript.md), [PlayStation](playstation.md))
- **[PS2](ps2.md)** (personal system 2)
- **[PSD](psd.md)** (Photoshop document)
- **[PSP](psp.md)** (PlayStation portable)
- **[PTHC](pthc.md)** (preteen hardcore)
- **[PTSD](ptsd.md)** (post traumatic stress disorder)
- **[PVP](pvp.md)** (player vs player)
- **[PWAD](pwad.md)** (patch WAD)
- **[Q3](q3.md)** (Quake III)
- **[QED](qed.md)** (quod erat demonstrandum)
- **[QEMU](qemu.md)** (quick emulator)
- **[QOL](qol.md)** (quality of life)
- **[QOS](qos.md)** (quality of service)
- **[RADAR](radar.md)** (radio detection and ranging)
- **[RAID](raid.md)** (redundant array of inexpensive discs)
- **[RAM](ram.md)** (random access [memory](memory.md))
- **[RAPE](rape.md)** (retire aged people early)
- **[RAR](rar.md)** (Roshal archive)
- **[RC](rc.md)** (release candidate)
- **[RCL](raycastlib.md)** (raycastlib)
- **[REGEX(P)](regex.md)** (regular expression)
- **[REST](rest.md)** (representational state transfer)
- **[RFC](rfc.md)** (request for comments)
- **[RGB](rgb.md)** (red green blue)
- **[RGBA](rgba.md)** (red green blue alpha)
- **[RISC](risc.md)** (reduced instruction set computer)
- **[RIP](rip.md)** (rest in piece)
- **[RLE](rle.md)** (run length encoding)
- **[RMS](rms.md)** (Richard Matthew Stallman)
- **[RN](rn.md)** (right now)
- **[RNG](rng.md)** (random number generator)
- **[ROFL](rofl.md)** (rolling on floor laughing)
- **[ROM](rom.md)** ([read-only](read_only.md) memory)
- **[RONJA](ronja.md)** (reasonable optical near joint access)
- **[RPG](rpg.md)** (role playing game)
- **[RPI](rpi.md)** (Raspberry Pi)
- **[RPM](rpm.md)** (revolutions per minute)
- **[RPN](rpn.md)** (reverse Polish notation)
- **[RQ](rq.md)** (ragequit)
- **[RSS](rss.md)** (RDF site summary, really simple syndication)
- **[RT](rt.md)** (real time)
- **[RTA](rta.md)** (real time attempt)
- **[RTF](rtf.md)** (rich text format)
- **[RTFM](rtfm.md)** (read the fucking manual)
- **[RTOS](rtos.md)** (real time operating system)
- **[RTS](rts.md)** (real time strategy)
- **[RUR](rur.md)** (Rossum's Universal Robots)
- **[S](s.md)** (second)
- **[S3L](small3dlib.md)** (small3dlib)
- **[SAAS](saas.md)** (software as a service)
- **[SAASS](saass.md)** (service as a software substitute)
- **[SAF](saf.md)** (smallabstractfish)
- **[SAT](sat.md)** (scholastic aptitude test)
- **[SBC](sbc.md)** (single board computer)
- **[SCAT](scat.md)** (subcategory)
- **[SCC](scc.md)** (simple C compiler)
- **[SCL](smallchesslib.md)** (smallchesslib)
- **[SCP](scp.md)** (secure, contain, protect)
- **[SCSI](scsi.md)** (small computer system interface)
- **[SD](sd.md)** (standard definition, secure digital)
- **[SDF](sdf.md)** (signed distance function)
- **[SDK](sdk.md)** (software development kit)
- **[SDL](sdl.md)** (simple directmedia layer)
- **[SED](sed.md)** (smoke emitting diode, stream editor)
- **[SEO](seo.md)** (search engine optimization)
- **[SETI](seti.md)** (search for extraterrestrial intelligence)
- **[SEX](sex.md)** (sign extension unit)
- **[SF](sf.md)** (Stockfish)
- **[SFML](sfml.md)** (simple and fast multimedia library)
- **[SFTP](sftp.md)** (secure file transfer protocol)
- **[SFW](sfw.md)** (safe for work)
- **[SFX](sfx.md)** (sound effects)
- **[SGML](sgml.md)** (standard generalized markup language)
- **[SHA](sha.md)** (secure [hash](hash.md) [algorithm](algorithm.md))
- **[SIG](sig.md)** (special interest group)
- **[SIM](sim.md)** (subscriber identity module)
- **[SIMD](simd.md)** (single [instruction](instruction.md) multiple [data](data.md))
- **[SJW](sjw.md)** (social [justice](justice.md) warrior)
- **[SLOC](sloc.md)** (source lines of code)
- **[SM](sm.md)** (Super Mario)
- **[SMH](smh.md)** (shaking my head)
- **[SMS](sms.md)** (short message service)
- **[SMTP](smtp.md)** (simple mail transfer protocol)
- **[SNES](snes.md)** (Super Nintendo Entertainment System)
- **[SNR](snr.md)** (signal to noise ratio)
- **[SNTP](sntp.md)** (simple network time protocol)
- **[SO](so.md)** (shared object)
- **[SOC](soc.md)** (system on a chip)
- **[SONAR](sonar.md)** (sound navigation and ranging)
- **[SOS](sos.md)** (si opus sit, save our souls)
- **[SPARC](sparc.md)** (scalable processor architecture)
- **[SPARQL](sparql.md)** (SPARQL protocol and RDF query language)
- **[SPQR](spqr.md)** (senatus populusque romanus)
- **[SPS](sps.md)** ([shitwords](shitword.md) per second)
- **[SQL](sql.md)** (structured query language)
- **[SRAM](sram.md)** (static RAM)
- **[SS](ss.md)** (schutzstaffel, screenshot)
- **[SSAO](ssao.md)** (screen space ambient occlusion)
- **[SSD](ssd.md)** (solid state drive)
- **[SSH](ssh.md)** (secure shell)
- **[SSL](ssl.md)** (secure socket layer)
- **[SSRE](ssre.md)** (shitty [software rendering](sw_rendering.md) engine)
- **[ST](st.md)** (simple terminal)
- **[STD](std.md)** (sexually transmitted [disease](disease.md))
- **[STDIN](stdin.md)** (standard input)
- **[STDIO](stdio.md)** (standard [input/output](io.md))
- **[STDOUT](stdout.md)** (standard output)
- **[STFU](stfu.md)** (shut the fuck up)
- **[STK](stk.md)** (super [tux](tux.md) kart)
- **[STL](stl.md)** (stereolithography, standard triangle/tessellation language)
- **[SVG](svg.md)** (scalable vector graphics)
- **[SW](software.md)** (software, Star Wars)
- **[SWM](swm.md)** (Solbourne window manager)
- **[SWAT](swat.md)** (special weapons and tactics)
- **[T](t.md)** (ton)
- **[TAR](tar.md)** (tape archive)
- **[TARGA](targa.md)** (truevision advanced raster graphics adapter)
- **[TAS](tas.md)** (tool assisted speedrun, tool assisted superplay)
- **[TB](tb.md)** (terabyte, terabit)
- **[TBA](tba.md)** (to be announced)
- **[TBPS](tbps.md)** (terabits per second)
- **[TCC](tcc.md)** (tiny [C](c.md) compiler)
- **[TCL](tcl.md)** (tool command language)
- **[TCP](tcp.md)** (transmission control protocol)
- **[TD](td.md)** ([tower defense](tower_defense.md))
- **[TES](tes.md)** (The Elder Scrolls)
- **[TF](tf.md)** (Team Fortress)
- **[TFT](tft.md)** (thin film [transistor](transistor.md))
- **[TFW](tfw.md)** (that face when)
- **[TGA](tga.md)** (truevision graphics adapter)
- **[THC](thc.md)** (tetrahydrocannabinol)
- **[TI](ti.md)** (Texas Instruments)
- **[TIL](til.md)** (today I learned)
- **[TIFF](tiff.md)** (tagged image file format)
- **[TIFU](tifu.md)** (today I fucked up)
- **[TITS](tits.md)** (there is this saying, that is to say)
- **[TKD](tkd.md)** (total [kike](kike.md) death)
- **[TL;DR](tldr.md)** (too long, didn't read)
- **[TLA](tla.md)** (three letter acronym)
- **[TLS](tls.md)** (transport layer security)
- **[TM](tm.md)** ([trademark](trademark.md), [Turing machine](turing_machine.md))
- **[TMTOWTDI](tmtowtdi.md)** (there is more than one way to do it)
- **[TND](tnd.md)** (total [nigger](nigger.md) death, totally nice day)
- **[TNT](tnt.md)** (trinitrotoluene)
- **[TOR](tor.md)** (claimed to not be an actual acronym but can mean "Tor onion routing" or "THE onion routing".)
- **[TOS](tos.md)** (terms of service)
- **[TPS](tps.md)** (third "person" shooter)
- **[TTF](ttf.md)** (truetype font)
- **[TTL](ttl.md)** (time to live)
- **[TTTT](lgbt.md)** (transsexual, transsexual, transsexual, transsexual)
- **[TTY](tty.md)** (teletype)
- **[TUI](tui.md)** (text user interface)
- **[TV](tv.md)** (television)
- **[TWM](twm.md)** (tab window manager)
- **[TY](ty.md)** (thank you)
- **[UAOFS](uaofs.md)** (ultimate act of [free speech](free_speech.md))
- **[UD](ud.md)** (undead)
- **[UBI](ubi.md)** (universal basic income)
- **[UDP](udp.md)** (user datagram protocol)
- **[UFO](ufo.md)** (unidentified flying object)
- **[UI](ui.md)** (user interface)
- **[UID](uid.mf)** (user ID)
- **[UINT](uint.md)** (unsigned integer)
- **[UK](uk.md)** (United Kingdom)
- **[UML](uml.md)** (unified modeling language)
- **[UN](un.md)** (united nations)
- **[URI](uri.md)** (uniform resource identifier)
- **[URL](url.md)** (uniform resource locator)
- **[USA](usa.md)** (United States of America)
- **[USB](usb.md)** (universal serial bus)
- **[USD](usd.md)** (USA dollar)
- **[USO](uso.md)** (unidentified submerged object)
- **[USSR](ussr.md)** (Union of Soviet Socialist Republics)
- **[UT](ut.md)** (Unreal Tournament)
- **[UTC](utc.md)** (coordinated universal time)
- **[UTF](utf.md)** (unicode transformation format)
- **[UV](uv.md)** (ultraviolet)
- **[UX](ux.md)** (user experience)
- **[V](v.md)** (volt)
- **[VB](vb.md)** (Visual Basic)
- **[VCS](vcs.md)** (version control system)
- **[VOD](vod.md)** (video on demand)
- **[VHDL](vhdl.md)** (VHSIC [hardware](hw.md) description language)
- **[VHS](vhs.md)** (video home system)
- **[VIM](vim.md)** ([vi](vi.md) improved)
- **[VIP](vip.md)** (very important person)
- **[VFX](vfx.md)** (visual effects)
- **[VLAN](vlan.md)** (virtual LAN)
- **[VLC](vlc.md)** (video LAN client)
- **[VLIW](vliw.md)** (very long instruction word)
- **[VM](vm.md)** (virtual machine)
- **[VOD](vod.md)** ([video](video.md) on demand)
- **[VOLCEL](volcel.md)** (voluntary celibate)
- **[VPN](vpn.md)** (virtual private network)
- **[VPS](vps.md)** (virtual private server)
- **[VR](vr.md)** (virtual reality)
- **[VRAM](vram.md)** (video RAM)
- **[VRML](vrml.md)** (virtual reality modeling language)
- **[VS](vs.md)** (versus)
- **[VST](vst.md)** (virtual studio technology)
- **[W3](w3.nd)** ([Warcraft](warcraft.md) 3)
- **[W3C](w3c.md)** (world wide web consortium)
- **[WAD](wad.md)** (where's all the data)
- **[WAN](wan.md)** (wide area network)
- **[WAP](wap.md)** (wireless application protocol)
- **[WC](wc.md)** (word count, water closet)
- **[WDYM](wdym.md)** (what do you mean)
- **[WGM](wgm.md)** ([woman](woman.md) grandmaster)
- **[WIFI](wifi.md)** (wireless fidelity)
- **[WINE](wine.md)** (WINE is not an [emulator](emulation.md))
- **[WIP](wip.md)** (work in progress)
- **[WM](wm.md)** (window manager, wikimedia)
- **[WOW](wow.md)** (World Of Warcraft)
- **[W](w.md)** (watt)
- **[WCGW](wcgw.md)** (what could go wrong)
- **[WP](wp.md)** (Wordpress, well played, [Wikipedia](wikipedia.md))
- **[WPA](wpa.md)** (WIFI protected access)
- **[WPD](wpd.md)** (watch people die)
- **[WR](wr.md)** (world record)
- **[WTF](wtf.md)** (what the fuck)
- **[WTFPL](wtfpl.md)** (do what the fuck you want to public [license](license.md))
- **[WTH](wth.md)** (what the heck/hell)
- **[WYSIAYG](wysiayg.md)** (what you see is all you get)
- **[WYSIWYG](wysiwyg.md)** (what you see is what you get)
- **[WM](wm.md)** (window manager)
- **[WMV](wmv.md)** ([Windows](windows.md) media video)
- **[WR](wr.md)** (world record)
- **[WWI](wwi.md)** (world war one)
- **[WWII](wwii.md)** (world war two)
- **[WWJD](wwjd.md)** (what would [Jesus](jesus.md) do?)
- **[WWW](www.md)** (world wide web)
- **[WWYD](wwyd.md)** (what would you do?)
- **[XAML](xaml.md)** (extensible application markup language)
- **[XCF](xcf.md)** (experimental computing facility)
- **[XFCE](xfce.md)** (XForms common environment)
- **[XHTML](xhtml.md)** (extensible HTML)
- **[XML](xml.md)** (extensible markup language)
- **[XMPP](xmpp.md)** (extensible messaging and presence protocol)
- **[XOR](xor.md)** (exclusive [OR](or.md))
- **[XP](xp.md)** (extreme programming)
- **[Y](y.md)** (year, yes)
- **[Y2K](y2k.md)** (year 2000)
- **[YACC](yacc.md)** (yet another compiler compiler)
- **[YACY](yacy.md)** (yet another cyberspace)
- **[YAHOO](yahoo.md)** (yet another hierarchical officious oracle) { cringe. ~drummyfish }
- **[YAML](yaml.md)** (YAML ain't markup language)
- **[YLYL](ylyl.md)** (you laugh you lose)
- **[YOLO](yolo.md)** (you only live once)
- **[YT](yt.md)** ([YouTube](youtube.md))
- **[YWNBAW](ywnbaw.md)** (you will never be a [woman](woman.md))
- **[ZIP](zip.md)** (zone improvement plan code)
- **[ZNK](znk.md)** (zivot neni krasny)
- **[ZOMG](zomg.md)** (when you want to write OMG but accidentally also hit Z)

## See Also

- [anagram](anagram.md)
- [palindrome](palindrome.md)
- [LRS dictionary](lrs_dictionary.md)
