/** Tiny test for comun.h which is meant to just quickly see if comun works on
  given platform. It takes a program (minified version of test_tiny.cmn from
  example programs), compiles it, interprets it and writes out a small message.
  This file can be compiled either as a standalone program (compile it like .c
  file and define STANDALONE during compilation), or as a tiny library to be
  used from another platform's specific code -- in this case before you include
  this as a library you need to define WRITE_CHAR to the name of a function that
  will print out a single character (signature void f(char)) and then call
  runComunMinitest() somewhere in the platform's code.

  by drummyfish, released under CC0 1.0, public domain */

// here we set lower limits for weak devices:
#define CMN_TOKEN_MAX_LENGTH 16
#define CMN_PARSE_STACK_SIZE 8
#define CMN_INTERPRETER_CALLSTACK_SIZE 8

#include "comun.h"

static const char source[] =
 "fun: ++ 2 * .\n"
 "err: 0 \"ERR\" --> .\n"
 "0 \"test: \" -->\n"
 "~a 3 $:a\n"
 "1000 @@\n"
 " $0 1 = ?\n"
 "  !@\n"
 " .\n"
 "--\n"
 ".\n"
 "0 ~8 257 >0 ~0 + fun $a /\n"
 "$0 7 = ?\n"
 "err\n"
 ";\n"
 "$0 2 = ? 0 \"OK\" --> ; err .\n"
 ".\n";

void runComunMinitest(void);

#ifdef STANDALONE
#define WRITE_CHAR writeChar

#include <stdio.h>

void writeChar(char c)
{
  putchar(c);
}

int main(void)
{
  runComunMinitest();
  putchar('\n');
  return 0;
}

#endif

#define MEMORY_SIZE 768
uint8_t memory[MEMORY_SIZE];

int16_t ioFunction(int16_t x)
{
  if (x >= 0)
    WRITE_CHAR(x);

  return 0;
}

void runComunMinitest(void)
{
  CMN_interpretStr(source,memory,MEMORY_SIZE,10,10,0,ioFunction,0);
}
