#!/bin/sh
# Helper Unix shell script to be used with comun_includeproc.cmn, pass:
#
# includeproc_executable file1 file2 file3 ...
#
# Outputs merged files on stdout.

filecount=0

touch _sources.txt

for srcfile in "$@"; do
  if [ $filecount -ge 1 ]; then
    echo $srcfile >> _sources.txt
    cat $srcfile >> _sources.txt
    echo -n "\000" >> _sources.txt
  fi

  filecount=$((filecount+1))
done

if [ $filecount -eq 2 ]; then # only 1 file?
  cat $2
  exit 0
fi

cat _sources.txt | "$1" > _parts.txt

while read l; do
  echo "\n# ====== START OF BLOCK $l ======"
  CMD_STR=`echo "cat ${PATH_PREFIX}${l}" | sed "s/ \([0-9]*\) / | tail -c +\1 /g" | sed "s/ \([0-9]*\)$/ | head -c \1/g"`
  eval "$CMD_STR"
  echo "\n# ====== END OF BLOCK $l ======"
done < _parts.txt

rm _sources.txt _parts.txt
