#!/bin/sh
# Simple script to easily run the self hosted comun, it can be used similarly
# to the old C version, though not exactly the same. Arguments not starting
# with "-" are considered input files, arguments starting with "-" have the
# dash removed and are passed as arguments to comun.

programs=""
args=""
filecount=0

for a in "$@"; do
  if [ -n "${a%%-*}" ]; then
    programs="$programs $a"
    filecount=$((filecount+1))
  else
    arg=`echo "$a" | cut -c2-`
    args="$args $arg"
  fi
done

sourcefile=$programs

if [ $filecount -eq 0 ]; then
  sourcefile=/dev/null
elif [ $filecount -ge 2 ]; then
  # multiple sources => merge
  ./includeproc.sh bootstrap/comun_includeproc $programs > _tmp.cmn
  sourcefile=_tmp.cmn
fi

# The following feeds in the source, then 0 (to terminate it), then user input
# (for interpreter).
( cat $sourcefile; echo -n "\000"; cat ; ) | ( bootstrap/comun $args; pkill -13 -s 0 cat; )

if [ -e _tmp.cmn ]; then
  rm _tmp.cmn
fi
