# comun: self hosted implementation

This is comun written in comun.

Currently this is still highly work in progress, but the compiler already works and is usable.

Keep in mind that not all code in this directory is necessary to set up a minimal compiler/interpreter, for example to make a basic small compiler you don't need the interpreter and optimizer module etc.

## overview

Files with prefix `cmn_` are part of comun **library**, files with prefix `comun_` are specific runnable **tools** made with the library. The basic all-in-one tool is `comun.cmn`, it contains compiler, interpreter, primitive debugging info etc. Then there are extra tools such as a plain minimal compiler that sacrifices things such as optimizations and good error messages and serves to allow simpler bootstrapping on very weak devices.

Most things are documented right in the source code. Code **conventions** (naming, function documentation, abbreviations etc.) are described in `cmn_general.cmn`.

At the moment there are a few **inconveniences** (you can get around most of them with the present shell scripts):

Firstly pure comun can't work with files, so this implementation only uses standard input/output for reading source code, outputting bytecode etc. This makes it more difficult to use the tool by itself, however there is a helper script called `comun.sh` that serves as a wrapper and allows Unix users to use this tool similarly to the C version.

Similarly user input is harder to feed to interpreted programs as it comes from the same channel as the source code (standard input), so the interpreter will first read source code and then expect user input. Therefore if you want to feed input to interpreter, you have to append it to source code (which must end with zero byte).

For the same reasons it is also more difficult for self hosted comun to handle file includes in programs, i.e. programs that consist of multiple files -- here programs consisting of multiple files have to first be merged into a single file before being passed to this compiler. This preprocessing is done with the help of `includeproc.sh` (which is just a wrapper around comun implementation of the include processor).

## how to use/bootstrap

Currently this implementation can be used in two ways:

1. Use the original C comun to interpret the code here. For example (after compiling `comun.c` in `src_c_old`): `cat ../programs/hello.cmn | src_c_old/comun comun.cmn`. OR
2. Use the `bootstrap.sh` script to obtain a native (fast) comun tool. The script currently uses precompiled minicompiler bytecode (in the *other* directory) and C backend to set everything up. Just running the script should be enough. After this you can use the native comun in `bootstrap` directory as well as the `comun.sh` script for more convenient CLI interface.

Of course you can still use the old C implementation too.

For example you can test everything like this:

```
./bootstrap.sh

cat ../programs/mandelbrot.cmn | bootstrap/comun
# OR equivalently
./comun.sh ../programs/mandelbrot.cmn
```