# Comun FAQ And How To

*by drummyfish*

This is a quick and dirty document providing some answers and directions so that people don't have to email me about common and/or trivial things. However if this document doesn't satisfy you, don't be afraid to mail me at drummyfish@disroot.org.

## I found a bug and/or have a suggestion, what now?

Just send it to my mail (at the top of this document).

## How do I integrate comun as a scripting language to my program?

If you're using C/C++ etc., then at this point you can use the C implementation. Later on the use of self hosted comun transpiled to C will be encouraged, but it's probably too early for that now. If you're using different language thatn C/C++, it's going to be harder, you'll just have to figure it out yourself now, but there's already e.g. python backend that allows to transpile comun to python, so that's likely one possible way. We'll just suppose you're using C now.

The initial C implementation of comun can be integrated to C/C++ programs very easily (just keep in mind it will no longer really be developed here, but it's reasonably debugged by now). You basically just include the header file of the implementation (`comun.h`, or possibly `minicomun.h`) and use functions it provides (you don't even need to install any dependencies or do any linking, the single-header libraries contain their implementation).

Firstly consider if you want full comun or if minicomun will suffice (minicomum is a much smaller and simpler implementation of comun subset, present among the C sources). Even full comun should be very minimal, but why go more complex than necessary?

With minicomun you just pass a string with the program to a function that interprets it. With `comun.h` you can do this too, there is a convenience function `CMN_interpretStr` that does this.

If you need something more complex such as compiling from a different stream of characters, controlling optimization, interpreting by individual steps etc., you have to handle this yourself with provided structs and functions (you'll have to use `comun.h`, `minicomun.h` doesn't provide as much control), mainly related to the compiler and interpreter -- it's still pretty easy, you'll just have to write a bit more code. Also keep in mind that preprocessor is a bit more difficult to integrate (take a look at `comun.c` if you need to do it), you should just not use it if you don't absolutely need it. Everything is documented in the header file itself so take a look at `comun.h` header and comments of the functions (you can also use doxygen to autogenerate an HTML documentation). If you want to see an example of integrating comun to C program this way, one is provided with my SAF library at https://codeberg.org/drummyfish/SAF/src/branch/master/examples/saf_comun.h.

## How fast/efficient is it?

Comun was made with simple technology in mind, i.e. it was made for writing fast and efficient programs, which is necessary when you have potato computers. The C implementation was tested on a device with only 2.5 Kb RAM which was able to compile and run the minitest.h test program. Of course you can't really talk about a speed of pure programming language, specific implementation and its ability to optimize always matters as well as the quality of code you write in the language itself, architecture of your hardware etc., but generally comun should be very fast; no high level bloat (such as dynamic typing, garbage collection, bound checking etc.) is preventing it from being so -- it is very low level without overhead of complex abstraction, it should be easy to automatically optimize and should relatively easily map to assembly.

Keep in mind that currently implemented interpreters are slow! They aren't optimized for speed but rather for relative simplicity of code, they can be made MUCH faster, however if you need to write a fast program in comun right now, you can just transpile it to C, this sometimes even results in a program that's slightly faster than if you write in directly in C, see the table below.

My plans now are to also write a small public domain CPU along with an ISA that would be friendly to comun code, i.e. probably something with stack-based computation in mind. With some existing CPUs nowadays there may be a bit of effort needed to generate absolutely optimal assembly from comun -- please keep in mind I am not an expert on CPUs at all, so take the following as more or less my best guess view of the situation: a straightforward/naive mapping of comun's stack-based computation to a typical CPU's assembly will be simple to make and quite fast but may not fully utilize a register architecture as basically each operation will mean a memory read, register operation, stack shift and memory write, i.e. several instructions, even though some CPU architectures (register-memory or register-plus-memory) may be very friendly to this as they allow to operate directly on memory. On load-store architectures some effort may be needed to convert operations on stack to operations done mainly with registers with minimum read/writes to/from main memory, for example we might copy a portion of the stack to registers, then perform N operations on this "stack emulated with registers" and then copy the whole block back to memory. However, lacking practical experience with this I can't really tell how close to reality I am thinking here.

Here is a quick test I did, I made a program that computes 12345678 iterations of an algorithm `x[n + 1] := (x[n] < 10000 ? (x[n] + 2 + 8000 / (7 * x[n] + 1)) : (x[n] - 9000))`, `x[0] := 123`. The expression contains addition, subtraction, division, multiplication and a branch. Here are the results (ran on Thinkpad X200):

| program          | execution time (sec) |
| ---------------- | -------------------- |
| comun -> C -O3   | 0.08                 |
| C -O3            | 0.09                 |
| comun -> C       | 0.83                 |
| python           | 3.71                 |
|comun interpreter | 6.07                 |
| minicomun        | 16.00                |

## How minimal is it?

Probably somewhere between Forth/Lisp level and C level. Some approximate stats:

- Specification fits on A4 sheet of paper (using both sides).
- Reasonably featured self hosted implementation (bytecode-based compiler+interpreter, very basic optimizer, CLI interface) is currently under 5000 lines of code, more minimal versions (like a bare compiler without any optimizations) use approximately half of this whole code.
- The compiler+interpreter tool transpiled to C and compiled (x86, GNU/Linux, gcc) is under 100 kB.

Hopefully this gives some idea.

## Can I read/write files from comun?

Not from pure comun, just as it's the case e.g. with C -- you have to use a library for file I/O (even if in C this is a standard library). Comun itself is only a language focused on purely processing input bytes to output bytes. In the future there WILL be a library for performing more I/O, including files of course, however it's a bigger project requiring a lot of planning (designing a good API is really about establishing a lot of general assumptions which is very hard and tricky to do). For now you can choose from the following:

- The Unix way: this is of course THE correct way to go if you can, i.e. use files as input stream via pipes, e.g. as: `cat inputfile.txt | comun myprogram.cmn > outfile.txt`. This is how many of the provided examples work, even the ones that create image files etc.
- A more dirty way is just using an external function from comun and transpiling to C at which point you really have pure C code that calls an external function, which you can write and link and you have a working system.
- You may use comun as the "core/backend" code that issues commands to some "framework" language inside which it runs, i.e. imagine for example comun program that's spitting out Bash commands and the shell is just executing them.

## I'd like to write a new compiler backend so that I can compile comun to my second favorite language. How do I do this?

NEW WAY: Write a program in your language that takes comun bytecode on standard input and translates it to the language you're using on standard output. For this check out the documentation of bytecode (and see the code of other backends as a supplement). Once you have this, you'll simply use comun compiler to obtain bytecode which you'll pass on to this backend you've written and you'll get a program in your language.

OLD WAY (kept for historical purposes): Take a look at how existing backend are made, i.e. the files `backend_c.h` and `backend_comun.h`. Basically you make a new backend source code, say `backend_mylang.h` and in it you create a function that takes comun bytecode, translates it to a program in your language and prints this to the file which is handed to that function. To understand the bytecode, see the bytecode documentation in /docs and how other backends translate it. Then you just integrate this backend to `comun.c` which just involves including your new backend header, adding a new command line option and some ifs which just call your function -- again, just take a look at how this is done with the C and comun backends.

## Can I contribute?

Not to this repo, but you can totally fork this and do absolutely anything you please -- in fact I highly encourage this, I reject any form of "intellectual property" and support hacking without any boundaries. Why don't I accept contributions then? As with my other projects, I want to keep the original repo completely my own work, firstly because I am weird and absolutely can't collaborate with anyone, and secondly to prevent issues arising from other people hopping on the board, for example someone suddenly trying to "withdraw" a granted license and whatnot. Now I can say this is completely my own work from the ground up and I 100% waive all my "rights" to it in the clearest way possible.

## Why the name "comun"?

I was searching for a good name for quite some time by browsing dictionaries of various languages etc., it's extremely hard to find something that's not already taken -- somehow I randomly came up with *comun* which seemed nice AND not already taken. I immediately liked the name for a number of reasons, some of them being:

- It's a classy name but not overly pompous or cringe, not some kind of cheap zoomer/corporate bullshit along the lines of "potato rainbow" or "rust". I hate that shit with my soul.
- It just sounds good.
- In a sense it refers to the purpose: being a *common* programming language for good technology.
- It sounds like it's related to communism, which it is, so it will keep capitalists and especially Americans away.

## How to emulate the SWITCH and/or function pointers that are currently missing?

I'm still thinking about how to possibly handle switch statements, dispatch tables etc., in a way that would keep maximum simplicity, for now you basically have to do with what's present and possibly write code so that it can easily be automatically optimized or converted later -- currently there are no optimizers that do this, but in the future there may be ones that will simply be able to turn a nested if into a switch automatically etc.

A few ways to emulate switch:

```
# Nested ifs, simple but possibly slow, may fail with small parse stack (nesting
# may be too deep).

condition1 ? action1 ;
condition2 ? action2 ;
condition3 ? action3 ;
             action4
. . .

# Non-nested ifs in a function (one-iteration loop with breaks would also work),
# not faster but friendlier to parse stack :-)

emulateSwitch:
  condition1 ? action1 !. .
  condition2 ? action2 !. .
  condition3 ? action3 !. .
               action4
.

# Tree-nested ifs -- sometimes you can speed things up with trees (from linear
# to log time complexity), also a bit friendlier to parse stack.

condition1 ?
  condition2 ?
    action1
  ;
    action2
  .
;
  condition2 ?
    action3
  ;
    action4
  .
.

# Etc., get creative :-)
```

Instead of function pointers probably just use some kind of "callFunctionById" function:

```
callFunctionByID:
  $0 0 = ? function0 ;
  $0 1 = ? function1 ;
  $0 2 = ? function2 ;
  . . .
  ^
.
```

## Can and should I write anything more complex than Tetris clone in this? Isn't this just esolang?

Yes, yes and no (though it's now on esolangwiki =3). It is absolutely possible to write quite big, serious and even critical programs in assembly, see e.g. RollerCoaster Tycoon and Apollo 11 Moon landing, and comun is still higher level than assembly, so it will be easier. This just takes a bit more effort and requires skills that zoomer "programmers" no longer posses because they're brainwashed by capitalist cancer. Why do this when "modern" high level languages exist? See the question about ideology etc.

## Why this obsession with simplicity, why this license, why not just C++/Java/Lua, muh memory safety blablabla ideology, politics, philosophy, metaphysics blablabla capitalism communism...

This is not a place to discuss such questions. If you just hate this, go enjoy your bloatware and steam gaymes, if you are open minded and curious or even like this approach and want to study it more, kindly follow the rabbithole that starts at my website (http://www.tastyfish.cz) and leads to my personal wiki about so called *Less Retarded Software/Society*.

## Is this comfortable for practical programming?

Once you get into the language, it is very comfortable, but of course not as fast to program in as high level scripting languages or even C. I was personally used to C programming but when I hopped to comun, after a few days I got comfortable with it and found greater joy in it than in C as the code is so much more compact and nicer, a function usually feels like a carefully crafted mathematical formula rather than some pragmatic duct tape code to just get some task done.

After yet longer time spent on writing the self-hosted compiler now I can say it can even be a downright enjoyable experience to program in this language, you just have to adopt the stack-based thinking mode -- Forth programmers will probably know what I'm talking about. C now feels ugly and bloated to me. Though comun may be objectively more prone to making bugs than C, I actually find myself writing fewer bugs as I have to keep my code simpler.

## Is this the best programming language?

It's one of the best, Forth is probably even more elegant.

## This sucks lol I made it crash.

Nice, well done, let me know how you did it and I may try to fix it, but still at the moment the implementation is considered more or less temporary, everything is still work in progress, for the moment don't use this for anything that people's lives depend on.

## Does this language have any furry mascot?

No. You probably confused this language with some children cartoon or maybe some political party.

## Where is the code of conduct?

There isn't any and never will be. (Really, check out the above answer on politics/ideology/etc.)

## I just wanna talk to you.

Thanks, this is the nicest thing I've heard in a while. Send me an email (see top of this document).

## Can I give you money?

Thank you very much for this kindness <3 This is a selfless project, it's absolutely not made for any profit. If you absolutely insist, I have a donation info on my website. But please know that I won't let money affect my projects in any way, I won't be giving any privileges to sponsors etc., i.e. all a donation will achieve is making me happy and giving me more time and freedom to do things I think are right.