#ifndef MONSTER_CHARACTER_H
#define MONSTER_CHARACTER_H

/**
 * Monster character class header file.
 *
 * by Miloslav  (drummyfish), released under CC0 1.0, public domain
 *
 * NOTE: This is a modified rerelease of a very old game, the code is pretty
 * bad despite me having cleaned it a bit. Use at own risk.
 */

#include "general.h"
#include "character.h"

class c_monster_character: public c_character
{
  protected:
    t_monster_type type;                                  /** monster type */
    int path_length;                                      /** length of path directions and path steps arrays */
    int current_path_instruction;                         /** current position in path arrays */
    double goes_to;                                       /** x or y coordination (depending on direction) to which the character is headed by the current path instruction */
    t_direction path_directions[MAX_MONSTER_PATH_LENGTH]; /** contains sequence of directions in which steps are made */
    int path_steps[MAX_MONSTER_PATH_LENGTH];              /** contains sequence of number of steps that will be made in given directions */
    bool is_dead;                                         /** whether the monster is dead */
    bool waiting;                                         /** whether the monster is waiting and not moving */
    double waiting_end;                                   /** end time of waiting */

    /**
      Switches to the next path instruction.
    */
    void next_instruction();

  public:
    /**
      Class constructor, creates a new object.

      @param type monster type to be set
      @param square_x initial x position
      @param square_y initial y position
      @param global_time pointer to global time counter
    */
    c_monster_character(t_monster_type type, int square_x, int square_y, long *global_time);

    /**
      Class destructor, frees it's memory.
    */
    virtual ~c_monster_character();

    /**
      Returns the monster's type.
    */
    t_monster_type get_monster_type();

    /**
      Adds a path instruction for the monster. There is a maximum of MAX_MONSTER_PATH_LENGTH that can be
      added. Those are instructions for monster to make it's movement.

      @param direction direction in which to move
      @param number_of_steps number of steps to make in provided direction
    */
    void add_path_instruction(t_direction direction, int number_of_steps);

    /**
      Returns the direction in which the monster should move next;

      @return direction in which monster should move (can be DIRECTION_NONE
        which means it should wait)
    */
    t_direction get_next_move();

    /**
      Starts the monster's movement, it's position and path should be set by
      the time this method is called.
    */
    void start_moving();

    /**
      Draws monster character at given position.

      @param x x position on the scrren
      @param y y position on the screen
    */
    virtual void draw(int x, int y);
};

#endif
