#ifndef GRAPHIC_OBJECT_H
#define GRAPHIC_OBJECT_H

/**
 * Graphic object class header file.
 *
 * by Miloslav  (drummyfish), released under CC0 1.0, public domain
 *
 * NOTE: This is a modified rerelease of a very old game, the code is pretty
 * bad despite me having cleaned it a bit. Use at own risk.
 */

#include "general.h"

using namespace std;

class c_graphic_object
{
  /**
    This class represents an object that is able to
    draw itself on the screen. It can also play
    animations.
  */

  protected:
    t_animation_type playing_animation;  /** type of animation being played or looped */
    long int started_playing;            /** time when the animation started playing to count the animation frame */
    long int *global_time;               /** reference to a global time counter variable (for animations) */
    long int animation_frame;            /** current animation frame */
    bool looping_animation;              /** true if the animation is looping, false otherwise */
    int animation_period;                /** number of frames of the current animation */
    bool succesfully_loaded;             /** stores information about errors */
    bool playing_sound;                  /** whether a sound is playing for this object */
    double sound_gain;                   /** sound gain */
    ALLEGRO_SAMPLE_ID playing_sound_id;  /** an ID of the sound being played */
    ALLEGRO_SAMPLE *sound;               /** sound played during animation */

  public:
    c_graphic_object();

    /**
      Tells the object to draw itself at given coordinations on the screen.

      @param x x coordination of the screen
      @param y y coordination of the screen
    */
    virtual void draw(int x, int y);

    /**
      Plays given animation.

      @param animation animation to be played
    */
    virtual void play_animation(t_animation_type animation);

    /**
      Loops the given animation untill it's stopped by stop_animation().

      @param animation animation to be looped
    */
    virtual void loop_animation(t_animation_type animation);

    /**
      Stops playing the current animation.
    */
    virtual void stop_animation();
      
    /**
      Checks if any animation is playing.

      @return true if any animation is playing or looping, false otherwise
    */
    bool is_animating();

    /**
      Depending on current animation sets the animation period attribute.
    */
    virtual void update_animation_period();

    /**
      Returns a type of animation being played or looped.
      @return type of animation
    */
    t_animation_type get_playing_animation();

    /**
      Checks if the map has been loaded succesfully.

      @return true if the map is loaded succesfully, false otherwise
    */
    bool is_succesfully_loaded();

    /**
      Returns the number of animation frame being currently displayed.

      @return number of the animation frame being displayed
    */
    int get_animation_frame();
};

#endif
