/**
 * Associative array class implementation.
 *
 * by Miloslav  (drummyfish), released under CC0 1.0, public domain
 *
 * NOTE: This is a modified rerelease of a very old game, the code is pretty
 * bad despite me having cleaned it a bit. Use at own risk.
 */

#include "associative_array.h"
#include "to_string.h"

c_associative_array::c_associative_array()
{
  this->keys = new vector<string>();
  this->values = new vector<string>();
}
  
c_associative_array::~c_associative_array()
{
  delete this->keys;
  delete this->values;
}

void c_associative_array::set_text(string identifier, string value)
{
  this->delete_text(identifier); // delete the item if it already exists
  this->keys->push_back(identifier);
  this->values->push_back(value);
}

string c_associative_array::get_text(string identifier)
{
  int i;
      
  for(i = 0; (unsigned int) i < this->keys->size(); i++)
    if (this->keys->at(i).compare(identifier) == 0)
      return this->values->at(i);

  return "";
}

void c_associative_array::delete_text(string identifier)
{ 
  int i;
  
  for (i = 0; (unsigned int) i < this->keys->size(); i++)
    if (this->keys->at(i).compare(identifier) == 0)
    {
      this->values->erase(this->values->begin() + i,this->values->begin() + i + 1);
      this->keys->erase(this->values->begin() + i,this->values->begin() + i + 1);
    }
}

bool c_associative_array::load_from_file(string file_name)
{
  ifstream file;

  file.open(file_name.c_str());

  string line, key, value;
  int i;

  if (!file.is_open())
    return false;

  this->keys->clear();
  this->values->clear();

  while (getline(file,line))
  { 
    for (i = 0; (unsigned int) i < line.length(); i++)
      if (line[i] == ':')
       break;

    try
    {
      key = line.substr(0,i); 
      value = line.substr(i + 1,line.length() - key.length());
      this->set_text(key,value);
    }
    catch (...)
    {
      // kek
    }
  }

  file.close();

  return true;
}

bool c_associative_array::save_to_file(string file_name)
{
  ofstream file;

  file.open(file_name.c_str());

  int i;

  if (!file.is_open())
    return false;

  for (i = 0; (unsigned int) i < this->keys->size(); i++)
    file << this->keys->at(i) << ":" << this->values->at(i) << endl;

  file.close();

  return true;
}

